/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.event.BaseExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.FailureImpl;
import com.intellij.openapi.externalSystem.model.task.event.FailureResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptorImpl;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.TaskOperationDescriptorImpl;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptorImpl;
import java.util.ArrayList;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.SkippedResult;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.StatusEvent;
import org.gradle.tooling.events.internal.DefaultOperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.jetbrains.annotations.NotNull;

public class GradleProgressEventConverter {
    @NotNull
    public static ExternalSystemTaskNotificationEvent convert(ExternalSystemTaskId id, ProgressEvent event) {
        ExternalSystemTaskNotificationEvent externalSystemTaskNotificationEvent = GradleProgressEventConverter.convert(id, event, "");
        if (externalSystemTaskNotificationEvent == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(0);
        }
        return externalSystemTaskNotificationEvent;
    }

    @NotNull
    public static ExternalSystemTaskNotificationEvent convert(@NotNull ExternalSystemTaskId id, @NotNull ProgressEvent event, @NotNull String operationId) {
        if (id == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(1);
        }
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(2);
        }
        if (operationId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(3);
        }
        InternalOperationDescriptor internalDesc = event.getDescriptor() instanceof DefaultOperationDescriptor ? ((DefaultOperationDescriptor)event.getDescriptor()).getInternalOperationDescriptor() : null;
        String eventId = internalDesc == null ? operationId + event.getDescriptor().getDisplayName() : operationId + internalDesc.getId().toString();
        String parentEventId = event.getDescriptor().getParent() == null ? null : (internalDesc == null ? operationId + event.getDescriptor().getParent().getDisplayName() : operationId + internalDesc.getParentId().toString());
        String description = event.getDescriptor().getName();
        if (event instanceof StartEvent) {
            OperationDescriptor descriptor = GradleProgressEventConverter.convert(event.getDescriptor(), event.getEventTime());
            ExternalSystemTaskExecutionEvent externalSystemTaskExecutionEvent = new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new ExternalSystemStartEventImpl(eventId, parentEventId, descriptor));
            if (externalSystemTaskExecutionEvent == null) {
                GradleProgressEventConverter.$$$reportNull$$$0(4);
            }
            return externalSystemTaskExecutionEvent;
        }
        if (event instanceof StatusEvent) {
            OperationDescriptor descriptor = GradleProgressEventConverter.convert(event.getDescriptor(), event.getEventTime());
            StatusEvent statusEvent = (StatusEvent)event;
            ExternalSystemTaskExecutionEvent externalSystemTaskExecutionEvent = new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new ExternalSystemStatusEventImpl(eventId, parentEventId, descriptor, statusEvent.getTotal(), statusEvent.getProgress(), statusEvent.getUnit()));
            if (externalSystemTaskExecutionEvent == null) {
                GradleProgressEventConverter.$$$reportNull$$$0(5);
            }
            return externalSystemTaskExecutionEvent;
        }
        if (event instanceof FinishEvent) {
            OperationDescriptor descriptor = GradleProgressEventConverter.convert(event.getDescriptor(), event.getEventTime());
            ExternalSystemTaskExecutionEvent externalSystemTaskExecutionEvent = new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new ExternalSystemFinishEventImpl(eventId, parentEventId, descriptor, GradleProgressEventConverter.convert(((FinishEvent)event).getResult())));
            if (externalSystemTaskExecutionEvent == null) {
                GradleProgressEventConverter.$$$reportNull$$$0(6);
            }
            return externalSystemTaskExecutionEvent;
        }
        if (event instanceof TaskProgressEvent) {
            OperationDescriptor descriptor = GradleProgressEventConverter.convert(event.getDescriptor(), event.getEventTime());
            ExternalSystemTaskExecutionEvent externalSystemTaskExecutionEvent = new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new BaseExternalSystemProgressEvent(eventId, parentEventId, descriptor));
            if (externalSystemTaskExecutionEvent == null) {
                GradleProgressEventConverter.$$$reportNull$$$0(7);
            }
            return externalSystemTaskExecutionEvent;
        }
        ExternalSystemTaskNotificationEvent externalSystemTaskNotificationEvent = new ExternalSystemTaskNotificationEvent(id, description);
        if (externalSystemTaskNotificationEvent == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(8);
        }
        return externalSystemTaskNotificationEvent;
    }

    private static OperationDescriptor convert(org.gradle.tooling.events.OperationDescriptor descriptor, long eventTime) {
        if (descriptor instanceof JvmTestOperationDescriptor) {
            JvmTestOperationDescriptor testOperationDescriptor = (JvmTestOperationDescriptor)descriptor;
            return new TestOperationDescriptorImpl(descriptor.getName(), eventTime, testOperationDescriptor.getSuiteName(), testOperationDescriptor.getClassName(), testOperationDescriptor.getMethodName());
        }
        if (descriptor instanceof TaskOperationDescriptor) {
            TaskOperationDescriptor testOperationDescriptor = (TaskOperationDescriptor)descriptor;
            return new TaskOperationDescriptorImpl(descriptor.getName(), eventTime, testOperationDescriptor.getTaskPath());
        }
        return new OperationDescriptorImpl(descriptor.getName(), eventTime);
    }

    @NotNull
    private static OperationResult convert(org.gradle.tooling.events.OperationResult operationResult) {
        if (operationResult instanceof FailureResult) {
            FailureResult failureResult = (FailureResult)operationResult;
            ArrayList<com.intellij.openapi.externalSystem.model.task.event.Failure> myFailures = new ArrayList<com.intellij.openapi.externalSystem.model.task.event.Failure>();
            for (Failure failure : failureResult.getFailures()) {
                myFailures.add(GradleProgressEventConverter.convert(failure));
            }
            FailureResultImpl failureResultImpl = new FailureResultImpl(failureResult.getStartTime(), failureResult.getEndTime(), myFailures);
            if (failureResultImpl == null) {
                GradleProgressEventConverter.$$$reportNull$$$0(9);
            }
            return failureResultImpl;
        }
        if (operationResult instanceof SkippedResult) {
            SkippedResultImpl skippedResultImpl = new SkippedResultImpl(operationResult.getStartTime(), operationResult.getEndTime());
            if (skippedResultImpl == null) {
                GradleProgressEventConverter.$$$reportNull$$$0(10);
            }
            return skippedResultImpl;
        }
        boolean isUpToDate = operationResult instanceof TaskSuccessResult && ((TaskSuccessResult)operationResult).isUpToDate();
        SuccessResultImpl successResultImpl = new SuccessResultImpl(operationResult.getStartTime(), operationResult.getEndTime(), isUpToDate);
        if (successResultImpl == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(11);
        }
        return successResultImpl;
    }

    private static com.intellij.openapi.externalSystem.model.task.event.Failure convert(Failure failure) {
        ArrayList<com.intellij.openapi.externalSystem.model.task.event.Failure> causes = new ArrayList<com.intellij.openapi.externalSystem.model.task.event.Failure>();
        for (Failure cause : failure.getCauses()) {
            causes.add(GradleProgressEventConverter.convert(cause));
        }
        return new FailureImpl(failure.getMessage(), failure.getDescription(), causes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

