/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0015\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0019J\r\u0010\u001a\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001bJ\u0016\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\tJ\u0014\u0010\u001f\u001a\u00020\u000b*\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002R2\u0010\u0005\u001a&\u0012\u0004\u0012\u00020\u0007\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/module/Module;", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleSourceInfo;", "Lorg/jetbrains/kotlin/name/FqName;", "", "pendingKtFileChanges", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "pendingVFileChanges", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "checkPendingChanges", "", "invalidateCacheForModuleSourceInfo", "moduleSourceInfo", "notifyPackageChange", "file", "notifyPackageChange$idea_core", "onTooComplexChange", "onTooComplexChange$idea_core", "packageExists", "packageFqName", "moduleInfo", "containedInOrContains", "root", "", "Companion", "idea-core"})
public final class PerModulePackageCacheService {
    private final ConcurrentHashMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> cache;
    private final Set<VirtualFile> pendingVFileChanges;
    private final Set<KtFile> pendingKtFileChanges;
    private final GlobalSearchScope projectScope;
    private final Project project;
    private static final int FULL_DROP_THRESHOLD = 1000;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onTooComplexChange$idea_core() {
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            this.pendingVFileChanges.clear();
            this.pendingKtFileChanges.clear();
            this.cache.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$idea_core(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            Collection collection = this.pendingVFileChanges;
            VirtualFile virtualFile2 = file2;
            collection.add(virtualFile2);
            virtualFile2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$idea_core(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            Collection collection = this.pendingKtFileChanges;
            KtFile ktFile = file2;
            collection.add(ktFile);
            ktFile = Unit.INSTANCE;
        }
    }

    private final void invalidateCacheForModuleSourceInfo(ModuleSourceInfo moduleSourceInfo) {
        ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>> concurrentMap = this.cache.get(moduleSourceInfo.getModule());
        if (concurrentMap == null) {
            return;
        }
        ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>> perSourceInfoData = concurrentMap;
        ConcurrentMap concurrentMap2 = (ConcurrentMap)perSourceInfoData.get(moduleSourceInfo);
        if (concurrentMap2 == null) {
            return;
        }
        ConcurrentMap dataForSourceInfo = concurrentMap2;
        dataForSourceInfo.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkPendingChanges() {
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            if (this.pendingVFileChanges.size() + this.pendingKtFileChanges.size() >= Companion.getFULL_DROP_THRESHOLD()) {
                this.onTooComplexChange$idea_core();
            } else {
                Object it;
                Map map2;
                Iterable $receiver$iv = this.pendingVFileChanges;
                for (Object element$iv : $receiver$iv) {
                    Object object;
                    VirtualFile vfile = (VirtualFile)element$iv;
                    if (vfile.isDirectory() || !vfile.isValid()) {
                        map2 = this.cache;
                        Iterator iterator2 = map2.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            boolean bl;
                            ConcurrentMap data;
                            block12: {
                                Object object2 = object = iterator2.next();
                                Module module = (Module)object2.getKey();
                                object2 = object;
                                data = (ConcurrentMap)object2.getValue();
                                String[] sourceRootUrls = ProjectUtil.getRootManager((Module)module).getSourceRootUrls();
                                Intrinsics.checkExpressionValueIsNotNull((Object)sourceRootUrls, (String)"sourceRootUrls");
                                for (Object element$iv2 : (Object[])sourceRootUrls) {
                                    String url;
                                    String string = url = (String)element$iv2;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
                                    if (!this.containedInOrContains(vfile, string)) continue;
                                    bl = true;
                                    break block12;
                                }
                                bl = false;
                            }
                            if (!bl) continue;
                            data.clear();
                        }
                        continue;
                    }
                    IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getModuleInfoByVirtualFile(this.project, vfile);
                    if (!(ideaModuleInfo instanceof ModuleSourceInfo)) {
                        ideaModuleInfo = null;
                    }
                    if ((ModuleSourceInfo)ideaModuleInfo == null) continue;
                    it = object;
                    this.invalidateCacheForModuleSourceInfo((ModuleSourceInfo)it);
                }
                this.pendingVFileChanges.clear();
                $receiver$iv = this.pendingKtFileChanges;
                for (Object element$iv : $receiver$iv) {
                    KtFile file2 = (KtFile)element$iv;
                    if (file2.getVirtualFile() != null && !this.projectScope.contains(file2.getVirtualFile())) continue;
                    IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getNullableModuleInfo((PsiElement)file2);
                    if (!(ideaModuleInfo instanceof ModuleSourceInfo)) {
                        ideaModuleInfo = null;
                    }
                    if ((ModuleSourceInfo)ideaModuleInfo == null) continue;
                    it = map2;
                    this.invalidateCacheForModuleSourceInfo((ModuleSourceInfo)it);
                }
                this.pendingKtFileChanges.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean containedInOrContains(@NotNull VirtualFile $receiver, String root) {
        return VfsUtilCore.isEqualOrAncestor((String)$receiver.getUrl(), (String)root) || $receiver.isDirectory() && VfsUtilCore.isEqualOrAncestor((String)root, (String)$receiver.getUrl());
    }

    public final boolean packageExists(@NotNull FqName packageFqName, @NotNull ModuleSourceInfo moduleInfo) {
        ConcurrentMap cacheForCurrentModuleInfo;
        Object object;
        Object default$iv;
        Object object2;
        ConcurrentMap perSourceInfoCache;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        Module module = moduleInfo.getModule();
        this.checkPendingChanges();
        ConcurrentMap $receiver$iv = this.cache;
        Object object3 = $receiver$iv.get(module);
        if (object3 == null) {
            ConcurrentMap concurrentMap;
            Disposer.register((Disposable)((Disposable)module), (Disposable)new Disposable(this, module){
                final /* synthetic */ PerModulePackageCacheService this$0;
                final /* synthetic */ Module $module$inlined;
                {
                    this.this$0 = perModulePackageCacheService;
                    this.$module$inlined = module;
                }

                public final void dispose() {
                    PerModulePackageCacheService.access$getCache$p(this.this$0).remove(this.$module$inlined);
                }
            });
            ConcurrentMap default$iv2 = concurrentMap = ContainerUtil.createConcurrentSoftMap();
            object3 = $receiver$iv.putIfAbsent(module, default$iv2);
            if (object3 == null) {
                object3 = default$iv2;
            }
        }
        ConcurrentMap concurrentMap = perSourceInfoCache = (ConcurrentMap)object3;
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"perSourceInfoCache");
        ConcurrentMap $receiver$iv2 = concurrentMap;
        Object object4 = $receiver$iv2.get(moduleInfo);
        if (object4 == null) {
            ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentSoftMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap2, (String)"ContainerUtil.createConcurrentSoftMap()");
            default$iv = object2 = concurrentMap2;
            object4 = $receiver$iv2.putIfAbsent(moduleInfo, default$iv);
            if (object4 == null) {
                object4 = default$iv;
            }
        }
        if ((object = ($receiver$iv2 = (cacheForCurrentModuleInfo = (ConcurrentMap)object4)).get(packageFqName)) == null) {
            object2 = PackageIndexUtil.packageExists(packageFqName, moduleInfo.contentScope(), this.project);
            default$iv = object2;
            object = $receiver$iv2.putIfAbsent(packageFqName, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (Boolean)object;
    }

    public PerModulePackageCacheService(@NotNull Project project) {
        Set set2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.cache = new ConcurrentHashMap();
        PerModulePackageCacheService perModulePackageCacheService = this;
        perModulePackageCacheService.pendingVFileChanges = set2 = (Set)new LinkedHashSet();
        perModulePackageCacheService = this;
        perModulePackageCacheService.pendingKtFileChanges = set2 = (Set)new LinkedHashSet();
        this.projectScope = GlobalSearchScope.projectScope((Project)this.project);
    }

    static {
        FULL_DROP_THRESHOLD = 1000;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getCache$p(PerModulePackageCacheService $this) {
        return $this.cache;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$Companion;", "", "()V", "FULL_DROP_THRESHOLD", "", "getFULL_DROP_THRESHOLD", "()I", "idea-core"})
    public static final class Companion {
        public final int getFULL_DROP_THRESHOLD() {
            return FULL_DROP_THRESHOLD;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

