/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\u0003*\u00020\u0003H\u0000\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\u0007*\u00020\nH\u0000\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u000e*\u00020\u0003H\u0000\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0007*\u00020\u0007H\u0000\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0003*\u00020\u0003H\u0000\u00a8\u0006\u0013"}, d2={"getExpectedDeclarationTooltip", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "navigateToExpectedDeclaration", "", "declarationOf", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "expectedDeclarationIfAny", "expectedDescriptor", "hasDeclarationOf", "", "isExpected", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isExpectedOrExpectedClassMember", "liftToExpected", "idea"})
public final class HasExpectedMarkerKt {
    public static final boolean hasDeclarationOf(@NotNull ModuleDescriptor $receiver, @NotNull MemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return HasExpectedMarkerKt.declarationOf($receiver, descriptor2) != null;
    }

    private static final DeclarationDescriptor declarationOf(@NotNull ModuleDescriptor $receiver, MemberDescriptor descriptor2) {
        ExpectedActualDeclarationChecker expectedActualDeclarationChecker;
        ExpectedActualDeclarationChecker $receiver2 = expectedActualDeclarationChecker = ExpectedActualDeclarationChecker.INSTANCE;
        return (MemberDescriptor)CollectionsKt.firstOrNull($receiver2.findCompatibleExpectedForActual(descriptor2, $receiver));
    }

    @Nullable
    public static final String getExpectedDeclarationTooltip(@Nullable KtDeclaration declaration2) {
        KtDeclaration ktDeclaration = declaration2;
        DeclarationDescriptor declarationDescriptor = ktDeclaration != null ? PsiModificationUtilsKt.toDescriptor(ktDeclaration) : null;
        if (!(declarationDescriptor instanceof MemberDescriptor)) {
            declarationDescriptor = null;
        }
        MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
        if (memberDescriptor == null) {
            return null;
        }
        MemberDescriptor descriptor2 = memberDescriptor;
        KtFile ktFile = declaration2.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"declaration.containingKtFile");
        ModuleDescriptor platformModuleDescriptor = ResolutionUtils.findModuleDescriptor(ktFile);
        ModuleDescriptor moduleDescriptor = FacetUtilsKt.getImplementedDescriptor(platformModuleDescriptor);
        if (moduleDescriptor == null) {
            return null;
        }
        ModuleDescriptor commonModuleDescriptor = moduleDescriptor;
        if (!HasExpectedMarkerKt.hasDeclarationOf(commonModuleDescriptor, descriptor2)) {
            return null;
        }
        return "Has declaration in common module";
    }

    public static final void navigateToExpectedDeclaration(@Nullable KtDeclaration declaration2) {
        block0: {
            KtDeclaration ktDeclaration = declaration2;
            if (ktDeclaration == null || (ktDeclaration = HasExpectedMarkerKt.expectedDeclarationIfAny(ktDeclaration)) == null) break block0;
            ktDeclaration.navigate(false);
        }
    }

    @Nullable
    public static final DeclarationDescriptor expectedDescriptor(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ModuleDescriptor moduleDescriptor = FacetUtilsKt.getImplementedDescriptor(DescriptorUtilsKt.getModule($receiver));
        return moduleDescriptor != null ? HasExpectedMarkerKt.declarationOf(moduleDescriptor, $receiver) : null;
    }

    @Nullable
    public static final KtDeclaration expectedDeclarationIfAny(@NotNull KtDeclaration $receiver) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor declarationDescriptor2 = PsiModificationUtilsKt.toDescriptor($receiver);
        if (!(declarationDescriptor2 instanceof MemberDescriptor)) {
            declarationDescriptor2 = null;
        }
        if ((declarationDescriptor = (MemberDescriptor)declarationDescriptor2) == null || (declarationDescriptor = HasExpectedMarkerKt.expectedDescriptor(declarationDescriptor)) == null) {
            return null;
        }
        DeclarationDescriptor expectedDescriptor = declarationDescriptor;
        PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(expectedDescriptor);
        if (!(psiElement2 instanceof KtDeclaration)) {
            psiElement2 = null;
        }
        return (KtDeclaration)psiElement2;
    }

    public static final boolean isExpectedOrExpectedClassMember(@NotNull KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (PsiUtilsKt.hasExpectModifier($receiver)) {
            return true;
        }
        if ($receiver instanceof KtClassOrObject) {
            return HasExpectedMarkerKt.isExpected((KtClassOrObject)$receiver);
        }
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject($receiver);
        return ktClassOrObject != null && HasExpectedMarkerKt.isExpected(ktClassOrObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExpected(@NotNull KtClassOrObject $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (PsiUtilsKt.hasExpectModifier($receiver)) return true;
        DeclarationDescriptor $receiver$iv = UtilsKt.getDescriptor($receiver);
        DeclarationDescriptor declarationDescriptor = $receiver$iv;
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) return false;
        if (!classDescriptor.isExpect()) return false;
        return true;
    }

    @Nullable
    public static final DeclarationDescriptor liftToExpected(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof MemberDescriptor) {
            return ((MemberDescriptor)$receiver).isExpect() ? $receiver : (((MemberDescriptor)$receiver).isActual() ? HasExpectedMarkerKt.expectedDescriptor((MemberDescriptor)$receiver) : null);
        }
        if ($receiver instanceof ValueParameterDescriptor) {
            DeclarationDescriptor declarationDescriptor = HasExpectedMarkerKt.liftToExpected(((ValueParameterDescriptor)$receiver).getContainingDeclaration());
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
            if (callableDescriptor == null) {
                return null;
            }
            CallableDescriptor containingExpectedDescriptor = callableDescriptor;
            List<ValueParameterDescriptor> list2 = containingExpectedDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"containingExpectedDescriptor.valueParameters");
            return (DeclarationDescriptor)CollectionsKt.getOrNull(list2, (int)((ValueParameterDescriptor)$receiver).getIndex());
        }
        return null;
    }

    @Nullable
    public static final KtDeclaration liftToExpected(@NotNull KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default($receiver, null, 1, null);
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null || (declarationDescriptor = HasExpectedMarkerKt.liftToExpected(declarationDescriptor)) == null) {
            return null;
        }
        DeclarationDescriptor expectedDescriptor = declarationDescriptor;
        PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(expectedDescriptor);
        if (!(psiElement2 instanceof KtDeclaration)) {
            psiElement2 = null;
        }
        return (KtDeclaration)psiElement2;
    }
}

