/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplacePutWithAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "ReplacePutWithAssignmentQuickfix", "idea"})
public final class ReplacePutWithAssignmentInspection
extends AbstractKotlinInspection {
    private static final Set<String> compatibleNames;
    public static final Companion Companion;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitDotQualifiedExpression(expression2);
                if (ReplacePutWithAssignmentInspection.Companion.isActiveFor(expression2)) {
                    KtCallExpression ktCallExpression = UtilsKt.getCallExpression(expression2);
                    if (ktCallExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    KtExpression ktExpression = ktCallExpression.getCalleeExpression();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$holder.registerProblem((PsiElement)ktExpression, "map.put() can be converted to assignment", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ReplacePutWithAssignmentQuickfix()});
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    static {
        Companion = new Companion(null);
        compatibleNames = SetsKt.setOf((Object)"put");
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplacePutWithAssignmentInspection$ReplacePutWithAssignmentQuickfix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    public static final class ReplacePutWithAssignmentQuickfix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Convert put to assignment";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
            PsiElement psiElement3 = psiElement2.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"descriptor.psiElement.parent");
            PsiElement psiElement4 = psiElement3.getParent();
            if (!(psiElement4 instanceof KtDotQualifiedExpression)) {
                psiElement4 = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement4;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            Companion.simplify(ktDotQualifiedExpression);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplacePutWithAssignmentInspection$Companion;", "", "()V", "compatibleNames", "", "", "getCompatibleNames", "()Ljava/util/Set;", "isActiveFor", "", "expression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "simplify", "", "idea"})
    public static final class Companion {
        private final Set<String> getCompatibleNames() {
            return compatibleNames;
        }

        public final boolean isActiveFor(@NotNull KtDotQualifiedExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            KtCallExpression callExpression2 = UtilsKt.getCallExpression(expression2);
            Object object = callExpression2;
            if (object == null || (object = ((KtCallExpression)object).getValueArguments()) == null || object.size() != 2) {
                return false;
            }
            KtExpression ktExpression = callExpression2.getCalleeExpression();
            if (!(ktExpression instanceof KtNameReferenceExpression)) {
                ktExpression = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
            if (ktNameReferenceExpression == null) {
                return false;
            }
            KtNameReferenceExpression calleeExpression2 = ktNameReferenceExpression;
            if (!this.getCompatibleNames().contains(calleeExpression2.getReferencedName())) {
                return false;
            }
            BindingContext context = ResolutionUtils.analyze$default(expression2, null, 1, null);
            if (BindingContextUtilsKt.isUsedAsExpression(expression2, context)) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context);
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            if (resolvedCall3 == null || (resolvedCall3 = ResolvedCallUtilKt.getExplicitReceiverValue(resolvedCall3)) == null || (resolvedCall3 = resolvedCall3.getType()) == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> receiverType2 = resolvedCall3;
            ClassifierDescriptor classifierDescriptor = ((KotlinType)((Object)receiverType2)).getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor receiverClass = classDescriptor;
            ClassDescriptor classDescriptor2 = DefaultBuiltIns.Companion.getInstance().getMutableMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"DefaultBuiltIns.Instance.mutableMap");
            return DescriptorUtilsKt.isSubclassOf(receiverClass, classDescriptor2);
        }

        public final void simplify(@NotNull KtDotQualifiedExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Object object = UtilsKt.getCallExpression(expression2);
            if (object == null || (object = ((KtCallExpression)object).getValueArguments()) == null) {
                return;
            }
            Object valueArguments = object;
            Object[] objectArray = new Object[3];
            objectArray[0] = expression2.getReceiverExpression();
            KtElement ktElement = (KtValueArgument)valueArguments.get(0);
            if (ktElement == null || (ktElement = ktElement.getArgumentExpression()) == null) {
                return;
            }
            objectArray[1] = ktElement;
            KtElement ktElement2 = (KtValueArgument)valueArguments.get(1);
            if (ktElement2 == null || (ktElement2 = ktElement2.getArgumentExpression()) == null) {
                return;
            }
            objectArray[2] = ktElement2;
            expression2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null), "$0[$1] = $2", objectArray, false, 4, null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

