/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspectionKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/WhenWithOnlyElseInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "SimplifyFix", "idea"})
public final class WhenWithOnlyElseInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
                KtWhenEntry singleEntry;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                List<KtWhenEntry> list2 = expression2.getEntries();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"expression.entries");
                KtWhenEntry ktWhenEntry = singleEntry = (KtWhenEntry)CollectionsKt.singleOrNull(list2);
                if (ktWhenEntry == null || !ktWhenEntry.isElse()) {
                    return;
                }
                boolean usedAsExpression = BindingContextUtilsKt.isUsedAsExpression(expression2, ResolutionUtils.analyze$default(expression2, null, 1, null));
                this.$holder.registerProblem((PsiElement)expression2, "'when' has only 'else' branch and can be simplified", new LocalQuickFix[]{new SimplifyFix(usedAsExpression)});
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/WhenWithOnlyElseInspection$SimplifyFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "isUsedAsExpression", "", "(Z)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class SimplifyFix
    implements LocalQuickFix {
        private final boolean isUsedAsExpression;

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return "Simplify expression";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtWhenExpression)) {
                psiElement2 = null;
            }
            KtWhenExpression ktWhenExpression = (KtWhenExpression)psiElement2;
            if (ktWhenExpression == null) {
                return;
            }
            KtWhenExpression whenExpression2 = ktWhenExpression;
            FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)whenExpression2);
            KtExpression ktExpression = whenExpression2.getElseExpression();
            if (ktExpression == null) {
                return;
            }
            ConstantConditionIfInspectionKt.replaceWithBranch$default(whenExpression2, ktExpression, this.isUsedAsExpression, false, 4, null);
        }

        public SimplifyFix(boolean isUsedAsExpression) {
            this.isUsedAsExpression = isUsedAsExpression;
        }
    }
}

