/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.idea.inspections.ReplaceStringInDocumentFix;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.versions.DeprecatedLibInfo;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DeprecatedMavenDependencyInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "idea-maven"})
public final class DeprecatedMavenDependencyInspection
extends DomElementsInspection<MavenDomProjectModel> {
    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        Module module;
        if (domFileElement == null || holder == null) {
            return;
        }
        XmlFile file2 = domFileElement.getFile();
        Module module2 = domFileElement.getModule();
        if (module2 == null) {
            return;
        }
        Module module3 = module = module2;
        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module3.getProject());
        if (mavenProjectsManager == null) {
            return;
        }
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(module);
        if (mavenProject == null) {
            return;
        }
        MavenProject project = mavenProject;
        XmlFile xmlFile = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)xmlFile, (String)"file");
        PomFile pomFile = PomFile.Companion.forFileOrNull(xmlFile);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        for (DeprecatedLibInfo libInfo : KotlinRuntimeLibraryUtilKt.getDEPRECATED_LIBRARIES_INFORMATION()) {
            MavenDomDependency it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = PomFile.findDependencies$default(pomFile2, new MavenId(libInfo.getOld().getGroupId(), libInfo.getOld().getName(), null), null, 2, null);
            Iterator iterator2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MavenDomDependency mavenDomDependency = it = (MavenDomDependency)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomDependency, (String)"it");
                GenericDomValue genericDomValue = mavenDomDependency.getVersion();
                if (!((genericDomValue != null ? genericDomValue.getStringValue() : null) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                it = (MavenDomDependency)element$iv$iv;
                List list2 = project.findDependencies(libInfo.getOld().getGroupId(), libInfo.getOld().getName());
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"project.findDependencies\u2026roupId, libInfo.old.name)");
                Iterable $i$f$filterTo = $receiver$iv2 = (Iterable)list2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void it2;
                    MavenArtifact mavenArtifact = (MavenArtifact)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    void v9 = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
                    String string = v9.getVersion();
                    collection.add(string);
                }
                String libVersion = (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)));
                boolean bl = libVersion != null && VersionComparatorUtil.COMPARATOR.compare(libVersion, libInfo.getOutdatedAfterVersion()) >= 0;
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                MavenDomDependency dependency;
                MavenDomDependency mavenDomDependency = dependency = (MavenDomDependency)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomDependency, (String)"dependency");
                GenericDomValue genericDomValue = mavenDomDependency.getArtifactId();
                Intrinsics.checkExpressionValueIsNotNull((Object)genericDomValue, (String)"dependency.artifactId");
                XmlElement xmlElement = genericDomValue.getXmlElement();
                if (xmlElement == null) continue;
                ReplaceStringInDocumentFix fix = new ReplaceStringInDocumentFix((PsiElement)xmlElement, libInfo.getOld().getName(), libInfo.getNew().getName());
                holder.createProblem((DomElement)dependency.getArtifactId(), ProblemHighlightType.LIKE_DEPRECATED, libInfo.getMessage(), null, new LocalQuickFix[]{fix});
            }
        }
    }

    public DeprecatedMavenDependencyInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }
}

