/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.caches.resolve.IdePlatformSupport;
import org.jetbrains.kotlin.resolve.TargetPlatform;

public class ProjectStructureUtil {
    private static final Key<CachedValue<TargetPlatform>> PLATFORM_FOR_MODULE = Key.create((String)"PLATFORM_FOR_MODULE");

    private ProjectStructureUtil() {
    }

    @NotNull
    static TargetPlatform getCachedPlatformForModule(final @NotNull Module module) {
        CachedValue result2 = (CachedValue)module.getUserData(PLATFORM_FOR_MODULE);
        if (result2 == null) {
            result2 = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<TargetPlatform>(){

                public CachedValueProvider.Result<TargetPlatform> compute() {
                    return CachedValueProvider.Result.create((Object)IdePlatformSupport.getPlatformForModule(module), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)module.getProject())});
                }
            }, false);
            module.putUserData(PLATFORM_FOR_MODULE, (Object)result2);
        }
        return (TargetPlatform)result2.getValue();
    }
}

