/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationTargetFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class AddAnnotationTargetFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Add annotation target";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        KtClass ktClass2 = AddAnnotationTargetFix.Companion.toAnnotationClass(annotationEntry2);
        if (ktClass2 == null) {
            return;
        }
        KtClass annotationClass = ktClass2;
        List requiredAnnotationTargets = AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(annotationEntry2, annotationClass, project);
        if (requiredAnnotationTargets.isEmpty()) {
            return;
        }
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)annotationEntry2, false, 2, null);
        AddAnnotationTargetFixKt.access$addAnnotationTargets(annotationClass, requiredAnnotationTargets, psiFactory);
    }

    public AddAnnotationTargetFix(@NotNull KtAnnotationEntry annotationEntry2) {
        Intrinsics.checkParameterIsNotNull((Object)annotationEntry2, (String)"annotationEntry");
        super((PsiElement)annotationEntry2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "toAnnotationClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private final KtClass toAnnotationClass(@NotNull KtAnnotationEntry $receiver) {
            KtClass ktClass2;
            KtClass it;
            ClassifierDescriptor annotationTypeDescriptor;
            BindingContext context = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL);
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context.get(BindingContext.ANNOTATION, $receiver);
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
            ClassifierDescriptor classifierDescriptor = annotationDescriptor2.getType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                return null;
            }
            ClassifierDescriptor classifierDescriptor2 = annotationTypeDescriptor = classifierDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor2, (String)"annotationTypeDescriptor");
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(classifierDescriptor2);
            if (!(psiElement2 instanceof KtClass)) {
                psiElement2 = null;
            }
            KtClass ktClass3 = (KtClass)psiElement2;
            return ktClass3 != null ? ((it = (ktClass2 = ktClass3)).isAnnotation() && it.isWritable() ? ktClass2 : null) : null;
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtAnnotationEntry> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtAnnotationEntry)) {
                psiElement2 = null;
            }
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)psiElement2;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry entry = ktAnnotationEntry;
            if (this.toAnnotationClass(entry) == null) {
                return null;
            }
            return new AddAnnotationTargetFix(entry);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

