/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.TemplateKind;
import org.jetbrains.kotlin.idea.core.TemplatesKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.quickfix.AddFunctionToSupertypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFix;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0019\u001aB\u001d\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\"\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "element", "functions", "", "Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix$FunctionData;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/List;)V", "actionName", "", "functionData", "addFunction", "", "project", "Lcom/intellij/openapi/project/Project;", "createFunctionPopup", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "getFamilyName", "getText", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "FunctionData", "idea"})
public final class AddFunctionToSupertypeFix
extends KotlinQuickFixAction<KtNamedFunction>
implements LowPriorityAction {
    private final List<FunctionData> functions;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        FunctionData single = (FunctionData)CollectionsKt.singleOrNull(this.functions);
        return single != null ? this.actionName(single) : "Add function to supertype...";
    }

    @NotNull
    public String getFamilyName() {
        return "Add function to supertype";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(this, editor, project){
            final /* synthetic */ AddFunctionToSupertypeFix this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $project;

            /*
             * Enabled aggressive block sorting
             */
            public final void run() {
                if (AddFunctionToSupertypeFix.access$getFunctions$p(this.this$0).size() != 1 && this.$editor != null) {
                    JComponent jComponent = this.$editor.getComponent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"editor.component");
                    if (jComponent.isShowing()) {
                        JBPopupFactory.getInstance().createListPopup(AddFunctionToSupertypeFix.access$createFunctionPopup(this.this$0, this.$project)).showInBestPositionFor(this.$editor);
                        return;
                    }
                }
                AddFunctionToSupertypeFix.access$addFunction(this.this$0, (FunctionData)CollectionsKt.first((List)AddFunctionToSupertypeFix.access$getFunctions$p(this.this$0)), this.$project);
            }
            {
                this.this$0 = addFunctionToSupertypeFix;
                this.$editor = editor;
                this.$project = project;
            }
        });
    }

    private final void addFunction(FunctionData functionData, Project project) {
        ApplicationUtilsKt.executeWriteCommand(project, "Add Function to Type", (Function0<Unit>)((Function0)new Function0<Unit>(functionData, project){
            final /* synthetic */ FunctionData $functionData;
            final /* synthetic */ Project $project;

            public final void invoke() {
                IElementType iElementType;
                KtClassBody classBody = KtClassOrObjectKt.getOrCreateBody(this.$functionData.getTargetClass());
                KtNamedFunction functionElement = new KtPsiFactory(this.$project, false, 2, null).createFunction(this.$functionData.getSourceCode());
                PsiElement psiElement2 = classBody.addBefore(functionElement, classBody.getRBrace());
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
                }
                KtNamedFunction insertedFunctionElement = (KtNamedFunction)psiElement2;
                ShortenReferences.process$default(ShortenReferences.DEFAULT, insertedFunctionElement, null, 2, null);
                PsiElement psiElement3 = KtPsiUtilKt.modalityModifier(insertedFunctionElement);
                if (!((psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : (iElementType = null)) instanceof KtModifierKeywordToken)) {
                    iElementType = null;
                }
                KtModifierKeywordToken ktModifierKeywordToken = (KtModifierKeywordToken)iElementType;
                if (ktModifierKeywordToken == null) {
                    return;
                }
                KtModifierKeywordToken modifierToken = ktModifierKeywordToken;
                if (Intrinsics.areEqual((Object)((Object)PsiModificationUtilsKt.implicitModality(insertedFunctionElement)), (Object)((Object)modifierToken))) {
                    new RemoveModifierFix(insertedFunctionElement, modifierToken, true).invoke();
                }
            }
            {
                this.$functionData = functionData;
                this.$project = project;
                super(0);
            }
        }));
    }

    private final ListPopupStep<?> createFunctionPopup(Project project) {
        return (ListPopupStep)new BaseListPopupStep<FunctionData>(this, project, "Choose Type", this.functions){
            final /* synthetic */ AddFunctionToSupertypeFix this$0;
            final /* synthetic */ Project $project;

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            @Nullable
            public PopupStep<?> onChosen(@NotNull FunctionData selectedValue, boolean finalChoice) {
                Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"selectedValue");
                if (finalChoice) {
                    AddFunctionToSupertypeFix.access$addFunction(this.this$0, selectedValue, this.$project);
                }
                return PopupStep.FINAL_CHOICE;
            }

            public Icon getIconFor(@NotNull FunctionData value2) {
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                return PlatformIcons.FUNCTION_ICON;
            }

            @NotNull
            public String getTextFor(@NotNull FunctionData value2) {
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                return AddFunctionToSupertypeFix.access$actionName(this.this$0, value2);
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
    }

    private final String actionName(FunctionData functionData) {
        return "Add '" + functionData.getSignaturePreview() + "' to '" + functionData.getTargetClass().getName() + '\'';
    }

    private AddFunctionToSupertypeFix(KtNamedFunction element3, List<FunctionData> functions2) {
        super((PsiElement)element3);
        boolean bl;
        this.functions = functions2;
        Collection collection = this.functions;
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @NotNull
    public static final /* synthetic */ List access$getFunctions$p(AddFunctionToSupertypeFix $this) {
        return $this.functions;
    }

    public static final /* synthetic */ void access$addFunction(AddFunctionToSupertypeFix $this, @NotNull FunctionData functionData, @NotNull Project project) {
        $this.addFunction(functionData, project);
    }

    @NotNull
    public static final /* synthetic */ ListPopupStep access$createFunctionPopup(AddFunctionToSupertypeFix $this, @NotNull Project project) {
        return $this.createFunctionPopup(project);
    }

    @NotNull
    public static final /* synthetic */ String access$actionName(AddFunctionToSupertypeFix $this, @NotNull FunctionData functionData) {
        return $this.actionName(functionData);
    }

    public /* synthetic */ AddFunctionToSupertypeFix(@NotNull KtNamedFunction element3, @NotNull List functions2, DefaultConstructorMarker $constructor_marker) {
        this(element3, functions2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix$FunctionData;", "", "signaturePreview", "", "sourceCode", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtClass;)V", "getSignaturePreview", "()Ljava/lang/String;", "getSourceCode", "getTargetClass", "()Lorg/jetbrains/kotlin/psi/KtClass;", "idea"})
    private static final class FunctionData {
        @NotNull
        private final String signaturePreview;
        @NotNull
        private final String sourceCode;
        @NotNull
        private final KtClass targetClass;

        @NotNull
        public final String getSignaturePreview() {
            return this.signaturePreview;
        }

        @NotNull
        public final String getSourceCode() {
            return this.sourceCode;
        }

        @NotNull
        public final KtClass getTargetClass() {
            return this.targetClass;
        }

        public FunctionData(@NotNull String signaturePreview, @NotNull String sourceCode, @NotNull KtClass targetClass) {
            Intrinsics.checkParameterIsNotNull((Object)signaturePreview, (String)"signaturePreview");
            Intrinsics.checkParameterIsNotNull((Object)sourceCode, (String)"sourceCode");
            Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
            this.signaturePreview = signaturePreview;
            this.sourceCode = sourceCode;
            this.targetClass = targetClass;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0015\u001a\u00020\u000fH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "createFunctionData", "Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix$FunctionData;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "generateFunctionSignatureForType", "typeDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateFunctionsToAdd", "", "functionElement", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getSuperClasses", "classDescriptor", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtNamedFunction)) {
                psiElement2 = null;
            }
            KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement2;
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function2 = ktNamedFunction;
            List<FunctionDescriptor> descriptors2 = this.generateFunctionsToAdd(function2);
            if (descriptors2.isEmpty()) {
                return null;
            }
            PsiFile psiFile = diagnostic.getPsiFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"diagnostic.psiFile");
            Project project = psiFile.getProject();
            Iterable iterable = $receiver$iv = (Iterable)descriptors2;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FunctionData functionData;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                Project project2 = project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                if (Companion.createFunctionData(it, project2) == null) continue;
                FunctionData it$iv$iv = functionData;
                destination$iv$iv.add(it$iv$iv);
            }
            List functionData = (List)destination$iv$iv;
            if (functionData.isEmpty()) {
                return null;
            }
            return new AddFunctionToSupertypeFix(function2, functionData, null);
        }

        private final FunctionData createFunctionData(FunctionDescriptor functionDescriptor2, Project project) {
            PsiElement psiElement2;
            String sourceCode;
            ClassDescriptor classDescriptor;
            block6: {
                String string;
                StringBuilder stringBuilder;
                block10: {
                    block7: {
                        Object object;
                        String string2;
                        TemplateKind templateKind;
                        Project project2;
                        block9: {
                            block8: {
                                KotlinType it;
                                DeclarationDescriptor declarationDescriptor = functionDescriptor2.getContainingDeclaration();
                                if (declarationDescriptor == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                                }
                                classDescriptor = (ClassDescriptor)declarationDescriptor;
                                sourceCode = IdeDescriptorRenderers.SOURCE_CODE.render(functionDescriptor2);
                                if (!(Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE)) ^ true) || !(Intrinsics.areEqual((Object)((Object)functionDescriptor2.getModality()), (Object)((Object)Modality.ABSTRACT)) ^ true)) break block6;
                                KotlinType returnType2 = functionDescriptor2.getReturnType();
                                stringBuilder = new StringBuilder().append(sourceCode);
                                if (returnType2 != null && KotlinBuiltIns.isUnit(returnType2)) break block7;
                                project2 = project;
                                templateKind = TemplateKind.FUNCTION;
                                string2 = functionDescriptor2.getName().asString();
                                object = functionDescriptor2.getReturnType();
                                if (object == null) break block8;
                                KotlinType kotlinType = object;
                                String string3 = string2;
                                TemplateKind templateKind2 = templateKind;
                                Project project3 = project2;
                                StringBuilder stringBuilder2 = stringBuilder;
                                KotlinType kotlinType2 = it = kotlinType;
                                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"it");
                                String string4 = IdeDescriptorRenderers.SOURCE_CODE.renderType(kotlinType2);
                                stringBuilder = stringBuilder2;
                                project2 = project3;
                                templateKind = templateKind2;
                                string2 = string3;
                                object = string4;
                                if (object != null) break block9;
                            }
                            object = "Unit";
                        }
                        String bodyText = TemplatesKt.getFunctionBodyTextFromTemplate(project2, templateKind, string2, (String)object, ImportsUtils.getImportableFqName(classDescriptor));
                        string = "{ " + bodyText + " }";
                        break block10;
                    }
                    string = "{}";
                }
                sourceCode = stringBuilder.append(string).toString();
            }
            if (!((psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, classDescriptor)) instanceof KtClass)) {
                psiElement2 = null;
            }
            KtClass ktClass2 = (KtClass)psiElement2;
            if (ktClass2 == null) {
                return null;
            }
            KtClass targetClass = ktClass2;
            return new FunctionData(IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(functionDescriptor2), sourceCode, targetClass);
        }

        private final List<FunctionDescriptor> generateFunctionsToAdd(KtNamedFunction functionElement) {
            ClassDescriptor it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny(functionElement, BodyResolveMode.FULL);
            if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                declarationDescriptor = null;
            }
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
            if (functionDescriptor2 == null) {
                return CollectionsKt.emptyList();
            }
            FunctionDescriptor functionDescriptor3 = functionDescriptor2;
            DeclarationDescriptor declarationDescriptor2 = functionDescriptor3.getContainingDeclaration();
            if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                declarationDescriptor2 = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor2;
            if (classDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            ClassDescriptor containingClass = classDescriptor;
            Iterable iterable = this.getSuperClasses(containingClass);
            void var5_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (ClassDescriptor)element$iv$iv;
                if (KotlinBuiltIns.isAnyOrNullableAny(it.getDefaultType())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (ClassDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                FunctionDescriptor functionDescriptor4 = Companion.generateFunctionSignatureForType(functionDescriptor3, it);
                collection.add(functionDescriptor4);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ClassDescriptor> getSuperClasses(ClassDescriptor classDescriptor) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            SimpleType simpleType2 = classDescriptor.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"classDescriptor.defaultType");
            List supertypes2 = CollectionsKt.sortedWith((Iterable)TypeUtilsKt.supertypes(simpleType2), (Comparator)getSuperClasses.supertypes.1.INSTANCE);
            Iterable iterable = $receiver$iv = (Iterable)supertypes2;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                ClassDescriptor classDescriptor2;
                Object element$iv$iv = element$iv$iv$iv;
                KotlinType it = (KotlinType)element$iv$iv;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                if ((ClassDescriptor)classifierDescriptor == null) continue;
                ClassDescriptor it$iv$iv = classDescriptor2;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final FunctionDescriptor generateFunctionSignatureForType(FunctionDescriptor functionDescriptor2, ClassDescriptor typeDescriptor) {
            Modality modality;
            if (Intrinsics.areEqual((Object)((Object)typeDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE))) {
                modality = Modality.ABSTRACT;
            } else {
                Modality modality2 = typeDescriptor.getModality();
                modality = modality2;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality2), (String)"typeDescriptor.modality");
            }
            Modality modality3 = modality;
            FunctionDescriptor functionDescriptor3 = functionDescriptor2.copy(typeDescriptor, modality3, functionDescriptor2.getVisibility(), CallableMemberDescriptor.Kind.DECLARATION, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"functionDescriptor.copy(\u2026copyOverrides = */ false)");
            return functionDescriptor3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

