/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalJsCacheKt;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.TranslationResultValueExternalizer;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\u0013\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u0004H\u0086\u0002J\u0013\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0007H\u0086\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "storageFile", "Ljava/io/File;", "(Ljava/io/File;)V", "dumpValue", "", "value", "get", "file", "key", "keys", "", "put", "", "newMetadata", "", "newBinaryAst", "remove", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "kotlin-build-common"})
final class TranslationResultMap
extends BasicStringMap<TranslationResultValue> {
    @Override
    @NotNull
    protected String dumpValue(@NotNull TranslationResultValue value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return "Metadata: " + IncrementalJvmCacheKt.md5(value2.getMetadata()) + ", Binary AST: " + IncrementalJvmCacheKt.md5(value2.getBinaryAst());
    }

    public final void put(@NotNull File file2, @NotNull byte[] newMetadata, @NotNull byte[] newBinaryAst) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)newMetadata, (String)"newMetadata");
        Intrinsics.checkParameterIsNotNull((Object)newBinaryAst, (String)"newBinaryAst");
        LazyStorage<String, TranslationResultValue> lazyStorage = this.getStorage();
        String string = file2.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.canonicalPath");
        lazyStorage.set(string, new TranslationResultValue(newMetadata, newBinaryAst));
    }

    @Nullable
    public final TranslationResultValue get(@NotNull File file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        LazyStorage lazyStorage = this.getStorage();
        String string = file2.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.canonicalPath");
        return (TranslationResultValue)lazyStorage.get(string);
    }

    @Nullable
    public final TranslationResultValue get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (TranslationResultValue)this.getStorage().get(key);
    }

    @NotNull
    public final Collection<String> keys() {
        return this.getStorage().getKeys();
    }

    public final void remove(@NotNull File file2, @NotNull ChangesCollector changesCollector) {
        Map<ClassId, ProtoData> protoMap;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        LazyStorage lazyStorage = this.getStorage();
        String string = file2.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.canonicalPath");
        Object v = lazyStorage.get(string);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        byte[] protoBytes = ((TranslationResultValue)v).getMetadata();
        Map<ClassId, ProtoData> map2 = protoMap = IncrementalJsCacheKt.getProtoData(file2, protoBytes);
        Iterator<Map.Entry<ClassId, ProtoData>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ClassId, ProtoData> entry;
            Map.Entry<ClassId, ProtoData> entry2 = entry = iterator2.next();
            ProtoData protoData = entry2.getValue();
            ChangesCollector.collectProtoChanges$default(changesCollector, protoData, null, false, 4, null);
        }
        LazyStorage lazyStorage2 = this.getStorage();
        String string2 = file2.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.canonicalPath");
        lazyStorage2.remove(string2);
    }

    public TranslationResultMap(@NotNull File storageFile) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        super(storageFile, TranslationResultValueExternalizer.INSTANCE);
    }
}

