/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageUtils {
    public static final double EPSILON = 1.0E-5;
    public static final int RETINA_SCALE = 2;
    public static final CropFilter TRANSPARENCY_FILTER = (bufferedImage, x, y) -> {
        int rgb = bufferedImage.getRGB(x, y);
        return (rgb & 0xFF000000) == 0;
    };
    private static boolean ourRetinaCapable = true;

    public static BufferedImage rotateByRightAngle(BufferedImage source, int degrees) {
        int h1;
        int w1;
        assert (degrees % 90 == 0);
        int w = source.getWidth();
        int h = source.getHeight();
        switch (degrees %= 360) {
            case 90: 
            case 270: {
                w1 = h;
                h1 = w;
                break;
            }
            default: {
                w1 = w;
                h1 = h;
            }
        }
        ColorModel model = source.getColorModel();
        WritableRaster raster = model.createCompatibleWritableRaster(w1, h1);
        BufferedImage rotated = new BufferedImage(model, raster, source.isAlphaPremultiplied(), null);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int y1;
                int x1;
                int v = source.getRGB(x, y);
                switch (degrees) {
                    case 90: {
                        x1 = h - y - 1;
                        y1 = x;
                        break;
                    }
                    case 180: {
                        x1 = w - x - 1;
                        y1 = h - y - 1;
                        break;
                    }
                    case 270: {
                        x1 = y;
                        y1 = w - x - 1;
                        break;
                    }
                    default: {
                        x1 = x;
                        y1 = y;
                    }
                }
                rotated.setRGB(x1, y1, v);
            }
        }
        return rotated;
    }

    public static boolean isRetinaImage(@Nullable BufferedImage image) {
        return image instanceof JBHiDPIScaledImage;
    }

    public static BufferedImage createDipImage(int width, int height, int type) {
        return UIUtil.createImage((int)width, (int)height, (int)type);
    }

    public static boolean supportsRetina() {
        return ourRetinaCapable;
    }

    @Nullable
    public static BufferedImage convertToRetina(@NotNull BufferedImage image) {
        if (image == null) {
            ImageUtils.$$$reportNull$$$0(0);
        }
        if (image.getWidth() < 2 || image.getHeight() < 2) {
            return null;
        }
        try {
            Image retina = RetinaImage.createFrom((Image)image);
            if (!(retina instanceof BufferedImage)) {
                ourRetinaCapable = false;
                return null;
            }
            return (BufferedImage)retina;
        }
        catch (Throwable ignored) {
            ourRetinaCapable = false;
            return null;
        }
    }

    @NotNull
    public static BufferedImage convertToRetinaIgnoringFailures(@NotNull BufferedImage image) {
        BufferedImage retina;
        if (image == null) {
            ImageUtils.$$$reportNull$$$0(1);
        }
        if (ImageUtils.supportsRetina() && (retina = ImageUtils.convertToRetina(image)) != null) {
            BufferedImage bufferedImage = retina;
            if (bufferedImage == null) {
                ImageUtils.$$$reportNull$$$0(2);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(3);
        }
        return bufferedImage;
    }

    public static void drawDipImage(Graphics g, Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @Nullable ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g.create(0, 0, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else {
            g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }
    }

    public static BufferedImage addMargin(BufferedImage source, int marginSize) {
        int destWidth = source.getWidth() + 2 * marginSize;
        int destHeight = source.getHeight() + 2 * marginSize;
        int type = source.getColorModel().hasAlpha() ? source.getType() : 2;
        BufferedImage expanded = new BufferedImage(destWidth, destHeight, type);
        Graphics2D g2 = expanded.createGraphics();
        g2.setColor(new Color(0, true));
        g2.fillRect(0, 0, destWidth, destHeight);
        g2.drawImage((Image)source, marginSize, marginSize, null);
        g2.dispose();
        return expanded;
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double amount) {
        BufferedImage bufferedImage = ImageUtils.scale(source, amount, amount, 0, 0);
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(4);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale) {
        BufferedImage bufferedImage = ImageUtils.scale(source, xScale, yScale, 0, 0);
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(5);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, @Nullable Shape clip) {
        BufferedImage bufferedImage = ImageUtils.scale(source, xScale, yScale, 0, 0, clip);
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(6);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin) {
        BufferedImage bufferedImage = ImageUtils.scale(source, xScale, yScale, rightMargin, bottomMargin, null);
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(7);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin, @Nullable Shape clip) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = Math.max(1, (int)(xScale * (double)sourceWidth));
        int destHeight = Math.max(1, (int)(yScale * (double)sourceHeight));
        int imageType = source.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        if (xScale > 0.5 && yScale > 0.5) {
            BufferedImage scaled = new BufferedImage(destWidth + rightMargin, destHeight + bottomMargin, imageType);
            Graphics2D g2 = scaled.createGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.setColor(new Color(0, true));
            g2.fillRect(0, 0, destWidth + rightMargin, destHeight + bottomMargin);
            if (clip != null) {
                g2.setClip(clip);
            }
            if (xScale == 1.0 && yScale == 1.0) {
                g2.drawImage((Image)source, 0, 0, null);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
            }
            g2.dispose();
            BufferedImage bufferedImage = scaled;
            if (bufferedImage == null) {
                ImageUtils.$$$reportNull$$$0(8);
            }
            return bufferedImage;
        }
        int iterations = 0;
        int nearestWidth = destWidth;
        int nearestHeight = destHeight;
        while (nearestWidth < sourceWidth / 2) {
            nearestWidth *= 2;
            nearestHeight *= 2;
            ++iterations;
        }
        if (iterations == 0) {
            nearestWidth += rightMargin;
            nearestHeight += bottomMargin;
        }
        BufferedImage scaled = new BufferedImage(nearestWidth, nearestHeight, imageType);
        Graphics2D g2 = scaled.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(source, 0, 0, nearestWidth, nearestHeight, 0, 0, sourceWidth, sourceHeight, null);
        g2.dispose();
        sourceWidth = nearestWidth;
        sourceHeight = nearestHeight;
        source = scaled;
        for (int iteration = iterations - 1; iteration >= 0; --iteration) {
            int halfWidth = sourceWidth / 2;
            int halfHeight = sourceHeight / 2;
            if (iteration == 0) {
                scaled = new BufferedImage(halfWidth + rightMargin, halfHeight + bottomMargin, imageType);
                g2 = scaled.createGraphics();
                if (clip != null) {
                    g2.setClip(clip);
                }
            } else {
                scaled = new BufferedImage(halfWidth, halfHeight, imageType);
                g2 = scaled.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(source, 0, 0, halfWidth, halfHeight, 0, 0, sourceWidth, sourceHeight, null);
            g2.dispose();
            sourceWidth = halfWidth;
            sourceHeight = halfHeight;
            source = scaled;
            --iterations;
        }
        BufferedImage bufferedImage = scaled;
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(9);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage lowQualityFastScale(@NotNull BufferedImage source, double xScale, double d) {
        void yScale;
        if (source == null) {
            ImageUtils.$$$reportNull$$$0(10);
        }
        BufferedImage bufferedImage = ImageUtils.lowQualityFastScale(source, xScale, (double)yScale, 0, 0, null);
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(11);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage lowQualityFastScale(@NotNull BufferedImage source, double xScale, double yScale, int rightMargin, int n, @Nullable Shape shape) {
        void clip;
        void bottomMargin;
        if (source == null) {
            ImageUtils.$$$reportNull$$$0(12);
        }
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = Math.max(1, (int)(xScale * (double)sourceWidth));
        int destHeight = Math.max(1, (int)(yScale * (double)sourceHeight));
        int imageType = source.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage scaled = new BufferedImage(destWidth + rightMargin, destHeight + bottomMargin, imageType);
        Graphics2D g2 = scaled.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setColor(new Color(0, true));
        g2.fillRect(0, 0, destWidth + rightMargin, destHeight + bottomMargin);
        if (clip != null) {
            g2.setClip((Shape)clip);
        }
        if (xScale == 1.0 && yScale == 1.0) {
            g2.drawImage((Image)source, 0, 0, null);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
        }
        g2.dispose();
        BufferedImage bufferedImage = scaled;
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(13);
        }
        return bufferedImage;
    }

    @Nullable
    public static BufferedImage cropBlank(@NotNull BufferedImage image, @Nullable Rectangle initialCrop) {
        if (image == null) {
            ImageUtils.$$$reportNull$$$0(14);
        }
        return ImageUtils.cropBlank(image, initialCrop, image.getType());
    }

    @Nullable
    public static BufferedImage cropBlank(@Nullable BufferedImage image, @Nullable Rectangle initialCrop, int imageType) {
        return ImageUtils.crop(image, TRANSPARENCY_FILTER, initialCrop, imageType);
    }

    @Nullable
    public static Rectangle getCropBounds(@Nullable BufferedImage image, @NotNull CropFilter filter, @Nullable Rectangle initialCrop) {
        int y;
        int x;
        int y2;
        int x2;
        int y1;
        int x1;
        if (filter == null) {
            ImageUtils.$$$reportNull$$$0(15);
        }
        if (image == null) {
            return null;
        }
        if (initialCrop != null) {
            x1 = initialCrop.x;
            y1 = initialCrop.y;
            x2 = initialCrop.x + initialCrop.width;
            y2 = initialCrop.y + initialCrop.height;
        } else {
            x1 = 0;
            y1 = 0;
            x2 = image.getWidth();
            y2 = image.getHeight();
        }
        if (x1 == x2 || y1 == y2) {
            return null;
        }
        block0: while (y1 < y2) {
            for (x = x1; x < x2; ++x) {
                if (!filter.crop(image, x, y1)) break block0;
            }
            ++y1;
        }
        if (y1 == y2) {
            return null;
        }
        block2: while (x1 < x2) {
            for (y = y1; y < y2; ++y) {
                if (!filter.crop(image, x1, y)) break block2;
            }
            ++x1;
        }
        block4: while (--x2 >= x1) {
            for (y = y1; y < y2; ++y) {
                if (!filter.crop(image, x2, y)) break block4;
            }
        }
        ++x2;
        block6: while (--y2 >= y1) {
            for (x = x1; x < x2; ++x) {
                if (!filter.crop(image, x, y2)) break block6;
            }
        }
        if (x1 == x2 || y1 == ++y2) {
            return null;
        }
        int width = x2 - x1;
        int height = y2 - y1;
        return new Rectangle(x1, y1, width, height);
    }

    @Nullable
    public static BufferedImage crop(@Nullable BufferedImage image, @NotNull CropFilter filter, @Nullable Rectangle initialCrop, int imageType) {
        if (filter == null) {
            ImageUtils.$$$reportNull$$$0(16);
        }
        if (image == null) {
            return null;
        }
        Rectangle cropBounds = ImageUtils.getCropBounds(image, filter, initialCrop);
        if (cropBounds == null) {
            return null;
        }
        int x1 = cropBounds.x;
        int y1 = cropBounds.y;
        int width = cropBounds.width;
        int height = cropBounds.height;
        int x2 = x1 + width;
        int y2 = y1 + height;
        if (imageType == -1) {
            imageType = image.getType();
        }
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage cropped = new BufferedImage(width, height, imageType);
        Graphics g = cropped.getGraphics();
        g.drawImage(image, 0, 0, width, height, x1, y1, x2, y2, null);
        g.dispose();
        return cropped;
    }

    public static boolean isNonOpaque(@NotNull BufferedImage image) {
        if (image == null) {
            ImageUtils.$$$reportNull$$$0(17);
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                if ((rgb & 0xFF000000 ^ 0xFF000000) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static double calcFullyDisplayZoomFactor(double viewHeight, double viewWidth, double imageHeight, double imageWidth) {
        assert (imageHeight != 0.0 && imageWidth != 0.0);
        return Math.min(viewHeight / imageHeight / 1.1, viewWidth / imageWidth / 1.1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/ImageUtils";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/ImageUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRetinaIgnoringFailures";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "lowQualityFastScale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToRetina";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertToRetinaIgnoringFailures";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lowQualityFastScale";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cropBlank";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCropBounds";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "crop";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isNonOpaque";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CropFilter {
        public boolean crop(BufferedImage var1, int var2, int var3);
    }
}

