/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLookupElementBuilder {
    private JavaLookupElementBuilder() {
    }

    public static LookupElementBuilder forField(@NotNull PsiField field) {
        if (field == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(0);
        }
        return JavaLookupElementBuilder.forField(field, field.getName(), null);
    }

    public static LookupElementBuilder forField(@NotNull PsiField field, String lookupString, @Nullable PsiClass qualifierClass) {
        if (field == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(1);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((Object)field, (String)lookupString).withIcon(field.getIcon(1));
        return JavaLookupElementBuilder.setBoldIfInClass((PsiMember)field, qualifierClass, builder);
    }

    public static LookupElementBuilder forMethod(@NotNull PsiMethod method, PsiSubstitutor substitutor) {
        if (method == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(2);
        }
        return JavaLookupElementBuilder.forMethod(method, method.getName(), substitutor, null);
    }

    public static LookupElementBuilder forMethod(@NotNull PsiMethod method, @NotNull String lookupString, @NotNull PsiSubstitutor substitutor, @Nullable PsiClass qualifierClass) {
        if (method == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(3);
        }
        if (lookupString == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(4);
        }
        if (substitutor == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(5);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((Object)method, (String)lookupString).withIcon(method.getIcon(1)).withPresentableText(method.getName()).withTailText(PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)substitutor, (int)256, (int)3));
        PsiType returnType = method.getReturnType();
        if (returnType != null) {
            builder = builder.withTypeText(substitutor.substitute(returnType).getPresentableText());
        }
        builder = JavaLookupElementBuilder.setBoldIfInClass((PsiMember)method, qualifierClass, builder);
        return builder;
    }

    private static LookupElementBuilder setBoldIfInClass(@NotNull PsiMember member, @Nullable PsiClass psiClass, @NotNull LookupElementBuilder builder) {
        if (member == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(7);
        }
        if (psiClass != null && member.getManager().areElementsEquivalent((PsiElement)member.getContainingClass(), (PsiElement)psiClass)) {
            return builder.bold();
        }
        return builder;
    }

    public static LookupElementBuilder forClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(8);
        }
        return JavaLookupElementBuilder.forClass(psiClass, psiClass.getName());
    }

    public static LookupElementBuilder forClass(@NotNull PsiClass psiClass, String lookupString) {
        if (psiClass == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(9);
        }
        return JavaLookupElementBuilder.forClass(psiClass, lookupString, false);
    }

    public static LookupElementBuilder forClass(@NotNull PsiClass psiClass, String lookupString, boolean withLocation) {
        if (psiClass == null) {
            JavaLookupElementBuilder.$$$reportNull$$$0(10);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((Object)psiClass, (String)lookupString).withIcon(psiClass.getIcon(1));
        String name = psiClass.getName();
        if (StringUtil.isNotEmpty((String)name)) {
            builder = builder.withLookupString(name);
        }
        if (withLocation) {
            return builder.withTailText(" (" + PsiFormatUtil.getPackageDisplayName((PsiClass)psiClass) + ")", true);
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/JavaLookupElementBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forField";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "forMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setBoldIfInClass";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "forClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

