/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMethodFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddMethodFix");
    private final PsiMethod myMethodPrototype;
    private final List<String> myExceptions;
    private String myText;

    public AddMethodFix(@NotNull PsiMethod methodPrototype, @NotNull PsiClass implClass) {
        if (methodPrototype == null) {
            AddMethodFix.$$$reportNull$$$0(0);
        }
        if (implClass == null) {
            AddMethodFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)implClass);
        this.myExceptions = new ArrayList<String>();
        this.myMethodPrototype = methodPrototype;
        this.setText(QuickFixBundle.message("add.method.text", methodPrototype.getName(), implClass.getName()));
    }

    public AddMethodFix(@NonNls @NotNull String methodText, @NotNull PsiClass implClass, String ... exceptions) {
        if (methodText == null) {
            AddMethodFix.$$$reportNull$$$0(2);
        }
        if (implClass == null) {
            AddMethodFix.$$$reportNull$$$0(3);
        }
        if (exceptions == null) {
            AddMethodFix.$$$reportNull$$$0(4);
        }
        this(AddMethodFix.createMethod(methodText, implClass), implClass);
        ContainerUtil.addAll(this.myExceptions, (Object[])exceptions);
    }

    private static PsiMethod createMethod(String methodText, PsiClass implClass) {
        try {
            return JavaPsiFacade.getInstance((Project)implClass.getProject()).getElementFactory().createMethodFromText(methodText, (PsiElement)implClass);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiMethod reformat(Project project, PsiMethod result) throws IncorrectOperationException {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        result = (PsiMethod)codeStyleManager.reformat((PsiElement)result);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        result = (PsiMethod)javaCodeStyleManager.shortenClassReferences((PsiElement)result);
        return result;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            AddMethodFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected void setText(@NotNull String text2) {
        if (text2 == null) {
            AddMethodFix.$$$reportNull$$$0(6);
        }
        this.myText = text2;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.method.family", new Object[0]);
        if (string == null) {
            AddMethodFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddMethodFix.$$$reportNull$$$0(8);
        }
        if (file == null) {
            AddMethodFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            AddMethodFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            AddMethodFix.$$$reportNull$$$0(11);
        }
        PsiClass myClass = (PsiClass)startElement;
        return this.myMethodPrototype.isValid() && myClass.getManager().isInProject((PsiElement)myClass) && this.myText != null && MethodSignatureUtil.findMethodBySignature((PsiClass)myClass, (PsiMethod)this.myMethodPrototype, (boolean)false) == null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiCodeBlock body2;
        PsiClass myClass;
        if (project == null) {
            AddMethodFix.$$$reportNull$$$0(12);
        }
        if (file == null) {
            AddMethodFix.$$$reportNull$$$0(13);
        }
        if (startElement == null) {
            AddMethodFix.$$$reportNull$$$0(14);
        }
        if (endElement == null) {
            AddMethodFix.$$$reportNull$$$0(15);
        }
        if ((myClass = (PsiClass)startElement).isInterface() && (body2 = this.myMethodPrototype.getBody()) != null) {
            body2.delete();
        }
        for (String exception : this.myExceptions) {
            PsiUtil.addException((PsiMethod)this.myMethodPrototype, (String)exception);
        }
        PsiMethod method = (PsiMethod)myClass.add((PsiElement)this.myMethodPrototype);
        method = (PsiMethod)method.replace((PsiElement)AddMethodFix.reformat(project, method));
        this.postAddAction(file, editor, method);
    }

    protected void postAddAction(@NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, PsiMethod newMethod) {
        if (file == null) {
            AddMethodFix.$$$reportNull$$$0(16);
        }
        if (editor != null && newMethod.getContainingFile() == file) {
            GenerateMembersUtil.positionCaret(editor, (PsiElement)newMethod, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodPrototype";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "postAddAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

