/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"createVoidMethodFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "psiClass", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/psi/JvmCommon;", "methodName", "", "modifier", "Lcom/intellij/lang/jvm/JvmModifier;", "(Lcom/intellij/psi/PsiClass;Ljava/lang/String;Lcom/intellij/lang/jvm/JvmModifier;)[Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.java.impl"})
public final class CreateMethodFixKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LocalQuickFix[] createVoidMethodFixes(@NotNull PsiClass psiClass, @NotNull String methodName, @NotNull JvmModifier modifier) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull((Object)modifier, (String)"modifier");
        if (!ModuleUtilCore.projectContainsFile((Project)psiClass.getProject(), (VirtualFile)psiClass.getContainingFile().getVirtualFile(), (boolean)false)) {
            Intrinsics.checkExpressionValueIsNotNull((Object)LocalQuickFix.EMPTY_ARRAY, (String)"LocalQuickFix.EMPTY_ARRAY");
            return LocalQuickFix.EMPTY_ARRAY;
        }
        Project project = psiClass.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiClass.project");
        PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiPrimitiveType, (String)"PsiType.VOID");
        CreateMethodRequest request = MethodRequestsKt.methodRequest((Project)project, (String)methodName, (JvmModifier)modifier, (JvmType)((JvmType)psiPrimitiveType));
        List actions = JvmElementActionFactories.createMethodActions((JvmClass)((JvmClass)psiClass), (CreateMethodRequest)request);
        if (actions.isEmpty()) {
            Intrinsics.checkExpressionValueIsNotNull((Object)LocalQuickFix.EMPTY_ARRAY, (String)"LocalQuickFix.EMPTY_ARRAY");
            return LocalQuickFix.EMPTY_ARRAY;
        }
        Collection collection = IntentionWrapper.wrapToQuickFixes((List)actions, (PsiFile)psiClass.getContainingFile());
        void v2 = $receiver$iv;
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v2;
        LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        if (localQuickFixArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return localQuickFixArray;
    }
}

