/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassToSeparateFileFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(MoveClassToSeparateFileFix.class);
    private final PsiClass myClass;

    public MoveClassToSeparateFileFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            MoveClassToSeparateFileFix.$$$reportNull$$$0(0);
        }
        this.myClass = aClass;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("move.class.to.separate.file.text", this.myClass.getName());
        if (string == null) {
            MoveClassToSeparateFileFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.class.to.separate.file.family", new Object[0]);
        if (string == null) {
            MoveClassToSeparateFileFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            MoveClassToSeparateFileFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            MoveClassToSeparateFileFix.$$$reportNull$$$0(4);
        }
        if (!this.myClass.isValid() || !this.myClass.getManager().isInProject((PsiElement)this.myClass)) {
            return false;
        }
        PsiDirectory dir = file.getContainingDirectory();
        if (dir == null) {
            return false;
        }
        try {
            JavaDirectoryServiceImpl.checkCreateClassOrInterface(dir, this.myClass.getName());
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            MoveClassToSeparateFileFix.$$$reportNull$$$0(5);
        }
        PsiClass psiClass = this.myClass;
        if (psiClass == null) {
            MoveClassToSeparateFileFix.$$$reportNull$$$0(6);
        }
        return psiClass;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            MoveClassToSeparateFileFix.$$$reportNull$$$0(7);
        }
        if (file == null) {
            MoveClassToSeparateFileFix.$$$reportNull$$$0(8);
        }
        PsiDirectory dir = file.getContainingDirectory();
        String name = this.myClass.getName();
        JavaDirectoryService directoryService = JavaDirectoryService.getInstance();
        PsiClass placeHolder = this.myClass.isInterface() ? directoryService.createInterface(dir, name) : directoryService.createClass(dir, name);
        WriteAction.run(() -> {
            if (project == null) {
                MoveClassToSeparateFileFix.$$$reportNull$$$0(9);
            }
            PsiClass newClass = (PsiClass)placeHolder.replace((PsiElement)this.myClass);
            this.myClass.delete();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, newClass.getContainingFile().getVirtualFile(), newClass.getTextOffset());
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

