/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.EqualsHashCodeTemplatesManager;
import com.intellij.codeInsight.generation.GenerateEqualsHandler;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.java.generate.GenerationUtil;
import org.jetbrains.java.generate.template.TemplateResource;

public class GenerateEqualsHelper
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateEqualsHelper");
    @NonNls
    private static final String INSTANCE_NAME = "instanceBaseName";
    @NonNls
    private static final String BASE_PARAM_NAME = "baseParamName";
    @NonNls
    private static final String SUPER_PARAM_NAME = "superParamName";
    @NonNls
    private static final String SUPER_HAS_EQUALS = "superHasEquals";
    @NonNls
    private static final String CHECK_PARAMETER_WITH_INSTANCEOF = "checkParameterWithInstanceof";
    @NonNls
    private static final String SUPER_HAS_HASH_CODE = "superHasHashCode";
    private final PsiClass myClass;
    private final PsiField[] myEqualsFields;
    private final PsiField[] myHashCodeFields;
    private final HashSet<PsiField> myNonNullSet;
    private final PsiElementFactory myFactory;
    private final boolean mySuperHasHashCode;
    private final CodeStyleManager myCodeStyleManager;
    private final JavaCodeStyleManager myJavaCodeStyleManager;
    private final Project myProject;
    private final boolean myCheckParameterWithInstanceof;
    private final boolean myUseAccessors;

    public GenerateEqualsHelper(Project project, PsiClass aClass, PsiField[] equalsFields, PsiField[] hashCodeFields, PsiField[] nonNullFields, boolean useInstanceofToCheckParameterType) {
        this(project, aClass, equalsFields, hashCodeFields, nonNullFields, useInstanceofToCheckParameterType, false);
    }

    public GenerateEqualsHelper(Project project, PsiClass aClass, PsiField[] equalsFields, PsiField[] hashCodeFields, PsiField[] nonNullFields, boolean useInstanceofToCheckParameterType, boolean useAccessors) {
        this.myClass = aClass;
        this.myEqualsFields = equalsFields;
        this.myHashCodeFields = hashCodeFields;
        this.myProject = project;
        this.myCheckParameterWithInstanceof = useInstanceofToCheckParameterType;
        this.myUseAccessors = useAccessors;
        this.myNonNullSet = new HashSet();
        ContainerUtil.addAll(this.myNonNullSet, (Object[])nonNullFields);
        PsiManager manager = PsiManager.getInstance((Project)project);
        this.myFactory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        this.mySuperHasHashCode = this.superMethodExists(GenerateEqualsHelper.getHashCodeSignature());
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        this.myJavaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)manager.getProject());
    }

    private static boolean shouldAddOverrideAnnotation(PsiElement context) {
        JavaCodeStyleSettings style = (JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)context.getProject()).getCustomSettings(JavaCodeStyleSettings.class);
        return style.INSERT_OVERRIDE_ANNOTATION && PsiUtil.isLanguageLevel5OrHigher((PsiElement)context);
    }

    @Override
    public void run() {
        try {
            Collection<PsiMethod> members = this.generateMembers();
            for (PsiElement psiElement : members) {
                this.myClass.add(psiElement);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public Collection<PsiMethod> generateMembers() throws IncorrectOperationException {
        PsiMethod equals = null;
        if (this.myEqualsFields != null && GenerateEqualsHandler.needToGenerateMethod(GenerateEqualsHelper.findMethod(this.myClass, GenerateEqualsHelper.getEqualsSignature(this.myProject, this.myClass.getResolveScope())))) {
            equals = this.createEquals();
        }
        PsiMethod hashCode = null;
        if (this.myHashCodeFields != null && GenerateEqualsHandler.needToGenerateMethod(GenerateEqualsHelper.findMethod(this.myClass, GenerateEqualsHelper.getHashCodeSignature()))) {
            if (this.myHashCodeFields.length > 0) {
                hashCode = this.createHashCode();
            } else if (!this.mySuperHasHashCode) {
                String text2 = "";
                if (GenerateEqualsHelper.shouldAddOverrideAnnotation((PsiElement)this.myClass)) {
                    text2 = text2 + "@Override\n";
                }
                text2 = text2 + "public int hashCode() {\nreturn 0;\n}";
                PsiMethod trivialHashCode = this.myFactory.createMethodFromText(text2, null);
                hashCode = (PsiMethod)this.myCodeStyleManager.reformat((PsiElement)trivialHashCode);
            }
        }
        if (hashCode != null && equals != null) {
            return Arrays.asList(equals, hashCode);
        }
        if (equals != null) {
            return Collections.singletonList(equals);
        }
        if (hashCode != null) {
            return Collections.singletonList(hashCode);
        }
        return Collections.emptyList();
    }

    public static Map<String, PsiType> getEqualsImplicitVars(Project project) {
        LinkedHashMap<String, PsiType> map = new LinkedHashMap<String, PsiType>();
        PsiPrimitiveType stringType = project != null ? PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)) : PsiType.NULL;
        map.put(INSTANCE_NAME, (PsiType)stringType);
        map.put(BASE_PARAM_NAME, (PsiType)stringType);
        map.put(SUPER_PARAM_NAME, (PsiType)stringType);
        map.put(CHECK_PARAMETER_WITH_INSTANCEOF, (PsiType)PsiType.BOOLEAN);
        map.put(SUPER_HAS_EQUALS, (PsiType)PsiType.BOOLEAN);
        return map;
    }

    public static Map<String, PsiType> getHashCodeImplicitVars() {
        LinkedHashMap<String, PsiType> map = new LinkedHashMap<String, PsiType>();
        map.put(SUPER_HAS_HASH_CODE, (PsiType)PsiType.BOOLEAN);
        return map;
    }

    private PsiMethod createEquals() throws IncorrectOperationException {
        PsiMethod result;
        StringBuilder buffer = new StringBuilder();
        JavaCodeStyleSettings styleSettings = (JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class);
        ArrayList equalsFields = new ArrayList();
        ContainerUtil.addAll(equalsFields, (Object[])this.myEqualsFields);
        Collections.sort(equalsFields, EqualsFieldsComparator.INSTANCE);
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        PsiClassType classType = JavaPsiFacade.getElementFactory((Project)this.myClass.getProject()).createType(this.myClass);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myClass.getProject());
        String[] nameSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)classType).names;
        String instanceBaseName = nameSuggestions.length > 0 && nameSuggestions[0].length() < 10 ? nameSuggestions[0] : "that";
        contextMap.put(INSTANCE_NAME, instanceBaseName);
        PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)this.myClass.getManager(), (GlobalSearchScope)this.myClass.getResolveScope());
        nameSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)objectType).names;
        String objectBaseName = nameSuggestions.length > 0 ? nameSuggestions[0] : "object";
        contextMap.put(BASE_PARAM_NAME, objectBaseName);
        MethodSignature equalsSignature = GenerateEqualsHelper.getEqualsSignature(this.myProject, this.myClass.getResolveScope());
        PsiMethod superEquals = MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (MethodSignature)equalsSignature, (boolean)true);
        if (superEquals != null) {
            contextMap.put(SUPER_PARAM_NAME, superEquals.getParameterList().getParameters()[0].getName());
        }
        contextMap.put(SUPER_HAS_EQUALS, this.superMethodExists(equalsSignature));
        contextMap.put(CHECK_PARAMETER_WITH_INSTANCEOF, this.myCheckParameterWithInstanceof);
        String methodText = GenerationUtil.velocityGenerateCode(this.myClass, equalsFields, this.myNonNullSet, new HashMap<String, String>(), contextMap, EqualsHashCodeTemplatesManager.getInstance().getDefaultEqualsTemplate().getTemplate(), 0, false, this.myUseAccessors);
        buffer.append(methodText);
        try {
            result = this.myFactory.createMethodFromText(buffer.toString(), (PsiElement)this.myClass);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        PsiParameter[] parameters2 = result.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return null;
        }
        PsiParameter parameter2 = parameters2[0];
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter2, (String)"final", (boolean)styleSettings.GENERATE_FINAL_PARAMETERS);
        PsiMethod method = (PsiMethod)this.myCodeStyleManager.reformat((PsiElement)result);
        if (superEquals != null) {
            OverrideImplementUtil.annotateOnOverrideImplement(method, this.myClass, superEquals);
        }
        method = (PsiMethod)this.myJavaCodeStyleManager.shortenClassReferences((PsiElement)method);
        return method;
    }

    private boolean superMethodExists(MethodSignature methodSignature) {
        LOG.assertTrue(this.myClass.isValid());
        PsiMethod superEquals = MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (MethodSignature)methodSignature, (boolean)true);
        if (superEquals == null) {
            return true;
        }
        if (superEquals.hasModifierProperty("abstract")) {
            return false;
        }
        return !"java.lang.Object".equals(superEquals.getContainingClass().getQualifiedName());
    }

    private PsiMethod createHashCode() throws IncorrectOperationException {
        PsiMethod hashCode;
        StringBuilder buffer = new StringBuilder();
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put(SUPER_HAS_HASH_CODE, this.mySuperHasHashCode);
        String methodText = GenerationUtil.velocityGenerateCode(this.myClass, Arrays.asList(this.myHashCodeFields), this.myNonNullSet, new HashMap<String, String>(), contextMap, EqualsHashCodeTemplatesManager.getInstance().getDefaultHashcodeTemplate().getTemplate(), 0, false, this.myUseAccessors);
        buffer.append(methodText);
        try {
            hashCode = this.myFactory.createMethodFromText(buffer.toString(), null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        PsiMethod superHashCode = MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (MethodSignature)GenerateEqualsHelper.getHashCodeSignature(), (boolean)true);
        if (superHashCode != null) {
            OverrideImplementUtil.annotateOnOverrideImplement(hashCode, this.myClass, superHashCode);
        }
        hashCode = (PsiMethod)this.myJavaCodeStyleManager.shortenClassReferences((PsiElement)hashCode);
        return (PsiMethod)this.myCodeStyleManager.reformat((PsiElement)hashCode);
    }

    public void invoke() {
        ApplicationManager.getApplication().runWriteAction((Runnable)this);
    }

    static PsiMethod findMethod(PsiClass aClass, MethodSignature signature) {
        return MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)signature, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithDefaultTemplateWhenNotApplicable() {
        EqualsHashCodeTemplatesManager manager = EqualsHashCodeTemplatesManager.getInstance();
        String baseName = manager.getDefaultTemplateBaseName();
        try {
            PsiClass usedClass;
            TemplateResource defaultTemplate = manager.getDefaultTemplate();
            String className = defaultTemplate.getClassName();
            if (className != null && ((usedClass = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).findClass(className, this.myClass.getResolveScope())) == null || PsiUtil.getLanguageLevel((PsiElement)this.myClass).isLessThan(PsiUtil.getLanguageLevel((PsiElement)usedClass)))) {
                manager.setDefaultTemplate("IntelliJ Default");
            }
            this.run();
        }
        finally {
            manager.setDefaultTemplate(baseName);
        }
    }

    public static boolean isArrayOfObjects(PsiType aType) {
        if (!(aType instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)aType).getComponentType();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)componentType);
        if (psiClass == null) {
            return false;
        }
        String qName = psiClass.getQualifiedName();
        return "java.lang.Object".equals(qName);
    }

    public static MethodSignature getHashCodeSignature() {
        return MethodSignatureUtil.createMethodSignature((String)"hashCode", (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    public static MethodSignature getEqualsSignature(Project project, GlobalSearchScope scope) {
        PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)scope);
        return MethodSignatureUtil.createMethodSignature((String)"equals", (PsiType[])new PsiType[]{javaLangObject}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    static class EqualsFieldsComparator
    implements Comparator<PsiField> {
        public static final EqualsFieldsComparator INSTANCE = new EqualsFieldsComparator();

        EqualsFieldsComparator() {
        }

        @Override
        public int compare(PsiField f1, PsiField f2) {
            if (f1.getType() instanceof PsiPrimitiveType && !(f2.getType() instanceof PsiPrimitiveType)) {
                return -1;
            }
            if (!(f1.getType() instanceof PsiPrimitiveType) && f2.getType() instanceof PsiPrimitiveType) {
                return 1;
            }
            return PsiUtilCore.compareElementsByPosition((PsiElement)f1, (PsiElement)f2);
        }
    }
}

