/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.hints.AnnotationHintsPassFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.DocumentUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00152\u00020\u0001:\u0005\u0014\u0015\u0016\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass;", "Lcom/intellij/codeHighlighting/EditorBoundHighlightingPass;", "rootElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "hints", "Lgnu/trove/TIntObjectHashMap;", "", "Lcom/intellij/codeInsight/hints/AnnotationHintsPass$HintData;", "traverser", "Lcom/intellij/psi/SyntaxTraverser;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "process", "element", "AnnotationHintRenderer", "Companion", "HintData", "ToggleExternalAnnotationsHintsAction", "ToggleInferredAnnotationsHintsAction", "intellij.java.impl"})
public final class AnnotationHintsPass
extends EditorBoundHighlightingPass {
    private final TIntObjectHashMap<List<HintData>> hints;
    private final SyntaxTraverser<PsiElement> traverser;
    private final PsiElement rootElement;
    private static final Key<Boolean> ANNOTATION_INLAY_KEY;
    public static final Companion Companion;

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)progress, (String)"progress");
        boolean bl2 = bl = this.myDocument != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.hints.clear();
        if (CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE || CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE) {
            Iterable $receiver$iv = (Iterable)this.traverser;
            for (Object element$iv : $receiver$iv) {
                PsiElement it;
                PsiElement psiElement = it = (PsiElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it");
                this.process(psiElement);
            }
        }
    }

    private final void process(PsiElement element) {
        if (element instanceof PsiModifierListOwner) {
            Sequence $receiver$iv;
            Sequence annotations2 = SequencesKt.emptySequence();
            if (CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE) {
                Object[] objectArray = ExternalAnnotationsManager.getInstance((Project)((PsiModifierListOwner)element).getProject()).findExternalAnnotations((PsiModifierListOwner)element);
                Sequence sequence = annotations2;
                Sequence sequence2 = $receiver$iv;
                if (sequence2 == null) {
                    sequence2 = new Sequence[]{};
                }
                Sequence sequence3 = sequence2;
                annotations2 = SequencesKt.plus((Sequence)sequence, (Object[])sequence3);
            }
            if (CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE) {
                PsiAnnotation[] psiAnnotationArray = InferredAnnotationsManager.getInstance((Project)((PsiModifierListOwner)element).getProject()).findInferredAnnotations((PsiModifierListOwner)element);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationArray, (String)"InferredAnnotationsManag\u2026erredAnnotations(element)");
                annotations2 = SequencesKt.plus((Sequence)annotations2, (Object[])psiAnnotationArray);
            }
            $receiver$iv = annotations2;
            for (Object element$iv : $receiver$iv) {
                int offset;
                List hintList;
                PsiAnnotation it = (PsiAnnotation)element$iv;
                if (it.getNameReferenceElement() == null || ((PsiModifierListOwner)element).getModifierList() == null) continue;
                PsiModifierList psiModifierList = ((PsiModifierListOwner)element).getModifierList();
                if (psiModifierList == null) {
                    Intrinsics.throwNpe();
                }
                if ((hintList = (List)this.hints.get(offset = psiModifierList.getTextRange().getStartOffset())) == null) {
                    hintList = new ArrayList();
                    this.hints.put(offset, (Object)hintList);
                }
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = it.getNameReferenceElement();
                hintList.add(new HintData("@" + (psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getReferenceName() : null) + it.getParameterList().getText()));
            }
        }
    }

    public void doApplyInformationToEditor() {
        CaretVisualPositionKeeper keeper = new CaretVisualPositionKeeper(this.myEditor);
        DocumentUtil.executeInBulk((Document)this.myEditor.getDocument(), (this.hints.size() > 1000 ? 1 : 0) != 0, (Runnable)new Runnable(this){
            final /* synthetic */ AnnotationHintsPass this$0;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $receiver$iv$iv;
                InlayModel inlayModel = AnnotationHintsPass.access$getMyEditor$p(this.this$0).getInlayModel();
                Iterable $receiver$iv = inlayModel.getInlineElementsInRange(AnnotationHintsPass.access$getRootElement$p(this.this$0).getTextRange().getStartOffset() + 1, AnnotationHintsPass.access$getRootElement$p(this.this$0).getTextRange().getEndOffset() - 1);
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    Inlay it = (Inlay)element$iv$iv;
                    if (!com.intellij.codeInsight.hints.AnnotationHintsPass$Companion.access$getANNOTATION_INLAY_KEY$p(AnnotationHintsPass.Companion).isIn((UserDataHolder)it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (E element$iv : $receiver$iv) {
                    Inlay it = (Inlay)element$iv;
                    Disposer.dispose((Disposable)((Disposable)it));
                }
                AnnotationHintsPass.access$getHints$p(this.this$0).forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<List<HintData>>(inlayModel){
                    final /* synthetic */ InlayModel $inlayModel;

                    public final boolean execute(int offset, List<HintData> info) {
                        Iterable $receiver$iv = info;
                        for (T element$iv : $receiver$iv) {
                            HintData it = (HintData)element$iv;
                            Inlay inlay = this.$inlayModel.addInlineElement(offset, (EditorCustomElementRenderer)new AnnotationHintRenderer(it.getPresentationText()));
                            inlay.putUserData(com.intellij.codeInsight.hints.AnnotationHintsPass$Companion.access$getANNOTATION_INLAY_KEY$p(AnnotationHintsPass.Companion), (Object)true);
                        }
                        return true;
                    }
                    {
                        this.$inlayModel = inlayModel;
                    }
                });
            }
            {
                this.this$0 = annotationHintsPass;
            }
        });
        keeper.restoreOriginalLocation(false);
        if (this.rootElement == this.myFile) {
            Editor editor = this.myEditor;
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myEditor");
            PsiFile psiFile = this.myFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"myFile");
            AnnotationHintsPassFactory.Companion.putCurrentModificationStamp(editor, psiFile);
        }
    }

    public AnnotationHintsPass(@NotNull PsiElement rootElement, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)rootElement, (String)"rootElement");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        super(editor, rootElement.getContainingFile(), true);
        this.rootElement = rootElement;
        this.hints = new TIntObjectHashMap();
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)this.rootElement);
        Intrinsics.checkExpressionValueIsNotNull((Object)syntaxTraverser, (String)"SyntaxTraverser.psiTraverser(rootElement)");
        this.traverser = syntaxTraverser;
    }

    static {
        Companion = new Companion(null);
        ANNOTATION_INLAY_KEY = Key.create((String)"ANNOTATION_INLAY_KEY");
    }

    @NotNull
    public static final /* synthetic */ Editor access$getMyEditor$p(AnnotationHintsPass $this) {
        return $this.myEditor;
    }

    @NotNull
    public static final /* synthetic */ PsiElement access$getRootElement$p(AnnotationHintsPass $this) {
        return $this.rootElement;
    }

    @NotNull
    public static final /* synthetic */ TIntObjectHashMap access$getHints$p(AnnotationHintsPass $this) {
        return $this.hints;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$HintData;", "", "presentationText", "", "(Ljava/lang/String;)V", "getPresentationText", "()Ljava/lang/String;", "intellij.java.impl"})
    public static final class HintData {
        @NotNull
        private final String presentationText;

        @NotNull
        public final String getPresentationText() {
            return this.presentationText;
        }

        public HintData(@NotNull String presentationText) {
            Intrinsics.checkParameterIsNotNull((Object)presentationText, (String)"presentationText");
            this.presentationText = presentationText;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$AnnotationHintRenderer;", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "text", "", "(Ljava/lang/String;)V", "getContextMenuGroupId", "intellij.java.impl"})
    private static final class AnnotationHintRenderer
    extends HintRenderer {
        @NotNull
        public String getContextMenuGroupId() {
            return "AnnotationHintsContextMenu";
        }

        public AnnotationHintRenderer(@NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            super(text2);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$ToggleExternalAnnotationsHintsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.java.impl"})
    public static final class ToggleExternalAnnotationsHintsAction
    extends ToggleAction {
        public boolean isSelected(@Nullable AnActionEvent e) {
            return CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE;
        }

        public void setSelected(@Nullable AnActionEvent e, boolean state) {
            CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE = state;
            AnnotationHintsPassFactory.Companion.forceHintsUpdateOnNextPass();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$ToggleInferredAnnotationsHintsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.java.impl"})
    public static final class ToggleInferredAnnotationsHintsAction
    extends ToggleAction {
        public boolean isSelected(@Nullable AnActionEvent e) {
            return CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE;
        }

        public void setSelected(@Nullable AnActionEvent e, boolean state) {
            CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE = state;
            AnnotationHintsPassFactory.Companion.forceHintsUpdateOnNextPass();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$Companion;", "", "()V", "ANNOTATION_INLAY_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "getANNOTATION_INLAY_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.java.impl"})
    public static final class Companion {
        private final Key<Boolean> getANNOTATION_INLAY_KEY() {
            return ANNOTATION_INLAY_KEY;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Key access$getANNOTATION_INLAY_KEY$p(Companion $this) {
            return $this.getANNOTATION_INLAY_KEY();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

