/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterDialog;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class CreateFieldFromParameterActionBase
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(CreateFieldFromParameterActionBase.class);

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiParameter parameter2;
        if (project == null) {
            CreateFieldFromParameterActionBase.$$$reportNull$$$0(0);
        }
        if ((parameter2 = FieldFromParameterUtils.findParameterAtCursor(file, editor)) == null || !this.isAvailable(parameter2)) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.create.field.from.parameter.text", (Object[])new Object[]{parameter2.getName()}));
        return true;
    }

    protected abstract boolean isAvailable(PsiParameter var1);

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.create.field.from.parameter.family", (Object[])new Object[0]);
        if (string == null) {
            CreateFieldFromParameterActionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        PsiParameter myParameter;
        if (project == null) {
            CreateFieldFromParameterActionBase.$$$reportNull$$$0(2);
        }
        if ((myParameter = FieldFromParameterUtils.findParameterAtCursor(file, editor)) == null || !FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        try {
            this.processParameter(project, myParameter, !ApplicationManager.getApplication().isHeadlessEnvironment());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void processParameter(@NotNull Project project, @NotNull PsiParameter myParameter, boolean isInteractive) {
        boolean isFinalToCalc;
        Object fieldNameToCalc;
        if (project == null) {
            CreateFieldFromParameterActionBase.$$$reportNull$$$0(3);
        }
        if (myParameter == null) {
            CreateFieldFromParameterActionBase.$$$reportNull$$$0(4);
        }
        PsiType type2 = this.getSubstitutedType(myParameter);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        String parameterName = myParameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class);
        PsiMethod method = (PsiMethod)myParameter.getDeclarationScope();
        boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind2 = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind2, propertyName, null, type2);
        Object[] names = suggestedNameInfo.names;
        if (isInteractive) {
            ArrayList<String> namesList = new ArrayList<String>();
            ContainerUtil.addAll(namesList, (Object[])names);
            String defaultName = styleManager.propertyNameToVariableName(propertyName, kind2);
            if (namesList.contains(defaultName)) {
                Collections.swap(namesList, 0, namesList.indexOf(defaultName));
            } else {
                namesList.add(0, defaultName);
            }
            names = ArrayUtil.toStringArray(namesList);
            CreateFieldFromParameterDialog dialog = new CreateFieldFromParameterDialog(project, (String[])names, targetClass, method.isConstructor(), type2);
            if (!dialog.showAndGet()) {
                return;
            }
            fieldNameToCalc = dialog.getEnteredName();
            isFinalToCalc = dialog.isDeclareFinal();
            suggestedNameInfo.nameChosen((String)fieldNameToCalc);
        } else {
            isFinalToCalc = !isMethodStatic && method.isConstructor();
            fieldNameToCalc = names[0];
        }
        boolean isFinal = isFinalToCalc;
        Object fieldName = fieldNameToCalc;
        ApplicationManager.getApplication().runWriteAction(() -> this.lambda$processParameter$0(project, targetClass, method, myParameter, type2, (String)fieldName, isMethodStatic, isFinal));
    }

    protected abstract PsiType getSubstitutedType(PsiParameter var1);

    protected abstract void performRefactoring(Project var1, PsiClass var2, PsiMethod var3, PsiParameter var4, PsiType var5, String var6, boolean var7, boolean var8);

    public boolean startInWriteAction() {
        return false;
    }

    private /* synthetic */ void lambda$processParameter$0(@NotNull Project project, PsiClass targetClass, PsiMethod method, @NotNull PsiParameter myParameter, PsiType type2, String fieldName, boolean isMethodStatic, boolean isFinal) {
        if (project == null) {
            CreateFieldFromParameterActionBase.$$$reportNull$$$0(5);
        }
        if (myParameter == null) {
            CreateFieldFromParameterActionBase.$$$reportNull$$$0(6);
        }
        try {
            this.performRefactoring(project, targetClass, method, myParameter, type2, fieldName, isMethodStatic, isFinal);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processParameter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processParameter$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

