/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import javax.swing.JList;

public class ImplementAbstractMethodHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.ImplementAbstractMethodHandler");
    private final Project myProject;
    private final Editor myEditor;
    private final PsiMethod myMethod;
    private JList myList;

    public ImplementAbstractMethodHandler(Project project, Editor editor, PsiMethod method) {
        this.myProject = project;
        this.myEditor = editor;
        this.myMethod = method;
    }

    public void invoke() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        Ref problemDetected = new Ref();
        PsiElement[][] result = new PsiElement[1][];
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass psiClass = this.myMethod.getContainingClass();
            if (!psiClass.isValid()) {
                return;
            }
            if (!psiClass.isEnum()) {
                result[0] = this.getClassImplementations(psiClass, (Ref<String>)problemDetected);
            } else {
                ArrayList<Object> enumConstants = new ArrayList<Object>();
                for (PsiField field : psiClass.getFields()) {
                    if (!(field instanceof PsiEnumConstant)) continue;
                    PsiEnumConstantInitializer initializingClass2 = ((PsiEnumConstant)field).getInitializingClass();
                    if (initializingClass2 != null) {
                        PsiMethod method = initializingClass2.findMethodBySignature(this.myMethod, true);
                        if (method != null && method.getContainingClass().equals(initializingClass2)) continue;
                        enumConstants.add(initializingClass2);
                        continue;
                    }
                    enumConstants.add(field);
                }
                result[0] = PsiUtilCore.toPsiElementArray(enumConstants);
            }
        }), CodeInsightBundle.message((String)"intention.implement.abstract.method.searching.for.descendants.progress", (Object[])new Object[0]), true, this.myProject);
        if (result[0] == null) {
            return;
        }
        if (result[0].length == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)(problemDetected.isNull() ? CodeInsightBundle.message((String)"intention.implement.abstract.method.error.no.classes.message", (Object[])new Object[0]) : (String)problemDetected.get()), (String)CodeInsightBundle.message((String)"intention.implement.abstract.method.error.no.classes.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return;
        }
        if (result[0].length == 1) {
            this.implementInClass(new Object[]{result[0][0]});
            return;
        }
        MyPsiElementListCellRenderer elementListCellRenderer = new MyPsiElementListCellRenderer();
        elementListCellRenderer.sort(result[0]);
        this.myList = new JBList(result[0]);
        this.myList.setSelectionMode(2);
        Runnable runnable = () -> {
            int index = this.myList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.implementInClass(this.myList.getSelectedValues());
        };
        this.myList.setCellRenderer(elementListCellRenderer);
        PopupChooserBuilder builder = new PopupChooserBuilder(this.myList);
        elementListCellRenderer.installSpeedSearch(builder);
        builder.setTitle(CodeInsightBundle.message((String)"intention.implement.abstract.method.class.chooser.title", (Object[])new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(this.myEditor);
    }

    public void implementInClass(Object[] selection) {
        for (Object o : selection) {
            if (((PsiElement)o).isValid()) continue;
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            LinkedHashSet<Object> classes2 = new LinkedHashSet<Object>();
            for (final Object o : selection) {
                if (o instanceof PsiEnumConstant) {
                    classes2.add(ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiClass>(){

                        public PsiClass compute() {
                            return ((PsiEnumConstant)o).getOrCreateInitializingClass();
                        }
                    }));
                    continue;
                }
                classes2.add((PsiClass)o);
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(classes2)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (PsiClass psiClass : classes2) {
                    try {
                        OverrideImplementUtil.overrideOrImplement(psiClass, this.myMethod);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }, CodeInsightBundle.message((String)"intention.implement.abstract.method.command.name", (Object[])new Object[0]), null);
    }

    private PsiClass[] getClassImplementations(PsiClass psiClass, Ref<String> problemDetected) {
        ArrayList<PsiClass> list = new ArrayList<PsiClass>();
        LinkedHashSet<String> classNamesWithPotentialImplementations = new LinkedHashSet<String>();
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)psiClass)) {
            PsiSubstitutor classSubstitutor;
            PsiMethod method;
            if (inheritor.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)inheritor) || (method = (classSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)psiClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY)) != null ? MethodSignatureUtil.findMethodBySignature((PsiClass)inheritor, (MethodSignature)this.myMethod.getSignature(classSubstitutor), (boolean)true) : inheritor.findMethodBySignature(this.myMethod, true)) == null) continue;
            PsiClass containingClass = method.getContainingClass();
            if (!psiClass.equals(containingClass)) {
                if (containingClass == null) continue;
                classNamesWithPotentialImplementations.add(PsiFormatUtil.formatClass((PsiClass)containingClass, (int)1));
                continue;
            }
            list.add(inheritor);
        }
        if (!classNamesWithPotentialImplementations.isEmpty()) {
            problemDetected.set((Object)("Potential implementations with weaker access privileges are found: " + StringUtil.join(classNamesWithPotentialImplementations, (String)", ")));
        }
        return list.toArray(PsiClass.EMPTY_ARRAY);
    }

    private static class MyPsiElementListCellRenderer
    extends PsiElementListCellRenderer<PsiElement> {
        private final PsiClassListCellRenderer myRenderer = new PsiClassListCellRenderer();

        private MyPsiElementListCellRenderer() {
        }

        void sort(PsiElement[] result) {
            Comparator comparator = this.myRenderer.getComparator();
            Arrays.sort(result, (o1, o2) -> {
                if (o1 instanceof PsiEnumConstant && o2 instanceof PsiEnumConstant) {
                    return ((PsiEnumConstant)o1).getName().compareTo(((PsiEnumConstant)o2).getName());
                }
                if (o1 instanceof PsiEnumConstant) {
                    return -1;
                }
                if (o2 instanceof PsiEnumConstant) {
                    return 1;
                }
                return comparator.compare((PsiClass)o1, (PsiClass)o2);
            });
        }

        public String getElementText(PsiElement element) {
            return element instanceof PsiClass ? this.myRenderer.getElementText((PsiClass)element) : ((PsiEnumConstant)element).getName();
        }

        protected String getContainerText(PsiElement element, String name) {
            return element instanceof PsiClass ? PsiClassListCellRenderer.getContainerTextStatic(element) : ((PsiEnumConstant)element).getContainingClass().getQualifiedName();
        }

        protected int getIconFlags() {
            return 0;
        }
    }
}

