/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortContentAction
extends PsiElementBaseIntentionAction {
    private static final ExpressionSortableList<?>[] ourSortableLists = new ExpressionSortableList[]{new ArraySortableList(), new VarargSortableList()};
    public static final int MIN_EXPRESSION_COUNT = 3;

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Sort content" == null) {
            SortContentAction.$$$reportNull$$$0(0);
        }
        return "Sort content";
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SortContentAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            SortContentAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SortContentAction.$$$reportNull$$$0(3);
        }
        for (ExpressionSortableList<?> list : ourSortableLists) {
            if (list.extract(element) != null) break;
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            SortContentAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            SortContentAction.$$$reportNull$$$0(5);
        }
        for (ExpressionSortableList<?> sortableList : ourSortableLists) {
            if (!((ExpressionSortableList)sortableList).isAvailable(element)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean isOrdered(@NotNull T[] array, @NotNull Comparator<T> comparator) {
        if (array == null) {
            SortContentAction.$$$reportNull$$$0(6);
        }
        if (comparator == null) {
            SortContentAction.$$$reportNull$$$0(7);
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (comparator.compare(array[i], array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null")
    @Nullable
    private static Comparator<PsiExpression> getComparator(@Nullable PsiType type2) {
        if (type2 == null) {
            return null;
        }
        if (type2.equalsToText("java.lang.String")) {
            return Comparator.comparing(o -> (String)ExpressionUtils.computeConstantExpression(o));
        }
        if (SortContentAction.isNumericType(type2)) {
            return Comparator.comparingLong(o -> ((Number)Objects.requireNonNull(ExpressionUtils.computeConstantExpression(o))).longValue());
        }
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Enum")) {
            return Comparator.comparing(expr -> ((PsiReferenceExpression)expr).getReferenceName());
        }
        return null;
    }

    private static boolean isNumericType(@NotNull PsiType type2) {
        if (type2 == null) {
            SortContentAction.$$$reportNull$$$0(8);
        }
        return type2.equals(PsiType.INT) || type2.equals(PsiType.LONG) || type2.equals(PsiType.SHORT) || type2.equals(PsiType.BYTE);
    }

    private static boolean isSortableExpression(@NotNull PsiExpression current) {
        if (current == null) {
            SortContentAction.$$$reportNull$$$0(9);
        }
        return ExpressionUtils.isEvaluatedAtCompileTime(current) || SortContentAction.isEnumConstant(current);
    }

    private static boolean isSeparator(@NotNull PsiElement current) {
        if (current == null) {
            SortContentAction.$$$reportNull$$$0(10);
        }
        return current instanceof PsiJavaToken && ((PsiJavaToken)current).getTokenType() == JavaTokenType.COMMA;
    }

    @Contract(value="null -> false")
    private static boolean isEnumConstant(PsiExpression current) {
        return current instanceof PsiReferenceExpression && ((PsiReferenceExpression)current).resolve() instanceof PsiEnumConstant;
    }

    private static boolean isSortableEnums(@NotNull StreamEx<PsiExpression> expressions2, @NotNull PsiType expectedType) {
        if (expressions2 == null) {
            SortContentAction.$$$reportNull$$$0(11);
        }
        if (expectedType == null) {
            SortContentAction.$$$reportNull$$$0(12);
        }
        return expressions2.allMatch(current -> {
            if (expectedType == null) {
                SortContentAction.$$$reportNull$$$0(18);
            }
            return expectedType.equals(current.getType()) && SortContentAction.isEnumConstant(current);
        });
    }

    private static boolean isSortableConstants(@NotNull StreamEx<PsiExpression> expressions2, @NotNull PsiType expectedType) {
        if (expressions2 == null) {
            SortContentAction.$$$reportNull$$$0(13);
        }
        if (expectedType == null) {
            SortContentAction.$$$reportNull$$$0(14);
        }
        return expressions2.allMatch(current -> {
            if (expectedType == null) {
                SortContentAction.$$$reportNull$$$0(17);
            }
            return expectedType.equals(current.getType()) && ExpressionUtils.computeConstantExpression(current) != null && current instanceof PsiLiteralExpression;
        });
    }

    private static boolean isSortableExpressions(@NotNull PsiExpression[] expressions2, @NotNull PsiType expectedType) {
        if (expressions2 == null) {
            SortContentAction.$$$reportNull$$$0(15);
        }
        if (expectedType == null) {
            SortContentAction.$$$reportNull$$$0(16);
        }
        return SortContentAction.isSortableConstants((StreamEx<PsiExpression>)StreamEx.of((Object[])expressions2), expectedType) || SortContentAction.isSortableEnums((StreamEx<PsiExpression>)StreamEx.of((Object[])expressions2), expectedType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SortContentAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SortContentAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isOrdered";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNumericType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSortableExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSeparator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSortableEnums";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSortableConstants";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSortableExpressions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isSortableConstants$4";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isSortableEnums$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SortableEntry {
        @NotNull
        private final PsiExpression myExpression;
        @NotNull
        private final List<PsiComment> myBeforeSeparator;
        @NotNull
        private final List<PsiComment> myAfterSeparator;

        private SortableEntry(@NotNull PsiExpression expression2, @NotNull List<PsiComment> beforeSeparator, @NotNull List<PsiComment> afterSeparator) {
            if (expression2 == null) {
                SortableEntry.$$$reportNull$$$0(0);
            }
            if (beforeSeparator == null) {
                SortableEntry.$$$reportNull$$$0(1);
            }
            if (afterSeparator == null) {
                SortableEntry.$$$reportNull$$$0(2);
            }
            this.myExpression = expression2;
            this.myBeforeSeparator = beforeSeparator;
            this.myAfterSeparator = afterSeparator;
        }

        @Nullable
        private static Comparator<SortableEntry> getEntryComparator(@NotNull PsiExpression exampleExpression) {
            if (exampleExpression == null) {
                SortableEntry.$$$reportNull$$$0(3);
            }
            if (exampleExpression instanceof PsiReferenceExpression) {
                if (!(((PsiReferenceExpression)exampleExpression).resolve() instanceof PsiEnumConstant)) {
                    return null;
                }
                return Comparator.comparing(entry -> ((PsiReferenceExpression)entry.myExpression).getReferenceName());
            }
            PsiType type2 = exampleExpression.getType();
            Comparator comparator = SortContentAction.getComparator(type2);
            if (comparator == null) {
                return null;
            }
            return Comparator.comparing(entry -> entry.myExpression, comparator);
        }

        void generate(StringBuilder sb, boolean isLastInRow, boolean isLast) {
            sb.append(this.myExpression.getText());
            for (PsiElement psiElement : this.myBeforeSeparator) {
                sb.append(psiElement.getText());
            }
            if (!isLast) {
                sb.append(",");
            }
            boolean newLineSet = false;
            for (PsiComment comment : this.myAfterSeparator) {
                sb.append(" ").append(comment.getText());
                if (comment.getText().contains("//")) {
                    sb.append("\n");
                    newLineSet = true;
                    continue;
                }
                newLineSet = false;
            }
            if (isLastInRow && !newLineSet && !isLast) {
                sb.append("\n");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beforeSeparator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterSeparator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exampleExpression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/intention/impl/SortContentAction$SortableEntry";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEntryComparator";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EntryListContext {
        @NotNull
        private final List<PsiElement> myBeforeFirst;
        @NotNull
        private final List<SortableEntry> myEntries;
        @NotNull
        private final LineLayout myLineLayout;

        private EntryListContext(@NotNull List<PsiElement> first, @NotNull List<SortableEntry> entries, @NotNull LineLayout layout) {
            if (first == null) {
                EntryListContext.$$$reportNull$$$0(0);
            }
            if (entries == null) {
                EntryListContext.$$$reportNull$$$0(1);
            }
            if (layout == null) {
                EntryListContext.$$$reportNull$$$0(2);
            }
            this.myBeforeFirst = first;
            this.myEntries = entries;
            this.myLineLayout = layout;
        }

        @Nullable(value="when failed to extract")
        static EntryListContext from(PsiElement startingElement, Predicate<PsiExpression> expressionPredicate, Predicate<PsiElement> separatorPredicate, Predicate<PsiElement> endPredicate) {
            PsiElement current;
            ArrayList<PsiElement> beforeFirst = new ArrayList<PsiElement>();
            for (current = startingElement; current != null && !EntryListContext.testWhenExpression(expressionPredicate, current); current = current.getNextSibling()) {
                beforeFirst.add(current);
            }
            List<SortableEntry> entries = EntryListContext.extractEntries(current, expressionPredicate, separatorPredicate, endPredicate);
            if (entries == null || entries.size() < 3) {
                return null;
            }
            return new EntryListContext(beforeFirst, entries, LineLayout.from(startingElement, endPredicate));
        }

        @Contract(value="_, null -> false")
        private static boolean testWhenExpression(Predicate<PsiExpression> expressionPredicate, PsiElement current) {
            return current instanceof PsiExpression && expressionPredicate.test((PsiExpression)current);
        }

        private void sortContent() {
            PsiExpression exampleExpression = this.myEntries.get(0).myExpression;
            Comparator comparator = SortableEntry.getEntryComparator(exampleExpression);
            if (comparator == null) {
                return;
            }
            Collections.sort(this.myEntries, comparator);
        }

        @Nullable(value="when failed to extract")
        private static List<SortableEntry> extractEntries(PsiElement startingElement, Predicate<PsiExpression> expressionPredicate, Predicate<PsiElement> separatorPredicate, Predicate<PsiElement> endPredicate) {
            PsiElement current = startingElement;
            ArrayList<SortableEntry> entries = new ArrayList<SortableEntry>();
            while (current != null) {
                if (!EntryListContext.testWhenExpression(expressionPredicate, current)) {
                    return null;
                }
                PsiExpression expression2 = (PsiExpression)current;
                ArrayList<PsiComment> beforeSeparator = new ArrayList<PsiComment>();
                for (current = current.getNextSibling(); current != null; current = current.getNextSibling()) {
                    if (separatorPredicate.test(current)) {
                        current = current.getNextSibling();
                        break;
                    }
                    if (endPredicate.test(current)) {
                        entries.add(new SortableEntry(expression2, beforeSeparator, new ArrayList()));
                        return entries;
                    }
                    if (!(current instanceof PsiComment)) continue;
                    beforeSeparator.add((PsiComment)current);
                }
                ArrayList<PsiComment> afterSeparator = new ArrayList<PsiComment>();
                while (current != null && !EntryListContext.testWhenExpression(expressionPredicate, current) && !endPredicate.test(current)) {
                    if (current instanceof PsiComment) {
                        afterSeparator.add((PsiComment)current);
                    }
                    current = current.getNextSibling();
                }
                entries.add(new SortableEntry(expression2, beforeSeparator, afterSeparator));
                if (!endPredicate.test(current)) continue;
                return entries;
            }
            return null;
        }

        @NotNull
        private String generate() {
            StringBuilder sb = new StringBuilder();
            for (PsiElement element : this.myBeforeFirst) {
                sb.append(element.getText());
            }
            this.myLineLayout.generate(sb, this.myEntries);
            String string = sb.toString();
            if (string == null) {
                EntryListContext.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entries";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layout";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/impl/SortContentAction$EntryListContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/impl/SortContentAction$EntryListContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LineLayout {
        private TIntArrayList myEntryCountOnLines;

        public LineLayout(TIntArrayList entryCountOnLines) {
            this.myEntryCountOnLines = entryCountOnLines;
        }

        @NotNull
        static LineLayout from(PsiElement startingElement, Predicate<PsiElement> endPredicate) {
            PsiElement current = startingElement;
            TIntArrayList entryCountOnLines = new TIntArrayList();
            int currentEntryCount = 0;
            while (!(current instanceof PsiExpression)) {
                current = current.getNextSibling();
            }
            while (current != null && !endPredicate.test(current)) {
                if (current instanceof PsiExpression) {
                    ++currentEntryCount;
                }
                if (current instanceof PsiWhiteSpace) {
                    int newLineCount = (int)current.getText().chars().filter(value2 -> value2 == 10).count();
                    for (int i = 0; i < newLineCount; ++i) {
                        entryCountOnLines.add(currentEntryCount);
                        currentEntryCount = 0;
                    }
                }
                current = current.getNextSibling();
            }
            entryCountOnLines.add(currentEntryCount);
            LineLayout lineLayout = new LineLayout(entryCountOnLines);
            if (lineLayout == null) {
                LineLayout.$$$reportNull$$$0(0);
            }
            return lineLayout;
        }

        private void generate(StringBuilder sb, List<SortableEntry> entries) {
            int entryIndex = 0;
            int lines = this.myEntryCountOnLines.size();
            int currentEntryIndex = 0;
            int entryCount = entries.size();
            for (int rowIndex = 0; rowIndex < lines; ++rowIndex) {
                int entryCountOnRow = this.myEntryCountOnLines.get(rowIndex);
                if (entryCountOnRow == 0) {
                    sb.append("\n");
                    continue;
                }
                for (int rowPosition = 0; rowPosition < entryCountOnRow; ++rowPosition) {
                    boolean isLastInRow = rowPosition + 1 == entryCountOnRow && rowIndex + 1 != lines;
                    entries.get(entryIndex).generate(sb, isLastInRow, ++currentEntryIndex == entryCount);
                    ++entryIndex;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SortContentAction$LineLayout", "from"));
        }
    }

    private static class VarargSortableList
    extends ExpressionSortableList<VarargContext> {
        private VarargSortableList() {
        }

        @Override
        @Nullable
        protected VarargContext extractContext(@NotNull PsiElement originElement) {
            PsiExpressionList list;
            PsiMethodCallExpression call;
            if (originElement == null) {
                VarargSortableList.$$$reportNull$$$0(0);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)(list = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)originElement, PsiExpressionList.class)), PsiMethodCallExpression.class)) == null) {
                return null;
            }
            PsiExpression[] arguments = call.getArgumentList().getExpressions();
            if (arguments.length < 3) {
                return null;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)call.getMethodExpression().resolve(), PsiMethod.class);
            if (method == null) {
                return null;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            Object[] varargArguments = VarargSortableList.getVarargArguments(arguments, originElement, parameters2);
            if (varargArguments == null) {
                return null;
            }
            PsiExpression argument = varargArguments[0];
            PsiType type2 = argument.getType();
            if (type2 == null) {
                return null;
            }
            if (!SortContentAction.isSortableExpressions((PsiExpression[])varargArguments, type2)) {
                return null;
            }
            Comparator comparator = SortContentAction.getComparator(type2);
            if (comparator == null) {
                return null;
            }
            if (SortContentAction.isOrdered(varargArguments, comparator)) {
                return null;
            }
            return new VarargContext(list, (PsiExpression[])varargArguments);
        }

        @Nullable
        private static PsiExpression[] getVarargArguments(@NotNull PsiExpression[] arguments, @NotNull PsiElement originElement, @NotNull PsiParameter[] parameters2) {
            PsiParameter last;
            if (arguments == null) {
                VarargSortableList.$$$reportNull$$$0(1);
            }
            if (originElement == null) {
                VarargSortableList.$$$reportNull$$$0(2);
            }
            if (parameters2 == null) {
                VarargSortableList.$$$reportNull$$$0(3);
            }
            if ((last = (PsiParameter)ArrayUtil.getLastElement((Object[])parameters2)) == null) {
                return null;
            }
            if (!last.isVarArgs()) {
                return null;
            }
            PsiExpression closestExpression = VarargSortableList.getClosestExpression(originElement);
            if (closestExpression == null) {
                return null;
            }
            int indexOfCurrent = Arrays.asList(arguments).indexOf(closestExpression);
            if (-1 == indexOfCurrent) {
                return null;
            }
            if (indexOfCurrent < parameters2.length - 1) {
                return null;
            }
            if (arguments.length < parameters2.length + 3 - 1) {
                return null;
            }
            return Arrays.copyOfRange(arguments, parameters2.length - 1, arguments.length);
        }

        @Nullable
        private static PsiExpression getClosestExpression(@NotNull PsiElement element) {
            if (element == null) {
                VarargSortableList.$$$reportNull$$$0(4);
            }
            while (element != null) {
                if (element instanceof PsiWhiteSpace) {
                    element = element.getNextSibling();
                    continue;
                }
                if (element instanceof PsiJavaToken) {
                    IElementType tokenType = ((PsiJavaToken)element).getTokenType();
                    if (!tokenType.equals(JavaTokenType.COMMA) && !tokenType.equals(TokenType.WHITE_SPACE)) break;
                    element = element.getNextSibling();
                    continue;
                }
                if (!(element instanceof PsiComment)) break;
                element = element.getNextSibling();
            }
            return (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class, (boolean)false);
        }

        @Override
        protected PsiElement getFirst(@NotNull VarargContext context) {
            if (context == null) {
                VarargSortableList.$$$reportNull$$$0(5);
            }
            return context.myArguments[0];
        }

        @Override
        protected boolean isLast(@NotNull PsiElement current) {
            if (current == null) {
                VarargSortableList.$$$reportNull$$$0(6);
            }
            return current instanceof PsiJavaToken && ((PsiJavaToken)current).getTokenType() == JavaTokenType.RPARENTH;
        }

        @Override
        @Nullable
        protected PsiElement replace(@NotNull EntryListContext listContext, @NotNull PsiElementFactory factory, @NotNull VarargContext context) {
            PsiMethodCallExpression call;
            if (listContext == null) {
                VarargSortableList.$$$reportNull$$$0(7);
            }
            if (factory == null) {
                VarargSortableList.$$$reportNull$$$0(8);
            }
            if (context == null) {
                VarargSortableList.$$$reportNull$$$0(9);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context.myExpressionList, PsiMethodCallExpression.class)) == null) {
                return null;
            }
            PsiExpression[] arguments = call.getArgumentList().getExpressions();
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)call.getMethodExpression().resolve(), PsiMethod.class);
            if (method == null) {
                return null;
            }
            int parametersCount = method.getParameters().length;
            PsiExpression last = arguments[parametersCount - 1];
            String methodText = call.getMethodExpression().getText();
            StringBuilder sb = new StringBuilder();
            sb.append(methodText);
            for (PsiElement current = context.myExpressionList.getChildren()[0]; current != null && current != last; current = current.getNextSibling()) {
                sb.append(current.getText());
            }
            sb.append(listContext.generate());
            sb.append(")");
            return call.replace((PsiElement)factory.createExpressionFromText(sb.toString(), (PsiElement)call));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listContext";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/intention/impl/SortContentAction$VarargSortableList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractContext";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVarargArguments";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getClosestExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirst";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLast";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class VarargContext {
            @NotNull
            private final PsiExpressionList myExpressionList;
            @NotNull
            private final PsiExpression[] myArguments;

            private VarargContext(@NotNull PsiExpressionList expressionList, @NotNull PsiExpression[] arguments) {
                if (expressionList == null) {
                    VarargContext.$$$reportNull$$$0(0);
                }
                if (arguments == null) {
                    VarargContext.$$$reportNull$$$0(1);
                }
                this.myExpressionList = expressionList;
                this.myArguments = arguments;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expressionList";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "arguments";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/intention/impl/SortContentAction$VarargSortableList$VarargContext";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class ArraySortableList
    extends ExpressionSortableList<PsiArrayInitializerExpression> {
        private ArraySortableList() {
        }

        @Override
        @Nullable
        protected PsiArrayInitializerExpression extractContext(@NotNull PsiElement originElement) {
            PsiArrayInitializerExpression initializerExpression;
            if (originElement == null) {
                ArraySortableList.$$$reportNull$$$0(0);
            }
            if ((initializerExpression = (PsiArrayInitializerExpression)PsiTreeUtil.getParentOfType((PsiElement)originElement, PsiArrayInitializerExpression.class)) == null) {
                return null;
            }
            Object[] initializers = initializerExpression.getInitializers();
            if (initializers.length < 3) {
                return null;
            }
            PsiType type2 = initializerExpression.getInitializers()[0].getType();
            if (type2 == null) {
                return null;
            }
            if (!SortContentAction.isSortableExpressions((PsiExpression[])initializers, type2)) {
                return null;
            }
            Comparator comparator = SortContentAction.getComparator(type2);
            if (comparator == null) {
                return null;
            }
            if (SortContentAction.isOrdered(initializers, comparator)) {
                return null;
            }
            return initializerExpression;
        }

        @Override
        public PsiElement getFirst(@NotNull PsiArrayInitializerExpression context) {
            if (context == null) {
                ArraySortableList.$$$reportNull$$$0(1);
            }
            return context.getChildren()[1];
        }

        @Override
        public PsiElement replace(@NotNull EntryListContext listContext, @NotNull PsiElementFactory factory, @NotNull PsiArrayInitializerExpression toReplace) {
            if (listContext == null) {
                ArraySortableList.$$$reportNull$$$0(2);
            }
            if (factory == null) {
                ArraySortableList.$$$reportNull$$$0(3);
            }
            if (toReplace == null) {
                ArraySortableList.$$$reportNull$$$0(4);
            }
            return toReplace.replace((PsiElement)factory.createExpressionFromText("{" + listContext.generate() + "}", (PsiElement)toReplace));
        }

        @Override
        public boolean isLast(@NotNull PsiElement current) {
            if (current == null) {
                ArraySortableList.$$$reportNull$$$0(5);
            }
            return current instanceof PsiJavaToken && ((PsiJavaToken)current).getTokenType() == JavaTokenType.RBRACE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toReplace";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/intention/impl/SortContentAction$ArraySortableList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirst";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLast";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ExpressionSortableList<C> {
        private ExpressionSortableList() {
        }

        @Nullable
        protected abstract C extractContext(@NotNull PsiElement var1);

        @Nullable
        protected abstract PsiElement getFirst(@NotNull C var1);

        protected abstract boolean isLast(@NotNull PsiElement var1);

        @Nullable
        protected abstract PsiElement replace(@NotNull EntryListContext var1, @NotNull PsiElementFactory var2, @NotNull C var3);

        public PsiElement extract(@NotNull PsiElement element) {
            C context;
            if (element == null) {
                ExpressionSortableList.$$$reportNull$$$0(0);
            }
            if ((context = this.extractContext(element)) == null) {
                return null;
            }
            EntryListContext listContext = EntryListContext.from(this.getFirst(context), x$0 -> SortContentAction.isSortableExpression(x$0), x$0 -> SortContentAction.isSeparator(x$0), this::isLast);
            if (listContext == null) {
                return null;
            }
            listContext.sortContent();
            return this.replace(listContext, JavaPsiFacade.getElementFactory((Project)element.getProject()), context);
        }

        private boolean isAvailable(@NotNull PsiElement element) {
            if (element == null) {
                ExpressionSortableList.$$$reportNull$$$0(1);
            }
            return this.extractContext(element) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/codeInsight/intention/impl/SortContentAction$ExpressionSortableList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extract";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

