/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinopInstruction
extends BranchingInstruction {
    private static final TokenSet ourSignificantOperations = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.INSTANCEOF_KEYWORD, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.AND, JavaTokenType.PERC});
    private final IElementType myOperationSign;
    private final Project myProject;

    public BinopInstruction(IElementType opSign, @Nullable PsiElement psiAnchor, @NotNull Project project) {
        if (project == null) {
            BinopInstruction.$$$reportNull$$$0(0);
        }
        super(psiAnchor);
        this.myProject = project;
        this.myOperationSign = ourSignificantOperations.contains(opSign) ? opSign : null;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitBinop(this, runner, stateBefore);
    }

    public DfaValue getNonNullStringValue(DfaValueFactory factory) {
        PsiElement anchor = this.getPsiAnchor();
        Project project = this.myProject;
        PsiClassType string = PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)(anchor == null ? GlobalSearchScope.allScope((Project)project) : anchor.getResolveScope()));
        return factory.createTypeValue((PsiType)string, Nullness.NOT_NULL);
    }

    public String toString() {
        return "BINOP " + this.myOperationSign;
    }

    public IElementType getOperationSign() {
        return this.myOperationSign;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/instructions/BinopInstruction", "<init>"));
    }
}

