/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.javaDoc.JavadocHighlightUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaDocReferenceInspectionBase
extends LocalInspectionTool {
    private static final String SHORT_NAME = "JavadocReference";

    private void visitRefInDocTag(PsiDocTag tag, JavadocManager manager, PsiElement context, ProblemsHolder holder, boolean isOnTheFly) {
        PsiDocCommentOwner commentOwner;
        PsiReference reference;
        String message2;
        PsiDocTagValue value2 = tag.getValueElement();
        if (value2 == null) {
            return;
        }
        String tagName = tag.getName();
        JavadocTagInfo info = manager.getTagInfo(tagName);
        if (info != null && !info.isValidInContext(context)) {
            return;
        }
        if (info != null && info.isInline() && (message2 = info.checkTagValue(value2)) != null) {
            holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)value2, message2, isOnTheFly, null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL));
        }
        if ((reference = value2.getReference()) == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (element != null) {
            return;
        }
        int textOffset = value2.getTextOffset();
        if (textOffset == value2.getTextRange().getEndOffset()) {
            return;
        }
        PsiDocTagValue valueElement = tag.getValueElement();
        if (valueElement == null) {
            return;
        }
        CharSequence paramName = value2.getContainingFile().getViewProvider().getContents().subSequence(textOffset, value2.getTextRange().getEndOffset());
        String params = "<code>" + paramName + "</code>";
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (isOnTheFly && "param".equals(tagName) && (commentOwner = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocCommentOwner.class)) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)commentOwner;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiDocTag[] tags = tag.getContainingComment().getTags();
            HashSet<String> unboundParams = new HashSet<String>();
            for (PsiParameter parameter2 : parameters2) {
                if (JavadocHighlightUtil.hasTagForParameter(tags, (PsiElement)parameter2)) continue;
                unboundParams.add(parameter2.getName());
            }
            if (!unboundParams.isEmpty()) {
                fixes.add(this.createRenameReferenceQuickFix(unboundParams));
            }
        }
        fixes.add(new RemoveTagFix(tagName, paramName));
        LocalQuickFix[] array = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)valueElement, reference.getRangeInElement(), JavaDocReferenceInspectionBase.cannotResolveSymbolMessage(params), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly, array));
    }

    protected LocalQuickFix createRenameReferenceQuickFix(Set<String> unboundParams) {
        return null;
    }

    private static String cannotResolveSymbolMessage(String params) {
        return InspectionsBundle.message((String)"inspection.javadoc.problem.cannot.resolve", (Object[])new Object[]{params});
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    protected LocalQuickFix createAddQualifierFix(PsiJavaCodeReferenceElement reference) {
        return null;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.javadoc.ref.display.name", (Object[])new Object[0]);
        if (string == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.javadoc.issues", (Object[])new Object[0]);
        if (string == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(2);
        }
        return SHORT_NAME;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(4);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitJavaFile(PsiJavaFile file) {
                if ("package-info.java".equals(file.getName())) {
                    JavaDocReferenceInspectionBase.this.checkComment((PsiDocComment)PsiTreeUtil.getChildOfType((PsiElement)file, PsiDocComment.class), (PsiElement)file, holder, isOnTheFly);
                }
            }

            public void visitModule(PsiJavaModule module) {
                JavaDocReferenceInspectionBase.this.checkComment(module.getDocComment(), (PsiElement)module, holder, isOnTheFly);
            }

            public void visitClass(PsiClass aClass) {
                JavaDocReferenceInspectionBase.this.checkComment(aClass.getDocComment(), (PsiElement)aClass, holder, isOnTheFly);
            }

            public void visitField(PsiField field) {
                JavaDocReferenceInspectionBase.this.checkComment(field.getDocComment(), (PsiElement)field, holder, isOnTheFly);
            }

            public void visitMethod(PsiMethod method) {
                JavaDocReferenceInspectionBase.this.checkComment(method.getDocComment(), (PsiElement)method, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(5);
        }
        return javaElementVisitor;
    }

    private void checkComment(PsiDocComment comment, final PsiElement context, final ProblemsHolder holder, final boolean isOnTheFly) {
        if (comment == null) {
            return;
        }
        final JavadocManager javadocManager = JavadocManager.SERVICE.getInstance((Project)holder.getProject());
        comment.accept((PsiElementVisitor)new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitElement((PsiElement)expression2);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                JavaResolveResult result = reference.advancedResolve(false);
                if (result.getElement() == null && !result.isPackagePrefixPackageReference()) {
                    PsiElement referenceNameElement = reference.getReferenceNameElement();
                    PsiElement element = referenceNameElement != null ? referenceNameElement : reference;
                    String message2 = JavaDocReferenceInspectionBase.cannotResolveSymbolMessage("<code>" + reference.getText() + "</code>");
                    LocalQuickFix fix = isOnTheFly ? JavaDocReferenceInspectionBase.this.createAddQualifierFix(reference) : null;
                    holder.registerProblem(holder.getManager().createProblemDescriptor(element, message2, fix, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly));
                }
            }

            public void visitDocTag(PsiDocTag tag) {
                super.visitDocTag(tag);
                JavadocTagInfo info = javadocManager.getTagInfo(tag.getName());
                if (info == null || !info.isInline()) {
                    JavaDocReferenceInspectionBase.this.visitRefInDocTag(tag, javadocManager, context, holder, isOnTheFly);
                }
            }

            public void visitInlineDocTag(PsiInlineDocTag tag) {
                super.visitInlineDocTag(tag);
                JavaDocReferenceInspectionBase.this.visitRefInDocTag((PsiDocTag)tag, javadocManager, context, holder, isOnTheFly);
            }

            public void visitElement(PsiElement element) {
                for (PsiElement child : element.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveTagFix
    implements LocalQuickFix {
        private final String myTagName;
        private final CharSequence myParamName;

        public RemoveTagFix(String tagName, CharSequence paramName) {
            this.myTagName = tagName;
            this.myParamName = paramName;
        }

        @NotNull
        public String getName() {
            String string = "Remove @" + this.myTagName + " " + this.myParamName;
            if (string == null) {
                RemoveTagFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove tag" == null) {
                RemoveTagFix.$$$reportNull$$$0(1);
            }
            return "Remove tag";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiDocTag myTag;
            if (project == null) {
                RemoveTagFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemoveTagFix.$$$reportNull$$$0(3);
            }
            if ((myTag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiDocTag.class)) != null) {
                myTag.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase$RemoveTagFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase$RemoveTagFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

