/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambdaToExplicit;

import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LambdaAndExplicitMethodPair {
    static final LambdaAndExplicitMethodPair[] INFOS = new LambdaAndExplicitMethodPair[]{new LambdaAndExplicitMethodPair("java.util.Map", "computeIfAbsent", "putIfAbsent", 1, "V", false, "k"), new LambdaAndExplicitMethodPair("java.util.Optional", "orElseGet", "orElse", 0, "T", true, new String[0]), new LambdaAndExplicitMethodPair("java.util.OptionalInt", "orElseGet", "orElse", 0, "int", true, new String[0]), new LambdaAndExplicitMethodPair("java.util.OptionalLong", "orElseGet", "orElse", 0, "long", true, new String[0]), new LambdaAndExplicitMethodPair("java.util.OptionalDouble", "orElseGet", "orElse", 0, "double", true, new String[0]), new LambdaAndExplicitMethodPair("com.google.common.base.Optional", "or", "*", 0, "T", true, new String[0]), new LambdaAndExplicitMethodPair("java.util.Objects", "requireNonNull", "*", 1, "java.lang.String", true, new String[0]), new LambdaAndExplicitMethodPair("java.util.Objects", "requireNonNullElseGet", "requireNonNullElse", 1, "T", true, new String[0]), new LambdaAndExplicitMethodPair("org.junit.jupiter.api.Assertions", "assert(?!Timeout).*|fail", "*", -1, "java.lang.String", true, new String[0]), new LambdaAndExplicitMethodPair("org.junit.jupiter.api.Assertions", "assert(True|False)", "*", 0, "java.lang.String", true, new String[0]), new LambdaAndExplicitMethodPair("java.util.Arrays", "setAll", "fill", 1, null, true, "i")};
    @NotNull
    private final String myClass;
    @NotNull
    private final Pattern myLambdaMethod;
    @NotNull
    private final String myExplicitMethod;
    private final int myParameterIndex;
    @Nullable
    private final String myExplicitParameterType;
    private final boolean myCanUseReturnValue;
    @NotNull
    private final String[] myDefaultLambdaParameters;

    LambdaAndExplicitMethodPair(@NotNull String aClass, @NotNull @RegExp String lambdaMethod, @NotNull String explicitMethod, int index, @Nullable String explicitParameterType, boolean canUseReturnValue, String ... defaultLambdaParameters) {
        if (aClass == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(0);
        }
        if (lambdaMethod == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(1);
        }
        if (explicitMethod == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(2);
        }
        if (defaultLambdaParameters == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(3);
        }
        this.myClass = aClass;
        this.myLambdaMethod = Pattern.compile(lambdaMethod);
        this.myExplicitMethod = explicitMethod;
        this.myParameterIndex = index;
        this.myExplicitParameterType = explicitParameterType;
        this.myCanUseReturnValue = canUseReturnValue;
        this.myDefaultLambdaParameters = defaultLambdaParameters;
    }

    boolean isLambdaCall(PsiMethodCallExpression lambdaCall, PsiLambdaExpression lambda2) {
        int index;
        String name = lambdaCall.getMethodExpression().getReferenceName();
        if (name == null || !this.myLambdaMethod.matcher(name).matches()) {
            return false;
        }
        if (!this.myCanUseReturnValue && !(lambdaCall.getParent() instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression[] args = lambdaCall.getArgumentList().getExpressions();
        if (args.length == 0) {
            return false;
        }
        int n = index = this.myParameterIndex == -1 ? args.length - 1 : this.myParameterIndex;
        if (args.length <= index || args[index] != lambda2) {
            return false;
        }
        PsiMethod method = lambdaCall.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length <= index) {
            return false;
        }
        PsiClass fnClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)parameters2[index].getType());
        return fnClass != null && LambdaUtil.getFunction((PsiClass)fnClass) != null && InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (boolean)false, (String)this.myClass);
    }

    PsiExpression getLambdaCandidateFromExplicitCall(PsiMethodCallExpression explicitCall) {
        int index;
        if (this.myExplicitParameterType == null) {
            return null;
        }
        String name = explicitCall.getMethodExpression().getReferenceName();
        if (name == null) {
            return null;
        }
        if (this.myExplicitMethod.equals("*") ? !this.myLambdaMethod.matcher(name).matches() : !this.myExplicitMethod.equals(name)) {
            return null;
        }
        if (!this.myCanUseReturnValue && !(explicitCall.getParent() instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpression[] args = explicitCall.getArgumentList().getExpressions();
        if (args.length == 0) {
            return null;
        }
        int n = index = this.myParameterIndex == -1 ? args.length - 1 : this.myParameterIndex;
        if (args.length <= index) {
            return null;
        }
        PsiExpression arg = args[index];
        if (arg instanceof PsiFunctionalExpression) {
            return null;
        }
        if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)arg)) {
            return null;
        }
        PsiMethod method = explicitCall.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length <= index) {
            return null;
        }
        PsiType type2 = parameters2[index].getType();
        if (!type2.equalsToText(this.myExplicitParameterType)) {
            return null;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (boolean)false, (String)this.myClass)) {
            return null;
        }
        return arg;
    }

    public String getExplicitMethodName(PsiMethodCallExpression lambdaCall) {
        if (this.myExplicitMethod.equals("*")) {
            return lambdaCall.getMethodExpression().getReferenceName();
        }
        return this.myExplicitMethod;
    }

    public String getLambdaMethodName(PsiMethodCallExpression explicitCall) {
        if (this.myExplicitMethod.equals("*")) {
            return explicitCall.getMethodExpression().getReferenceName();
        }
        return this.myLambdaMethod.pattern();
    }

    @NotNull
    public String makeLambda(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(4);
        }
        if (this.myDefaultLambdaParameters.length == 0) {
            String string = "()->" + expression2.getText();
            if (string == null) {
                LambdaAndExplicitMethodPair.$$$reportNull$$$0(5);
            }
            return string;
        }
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
        String params = StreamEx.of((Object[])this.myDefaultLambdaParameters).map(param -> {
            if (expression2 == null) {
                LambdaAndExplicitMethodPair.$$$reportNull$$$0(7);
            }
            return manager.suggestUniqueVariableName(param, (PsiElement)expression2, true);
        }).joining((CharSequence)",");
        if (this.myDefaultLambdaParameters.length != 1) {
            params = "(" + params + ")";
        }
        String string = params + "->" + expression2.getText();
        if (string == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLambdaParameters";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/lambdaToExplicit/LambdaAndExplicitMethodPair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/lambdaToExplicit/LambdaAndExplicitMethodPair";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makeLambda";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "makeLambda";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$makeLambda$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

