/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;

public class RefJavaFileImpl
extends RefFileImpl {
    private final RefModule myRefModule;

    RefJavaFileImpl(PsiJavaFile elem, RefManager manager) {
        super((PsiFile)elem, manager, false);
        this.myRefModule = manager.getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)elem));
        String packageName = elem.getPackageName();
        if (!packageName.isEmpty()) {
            ((RefPackageImpl)((RefJavaManager)this.getRefManager().getExtension(RefJavaManager.MANAGER)).getPackage(packageName)).add((RefEntity)this);
        } else if (this.myRefModule != null) {
            ((RefModuleImpl)this.myRefModule).add((RefEntity)this);
        } else {
            ((RefProjectImpl)manager.getRefProject()).add((RefEntity)this);
        }
    }

    public void buildReferences() {
        this.getRefManager().fireBuildReferences((RefElement)this);
    }

    public RefModule getModule() {
        return this.myRefModule;
    }
}

