/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefParameterImpl
extends RefJavaElementImpl
implements RefParameter {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private final short myIndex;
    private Object myActualValueTemplate;

    RefParameterImpl(PsiParameter parameter2, int index, RefManager manager) {
        super((PsiModifierListOwner)parameter2, manager);
        this.myIndex = (short)index;
        this.myActualValueTemplate = VALUE_UNDEFINED;
        RefElementImpl owner = (RefElementImpl)manager.getReference(PsiTreeUtil.getParentOfType((PsiElement)parameter2, PsiMethod.class));
        if (owner != null) {
            owner.add((RefEntity)this);
        }
    }

    public void parameterReferenced(boolean forWriting) {
        if (forWriting) {
            this.setUsedForWriting();
        } else {
            this.setUsedForReading();
        }
    }

    public boolean isUsedForReading() {
        return this.checkFlag(65536L);
    }

    private void setUsedForReading() {
        this.setFlag(true, 65536L);
    }

    public PsiParameter getElement() {
        return (PsiParameter)super.getElement();
    }

    public boolean isUsedForWriting() {
        return this.checkFlag(131072L);
    }

    private void setUsedForWriting() {
        this.setFlag(true, 131072L);
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefParameterImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor == null) {
                    RefParameterImpl.$$$reportNull$$$0(1);
                }
                ((RefJavaVisitor)visitor).visitParameter((RefParameter)this);
            });
        } else {
            super.accept(visitor);
        }
    }

    public int getIndex() {
        return this.myIndex;
    }

    public void buildReferences() {
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        PsiParameter parameter2 = this.getElement();
        if (parameter2 != null) {
            refUtil.addReferences((PsiModifierListOwner)parameter2, (RefJavaElement)this, (PsiElement)parameter2.getModifierList());
        }
    }

    void updateTemplateValue(PsiExpression expression2) {
        if (this.myActualValueTemplate == VALUE_IS_NOT_CONST) {
            return;
        }
        Object newTemplate = RefParameterImpl.getExpressionValue(expression2);
        if (this.myActualValueTemplate == VALUE_UNDEFINED) {
            this.myActualValueTemplate = newTemplate;
        } else if (!Comparing.equal((Object)this.myActualValueTemplate, (Object)newTemplate)) {
            this.myActualValueTemplate = VALUE_IS_NOT_CONST;
        }
    }

    @Nullable
    public Object getActualValueIfSame() {
        return this.myActualValueTemplate;
    }

    protected void initialize() {
    }

    public String getExternalName() {
        String[] result = new String[1];
        Runnable runnable = () -> {
            PsiParameter parameter2 = this.getElement();
            LOG.assertTrue(parameter2 != null);
            result[0] = PsiFormatUtil.getExternalName((PsiModifierListOwner)parameter2);
        };
        ApplicationManager.getApplication().runReadAction(runnable);
        return result[0];
    }

    @Nullable
    public static Object getExpressionValue(PsiExpression expression2) {
        PsiField psiField;
        PsiReferenceExpression referenceExpression;
        PsiElement resolved;
        if (expression2 instanceof PsiReferenceExpression && (resolved = (referenceExpression = (PsiReferenceExpression)expression2).resolve()) instanceof PsiField && (psiField = (PsiField)resolved).hasModifierProperty("static") && psiField.hasModifierProperty("final") && psiField.getContainingClass().getQualifiedName() != null) {
            return PsiFormatUtil.formatVariable((PsiVariable)psiField, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
        if (expression2 instanceof PsiLiteralExpression && ((PsiLiteralExpression)expression2).getValue() == null) {
            return null;
        }
        Object constValue = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, false);
        return constValue == null ? VALUE_IS_NOT_CONST : constValue;
    }

    @Nullable
    static RefElement parameterFromExternalName(RefManager manager, String fqName) {
        String method;
        RefMethod refMethod;
        int idx = fqName.lastIndexOf(32);
        if (idx > 0 && (refMethod = RefMethodImpl.methodFromExternalName(manager, method = fqName.substring(0, idx))) != null) {
            PsiMethod element = (PsiMethod)refMethod.getElement();
            PsiParameterList list = element.getParameterList();
            PsiParameter[] parameters2 = list.getParameters();
            int paramIdx = 0;
            String paramName = fqName.substring(idx + 1);
            for (PsiParameter parameter2 : parameters2) {
                String name = parameter2.getName();
                if (name != null && name.equals(paramName)) {
                    return ((RefJavaManager)manager.getExtension(RefJavaManager.MANAGER)).getParameterReference(parameter2, paramIdx);
                }
                ++paramIdx;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "visitor";
        objectArray2[1] = "com/intellij/codeInspection/reference/RefParameterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$accept$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

