/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class RedundantThrowsGraphAnnotator
extends RefGraphAnnotatorEx {
    private final RefManager myRefManager;

    public RedundantThrowsGraphAnnotator(RefManager refManager) {
        this.myRefManager = refManager;
    }

    public void onInitialize(RefElement refElement) {
        PsiElement element;
        if (refElement instanceof RefMethodImpl && (element = refElement.getElement()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) {
                return;
            }
            Set<PsiClassType> exceptionTypes = RedundantThrowsGraphAnnotator.getUnhandledExceptions(body2, method, method.getContainingClass());
            for (PsiClassType exceptionType : exceptionTypes) {
                ((RefMethodImpl)refElement).updateThrowsList(exceptionType);
            }
        }
    }

    public void onMarkReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
        RefElement refResolved;
        if (from instanceof PsiFunctionalExpression && (refResolved = this.myRefManager.getReference(what)) instanceof RefMethodImpl) {
            PsiElement resolve;
            PsiElement body2;
            PsiFunctionalExpression expression2 = (PsiFunctionalExpression)from;
            Collection<Object> exceptionTypes = expression2 instanceof PsiLambdaExpression ? ((body2 = ((PsiLambdaExpression)expression2).getBody()) != null ? ExceptionUtil.collectUnhandledExceptions(body2, (PsiElement)expression2, false) : Collections.emptyList()) : ((resolve = ((PsiMethodReferenceExpression)expression2).resolve()) instanceof PsiMethod ? Arrays.asList(((PsiMethod)resolve).getThrowsList().getReferencedTypes()) : Collections.emptyList());
            for (PsiClassType exceptionType : exceptionTypes) {
                ((RefMethodImpl)refResolved).updateThrowsList(exceptionType);
            }
        }
    }

    public static Set<PsiClassType> getUnhandledExceptions(PsiCodeBlock body2, PsiMethod method, PsiClass containingClass) {
        Collection<PsiClassType> types = ExceptionUtil.collectUnhandledExceptions((PsiElement)body2, (PsiElement)method, false);
        HashSet<PsiClassType> unhandled = new HashSet<PsiClassType>(types);
        if (method.isConstructor()) {
            PsiField[] fields;
            for (PsiField field : fields = containingClass.getFields()) {
                PsiExpression initializer;
                if (field.hasModifierProperty("static") || (initializer = field.getInitializer()) == null) continue;
                unhandled.addAll(ExceptionUtil.collectUnhandledExceptions((PsiElement)initializer, (PsiElement)field));
            }
        }
        return unhandled;
    }
}

