/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.impl.ProjectRootUtil;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModulePackageIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ActionRunner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PackageUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.util.PackageUtil");

    @Nullable
    public static PsiDirectory findPossiblePackageDirectoryInModule(Module module, String packageName) {
        return PackageUtil.findPossiblePackageDirectoryInModule(module, packageName, true);
    }

    @Nullable
    public static PsiDirectory findPossiblePackageDirectoryInModule(Module module, String packageName, boolean preferNonGeneratedRoots) {
        PsiDirectory[] psiDirectories;
        PsiPackage rootPackage;
        Project project = module.getProject();
        PsiDirectory psiDirectory = null;
        if (!StringUtil.isEmptyOrSpaces((String)packageName) && (rootPackage = PackageUtil.findLongestExistingPackage(project, packageName)) != null && (psiDirectories = PackageUtil.getPackageDirectoriesInModule(rootPackage, module)).length > 0) {
            psiDirectory = psiDirectories[0];
            if (preferNonGeneratedRoots && psiDirectories.length > 1) {
                for (PsiDirectory dir : psiDirectories) {
                    if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)dir.getVirtualFile(), (Project)project)) continue;
                    psiDirectory = dir;
                    break;
                }
            }
        }
        if (psiDirectory == null && PackageUtil.checkSourceRootsConfigured(module)) {
            List sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            for (VirtualFile sourceRoot : sourceRoots) {
                PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(sourceRoot);
                if (directory == null) continue;
                psiDirectory = directory;
                break;
            }
        }
        return psiDirectory;
    }

    @Nullable
    public static PsiDirectory findOrCreateDirectoryForPackage(Project project, String packageName, PsiDirectory baseDir, boolean askUserToCreate) throws IncorrectOperationException {
        return PackageUtil.findOrCreateDirectoryForPackage(project, packageName, baseDir, askUserToCreate, false);
    }

    @Nullable
    public static PsiDirectory findOrCreateDirectoryForPackage(Project project, String packageName, PsiDirectory baseDir, boolean askUserToCreate, boolean filterSourceDirsForTestBaseDir) throws IncorrectOperationException {
        PsiDirectory[] sourceDirectories;
        PsiPackage rootPackage;
        PsiDirectory psiDirectory = null;
        if (!"".equals(packageName) && (rootPackage = PackageUtil.findLongestExistingPackage(project, packageName)) != null) {
            int beginIndex = rootPackage.getQualifiedName().length() + 1;
            packageName = beginIndex < packageName.length() ? packageName.substring(beginIndex) : "";
            String postfixToShow = packageName.replace('.', File.separatorChar);
            if (packageName.length() > 0) {
                postfixToShow = File.separatorChar + postfixToShow;
            }
            PsiDirectory[] directories = rootPackage.getDirectories();
            if (filterSourceDirsForTestBaseDir) {
                directories = PackageUtil.filterSourceDirectories(baseDir, project, directories);
            }
            if ((psiDirectory = DirectoryChooserUtil.selectDirectory((Project)project, (PsiDirectory[])directories, (PsiDirectory)baseDir, (String)postfixToShow)) == null) {
                return null;
            }
        }
        if (psiDirectory == null && (psiDirectory = DirectoryChooserUtil.selectDirectory((Project)project, (PsiDirectory[])(sourceDirectories = ProjectRootUtil.getSourceRootDirectories((Project)project)), (PsiDirectory)baseDir, (String)(File.separatorChar + packageName.replace('.', File.separatorChar)))) == null) {
            return null;
        }
        String restOfName = packageName;
        boolean askedToCreate = false;
        while (restOfName.length() > 0) {
            String name = PackageUtil.getLeftPart(restOfName);
            PsiDirectory foundExistingDirectory = psiDirectory.findSubdirectory(name);
            if (foundExistingDirectory == null) {
                if (!askedToCreate && askUserToCreate) {
                    int toCreate = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"prompt.create.non.existing.package", (Object[])new Object[]{packageName}), (String)IdeBundle.message((String)"title.package.not.found", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (toCreate != 0) {
                        return null;
                    }
                    askedToCreate = true;
                }
                psiDirectory = PackageUtil.createSubdirectory(psiDirectory, name, project);
            } else {
                psiDirectory = foundExistingDirectory;
            }
            restOfName = PackageUtil.cutLeftPart(restOfName);
        }
        return psiDirectory;
    }

    private static PsiDirectory createSubdirectory(final PsiDirectory oldDirectory, final String name, Project project) throws IncorrectOperationException {
        PsiDirectory[] psiDirectory = new PsiDirectory[1];
        final IncorrectOperationException[] exception = new IncorrectOperationException[1];
        CommandProcessor.getInstance().executeCommand(project, () -> {
            psiDirectory[0] = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                public PsiDirectory compute() {
                    try {
                        return oldDirectory.createSubdirectory(name);
                    }
                    catch (IncorrectOperationException e) {
                        exception[0] = e;
                        return null;
                    }
                }
            });
        }, IdeBundle.message((String)"command.create.new.subdirectory", (Object[])new Object[0]), null);
        if (exception[0] != null) {
            throw exception[0];
        }
        return psiDirectory[0];
    }

    @Nullable
    public static PsiDirectory findOrCreateDirectoryForPackage(@NotNull Module module, String packageName, @Nullable PsiDirectory baseDir, boolean askUserToCreate) throws IncorrectOperationException {
        if (module == null) {
            PackageUtil.$$$reportNull$$$0(0);
        }
        return PackageUtil.findOrCreateDirectoryForPackage(module, packageName, baseDir, askUserToCreate, false);
    }

    @Nullable
    public static PsiDirectory findOrCreateDirectoryForPackage(@NotNull Module module, String packageName, PsiDirectory baseDir, boolean askUserToCreate, boolean filterSourceDirsForBaseTestDirectory) throws IncorrectOperationException {
        PsiPackage rootPackage;
        if (module == null) {
            PackageUtil.$$$reportNull$$$0(1);
        }
        Project project = module.getProject();
        PsiDirectory psiDirectory = null;
        if (!packageName.isEmpty() && (rootPackage = PackageUtil.findLongestExistingPackage(module, packageName)) != null) {
            int beginIndex = rootPackage.getQualifiedName().length() + 1;
            packageName = beginIndex < packageName.length() ? packageName.substring(beginIndex) : "";
            Object postfixToShow = packageName.replace('.', File.separatorChar);
            if (packageName.length() > 0) {
                postfixToShow = File.separatorChar + (String)postfixToShow;
            }
            PsiDirectory[] moduleDirectories = PackageUtil.getPackageDirectoriesInModule(rootPackage, module);
            if (filterSourceDirsForBaseTestDirectory) {
                moduleDirectories = PackageUtil.filterSourceDirectories(baseDir, project, moduleDirectories);
            }
            if ((psiDirectory = DirectoryChooserUtil.selectDirectory((Project)project, (PsiDirectory[])moduleDirectories, (PsiDirectory)baseDir, (String)postfixToShow)) == null) {
                return null;
            }
        }
        if (psiDirectory == null) {
            if (!PackageUtil.checkSourceRootsConfigured(module, askUserToCreate)) {
                return null;
            }
            List sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            ArrayList<PsiDirectory> directoryList = new ArrayList<PsiDirectory>();
            for (VirtualFile sourceRoot : sourceRoots) {
                PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(sourceRoot);
                if (directory == null) continue;
                directoryList.add(directory);
            }
            PsiDirectory[] sourceDirectories = directoryList.toArray(PsiDirectory.EMPTY_ARRAY);
            psiDirectory = DirectoryChooserUtil.selectDirectory((Project)project, (PsiDirectory[])sourceDirectories, (PsiDirectory)baseDir, (String)(File.separatorChar + packageName.replace('.', File.separatorChar)));
            if (psiDirectory == null) {
                return null;
            }
        }
        String restOfName = packageName;
        boolean askedToCreate = false;
        while (restOfName.length() > 0) {
            final String name = PackageUtil.getLeftPart(restOfName);
            PsiDirectory foundExistingDirectory = psiDirectory.findSubdirectory(name);
            if (foundExistingDirectory == null) {
                if (!askedToCreate && askUserToCreate) {
                    int toCreate;
                    if (!ApplicationManager.getApplication().isUnitTestMode() && (toCreate = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"prompt.create.non.existing.package", (Object[])new Object[]{packageName}), (String)IdeBundle.message((String)"title.package.not.found", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                        return null;
                    }
                    askedToCreate = true;
                }
                final PsiDirectory psiDirectory1 = psiDirectory;
                try {
                    psiDirectory = (PsiDirectory)ActionRunner.runInsideWriteAction((ActionRunner.InterruptibleRunnableWithResult)new ActionRunner.InterruptibleRunnableWithResult<PsiDirectory>(){

                        public PsiDirectory run() throws Exception {
                            return psiDirectory1.createSubdirectory(name);
                        }
                    });
                }
                catch (IncorrectOperationException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new IncorrectOperationException((Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            } else {
                psiDirectory = foundExistingDirectory;
            }
            restOfName = PackageUtil.cutLeftPart(restOfName);
        }
        return psiDirectory;
    }

    @NotNull
    private static PsiDirectory[] filterSourceDirectories(PsiDirectory baseDir, Project project, @NotNull PsiDirectory[] moduleDirectories) {
        ProjectFileIndex fileIndex;
        if (moduleDirectories == null) {
            PackageUtil.$$$reportNull$$$0(2);
        }
        if ((fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex()).isInTestSourceContent(baseDir.getVirtualFile())) {
            ArrayList<PsiDirectory> result = new ArrayList<PsiDirectory>();
            for (PsiDirectory moduleDirectory : moduleDirectories) {
                if (!fileIndex.isInTestSourceContent(moduleDirectory.getVirtualFile())) continue;
                result.add(moduleDirectory);
            }
            moduleDirectories = result.toArray(PsiDirectory.EMPTY_ARRAY);
        }
        if (moduleDirectories == null) {
            PackageUtil.$$$reportNull$$$0(3);
        }
        return moduleDirectories;
    }

    @NotNull
    private static PsiDirectory[] getPackageDirectoriesInModule(PsiPackage rootPackage, Module module) {
        PsiDirectory[] psiDirectoryArray = rootPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module));
        if (psiDirectoryArray == null) {
            PackageUtil.$$$reportNull$$$0(4);
        }
        return psiDirectoryArray;
    }

    private static PsiPackage findLongestExistingPackage(Project project, String packageName) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        String nameToMatch = packageName;
        while (true) {
            PsiPackage aPackage;
            if ((aPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(nameToMatch)) != null && PackageUtil.isWritablePackage(aPackage)) {
                return aPackage;
            }
            int lastDotIndex = nameToMatch.lastIndexOf(46);
            if (lastDotIndex < 0) break;
            nameToMatch = nameToMatch.substring(0, lastDotIndex);
        }
        return null;
    }

    private static boolean isWritablePackage(PsiPackage aPackage) {
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            if (!directory.isValid() || !directory.isWritable()) continue;
            return true;
        }
        return false;
    }

    private static PsiDirectory getWritableModuleDirectory(@NotNull Query<VirtualFile> vFiles, @NotNull Module module, PsiManager manager) {
        if (vFiles == null) {
            PackageUtil.$$$reportNull$$$0(5);
        }
        if (module == null) {
            PackageUtil.$$$reportNull$$$0(6);
        }
        for (VirtualFile vFile : vFiles) {
            PsiDirectory directory;
            if (ModuleUtil.findModuleForFile((VirtualFile)vFile, (Project)module.getProject()) != module || (directory = manager.findDirectory(vFile)) == null || !directory.isValid() || !directory.isWritable()) continue;
            return directory;
        }
        return null;
    }

    private static PsiPackage findLongestExistingPackage(Module module, String packageName) {
        PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        String nameToMatch = packageName;
        while (true) {
            Query vFiles;
            PsiDirectory directory;
            if ((directory = PackageUtil.getWritableModuleDirectory((Query<VirtualFile>)(vFiles = ModulePackageIndex.getInstance((Module)module).getDirsByPackageName(nameToMatch, false)), module, manager)) != null) {
                return JavaDirectoryService.getInstance().getPackage(directory);
            }
            int lastDotIndex = nameToMatch.lastIndexOf(46);
            if (lastDotIndex < 0) break;
            nameToMatch = nameToMatch.substring(0, lastDotIndex);
        }
        return null;
    }

    private static String getLeftPart(String packageName) {
        int index = packageName.indexOf(46);
        return index > -1 ? packageName.substring(0, index) : packageName;
    }

    private static String cutLeftPart(String packageName) {
        int index = packageName.indexOf(46);
        return index > -1 ? packageName.substring(index + 1) : "";
    }

    public static boolean checkSourceRootsConfigured(Module module) {
        return PackageUtil.checkSourceRootsConfigured(module, true);
    }

    public static boolean checkSourceRootsConfigured(Module module, boolean askUserToSetupSourceRoots) {
        List sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
        if (sourceRoots.isEmpty()) {
            if (!askUserToSetupSourceRoots) {
                return false;
            }
            Project project = module.getProject();
            Messages.showErrorDialog((Project)project, (String)ProjectBundle.message((String)"module.source.roots.not.configured.error", (Object[])new Object[]{module.getName()}), (String)ProjectBundle.message((String)"module.source.roots.not.configured.title", (Object[])new Object[0]));
            ProjectSettingsService.getInstance((Project)project).showModuleConfigurationDialog(module.getName(), CommonContentEntriesEditor.NAME);
            sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            if (sourceRoots.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static PsiDirectory findOrCreateSubdirectory(@NotNull PsiDirectory directory, @NotNull String directoryName) {
        if (directory == null) {
            PackageUtil.$$$reportNull$$$0(7);
        }
        if (directoryName == null) {
            PackageUtil.$$$reportNull$$$0(8);
        }
        PsiDirectory psiDirectory = CreateFileAction.findOrCreateSubdirectory((PsiDirectory)directory, (String)directoryName);
        if (psiDirectory == null) {
            PackageUtil.$$$reportNull$$$0(9);
        }
        return psiDirectory;
    }

    public static boolean isPackageInfoFile(@Nullable PsiElement element) {
        return element instanceof PsiJavaFile && "package-info.java".equals(((PsiJavaFile)element).getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDirectories";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PackageUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PackageUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSourceDirectories";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageDirectoriesInModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateSubdirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateDirectoryForPackage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterSourceDirectories";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getWritableModuleDirectory";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateSubdirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

