/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.JavaModuleSystemEx;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExportsDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiresDirectiveFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.psi.JavaCompilerConfigurationProxy;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.JavaPlatformModuleSystem;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J(\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/psi/impl/JavaPlatformModuleSystem;", "Lcom/intellij/codeInsight/JavaModuleSystemEx;", "()V", "ERR", "Lcom/intellij/codeInsight/JavaModuleSystemEx$ErrorWithFixes;", "checkAccess", "target", "Lcom/intellij/psi/PsiClass;", "place", "Lcom/intellij/psi/PsiElement;", "quick", "", "Lcom/intellij/psi/PsiFileSystemItem;", "packageName", "", "Lcom/intellij/psi/PsiPackage;", "getName", "inAddedExports", "module", "Lcom/intellij/openapi/module/Module;", "targetName", "useName", "inAddedModules", "moduleName", "isAccessible", "optionValues", "Lkotlin/sequences/Sequence;", "options", "", "name", "AddExportsOptionFix", "AddModulesOptionFix", "CompilerOptionFix", "intellij.java.impl"})
public final class JavaPlatformModuleSystem
implements JavaModuleSystemEx {
    private final JavaModuleSystemEx.ErrorWithFixes ERR = new JavaModuleSystemEx.ErrorWithFixes("-");

    @NotNull
    public String getName() {
        return "Java Platform Module System";
    }

    public boolean isAccessible(@NotNull PsiPackage target, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.checkAccess(target, place, true) == null;
    }

    public boolean isAccessible(@NotNull PsiClass target, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.checkAccess(target, place, true) == null;
    }

    @Nullable
    public JavaModuleSystemEx.ErrorWithFixes checkAccess(@NotNull PsiPackage target, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.checkAccess(target, place, false);
    }

    @Nullable
    public JavaModuleSystemEx.ErrorWithFixes checkAccess(@NotNull PsiClass target, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.checkAccess(target, place, false);
    }

    private final JavaModuleSystemEx.ErrorWithFixes checkAccess(PsiClass target, PsiElement place, boolean quick) {
        PsiFile targetFile;
        PsiFile useFile;
        PsiFile psiFile = place.getContainingFile();
        Object object = useFile = psiFile != null ? psiFile.getOriginalFile() : null;
        if (useFile != null && PsiUtil.isLanguageLevel9OrHigher((PsiElement)((PsiElement)useFile)) && (targetFile = target.getContainingFile()) instanceof PsiClassOwner) {
            if (((PsiClassOwner)targetFile).isPhysical()) {
                PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)targetFile;
                PsiFileSystemItem psiFileSystemItem2 = (PsiFileSystemItem)useFile;
                String string = ((PsiClassOwner)targetFile).getPackageName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"targetFile.packageName");
                return this.checkAccess(psiFileSystemItem, psiFileSystemItem2, string, quick);
            }
            PsiPackage pkg = JavaPsiFacade.getInstance((Project)((PsiClassOwner)targetFile).getProject()).findPackage(((PsiClassOwner)targetFile).getPackageName());
            if (pkg != null) {
                return this.checkAccess(pkg, place, quick);
            }
        }
        return null;
    }

    private final JavaModuleSystemEx.ErrorWithFixes checkAccess(PsiPackage target, PsiElement place, boolean quick) {
        ProjectFileIndex index;
        Module module;
        VirtualFile useVFile;
        PsiFile useFile;
        PsiFile psiFile = place.getContainingFile();
        Object object = useFile = psiFile != null ? psiFile.getOriginalFile() : null;
        if (useFile != null && PsiUtil.isLanguageLevel9OrHigher((PsiElement)((PsiElement)useFile)) && (useVFile = useFile.getVirtualFile()) != null && (module = (index = ProjectFileIndex.getInstance((Project)useFile.getProject())).getModuleForFile(useVFile)) != null) {
            Object object2;
            boolean test = index.isInTestSourceContent(useVFile);
            PsiDirectory[] dirs = target.getDirectories(module.getModuleWithDependenciesAndLibrariesScope(test));
            Object[] objectArray = dirs;
            if (objectArray.length == 0) {
                return quick ? this.ERR : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("package.not.found", target.getQualifiedName()));
            }
            PsiDirectory psiDirectory = dirs[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"dirs[0]");
            PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)psiDirectory;
            PsiFileSystemItem psiFileSystemItem2 = (PsiFileSystemItem)useFile;
            String string = target.getQualifiedName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.qualifiedName");
            JavaModuleSystemEx.ErrorWithFixes error = this.checkAccess(psiFileSystemItem, psiFileSystemItem2, string, quick);
            if (error == null) {
                object2 = null;
            } else if (((Object[])dirs).length == 1) {
                object2 = error;
            } else {
                boolean bl;
                block7: {
                    Sequence $receiver$iv = SequencesKt.drop((Sequence)ArraysKt.asSequence((Object[])dirs), (int)1);
                    for (Object element$iv : $receiver$iv) {
                        PsiDirectory it;
                        PsiDirectory psiDirectory2 = it = (PsiDirectory)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory2, (String)"it");
                        PsiFileSystemItem psiFileSystemItem3 = (PsiFileSystemItem)psiDirectory2;
                        PsiFileSystemItem psiFileSystemItem4 = (PsiFileSystemItem)useFile;
                        String string2 = target.getQualifiedName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"target.qualifiedName");
                        if (!(this.checkAccess(psiFileSystemItem3, psiFileSystemItem4, string2, true) == null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
                object2 = bl ? null : error;
            }
            return object2;
        }
        return null;
    }

    private final JavaModuleSystemEx.ErrorWithFixes checkAccess(PsiFileSystemItem target, PsiFileSystemItem place, String packageName, boolean quick) {
        block32: {
            PsiJavaModule useModule;
            block29: {
                Module module;
                Object useName;
                String targetName;
                PsiJavaModule targetModule;
                block30: {
                    List list;
                    Object it;
                    block31: {
                        Module module2;
                        PsiFile psiFile;
                        PsiJavaModule psiJavaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)target);
                        targetModule = (PsiJavaModule)(psiJavaModule != null ? psiJavaModule.getOriginalElement() : null);
                        PsiJavaModule psiJavaModule2 = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)place);
                        useModule = (PsiJavaModule)(psiJavaModule2 != null ? psiJavaModule2.getOriginalElement() : null);
                        if (targetModule == null) break block29;
                        if (Intrinsics.areEqual((Object)targetModule, (Object)useModule)) {
                            return null;
                        }
                        if (useModule == null && !(((psiFile = targetModule.getContainingFile()) != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getFileSystem() : null) instanceof JrtFileSystem)) {
                            return null;
                        }
                        targetName = targetModule.getName();
                        Object object = useModule;
                        if (object == null || (object = object.getName()) == null) {
                            object = "ALL-UNNAMED";
                        }
                        useName = object;
                        VirtualFile virtualFile = place.getVirtualFile();
                        if (virtualFile != null) {
                            VirtualFile virtualFile2 = virtualFile;
                            it = virtualFile2;
                            module2 = ProjectFileIndex.getInstance((Project)place.getProject()).getModuleForFile((VirtualFile)it);
                        } else {
                            module2 = module = null;
                        }
                        if (targetModule instanceof LightJavaModule || JavaModuleGraphUtil.exports(targetModule, packageName, useModule)) break block30;
                        if (module == null) break block31;
                        String string = targetName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"targetName");
                        Object object2 = useName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"useName");
                        if (this.inAddedExports(module, string, packageName, (String)object2)) break block30;
                    }
                    if (quick) {
                        return this.ERR;
                    }
                    it = packageName;
                    if (it.length() == 0) {
                        list = CollectionsKt.emptyList();
                    } else if (targetModule instanceof PsiCompiledElement && module != null) {
                        String string = targetName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"targetName");
                        Object object = useName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"useName");
                        list = CollectionsKt.listOf((Object)new AddExportsOptionFix(module, string, packageName, (String)object));
                    } else if (!(targetModule instanceof PsiCompiledElement) && useModule != null) {
                        Object object = useName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"useName");
                        list = CollectionsKt.listOf((Object)((Object)new AddExportsDirectiveFix(targetModule, packageName, (String)object)));
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List fixes = list;
                    it = useModule;
                    return it == null ? new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("module.access.from.unnamed", packageName, targetName), fixes) : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("module.access.from.named", packageName, targetName, useName), fixes);
                }
                if (useModule == null) {
                    List list;
                    if (!StringsKt.startsWith$default((String)targetName, (String)"java.", (boolean)false, (int)2, null)) {
                        return null;
                    }
                    PsiJavaModule root = PsiJavaModuleReference.resolve((PsiElement)place, "java.se", false);
                    if (root == null || JavaModuleGraphUtil.reads(root, targetModule)) {
                        return null;
                    }
                    if (module != null) {
                        String string = targetName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"targetName");
                        if (this.inAddedModules(module, string)) {
                            return null;
                        }
                    }
                    if (quick || module == null) {
                        list = CollectionsKt.emptyList();
                    } else {
                        String string = targetName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"targetName");
                        list = CollectionsKt.listOf((Object)new AddModulesOptionFix(module, string));
                    }
                    List fixes = list;
                    return quick ? this.ERR : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("module.access.not.in.graph", packageName, targetName), fixes);
                }
                if (!Intrinsics.areEqual((Object)targetName, (Object)"java.base") && !JavaModuleGraphUtil.reads(useModule, targetModule)) {
                    JavaModuleSystemEx.ErrorWithFixes errorWithFixes;
                    if (quick) {
                        errorWithFixes = this.ERR;
                    } else if (PsiNameHelper.isValidModuleName((String)targetName, (PsiElement)((PsiElement)useModule))) {
                        String string = JavaErrorMessages.message("module.access.does.not.read", packageName, targetName, useName);
                        String string2 = targetName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"targetName");
                        errorWithFixes = new JavaModuleSystemEx.ErrorWithFixes(string, CollectionsKt.listOf((Object)((Object)new AddRequiresDirectiveFix(useModule, string2))));
                    } else {
                        errorWithFixes = new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("module.access.bad.name", packageName, targetName));
                    }
                    return errorWithFixes;
                }
                break block32;
            }
            if (useModule != null) {
                return quick ? this.ERR : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("module.access.to.unnamed", packageName, useModule.getName()));
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean inAddedExports(Module module, String targetName, String packageName, String useName) {
        boolean bl;
        block2: {
            void $receiver$iv;
            List options = JavaCompilerConfigurationProxy.getAdditionalOptions((Project)module.getProject(), (Module)module);
            if (options.isEmpty()) {
                return false;
            }
            String prefix = "" + targetName + '/' + packageName + '=';
            List list = options;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"options");
            Sequence sequence = SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(this.optionValues(list, "--add-exports"), (Function1)((Function1)new Function1<String, Boolean>(prefix){
                final /* synthetic */ String $prefix;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return StringsKt.startsWith$default((String)it, (String)this.$prefix, (boolean)false, (int)2, null);
                }
                {
                    this.$prefix = string;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<String, String>(prefix){
                final /* synthetic */ String $prefix;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String string = it;
                    int n = this.$prefix.length();
                    String string2 = string.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    return string2;
                }
                {
                    this.$prefix = string;
                    super(1);
                }
            })), (Function1)inAddedExports.3.INSTANCE);
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                if (!Intrinsics.areEqual((Object)it, (Object)useName)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean inAddedModules(Module module, String moduleName) {
        boolean bl;
        block1: {
            void $receiver$iv;
            List options;
            List list = options = JavaCompilerConfigurationProxy.getAdditionalOptions((Project)module.getProject(), (Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"options");
            Sequence sequence = SequencesKt.flatMap(this.optionValues(list, "--add-modules"), (Function1)inAddedModules.1.INSTANCE);
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                if (!(Intrinsics.areEqual((Object)it, (Object)moduleName) || Intrinsics.areEqual((Object)it, (Object)"ALL-SYSTEM"))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<String> optionValues(List<String> options, String name) {
        Sequence sequence;
        if (options.isEmpty()) {
            sequence = SequencesKt.emptySequence();
        } else {
            void useValue;
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            sequence = SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)options), (Function1)((Function1)new Function1<String, String>(name, (Ref.BooleanRef)useValue){
                final /* synthetic */ String $name;
                final /* synthetic */ Ref.BooleanRef $useValue;

                @NotNull
                public final String invoke(@NotNull String it) {
                    String string;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (Intrinsics.areEqual((Object)it, (Object)this.$name)) {
                        this.$useValue.element = true;
                        string = "";
                    } else if (this.$useValue.element) {
                        this.$useValue.element = false;
                        string = it;
                    } else if (StringsKt.startsWith$default((String)it, (String)this.$name, (boolean)false, (int)2, null) && it.charAt(this.$name.length()) == '=') {
                        String string2 = it;
                        int n = this.$name.length() + 1;
                        String string3 = string2.substring(n);
                        string = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    } else {
                        string = "";
                    }
                    return string;
                }
                {
                    this.$name = string;
                    this.$useValue = booleanRef;
                    super(1);
                }
            })), (Function1)optionValues.2.INSTANCE);
        }
        return sequence;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0016\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/psi/impl/JavaPlatformModuleSystem$CompilerOptionFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "update", "options", "", "intellij.java.impl"})
    private static abstract class CompilerOptionFix
    implements IntentionAction {
        private final Module module;

        @NotNull
        public String getFamilyName() {
            return "dfd4a2c1-da18-4651-9aa8-d7d31cae10be";
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return !this.module.isDisposed();
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (this.isAvailable(project, editor, file)) {
                List options = CollectionsKt.toMutableList((Collection)JavaCompilerConfigurationProxy.getAdditionalOptions((Project)this.module.getProject(), (Module)this.module));
                this.update(options);
                JavaCompilerConfigurationProxy.setAdditionalOptions((Project)this.module.getProject(), (Module)this.module, (List)options);
                PsiManager.getInstance((Project)project).dropPsiCaches();
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }

        protected abstract void update(@NotNull List<String> var1);

        public boolean startInWriteAction() {
            return true;
        }

        public CompilerOptionFix(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            this.module = module;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u0005H\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0014R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/psi/impl/JavaPlatformModuleSystem$AddExportsOptionFix;", "Lcom/intellij/psi/impl/JavaPlatformModuleSystem$CompilerOptionFix;", "module", "Lcom/intellij/openapi/module/Module;", "targetName", "", "packageName", "useName", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "qualifier", "getText", "update", "", "options", "", "intellij.java.impl"})
    private static final class AddExportsOptionFix
    extends CompilerOptionFix {
        private final String qualifier;
        private final String useName;

        @NotNull
        public String getText() {
            return QuickFixBundle.message("add.compiler.option.fix.name", "--add-exports=" + this.qualifier + '=' + this.useName);
        }

        @Override
        protected void update(@NotNull List<String> options) {
            Intrinsics.checkParameterIsNotNull(options, (String)"options");
            int idx = -1;
            int candidate = -1;
            int offset = 0;
            for (Object object : CollectionsKt.withIndex((Iterable)options)) {
                int i = object.component1();
                String option = (String)object.component2();
                if (StringsKt.startsWith$default((String)option, (String)"--add-exports", (boolean)false, (int)2, null)) {
                    if (option.length() == 13) {
                        candidate = i + 1;
                        offset = 0;
                    } else if (option.charAt(13) == '=') {
                        candidate = i;
                        offset = 14;
                    }
                }
                if (i != candidate || !StringsKt.startsWith$default((String)option, (String)this.qualifier, (int)offset, (boolean)false, (int)4, null)) continue;
                int qualifierEnd = this.qualifier.length() + offset;
                if (option.length() != qualifierEnd && option.charAt(qualifierEnd) != '=') continue;
                idx = i;
            }
            if (idx == -1) {
                Object object;
                object = options;
                String string = "--add-exports=" + this.qualifier + '=' + this.useName;
                object.add(string);
            } else if (candidate == options.size()) {
                options.set(idx - 1, "--add-exports=" + this.qualifier + '=' + this.useName);
            } else {
                String value2 = options.get(idx);
                options.set(idx, StringsKt.endsWith$default((CharSequence)value2, (char)'=', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)value2, (char)',', (boolean)false, (int)2, null) ? value2 + this.useName : value2 + ',' + this.useName);
            }
        }

        public AddExportsOptionFix(@NotNull Module module, @NotNull String targetName, @NotNull String packageName, @NotNull String useName) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)targetName, (String)"targetName");
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            Intrinsics.checkParameterIsNotNull((Object)useName, (String)"useName");
            super(module);
            this.useName = useName;
            this.qualifier = targetName + '/' + packageName;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/psi/impl/JavaPlatformModuleSystem$AddModulesOptionFix;", "Lcom/intellij/psi/impl/JavaPlatformModuleSystem$CompilerOptionFix;", "module", "Lcom/intellij/openapi/module/Module;", "moduleName", "", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "getText", "update", "", "options", "", "intellij.java.impl"})
    private static final class AddModulesOptionFix
    extends CompilerOptionFix {
        private final String moduleName;

        @NotNull
        public String getText() {
            return QuickFixBundle.message("add.compiler.option.fix.name", "--add-modules=" + this.moduleName);
        }

        @Override
        protected void update(@NotNull List<String> options) {
            Intrinsics.checkParameterIsNotNull(options, (String)"options");
            int idx = -1;
            for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)options)) {
                int i = indexedValue.component1();
                String option = (String)indexedValue.component2();
                if (!StringsKt.startsWith$default((String)option, (String)"--add-modules", (boolean)false, (int)2, null)) continue;
                if (option.length() == 13) {
                    idx = i + 1;
                    continue;
                }
                if (option.charAt(13) != '=') continue;
                idx = i;
            }
            int n = idx;
            if (n == -1) {
                Collection collection = options;
                String string = "--add-modules=" + this.moduleName;
                collection.add(string);
            } else if (n == options.size()) {
                options.set(idx - 1, "--add-modules=" + this.moduleName);
            } else {
                String value2 = options.get(idx);
                options.set(idx, StringsKt.endsWith$default((CharSequence)value2, (char)'=', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)value2, (char)',', (boolean)false, (int)2, null) ? value2 + this.moduleName : value2 + ',' + this.moduleName);
            }
        }

        public AddModulesOptionFix(@NotNull Module module, @NotNull String moduleName) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            super(module);
            this.moduleName = moduleName;
        }
    }
}

