/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AnonymousTargetClassPreselectionUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.AddNullableNotNullAnnotationFix;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ControlFlowWrapper;
import com.intellij.refactoring.extractMethod.ExtractMethodDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.ParametrizedDuplicates;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethod.SignatureSuggesterPreviewDialog;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.classMembers.ElementNeedsThis;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MatchUtil;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodProcessor
implements MatchProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.extractMethod.ExtractMethodProcessor");
    protected final Project myProject;
    private final Editor myEditor;
    protected final PsiElement[] myElements;
    private final PsiBlockStatement myEnclosingBlockStatement;
    private final PsiType myForcedReturnType;
    protected final String myRefactoringName;
    protected final String myInitialMethodName;
    private final String myHelpId;
    private final PsiManager myManager;
    private final PsiElementFactory myElementFactory;
    private final CodeStyleManager myStyleManager;
    private PsiExpression myExpression;
    private PsiElement myCodeFragmentMember;
    protected String myMethodName;
    protected PsiType myReturnType;
    protected PsiTypeParameterList myTypeParameterList;
    protected VariableData[] myVariableDatum;
    protected PsiClassType[] myThrownExceptions;
    protected boolean myStatic;
    protected PsiClass myTargetClass;
    private PsiElement myAnchor;
    protected ControlFlowWrapper myControlFlowWrapper;
    protected InputVariables myInputVariables;
    protected PsiVariable[] myOutputVariables;
    protected PsiVariable myOutputVariable;
    protected PsiVariable myArtificialOutputVariable;
    private Collection<PsiStatement> myExitStatements;
    private boolean myHasReturnStatement;
    private boolean myHasReturnStatementOutput;
    protected boolean myHasExpressionOutput;
    private boolean myNeedChangeContext;
    private boolean myShowErrorDialogs = true;
    private boolean myIsPreviewSupported;
    private boolean myPreviewDuplicates;
    protected boolean myCanBeStatic;
    protected boolean myCanBeChainedConstructor;
    protected boolean myIsChainedConstructor;
    private List<Match> myDuplicates;
    private ParametrizedDuplicates myParametrizedDuplicates;
    @PsiModifier.ModifierConstant
    protected String myMethodVisibility = "private";
    protected boolean myGenerateConditionalExit;
    protected PsiStatement myFirstExitStatementCopy;
    protected PsiMethod myExtractedMethod;
    private PsiMethodCallExpression myMethodCall;
    private PsiBlockStatement myAddedToMethodCallLocation;
    protected boolean myNullConditionalCheck;
    protected boolean myNotNullConditionalCheck;
    protected Nullness myNullness;

    public ExtractMethodProcessor(Project project, Editor editor, PsiElement[] elements, PsiType forcedReturnType, String refactoringName, String initialMethodName, String helpId) {
        this.myProject = project;
        this.myEditor = editor;
        if (elements.length != 1 || !(elements[0] instanceof PsiBlockStatement)) {
            PsiElement[] psiElementArray;
            if (elements.length == 1 && elements[0] instanceof PsiParenthesizedExpression) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)elements[0]));
            } else {
                psiElementArray = elements;
            }
            this.myElements = psiElementArray;
            this.myEnclosingBlockStatement = null;
        } else {
            this.myEnclosingBlockStatement = (PsiBlockStatement)elements[0];
            PsiElement[] codeBlockChildren = this.myEnclosingBlockStatement.getCodeBlock().getChildren();
            this.myElements = ExtractMethodProcessor.processCodeBlockChildren(codeBlockChildren);
        }
        this.myForcedReturnType = forcedReturnType;
        this.myRefactoringName = refactoringName;
        this.myInitialMethodName = initialMethodName;
        this.myHelpId = helpId;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myElementFactory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        this.myStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
    }

    private static PsiElement[] processCodeBlockChildren(PsiElement[] codeBlockChildren) {
        PsiElement last;
        int resultLast = codeBlockChildren.length;
        if (codeBlockChildren.length == 0) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement first = codeBlockChildren[0];
        int resultStart = 0;
        if (PsiUtil.isJavaToken((PsiElement)first, (IElementType)JavaTokenType.LBRACE)) {
            ++resultStart;
        }
        if (PsiUtil.isJavaToken((PsiElement)(last = codeBlockChildren[codeBlockChildren.length - 1]), (IElementType)JavaTokenType.RBRACE)) {
            --resultLast;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (int i = resultStart; i < resultLast; ++i) {
            PsiElement element = codeBlockChildren[i];
            if (element instanceof PsiWhiteSpace) continue;
            result.add(element);
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    public void setShowErrorDialogs(boolean showErrorDialogs) {
        this.myShowErrorDialogs = showErrorDialogs;
    }

    public void setPreviewSupported(boolean previewSupported) {
        this.myIsPreviewSupported = previewSupported;
    }

    public boolean isPreviewDuplicates() {
        return this.myPreviewDuplicates;
    }

    public void setChainedConstructor(boolean isChainedConstructor) {
        this.myIsChainedConstructor = isChainedConstructor;
    }

    public boolean prepare() throws PrepareFailedException {
        return this.prepare(null);
    }

    public boolean prepare(@Nullable Pass<ExtractMethodProcessor> pass) throws PrepareFailedException {
        PsiElement codeFragment;
        block10: {
            if (this.myElements.length == 0) {
                return false;
            }
            this.myExpression = null;
            if (this.myElements.length == 1 && this.myElements[0] instanceof PsiExpression) {
                PsiExpression expression2 = (PsiExpression)this.myElements[0];
                if (expression2 instanceof PsiAssignmentExpression && expression2.getParent() instanceof PsiExpressionStatement) {
                    this.myElements[0] = expression2.getParent();
                } else {
                    this.myExpression = expression2;
                }
            }
            codeFragment = ControlFlowUtil.findCodeFragment(this.myElements[0]);
            this.myCodeFragmentMember = (PsiElement)codeFragment.getUserData(ElementToWorkOn.PARENT);
            if (this.myCodeFragmentMember == null) {
                this.myCodeFragmentMember = codeFragment.getParent();
            }
            if (this.myCodeFragmentMember == null) {
                PsiElement context = codeFragment.getContext();
                LOG.assertTrue(context != null, (Object)"code fragment context is null");
                this.myCodeFragmentMember = ControlFlowUtil.findCodeFragment(context).getParent();
            }
            this.myControlFlowWrapper = new ControlFlowWrapper(this.myProject, codeFragment, this.myElements);
            try {
                this.myExitStatements = this.myControlFlowWrapper.prepareExitStatements(this.myElements, codeFragment);
                if (this.myControlFlowWrapper.isGenerateConditionalExit()) {
                    this.myGenerateConditionalExit = true;
                } else {
                    this.myHasReturnStatement = this.myExpression == null && this.myControlFlowWrapper.isReturnPresentBetween();
                }
                this.myFirstExitStatementCopy = this.myControlFlowWrapper.getFirstExitStatementCopy();
            }
            catch (ControlFlowWrapper.ExitStatementsNotSameException e) {
                this.myExitStatements = this.myControlFlowWrapper.getExitStatements();
                this.myNotNullConditionalCheck = this.areAllExitPointsNotNull(this.getExpectedReturnType());
                if (this.myNotNullConditionalCheck) break block10;
                this.showMultipleExitPointsMessage();
                return false;
            }
        }
        this.myOutputVariables = this.myControlFlowWrapper.getOutputVariables();
        return this.chooseTargetClass(codeFragment, pass);
    }

    private boolean checkExitPoints() throws PrepareFailedException {
        PsiPrimitiveType expressionType = null;
        if (this.myExpression != null) {
            if (this.myForcedReturnType != null) {
                expressionType = this.myForcedReturnType;
            } else {
                expressionType = RefactoringUtil.getTypeByExpressionWithExpectedType(this.myExpression);
                if (expressionType == null && !(this.myExpression.getParent() instanceof PsiExpressionStatement)) {
                    expressionType = PsiType.getJavaLangObject((PsiManager)this.myExpression.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
                }
            }
        }
        if (expressionType == null) {
            expressionType = PsiType.VOID;
        }
        this.myHasExpressionOutput = !PsiType.VOID.equals((Object)expressionType);
        PsiType returnStatementType = this.getExpectedReturnType();
        boolean bl = this.myHasReturnStatementOutput = this.myHasReturnStatement && returnStatementType != null && !PsiType.VOID.equals((Object)returnStatementType);
        if (this.myGenerateConditionalExit && this.myOutputVariables.length == 1) {
            if (!(this.myOutputVariables[0].getType() instanceof PsiPrimitiveType)) {
                this.myNullConditionalCheck = this.isNullInferred(this.myOutputVariables[0].getName()) && this.getReturnsNullability(true);
            }
            this.myNotNullConditionalCheck = this.areAllExitPointsNotNull(returnStatementType);
        }
        if (!this.myHasReturnStatementOutput && this.checkOutputVariablesCount() && !this.myNullConditionalCheck && !this.myNotNullConditionalCheck) {
            this.showMultipleOutputMessage((PsiType)expressionType);
            return false;
        }
        PsiVariable psiVariable = this.myOutputVariable = this.myOutputVariables.length > 0 ? this.myOutputVariables[0] : null;
        this.myReturnType = this.myNotNullConditionalCheck ? (returnStatementType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)returnStatementType).getBoxedType(this.myCodeFragmentMember) : returnStatementType) : (this.myHasReturnStatementOutput ? returnStatementType : (this.myOutputVariable != null ? this.myOutputVariable.getType() : (this.myGenerateConditionalExit ? PsiType.BOOLEAN : expressionType)));
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)this.myElements[0], (Class[])new Class[]{PsiClass.class, PsiMethod.class});
        while (container instanceof PsiMethod && ((PsiMethod)container).getContainingClass() != this.myTargetClass) {
            container = PsiTreeUtil.getParentOfType((PsiElement)container, PsiMethod.class, (boolean)true);
        }
        if (container instanceof PsiMethod) {
            PsiElement[] elements = this.myElements;
            if (this.myExpression == null) {
                if (this.myOutputVariable != null) {
                    elements = (PsiElement[])ArrayUtil.append((Object[])this.myElements, (Object)this.myOutputVariable, PsiElement.class);
                }
                if (this.myCodeFragmentMember instanceof PsiMethod && this.myReturnType == ((PsiMethod)this.myCodeFragmentMember).getReturnType()) {
                    elements = (PsiElement[])ArrayUtil.append((Object[])this.myElements, (Object)((PsiMethod)this.myCodeFragmentMember).getReturnTypeElement(), PsiElement.class);
                }
            }
            this.myTypeParameterList = RefactoringUtil.createTypeParameterListWithUsedTypeParameters(((PsiMethod)container).getTypeParameterList(), elements);
        }
        List<PsiClassType> exceptions = ExceptionUtil.getThrownCheckedExceptions(this.myElements);
        this.myThrownExceptions = exceptions.toArray(PsiClassType.EMPTY_ARRAY);
        if (container instanceof PsiMethod) {
            this.checkLocalClasses((PsiMethod)container);
        }
        return true;
    }

    private PsiType getExpectedReturnType() {
        return this.myCodeFragmentMember instanceof PsiMethod ? ((PsiMethod)this.myCodeFragmentMember).getReturnType() : (this.myCodeFragmentMember instanceof PsiLambdaExpression ? LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)this.myCodeFragmentMember)) : null);
    }

    @Nullable
    protected PsiVariable getArtificialOutputVariable() {
        if (this.myOutputVariables.length == 0 && this.myExitStatements.isEmpty()) {
            if (this.myCanBeChainedConstructor) {
                final HashSet fields = new HashSet();
                for (PsiElement element : this.myElements) {
                    element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitReferenceExpression(PsiReferenceExpression expression2) {
                            super.visitReferenceExpression(expression2);
                            PsiElement resolve = expression2.resolve();
                            if (resolve instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final") && PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                                fields.add((PsiField)resolve);
                            }
                        }
                    });
                }
                if (!fields.isEmpty()) {
                    return fields.size() == 1 ? (PsiVariable)fields.iterator().next() : null;
                }
            }
            VariablesProcessor processor = new VariablesProcessor(true){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    return ExtractMethodProcessor.this.isDeclaredInside(var);
                }
            };
            PsiScopesUtil.treeWalkUp(processor, this.myElements[this.myElements.length - 1], this.myCodeFragmentMember);
            if (processor.size() == 1) {
                return processor.getResult(0);
            }
        }
        return null;
    }

    private boolean areAllExitPointsNotNull(PsiType returnStatementType) {
        if (this.insertNotNullCheckIfPossible() && this.myControlFlowWrapper.getOutputVariables(false).length == 0 && returnStatementType != null && !PsiType.VOID.equals((Object)returnStatementType)) {
            return this.getReturnsNullability(false);
        }
        return false;
    }

    private boolean getReturnsNullability(final boolean nullsExpected) {
        PsiCodeBlock body2 = null;
        if (this.myCodeFragmentMember instanceof PsiMethod) {
            body2 = ((PsiMethod)this.myCodeFragmentMember).getBody();
        } else if (this.myCodeFragmentMember instanceof PsiLambdaExpression) {
            body2 = ((PsiLambdaExpression)this.myCodeFragmentMember).getBody();
        }
        if (body2 == null) {
            return false;
        }
        final Set returnedExpressions = StreamEx.of(this.myExitStatements).select(PsiReturnStatement.class).map(PsiReturnStatement::getReturnValue).nonNull().toSet();
        Iterator it = returnedExpressions.iterator();
        while (it.hasNext()) {
            PsiType type2 = ((PsiExpression)it.next()).getType();
            if (nullsExpected) {
                if (type2 == PsiType.NULL) {
                    it.remove();
                    continue;
                }
                if (!(type2 instanceof PsiPrimitiveType)) continue;
                return false;
            }
            if (type2 == PsiType.NULL) {
                return false;
            }
            if (!(type2 instanceof PsiPrimitiveType)) continue;
            it.remove();
        }
        if (returnedExpressions.isEmpty()) {
            return true;
        }
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner();
        class ReturnChecker
        extends StandardInstructionVisitor {
            boolean myResult = true;

            ReturnChecker() {
            }

            @Override
            public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                if (returnedExpressions.contains(instruction.getReturn())) {
                    this.myResult &= nullsExpected ? memState.isNull(memState.peek()) : memState.isNotNull(memState.peek());
                }
                return super.visitCheckReturnValue(instruction, runner, memState);
            }
        }
        ReturnChecker returnChecker = new ReturnChecker();
        if (dfaRunner.analyzeMethod((PsiElement)body2, returnChecker) == RunnerResult.OK) {
            return returnChecker.myResult;
        }
        return false;
    }

    protected boolean insertNotNullCheckIfPossible() {
        return true;
    }

    private boolean isNullInferred(String exprText) {
        PsiCodeBlock block = this.myElementFactory.createCodeBlockFromText("{}", this.myElements[0]);
        for (PsiElement element : this.myElements) {
            block.add(element);
        }
        PsiIfStatement statementFromText = (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + exprText + " == null);", null);
        block.add((PsiElement)statementFromText);
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner();
        StandardInstructionVisitor visitor = new StandardInstructionVisitor();
        RunnerResult rc = dfaRunner.analyzeMethod((PsiElement)block, visitor);
        if (rc == RunnerResult.OK) {
            Pair<Set<Instruction>, Set<Instruction>> expressions2 = dfaRunner.getConstConditionalExpressions();
            Set set = (Set)expressions2.getSecond();
            for (Instruction instruction : set) {
                if (!(instruction instanceof BranchingInstruction) || !((BranchingInstruction)instruction).getPsiAnchor().getText().equals(statementFromText.getCondition().getText())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkOutputVariablesCount() {
        int outputCount = (this.myHasExpressionOutput ? 1 : 0) + (this.myGenerateConditionalExit ? 1 : 0) + this.myOutputVariables.length;
        return outputCount > 1;
    }

    private void checkCanBeChainedConstructor() {
        if (!(this.myCodeFragmentMember instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)this.myCodeFragmentMember;
        if (!method.isConstructor() || !PsiType.VOID.equals((Object)this.myReturnType)) {
            return;
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return;
        }
        PsiStatement[] psiStatements = body2.getStatements();
        if (psiStatements.length > 0 && this.myElements[0] == psiStatements[0]) {
            this.myCanBeChainedConstructor = true;
        }
    }

    private void checkLocalClasses(PsiMethod container) throws PrepareFailedException {
        final ArrayList localClasses = new ArrayList();
        container.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
                localClasses.add(aClass);
            }

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                this.visitElement((PsiElement)aClass);
            }

            public void visitTypeParameter(PsiTypeParameter classParameter) {
                this.visitElement((PsiElement)classParameter);
            }
        });
        for (PsiClass localClass : localClasses) {
            boolean classExtracted = this.isExtractedElement((PsiElement)localClass);
            List extractedReferences = Collections.synchronizedList(new ArrayList());
            List remainingReferences = Collections.synchronizedList(new ArrayList());
            ReferencesSearch.search((PsiElement)localClass).forEach(psiReference -> {
                PsiElement element = psiReference.getElement();
                boolean elementExtracted = this.isExtractedElement(element);
                if (elementExtracted && !classExtracted) {
                    extractedReferences.add(element);
                    return false;
                }
                if (!elementExtracted && classExtracted) {
                    remainingReferences.add(element);
                    return false;
                }
                return true;
            });
            if (!extractedReferences.isEmpty()) {
                throw new PrepareFailedException("Cannot extract method because the selected code fragment uses local classes defined outside of the fragment", (PsiElement)extractedReferences.get(0));
            }
            if (!remainingReferences.isEmpty()) {
                throw new PrepareFailedException("Cannot extract method because the selected code fragment defines local classes used outside of the fragment", (PsiElement)remainingReferences.get(0));
            }
            if (!classExtracted) continue;
            for (PsiVariable variable : this.myControlFlowWrapper.getUsedVariables()) {
                if (!this.isDeclaredInside(variable) || variable.equals(this.myOutputVariable) || PsiUtil.resolveClassInType((PsiType)variable.getType()) != localClass) continue;
                throw new PrepareFailedException("Cannot extract method because the selected code fragment defines variable of local class type used outside of the fragment", (PsiElement)variable);
            }
        }
    }

    private boolean isExtractedElement(PsiElement element) {
        boolean isExtracted = false;
        for (PsiElement psiElement : this.myElements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
            isExtracted = true;
            break;
        }
        return isExtracted;
    }

    private boolean shouldBeStatic() {
        for (PsiElement element : this.myElements) {
            PsiExpressionStatement statement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionStatement.class);
            if (statement == null || !JavaHighlightUtil.isSuperOrThisCall((PsiStatement)statement, true, true)) continue;
            return true;
        }
        PsiElement codeFragmentMember = this.myCodeFragmentMember;
        while (codeFragmentMember != null && PsiTreeUtil.isAncestor((PsiElement)this.myTargetClass, (PsiElement)codeFragmentMember, (boolean)true)) {
            if (codeFragmentMember instanceof PsiModifierListOwner && ((PsiModifierListOwner)codeFragmentMember).hasModifierProperty("static")) {
                return true;
            }
            codeFragmentMember = PsiTreeUtil.getParentOfType((PsiElement)codeFragmentMember, PsiModifierListOwner.class, (boolean)true);
        }
        return false;
    }

    public boolean showDialog(boolean direct) {
        AbstractExtractDialog dialog = this.createExtractMethodDialog(direct);
        dialog.show();
        if (!dialog.isOK()) {
            return false;
        }
        this.apply(dialog);
        return true;
    }

    protected void apply(AbstractExtractDialog dialog) {
        this.myMethodName = dialog.getChosenMethodName();
        this.myVariableDatum = dialog.getChosenParameters();
        this.myStatic = this.isStatic() | dialog.isMakeStatic();
        this.myIsChainedConstructor = dialog.isChainedConstructor();
        this.myMethodVisibility = dialog.getVisibility();
        PsiType returnType = dialog.getReturnType();
        if (returnType != null) {
            this.myReturnType = returnType;
        }
        this.myPreviewDuplicates = dialog.isPreviewUsages();
    }

    protected AbstractExtractDialog createExtractMethodDialog(final boolean direct) {
        this.setDataFromInputVariables();
        this.myNullness = this.initNullness();
        this.myArtificialOutputVariable = PsiType.VOID.equals((Object)this.myReturnType) ? this.getArtificialOutputVariable() : null;
        PsiType returnType = this.myArtificialOutputVariable != null ? this.myArtificialOutputVariable.getType() : this.myReturnType;
        int duplicatesCount = this.estimateDuplicatesCount();
        return new ExtractMethodDialog(this.myProject, this.myTargetClass, this.myInputVariables, returnType, this.getTypeParameterList(), (PsiType[])this.getThrownExceptions(), this.isStatic(), this.isCanBeStatic(), this.myCanBeChainedConstructor, this.myRefactoringName, this.myHelpId, this.myNullness, this.myElements, duplicatesCount){

            @Override
            protected boolean areTypesDirected() {
                return direct;
            }

            @Override
            protected String[] suggestMethodNames() {
                return ExtractMethodProcessor.this.suggestInitialMethodName();
            }

            @Override
            protected PsiExpression[] findOccurrences() {
                return ExtractMethodProcessor.this.findOccurrences();
            }

            @Override
            protected boolean isOutputVariable(PsiVariable var) {
                return ExtractMethodProcessor.this.isOutputVariable(var);
            }

            @Override
            protected boolean isVoidReturn() {
                return ExtractMethodProcessor.this.myArtificialOutputVariable != null && !(ExtractMethodProcessor.this.myArtificialOutputVariable instanceof PsiField);
            }

            @Override
            protected void checkMethodConflicts(MultiMap<PsiElement, String> conflicts) {
                super.checkMethodConflicts(conflicts);
                VariableData[] parameters2 = this.getChosenParameters();
                final HashMap vars = new HashMap();
                for (PsiElement psiElement : ExtractMethodProcessor.this.myElements) {
                    psiElement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitLocalVariable(PsiLocalVariable variable) {
                            super.visitLocalVariable(variable);
                            vars.put(variable.getName(), variable);
                        }

                        public void visitClass(PsiClass aClass) {
                        }
                    });
                }
                for (VariableData variableData : parameters2) {
                    String paramName = variableData.name;
                    PsiLocalVariable variable = (PsiLocalVariable)vars.get(paramName);
                    if (variable == null) continue;
                    conflicts.putValue((Object)variable, (Object)("Variable with name " + paramName + " is already defined in the selected scope"));
                }
            }

            @Override
            protected boolean isPreviewSupported() {
                return ExtractMethodProcessor.this.myIsPreviewSupported && this.getDuplicatesCount() != 0;
            }
        };
    }

    public void setDataFromInputVariables() {
        List<VariableData> variables = this.myInputVariables.getInputVariables();
        this.myVariableDatum = variables.toArray(new VariableData[0]);
    }

    public PsiExpression[] findOccurrences() {
        if (this.myExpression != null) {
            return new PsiExpression[]{this.myExpression};
        }
        if (this.myOutputVariable != null) {
            PsiElement scope = this.myOutputVariable instanceof PsiLocalVariable ? RefactoringUtil.getVariableScope((PsiLocalVariable)this.myOutputVariable) : PsiTreeUtil.findCommonParent((PsiElement[])this.myElements);
            return CodeInsightUtil.findReferenceExpressions(scope, (PsiElement)this.myOutputVariable);
        }
        List filter = ContainerUtil.filter(this.myExitStatements, statement -> statement instanceof PsiReturnStatement && ((PsiReturnStatement)statement).getReturnValue() != null);
        List map = ContainerUtil.map((Collection)filter, statement -> ((PsiReturnStatement)statement).getReturnValue());
        return map.toArray(PsiExpression.EMPTY_ARRAY);
    }

    private Nullness initNullness() {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)this.myElements[0]) || PsiUtil.resolveClassInType((PsiType)this.myReturnType) == null) {
            return null;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
        PsiClass nullableAnnotationClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(manager.getDefaultNullable(), this.myElements[0].getResolveScope());
        if (nullableAnnotationClass != null) {
            PsiElement elementInCopy = this.myTargetClass.getContainingFile().copy().findElementAt(this.myTargetClass.getTextOffset());
            PsiClass classCopy = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementInCopy, PsiClass.class);
            if (classCopy == null) {
                return null;
            }
            PsiMethod emptyMethod = (PsiMethod)classCopy.addAfter((PsiElement)this.generateEmptyMethod("name", null), classCopy.getLBrace());
            this.prepareMethodBody(emptyMethod, false);
            if (this.myNotNullConditionalCheck || this.myNullConditionalCheck) {
                return Nullness.NULLABLE;
            }
            return DfaUtil.inferMethodNullity(emptyMethod);
        }
        return null;
    }

    protected String[] suggestInitialMethodName() {
        if (StringUtil.isEmpty((String)this.myInitialMethodName)) {
            LinkedHashSet<String> initialMethodNames = new LinkedHashSet<String>();
            JavaCodeStyleManagerImpl codeStyleManager = (JavaCodeStyleManagerImpl)JavaCodeStyleManager.getInstance((Project)this.myProject);
            if (this.myExpression != null || !(this.myReturnType instanceof PsiPrimitiveType)) {
                String[] names;
                for (String name : names = codeStyleManager.suggestVariableName((VariableKind)VariableKind.FIELD, null, (PsiExpression)this.myExpression, (PsiType)this.myReturnType).names) {
                    initialMethodNames.add(codeStyleManager.variableNameToPropertyName(name, VariableKind.FIELD));
                }
            }
            if (this.myOutputVariable != null) {
                VariableKind outKind = codeStyleManager.getVariableKind(this.myOutputVariable);
                SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.FIELD, codeStyleManager.variableNameToPropertyName(this.myOutputVariable.getName(), outKind), null, this.myOutputVariable.getType());
                for (String name : nameInfo.names) {
                    initialMethodNames.add(codeStyleManager.variableNameToPropertyName(name, VariableKind.FIELD));
                }
            }
            String nameByComment = this.getNameByComment();
            PsiField field = JavaPsiFacade.getElementFactory((Project)this.myProject).createField("fieldNameToReplace", this.myReturnType instanceof PsiEllipsisType ? ((PsiEllipsisType)this.myReturnType).toArrayType() : this.myReturnType);
            ArrayList getters = new ArrayList(ContainerUtil.map(initialMethodNames, propertyName -> {
                if (!PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(propertyName)) {
                    LOG.info(propertyName + "; " + this.myExpression);
                    return null;
                }
                field.setName(propertyName);
                return GenerateMembersUtil.suggestGetterName(field);
            }));
            ContainerUtil.addIfNotNull(getters, (Object)nameByComment);
            return ArrayUtil.toStringArray(getters);
        }
        return new String[]{this.myInitialMethodName};
    }

    private String getNameByComment() {
        PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)this.myElements[0]);
        if (prevSibling instanceof PsiComment && ((PsiComment)prevSibling).getTokenType() == JavaTokenType.END_OF_LINE_COMMENT) {
            String text2 = StringUtil.decapitalize((String)StringUtil.capitalizeWords((String)prevSibling.getText().trim().substring(2), (boolean)true)).replaceAll(" ", "");
            if (PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(text2) && text2.length() < 20) {
                return text2;
            }
        }
        return null;
    }

    public boolean isOutputVariable(PsiVariable var) {
        return ArrayUtil.find((Object[])this.myOutputVariables, (Object)var) != -1;
    }

    public boolean showDialog() {
        return this.showDialog(true);
    }

    public void testRun() throws IncorrectOperationException {
        this.testPrepare();
        this.testNullness();
        ExtractMethodHandler.extractMethod(this.myProject, this);
    }

    public void testNullness() {
        this.myNullness = this.initNullness();
    }

    public void testPrepare() {
        this.myInputVariables.setFoldingAvailable(this.myInputVariables.isFoldingSelectedByDefault());
        this.myMethodName = this.myInitialMethodName;
        this.myVariableDatum = new VariableData[this.myInputVariables.getInputVariables().size()];
        for (int i = 0; i < this.myInputVariables.getInputVariables().size(); ++i) {
            this.myVariableDatum[i] = this.myInputVariables.getInputVariables().get(i);
        }
    }

    public void testTargetClass(PsiClass targetClass) {
        if (targetClass != null) {
            this.myTargetClass = targetClass;
            this.myNeedChangeContext = true;
        }
    }

    public void testPrepare(PsiType returnType, boolean makeStatic) throws PrepareFailedException {
        if (makeStatic) {
            if (!this.isCanBeStatic()) {
                throw new PrepareFailedException("Failed to make static", this.myElements[0]);
            }
            this.myInputVariables.setPassFields(true);
            this.myStatic = true;
        }
        if (PsiType.VOID.equals((Object)this.myReturnType)) {
            this.myArtificialOutputVariable = this.getArtificialOutputVariable();
        }
        this.testPrepare();
        if (returnType != null) {
            this.myReturnType = returnType;
        }
    }

    public void doNotPassParameter(int i) {
        this.myVariableDatum[i].passAsParameter = false;
    }

    public void changeParamName(int i, String param) {
        this.myVariableDatum[i].name = param;
    }

    public void doRefactoring() throws IncorrectOperationException {
        LogicalPosition pos1;
        this.initDuplicates();
        this.chooseAnchor();
        if (this.myEditor != null) {
            int col = this.myEditor.getCaretModel().getLogicalPosition().column;
            int line = this.myEditor.getCaretModel().getLogicalPosition().line;
            pos1 = new LogicalPosition(line, col);
            LogicalPosition pos = new LogicalPosition(0, 0);
            this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        } else {
            pos1 = null;
        }
        LocalSearchScope processConflictsScope = this.myMethodVisibility.equals("private") ? new LocalSearchScope((PsiElement)this.myTargetClass) : GlobalSearchScope.projectScope((Project)this.myProject);
        HashMap overloadsResolveMap = new HashMap();
        Runnable collectOverloads = () -> this.lambda$doRefactoring$5((SearchScope)processConflictsScope, overloadsResolveMap);
        Runnable extract = () -> {
            this.doExtract();
            ExtractMethodUtil.decodeOverloadTargets(overloadsResolveMap, this.myExtractedMethod, this.myCodeFragmentMember);
        };
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            collectOverloads.run();
            extract.run();
        } else {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(collectOverloads, "Collect overloads...", true, this.myProject)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(extract);
        }
        if (this.myEditor != null) {
            this.myEditor.getCaretModel().moveToLogicalPosition(pos1);
            int offset = this.myMethodCall.getMethodExpression().getTextRange().getStartOffset();
            this.myEditor.getCaretModel().moveToOffset(offset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getSelectionModel().removeSelection();
        }
    }

    public void previewRefactoring() {
        this.initDuplicates();
        this.chooseAnchor();
    }

    @Nullable
    private DuplicatesFinder initDuplicates() {
        PsiElement[] elements = (PsiElement[])((StreamEx)StreamEx.of((Object[])this.myElements).filter(element -> !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment))).toArray(PsiElement[]::new);
        if (this.myExpression != null) {
            DuplicatesFinder finder = new DuplicatesFinder(elements, this.myInputVariables.copy(), Collections.emptyList());
            this.myDuplicates = finder.findDuplicates((PsiElement)this.myTargetClass);
            this.myParametrizedDuplicates = ParametrizedDuplicates.findDuplicates(this);
            return finder;
        }
        if (elements.length != 0) {
            DuplicatesFinder finder = new DuplicatesFinder(elements, this.myInputVariables.copy(), this.myOutputVariable != null ? new VariableReturnValue(this.myOutputVariable) : null, Arrays.asList(this.myOutputVariables));
            this.myDuplicates = finder.findDuplicates((PsiElement)this.myTargetClass);
            this.myParametrizedDuplicates = ParametrizedDuplicates.findDuplicates(this);
            return finder;
        }
        this.myDuplicates = new ArrayList<Match>();
        return null;
    }

    private int estimateDuplicatesCount() {
        List<Object> parameters2;
        VariableReturnValue value2;
        PsiElement[] elements = (PsiElement[])((StreamEx)StreamEx.of((Object[])this.myElements).filter(element -> !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment))).toArray(PsiElement[]::new);
        if (this.myExpression != null) {
            value2 = null;
            parameters2 = Collections.emptyList();
        } else if (elements.length != 0) {
            value2 = this.myOutputVariable != null ? new VariableReturnValue(this.myOutputVariable) : null;
            parameters2 = Arrays.asList(this.myOutputVariables);
        } else {
            return 0;
        }
        DuplicatesFinder finder = new DuplicatesFinder(elements, this.myInputVariables.copy(), value2, parameters2);
        List<Match> myDuplicates = finder.findDuplicates((PsiElement)this.myTargetClass);
        if (!ContainerUtil.isEmpty(myDuplicates)) {
            return myDuplicates.size();
        }
        ParametrizedDuplicates parametrizedDuplicates = ParametrizedDuplicates.findDuplicates(this);
        if (parametrizedDuplicates != null) {
            List<Match> duplicates = parametrizedDuplicates.getDuplicates();
            return duplicates != null ? duplicates.size() : 0;
        }
        return 0;
    }

    public void doExtract() throws IncorrectOperationException {
        PsiMethod newMethod = this.generateEmptyMethod();
        this.myExpression = this.myInputVariables.replaceWrappedReferences(this.myElements, this.myExpression);
        this.renameInputVariables();
        LOG.assertTrue(this.myElements[0].isValid());
        PsiCodeBlock body2 = newMethod.getBody();
        this.myMethodCall = this.generateMethodCall(null, true);
        LOG.assertTrue(this.myElements[0].isValid());
        PsiStatement exitStatementCopy = this.prepareMethodBody(newMethod, true);
        if (this.myExpression == null) {
            PsiStatement statement;
            String varName;
            if (this.myNeedChangeContext && this.isNeedToChangeCallContext()) {
                for (PsiElement element : this.myElements) {
                    ChangeContextUtil.encodeContextInfo(element, false);
                }
            }
            if (this.myNullConditionalCheck) {
                varName = this.myOutputVariable.getName();
                if (this.isDeclaredInside(this.myOutputVariable)) {
                    this.declareVariableAtMethodCallLocation(varName);
                } else {
                    PsiExpressionStatement assignmentExpression = (PsiExpressionStatement)this.myElementFactory.createStatementFromText(varName + "=x;", null);
                    assignmentExpression = (PsiExpressionStatement)this.addToMethodCallLocation((PsiStatement)assignmentExpression);
                    this.myMethodCall = (PsiMethodCallExpression)((PsiAssignmentExpression)assignmentExpression.getExpression()).getRExpression().replace((PsiElement)this.myMethodCall);
                }
                this.declareNecessaryVariablesAfterCall(this.myOutputVariable);
                PsiIfStatement ifStatement = this.myHasReturnStatementOutput ? (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) return null;", null) : (this.myGenerateConditionalExit ? this.generateConditionalExitStatement(varName) : (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) return;", null));
                ifStatement = (PsiIfStatement)this.addToMethodCallLocation((PsiStatement)ifStatement);
                CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)ifStatement);
            } else if (this.myNotNullConditionalCheck) {
                varName = this.myOutputVariable != null ? this.myOutputVariable.getName() : "x";
                varName = this.declareVariableAtMethodCallLocation(varName, (PsiType)(this.myReturnType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)this.myReturnType).getBoxedType(this.myCodeFragmentMember) : this.myReturnType));
                this.addToMethodCallLocation(this.generateNotNullConditionalStatement(varName));
                this.declareVariableReusedAfterCall(this.myOutputVariable);
            } else if (this.myGenerateConditionalExit) {
                PsiIfStatement ifStatement = (PsiIfStatement)this.myElementFactory.createStatementFromText("if (a) b;", null);
                ifStatement = (PsiIfStatement)this.addToMethodCallLocation((PsiStatement)ifStatement);
                this.myMethodCall = (PsiMethodCallExpression)ifStatement.getCondition().replace((PsiElement)this.myMethodCall);
                this.myFirstExitStatementCopy = (PsiStatement)ifStatement.getThenBranch().replace((PsiElement)this.myFirstExitStatementCopy);
                CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)ifStatement);
            } else if (this.myOutputVariable != null || this.isArtificialOutputUsed()) {
                String name;
                boolean toDeclare = this.isArtificialOutputUsed() ? !(this.myArtificialOutputVariable instanceof PsiField) : this.isDeclaredInside(this.myOutputVariable);
                String string = name = this.isArtificialOutputUsed() ? this.myArtificialOutputVariable.getName() : this.myOutputVariable.getName();
                if (!toDeclare) {
                    PsiExpressionStatement statement2 = (PsiExpressionStatement)this.myElementFactory.createStatementFromText(name + "=x;", null);
                    statement2 = (PsiExpressionStatement)this.myStyleManager.reformat((PsiElement)statement2);
                    statement2 = (PsiExpressionStatement)this.addToMethodCallLocation((PsiStatement)statement2);
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement2.getExpression();
                    this.myMethodCall = (PsiMethodCallExpression)assignment.getRExpression().replace((PsiElement)this.myMethodCall);
                } else {
                    this.declareVariableAtMethodCallLocation(name);
                }
            } else if (this.myHasReturnStatementOutput) {
                statement = this.myElementFactory.createStatementFromText("return x;", null);
                statement = (PsiStatement)this.addToMethodCallLocation(statement);
                this.myMethodCall = (PsiMethodCallExpression)((PsiReturnStatement)statement).getReturnValue().replace((PsiElement)this.myMethodCall);
            } else {
                statement = this.myElementFactory.createStatementFromText("x();", null);
                statement = (PsiStatement)this.addToMethodCallLocation(statement);
                this.myMethodCall = (PsiMethodCallExpression)((PsiExpressionStatement)statement).getExpression().replace((PsiElement)this.myMethodCall);
            }
            if (this.myHasReturnStatement && !this.myHasReturnStatementOutput && !this.hasNormalExit()) {
                PsiStatement statement3 = this.myElementFactory.createStatementFromText("return;", null);
                this.addToMethodCallLocation(statement3);
            } else if (!this.myGenerateConditionalExit && exitStatementCopy != null) {
                this.addToMethodCallLocation(exitStatementCopy);
            }
            if (!this.myNullConditionalCheck && !this.myNotNullConditionalCheck) {
                this.declareNecessaryVariablesAfterCall(this.myOutputVariable);
            }
            this.deleteExtracted();
        } else {
            PsiExpression expression2Replace = this.expressionToReplace(this.myExpression);
            this.myExpression = (PsiExpression)IntroduceVariableBase.replace(expression2Replace, (PsiExpression)this.myMethodCall, this.myProject);
            this.myMethodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myExpression.findElementAt(this.myExpression.getText().indexOf(this.myMethodCall.getText())), PsiMethodCallExpression.class);
            this.declareNecessaryVariablesAfterCall(this.myOutputVariable);
        }
        if (this.myAnchor instanceof PsiField) {
            ((PsiField)this.myAnchor).normalizeDeclaration();
        }
        this.adjustFinalParameters(newMethod);
        int i = 0;
        for (VariableData data : this.myVariableDatum) {
            if (!data.passAsParameter) continue;
            PsiParameter psiParameter = newMethod.getParameterList().getParameters()[i++];
            PsiType paramType = psiParameter.getType();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiParameter, (SearchScope)new LocalSearchScope((PsiElement)body2))) {
                PsiTypeCastExpression typeCastExpression;
                PsiTypeElement castType;
                PsiElement parent;
                PsiElement element = reference.getElement();
                if (element == null || !((parent = element.getParent()) instanceof PsiTypeCastExpression) || (castType = (typeCastExpression = (PsiTypeCastExpression)parent).getCastType()) == null || !Comparing.equal((Object)castType.getType(), (Object)paramType)) continue;
                RedundantCastUtil.removeCast((PsiTypeCastExpression)typeCastExpression);
            }
        }
        if (this.myNullness != null && PsiUtil.resolveClassInType((PsiType)newMethod.getReturnType()) != null && PropertiesComponent.getInstance((Project)this.myProject).getBoolean("extractMethod.generateAnnotations", true)) {
            AddNullableNotNullAnnotationFix annotationFix;
            NullableNotNullManager notNullManager = NullableNotNullManager.getInstance((Project)this.myProject);
            switch (this.myNullness) {
                case NOT_NULL: {
                    annotationFix = new AddNullableNotNullAnnotationFix(notNullManager.getDefaultNotNull(), (PsiModifierListOwner)newMethod, new String[0]);
                    break;
                }
                case NULLABLE: {
                    annotationFix = new AddNullableNotNullAnnotationFix(notNullManager.getDefaultNullable(), (PsiModifierListOwner)newMethod, new String[0]);
                    break;
                }
                default: {
                    annotationFix = null;
                }
            }
            if (annotationFix != null) {
                annotationFix.invoke(this.myProject, this.myTargetClass.getContainingFile(), (PsiElement)newMethod, (PsiElement)newMethod);
            }
        }
        this.myExtractedMethod = this.addExtractedMethod(newMethod);
        if (this.isNeedToChangeCallContext() && this.myNeedChangeContext) {
            ChangeContextUtil.decodeContextInfo((PsiElement)this.myExtractedMethod, this.myTargetClass, (PsiExpression)RefactoringChangeUtil.createThisExpression(this.myManager, null));
            if (this.myMethodCall.resolveMethod() != this.myExtractedMethod) {
                PsiReferenceExpression methodExpression;
                RefactoringChangeUtil.qualifyReference(methodExpression, (PsiMember)this.myExtractedMethod, PsiUtil.getEnclosingStaticElement((PsiElement)(methodExpression = this.myMethodCall.getMethodExpression()), (PsiClass)this.myTargetClass) != null ? this.myTargetClass : null);
            }
        }
    }

    @NotNull
    private PsiIfStatement generateConditionalExitStatement(String varName) {
        if (this.myFirstExitStatementCopy instanceof PsiReturnStatement && ((PsiReturnStatement)this.myFirstExitStatementCopy).getReturnValue() != null) {
            PsiIfStatement psiIfStatement = (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) return null;", null);
            if (psiIfStatement == null) {
                ExtractMethodProcessor.$$$reportNull$$$0(0);
            }
            return psiIfStatement;
        }
        PsiIfStatement psiIfStatement = (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) " + this.myFirstExitStatementCopy.getText(), null);
        if (psiIfStatement == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(1);
        }
        return psiIfStatement;
    }

    @NotNull
    private PsiStatement generateNotNullConditionalStatement(String varName) {
        PsiStatement psiStatement = this.myElementFactory.createStatementFromText("if (" + varName + " != null) return " + varName + ";", null);
        if (psiStatement == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(2);
        }
        return psiStatement;
    }

    protected PsiExpression expressionToReplace(PsiExpression expression2) {
        if (expression2 instanceof PsiAssignmentExpression) {
            return ((PsiAssignmentExpression)expression2).getRExpression();
        }
        return expression2;
    }

    protected PsiMethod addExtractedMethod(PsiMethod newMethod) {
        return (PsiMethod)this.myTargetClass.addAfter((PsiElement)newMethod, this.myAnchor);
    }

    @Nullable
    private PsiStatement prepareMethodBody(PsiMethod newMethod, boolean doExtract) {
        String outVariableName;
        PsiCodeBlock body2 = newMethod.getBody();
        if (this.myExpression != null) {
            this.declareNecessaryVariablesInsideBody(body2);
            if (this.myHasExpressionOutput) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)this.myElementFactory.createStatementFromText("return x;", null);
                PsiExpression returnValue = RefactoringUtil.convertInitializerToNormalExpression(this.myExpression, this.myForcedReturnType);
                returnStatement.getReturnValue().replace((PsiElement)returnValue);
                body2.add((PsiElement)returnStatement);
            } else {
                PsiExpressionStatement statement = (PsiExpressionStatement)this.myElementFactory.createStatementFromText("x;", null);
                statement.getExpression().replace((PsiElement)this.myExpression);
                body2.add((PsiElement)statement);
            }
            return null;
        }
        boolean hasNormalExit = this.hasNormalExit();
        String string = outVariableName = this.myOutputVariable != null ? this.getNewVariableName(this.myOutputVariable) : null;
        PsiReturnStatement returnStatement = this.myNullConditionalCheck ? (PsiReturnStatement)this.myElementFactory.createStatementFromText("return null;", null) : (this.myOutputVariable != null ? (PsiReturnStatement)this.myElementFactory.createStatementFromText("return " + outVariableName + ";", null) : (this.myGenerateConditionalExit ? (PsiReturnStatement)this.myElementFactory.createStatementFromText("return true;", null) : (PsiReturnStatement)this.myElementFactory.createStatementFromText("return;", null)));
        PsiStatement exitStatementCopy = !doExtract || this.myNotNullConditionalCheck ? null : this.myControlFlowWrapper.getExitStatementCopy((PsiElement)returnStatement, this.myElements);
        this.declareNecessaryVariablesInsideBody(body2);
        body2.addRange(this.myElements[0], this.myElements[this.myElements.length - 1]);
        if (this.myNullConditionalCheck) {
            body2.add((PsiElement)this.myElementFactory.createStatementFromText("return " + this.myOutputVariable.getName() + ";", null));
        } else if (this.myNotNullConditionalCheck) {
            body2.add((PsiElement)this.myElementFactory.createStatementFromText("return null;", null));
        } else if (this.myGenerateConditionalExit) {
            body2.add((PsiElement)this.myElementFactory.createStatementFromText("return false;", null));
        } else if (!this.myHasReturnStatement && hasNormalExit && this.myOutputVariable != null) {
            Object[] declaredElements;
            PsiStatement statement;
            PsiElement resolved;
            PsiExpression returnValue;
            PsiReturnStatement insertedReturnStatement = (PsiReturnStatement)body2.add((PsiElement)returnStatement);
            if (this.myOutputVariables.length == 1 && (returnValue = insertedReturnStatement.getReturnValue()) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiLocalVariable && Comparing.strEqual((String)((PsiVariable)resolved).getName(), (String)outVariableName) && (statement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)insertedReturnStatement, PsiStatement.class)) instanceof PsiDeclarationStatement && ArrayUtil.find((Object[])(declaredElements = ((PsiDeclarationStatement)statement).getDeclaredElements()), (Object)resolved) != -1) {
                InlineUtil.inlineVariable((PsiVariable)resolved, ((PsiVariable)resolved).getInitializer(), (PsiJavaCodeReferenceElement)((PsiReferenceExpression)returnValue));
                resolved.delete();
            }
        } else if (this.isArtificialOutputUsed()) {
            body2.add((PsiElement)this.myElementFactory.createStatementFromText("return " + this.myArtificialOutputVariable.getName() + ";", null));
        }
        return exitStatementCopy;
    }

    private boolean isArtificialOutputUsed() {
        return this.myArtificialOutputVariable != null && !PsiType.VOID.equals((Object)this.myReturnType) && !this.myIsChainedConstructor;
    }

    private boolean hasNormalExit() {
        try {
            PsiCodeBlock block = JavaPsiFacade.getElementFactory((Project)this.myProject).createCodeBlock();
            block.addRange(this.myElements[0], this.myElements[this.myElements.length - 1]);
            ControlFlow flow = ControlFlowFactory.getInstance(this.myProject).getControlFlow((PsiElement)block, new LocalsControlFlowPolicy((PsiElement)block), false, false);
            return ControlFlowUtil.canCompleteNormally(flow, 0, flow.getSize());
        }
        catch (AnalysisCanceledException e) {
            PsiElement lastElement = this.myElements[this.myElements.length - 1];
            return !(lastElement instanceof PsiReturnStatement) && !(lastElement instanceof PsiBreakStatement) && !(lastElement instanceof PsiContinueStatement);
        }
    }

    protected boolean isNeedToChangeCallContext() {
        return true;
    }

    private void declareVariableAtMethodCallLocation(String name) {
        this.declareVariableAtMethodCallLocation(name, this.myReturnType);
    }

    private String declareVariableAtMethodCallLocation(String name, PsiType type2) {
        PsiElement lastStatement;
        if (this.myControlFlowWrapper.getOutputVariables(false).length == 0 && (lastStatement = PsiTreeUtil.getNextSiblingOfType((PsiElement)(this.myEnclosingBlockStatement != null ? this.myEnclosingBlockStatement : this.myElements[this.myElements.length - 1]), PsiStatement.class)) != null) {
            name = JavaCodeStyleManager.getInstance((Project)this.myProject).suggestUniqueVariableName(name, lastStatement, true);
        }
        PsiDeclarationStatement statement = this.myElementFactory.createVariableDeclarationStatement(name, type2, (PsiExpression)this.myMethodCall);
        statement = (PsiDeclarationStatement)JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(this.addToMethodCallLocation((PsiStatement)statement));
        PsiVariable var = (PsiVariable)statement.getDeclaredElements()[0];
        this.myMethodCall = (PsiMethodCallExpression)var.getInitializer();
        if (this.myOutputVariable != null) {
            var.getModifierList().replace((PsiElement)this.myOutputVariable.getModifierList());
        }
        return name;
    }

    private void adjustFinalParameters(final PsiMethod method) throws IncorrectOperationException {
        final IncorrectOperationException[] exc = new IncorrectOperationException[]{null};
        final PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length > 0) {
            if (((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS) {
                method.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        PsiParameter param;
                        int index;
                        PsiElement resolved = expression2.resolve();
                        if (resolved != null && (index = ArrayUtil.find((Object[])parameters2, (Object)resolved)) >= 0 && (param = parameters2[index]).hasModifierProperty("final") && PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                            try {
                                PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)false);
                            }
                            catch (IncorrectOperationException e) {
                                exc[0] = e;
                            }
                        }
                        super.visitReferenceExpression(expression2);
                    }
                });
            } else if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myTargetClass)) {
                method.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        PsiParameter param;
                        PsiElement resolved = expression2.resolve();
                        int index = ArrayUtil.find((Object[])parameters2, (Object)resolved);
                        if (index >= 0 && !(param = parameters2[index]).hasModifierProperty("final") && RefactoringUtil.isInsideAnonymousOrLocal((PsiElement)expression2, (PsiElement)method)) {
                            try {
                                PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)true);
                            }
                            catch (IncorrectOperationException e) {
                                exc[0] = e;
                            }
                        }
                        super.visitReferenceExpression(expression2);
                    }
                });
            }
            if (exc[0] != null) {
                throw exc[0];
            }
        }
    }

    @Override
    public List<Match> getDuplicates() {
        if (this.myIsChainedConstructor) {
            return ExtractMethodProcessor.filterChainedConstructorDuplicates(this.myDuplicates);
        }
        return this.myDuplicates;
    }

    ParametrizedDuplicates getParametrizedDuplicates() {
        return this.myParametrizedDuplicates;
    }

    private static List<Match> filterChainedConstructorDuplicates(List<Match> duplicates) {
        ArrayList<Match> result = new ArrayList<Match>();
        for (Match duplicate : duplicates) {
            PsiStatement[] psiStatements;
            PsiCodeBlock body2;
            PsiElement matchStart = duplicate.getMatchStart();
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)matchStart, PsiMethod.class);
            if (method == null || !method.isConstructor() || (body2 = method.getBody()) == null || (psiStatements = body2.getStatements()).length <= 0 || matchStart != psiStatements[0]) continue;
            result.add(duplicate);
        }
        return result;
    }

    @Override
    public void prepareSignature(Match match) {
        MatchUtil.changeSignature(match, this.myExtractedMethod);
    }

    @Override
    public PsiElement processMatch(Match match) throws IncorrectOperationException {
        if (PsiTreeUtil.isContextAncestor((PsiElement)this.myExtractedMethod.getContainingClass(), (PsiElement)match.getMatchStart(), (boolean)false) && RefactoringUtil.isInStaticContext(match.getMatchStart(), this.myExtractedMethod.getContainingClass())) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myExtractedMethod, (String)"static", (boolean)true);
        }
        PsiMethodCallExpression methodCallExpression = this.generateMethodCall(match.getInstanceExpression(), false);
        ArrayList<VariableData> datas = new ArrayList<VariableData>();
        for (VariableData variableData : this.myVariableDatum) {
            if (!variableData.passAsParameter) continue;
            datas.add(variableData);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        for (VariableData data : datas) {
            List<PsiElement> parameterValue = match.getParameterValues(data.variable);
            if (parameterValue != null) {
                for (PsiElement val : parameterValue) {
                    PsiType exprType;
                    if (val instanceof PsiExpression && (exprType = ((PsiExpression)val).getType()) != null && !TypeConversionUtil.isAssignable((PsiType)data.type, (PsiType)exprType)) {
                        PsiTypeCastExpression cast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(A)a", val);
                        cast.getCastType().replace((PsiElement)elementFactory.createTypeElement(data.type));
                        cast.getOperand().replace(val.copy());
                        val = cast;
                    }
                    methodCallExpression.getArgumentList().add(val);
                }
                continue;
            }
            methodCallExpression.getArgumentList().add((PsiElement)this.myElementFactory.createExpressionFromText(data.variable.getName(), (PsiElement)methodCallExpression));
        }
        PsiElement replacedMatch = match.replace(this.myExtractedMethod, methodCallExpression, this.myOutputVariable);
        this.addNotNullConditionalCheck(match, replacedMatch);
        return replacedMatch;
    }

    private void addNotNullConditionalCheck(Match match, PsiElement replacedMatch) {
        ReturnValue returnValue;
        if ((this.myNotNullConditionalCheck || this.myGenerateConditionalExit) && this.myOutputVariable != null && (returnValue = match.getOutputVariableValue(this.myOutputVariable)) instanceof VariableReturnValue) {
            String varName = ((VariableReturnValue)returnValue).getVariable().getName();
            LOG.assertTrue(varName != null, (Object)"returned variable name is null");
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)replacedMatch, PsiStatement.class, (boolean)false);
            if (statement != null) {
                PsiStatement conditionalExit = this.myNotNullConditionalCheck ? this.generateNotNullConditionalStatement(varName) : this.generateConditionalExitStatement(varName);
                statement.getParent().addAfter((PsiElement)conditionalExit, (PsiElement)statement);
            }
        }
    }

    @Nullable
    protected PsiMethodCallExpression getMatchMethodCallExpression(PsiElement element) {
        PsiExpression condition2;
        PsiMethodCallExpression methodCallExpression = null;
        if (element instanceof PsiMethodCallExpression) {
            methodCallExpression = (PsiMethodCallExpression)element;
        } else if (element instanceof PsiExpressionStatement) {
            PsiExpression psiExpression;
            PsiExpression expression2 = ((PsiExpressionStatement)element).getExpression();
            if (expression2 instanceof PsiMethodCallExpression) {
                methodCallExpression = (PsiMethodCallExpression)expression2;
            } else if (expression2 instanceof PsiAssignmentExpression && (psiExpression = ((PsiAssignmentExpression)expression2).getRExpression()) instanceof PsiMethodCallExpression) {
                methodCallExpression = (PsiMethodCallExpression)psiExpression;
            }
        } else if (element instanceof PsiDeclarationStatement) {
            PsiElement[] declaredElements;
            for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)element).getDeclaredElements()) {
                PsiExpression initializer;
                if (!(declaredElement instanceof PsiLocalVariable) || !((initializer = ((PsiLocalVariable)declaredElement).getInitializer()) instanceof PsiMethodCallExpression)) continue;
                methodCallExpression = (PsiMethodCallExpression)initializer;
                break;
            }
        } else if (element instanceof PsiIfStatement && (condition2 = ((PsiIfStatement)element).getCondition()) instanceof PsiMethodCallExpression) {
            methodCallExpression = (PsiMethodCallExpression)condition2;
        }
        return methodCallExpression;
    }

    protected void deleteExtracted() throws IncorrectOperationException {
        if (this.myEnclosingBlockStatement == null) {
            this.myElements[0].getParent().deleteChildRange(this.myElements[0], this.myElements[this.myElements.length - 1]);
        } else {
            this.myEnclosingBlockStatement.delete();
        }
    }

    protected PsiElement addToMethodCallLocation(PsiStatement newStatement) throws IncorrectOperationException {
        PsiBlockStatement location;
        PsiBlockStatement oldStatement;
        if (this.myAddedToMethodCallLocation != null) {
            PsiCodeBlock block = this.myAddedToMethodCallLocation.getCodeBlock();
            return block.addBefore((PsiElement)newStatement, (PsiElement)block.getRBrace());
        }
        if (this.myEnclosingBlockStatement != null) {
            location = oldStatement = this.myEnclosingBlockStatement;
        } else {
            Object element = this.myExpression != null ? this.myExpression : this.myElements[0];
            PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false);
            if (comment == null) {
                location = oldStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false);
            } else {
                location = comment;
                oldStatement = ((StreamEx)StreamEx.of((Object[])this.myElements).filter(e -> !(e instanceof PsiComment) && !(e instanceof PsiWhiteSpace))).map(e -> (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)e, PsiStatement.class, (boolean)false)).nonNull().findFirst().orElse(null);
            }
        }
        LOG.assertTrue(location != null, (Object)"Can't find statement/comment at the extracted location");
        PsiElement parent = location.getParent();
        if (ExtractMethodProcessor.isBranchOrBody(parent, (PsiElement)oldStatement)) {
            this.myAddedToMethodCallLocation = (PsiBlockStatement)this.myElementFactory.createStatementFromText("{}", (PsiElement)oldStatement);
            this.myAddedToMethodCallLocation = (PsiBlockStatement)parent.addBefore((PsiElement)this.myAddedToMethodCallLocation, (PsiElement)location);
            PsiCodeBlock block = this.myAddedToMethodCallLocation.getCodeBlock();
            return block.addBefore((PsiElement)newStatement, (PsiElement)block.getRBrace());
        }
        return parent.addBefore((PsiElement)newStatement, (PsiElement)location);
    }

    @Contract(value="_,null -> false; null,_ -> false")
    private static boolean isBranchOrBody(PsiElement parent, PsiElement element) {
        if (element == null) {
            return false;
        }
        if (parent instanceof PsiIfStatement) {
            return ((PsiIfStatement)parent).getThenBranch() == element || ((PsiIfStatement)parent).getElseBranch() == element;
        }
        if (parent instanceof PsiLoopStatement) {
            return ((PsiLoopStatement)parent).getBody() == element;
        }
        return false;
    }

    private void renameInputVariables() throws IncorrectOperationException {
        LocalSearchScope localSearchScope = null;
        for (int i = this.myVariableDatum.length - 1; i >= 0; --i) {
            VariableData data = this.myVariableDatum[i];
            PsiVariable variable = data.variable;
            if (data.name.equals(variable.getName()) && !(variable instanceof PsiField)) continue;
            if (localSearchScope == null) {
                localSearchScope = new LocalSearchScope(this.myElements);
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, localSearchScope)) {
                PsiReferenceExpression referenceExpression;
                PsiExpression qualifierExpression2;
                reference.handleElementRename(data.name);
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiReferenceExpression) || !((qualifierExpression2 = (referenceExpression = (PsiReferenceExpression)element).getQualifierExpression()) instanceof PsiThisExpression) && !(qualifierExpression2 instanceof PsiSuperExpression)) continue;
                referenceExpression.setQualifierExpression(null);
            }
        }
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    public PsiType getReturnType() {
        return this.myReturnType;
    }

    private PsiMethod generateEmptyMethod() throws IncorrectOperationException {
        return this.generateEmptyMethod(this.myMethodName, null);
    }

    public PsiMethod generateEmptyMethod(String methodName, PsiElement context) throws IncorrectOperationException {
        PsiMethod containingMethod;
        PsiCodeBlock body2;
        PsiMethod newMethod;
        if (this.myIsChainedConstructor) {
            newMethod = this.myElementFactory.createConstructor();
        } else {
            newMethod = context != null ? this.myElementFactory.createMethod(methodName, this.myReturnType, context) : this.myElementFactory.createMethod(methodName, this.myReturnType);
            PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"static", (boolean)this.isStatic());
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)this.myMethodVisibility, (boolean)true);
        if (this.getTypeParameterList() != null) {
            newMethod.getTypeParameterList().replace((PsiElement)this.getTypeParameterList());
        }
        LOG.assertTrue((body2 = newMethod.getBody()) != null);
        boolean isFinal = ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS;
        PsiParameterList list = newMethod.getParameterList();
        for (VariableData data : this.myVariableDatum) {
            if (data.passAsParameter) {
                PsiParameter parm = this.myElementFactory.createParameter(data.name, data.type);
                this.copyParamAnnotations(parm);
                if (isFinal) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)parm, (String)"final", (boolean)true);
                }
                list.add((PsiElement)parm);
                continue;
            }
            if (!this.defineVariablesForUnselectedParameters()) continue;
            StringBuilder buffer = new StringBuilder();
            if (isFinal) {
                buffer.append("final ");
            }
            buffer.append("int ");
            buffer.append(data.name);
            buffer.append("=;");
            String text2 = buffer.toString();
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)this.myElementFactory.createStatementFromText(text2, null);
            declaration2 = (PsiDeclarationStatement)this.myStyleManager.reformat((PsiElement)declaration2);
            PsiTypeElement typeElement = this.myElementFactory.createTypeElement(data.type);
            ((PsiVariable)declaration2.getDeclaredElements()[0]).getTypeElement().replace((PsiElement)typeElement);
            body2.add((PsiElement)declaration2);
        }
        PsiReferenceList throwsList = newMethod.getThrowsList();
        for (PsiClassType exception : this.getThrownExceptions()) {
            throwsList.add((PsiElement)JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createReferenceElementByType(exception));
        }
        if (this.myTargetClass.isInterface() && PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myTargetClass) && (containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myCodeFragmentMember, PsiMethod.class, (boolean)false)) != null && containingMethod.hasModifierProperty("default")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"default", (boolean)true);
        }
        return (PsiMethod)this.myStyleManager.reformat((PsiElement)newMethod);
    }

    protected boolean defineVariablesForUnselectedParameters() {
        return true;
    }

    private void copyParamAnnotations(PsiParameter parm) {
        PsiModifierList modifierList;
        PsiVariable variable = PsiResolveHelper.SERVICE.getInstance((Project)this.myProject).resolveReferencedVariable(parm.getName(), this.myElements[0]);
        if (variable instanceof PsiParameter && (modifierList = variable.getModifierList()) != null) {
            PsiModifierList parmModifierList = parm.getModifierList();
            LOG.assertTrue(parmModifierList != null);
            GenerateMembersUtil.copyAnnotations(modifierList, parmModifierList, SuppressWarnings.class.getName());
            this.updateNullabilityAnnotation(parm, variable);
        }
    }

    private void updateNullabilityAnnotation(@NotNull PsiParameter parm, @NotNull PsiVariable variable) {
        Boolean isNotNull;
        if (parm == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(3);
        }
        if (variable == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(4);
        }
        NullableNotNullManager nullabilityManager = NullableNotNullManager.getInstance((Project)this.myProject);
        List notNullAnnotations = nullabilityManager.getNotNulls();
        List nullableAnnotations = nullabilityManager.getNullables();
        if ((AnnotationUtil.isAnnotated((PsiModifierListOwner)variable, (Collection)nullableAnnotations, (int)8) || AnnotationUtil.isAnnotated((PsiModifierListOwner)variable, (Collection)notNullAnnotations, (int)8) || PropertiesComponent.getInstance((Project)this.myProject).getBoolean("extractMethod.generateAnnotations", false)) && (isNotNull = ExtractMethodProcessor.isNotNullAt(variable, this.myElements[0])) != null) {
            List toKeep = isNotNull != false ? notNullAnnotations : nullableAnnotations;
            String[] toRemove = (isNotNull == false ? notNullAnnotations : nullableAnnotations).toArray(ArrayUtil.EMPTY_STRING_ARRAY);
            AddAnnotationPsiFix.removePhysicalAnnotations((PsiModifierListOwner)parm, toRemove);
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parm, (Collection)toKeep, (int)8)) {
                String toAdd = isNotNull != false ? nullabilityManager.getDefaultNotNull() : nullabilityManager.getDefaultNullable();
                PsiAnnotation added = AddAnnotationPsiFix.addPhysicalAnnotation(toAdd, PsiNameValuePair.EMPTY_ARRAY, parm.getModifierList());
                JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)added);
            }
        }
    }

    @Nullable
    private static Boolean isNotNullAt(@NotNull PsiVariable variable, PsiElement startElement) {
        PsiParameterListOwner methodOrLambda;
        String variableName;
        if (variable == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(5);
        }
        if ((variableName = variable.getName()) == null) {
            return null;
        }
        PsiElement methodOrLambdaBody = null;
        if ((variable instanceof PsiLocalVariable || variable instanceof PsiParameter) && (methodOrLambda = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class})) != null) {
            methodOrLambdaBody = methodOrLambda.getBody();
        }
        if (methodOrLambdaBody instanceof PsiCodeBlock) {
            PsiElement topmostLambdaOrAnonymousClass = null;
            for (PsiElement element = startElement; element != null && element != methodOrLambdaBody; element = element.getParent()) {
                if (!(element instanceof PsiLambdaExpression) && !(element instanceof PsiAnonymousClass)) continue;
                topmostLambdaOrAnonymousClass = element;
            }
            if (topmostLambdaOrAnonymousClass != null) {
                startElement = topmostLambdaOrAnonymousClass;
            }
            Project project = methodOrLambdaBody.getProject();
            PsiFile file = methodOrLambdaBody.getContainingFile();
            PsiFile copy = PsiFileFactory.getInstance((Project)project).createFileFromText(file.getName(), file.getFileType(), (CharSequence)file.getText(), file.getModificationStamp(), false);
            PsiCodeBlock bodyCopy = ExtractMethodProcessor.findCopy(copy, methodOrLambdaBody, PsiCodeBlock.class);
            PsiVariable variableCopy = ExtractMethodProcessor.findCopy(copy, (PsiElement)variable, PsiVariable.class);
            if (startElement instanceof PsiExpression) {
                startElement = PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiStatement.class);
            }
            if (startElement instanceof PsiStatement) {
                PsiStatement startStatementCopy = ExtractMethodProcessor.findCopy(copy, startElement, PsiStatement.class);
                try {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                    startStatementCopy = ExtractMethodProcessor.wrapWithBlockStatementIfNeeded(startStatementCopy, factory);
                    String dummyName = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("_Dummy_", startElement.getParent(), true);
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)factory.createStatementFromText("java.lang.Object " + dummyName + " = " + variableName + ";", (PsiElement)startStatementCopy);
                    PsiElement parent = startStatementCopy.getParent();
                    declarationStatement = (PsiDeclarationStatement)parent.addBefore((PsiElement)declarationStatement, (PsiElement)startStatementCopy);
                    PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                    PsiExpression initializer = ((PsiVariable)declaredElements[0]).getInitializer();
                    Nullness nullness = DfaUtil.checkNullness(variableCopy, (PsiElement)initializer, (PsiElement)bodyCopy);
                    return nullness == Nullness.NOT_NULL;
                }
                catch (IncorrectOperationException ignore) {
                    return null;
                }
            }
        }
        return null;
    }

    private static <T extends PsiElement> T findCopy(@NotNull PsiFile copy, @NotNull PsiElement element, @NotNull Class<T> clazz) {
        if (copy == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(7);
        }
        if (clazz == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(8);
        }
        TextRange range = element.getTextRange();
        return CodeInsightUtil.findElementInRange(copy, range.getStartOffset(), range.getEndOffset(), clazz);
    }

    private static PsiStatement wrapWithBlockStatementIfNeeded(@NotNull PsiStatement statement, @NotNull PsiElementFactory factory) {
        PsiElement parent;
        if (statement == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(9);
        }
        if (factory == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(10);
        }
        if ((parent = statement.getParent()) instanceof PsiLoopStatement && ((PsiLoopStatement)parent).getBody() == statement || parent instanceof PsiIfStatement && (((PsiIfStatement)parent).getThenBranch() == statement || ((PsiIfStatement)parent).getElseBranch() == statement)) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)statement);
            blockStatement.getCodeBlock().add((PsiElement)statement);
            blockStatement = (PsiBlockStatement)statement.replace((PsiElement)blockStatement);
            return blockStatement.getCodeBlock().getStatements()[0];
        }
        if (parent instanceof PsiForStatement && (((PsiForStatement)parent).getInitialization() == statement || ((PsiForStatement)parent).getUpdate() == statement)) {
            return ExtractMethodProcessor.wrapWithBlockStatementIfNeeded((PsiStatement)((PsiForStatement)parent), factory);
        }
        return statement;
    }

    @NotNull
    protected PsiMethodCallExpression generateMethodCall(PsiExpression instanceQualifier, boolean generateArgs) throws IncorrectOperationException {
        boolean skipInstanceQualifier;
        StringBuilder buffer = new StringBuilder();
        if (this.myIsChainedConstructor) {
            skipInstanceQualifier = true;
            buffer.append("this");
        } else {
            boolean bl = skipInstanceQualifier = instanceQualifier == null || instanceQualifier instanceof PsiThisExpression;
            if (skipInstanceQualifier) {
                if (this.isNeedToChangeCallContext() && this.myNeedChangeContext) {
                    boolean needsThisQualifier = false;
                    PsiElement parent = this.myCodeFragmentMember;
                    while (!this.myTargetClass.equals(parent)) {
                        String methodName;
                        if (parent instanceof PsiMethod && (methodName = ((PsiMethod)parent).getName()).equals(this.myMethodName)) {
                            needsThisQualifier = true;
                            break;
                        }
                        parent = parent.getParent();
                    }
                    if (needsThisQualifier) {
                        buffer.append(this.myTargetClass.getName());
                        buffer.append(".this.");
                    }
                }
            } else {
                buffer.append("qqq.");
            }
            buffer.append(this.myMethodName);
        }
        buffer.append("(");
        if (generateArgs) {
            int count = 0;
            for (PsiElement data : this.myVariableDatum) {
                if (!data.passAsParameter) continue;
                if (count > 0) {
                    buffer.append(",");
                }
                this.myInputVariables.appendCallArguments((VariableData)data, buffer);
                ++count;
            }
        }
        buffer.append(")");
        String text2 = buffer.toString();
        PsiMethodCallExpression expr = (PsiMethodCallExpression)this.myElementFactory.createExpressionFromText(text2, null);
        expr = (PsiMethodCallExpression)this.myStyleManager.reformat((PsiElement)expr);
        if (!skipInstanceQualifier) {
            PsiExpression qualifierExpression2 = expr.getMethodExpression().getQualifierExpression();
            LOG.assertTrue(qualifierExpression2 != null);
            qualifierExpression2.replace((PsiElement)instanceQualifier);
        }
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)expr);
        if (psiMethodCallExpression == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(11);
        }
        return psiMethodCallExpression;
    }

    private boolean chooseTargetClass(PsiElement codeFragment, final Pass<ExtractMethodProcessor> extractPass) throws PrepareFailedException {
        final List<PsiVariable> inputVariables = this.myControlFlowWrapper.getInputVariables(codeFragment, this.myElements, this.myOutputVariables);
        this.myNeedChangeContext = false;
        PsiClass psiClass = this.myTargetClass = this.myCodeFragmentMember instanceof PsiMember ? ((PsiMember)this.myCodeFragmentMember).getContainingClass() : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myCodeFragmentMember, PsiClass.class);
        if (this.myTargetClass == null) {
            LOG.error((Object)this.myElements[0].getContainingFile());
        }
        if (!ExtractMethodProcessor.shouldAcceptCurrentTarget(extractPass, (PsiElement)this.myTargetClass)) {
            final LinkedHashMap<PsiClass, ArrayList<PsiVariable>> classes2 = new LinkedHashMap<PsiClass, ArrayList<PsiVariable>>();
            PsiElementProcessor<PsiClass> processor = new PsiElementProcessor<PsiClass>(){

                public boolean execute(@NotNull PsiClass selectedClass) {
                    if (selectedClass == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    AnonymousTargetClassPreselectionUtil.rememberSelection(selectedClass, ExtractMethodProcessor.this.myTargetClass);
                    List array = (List)classes2.get(selectedClass);
                    ExtractMethodProcessor.this.myNeedChangeContext = ExtractMethodProcessor.this.myTargetClass != selectedClass;
                    ExtractMethodProcessor.this.myTargetClass = selectedClass;
                    if (array != null) {
                        for (PsiVariable variable : array) {
                            if (inputVariables.contains(variable)) continue;
                            inputVariables.addAll(array);
                        }
                    }
                    try {
                        return ExtractMethodProcessor.this.applyChosenClassAndExtract(inputVariables, (Pass<ExtractMethodProcessor>)extractPass);
                    }
                    catch (PrepareFailedException e) {
                        if (ExtractMethodProcessor.this.myShowErrorDialogs) {
                            CommonRefactoringUtil.showErrorHint((Project)ExtractMethodProcessor.this.myProject, (Editor)ExtractMethodProcessor.this.myEditor, (String)e.getMessage(), (String)ExtractMethodHandler.REFACTORING_NAME, (String)"refactoring.extractMethod");
                            ExtractMethodHandler.highlightPrepareError(e, e.getFile(), ExtractMethodProcessor.this.myEditor, ExtractMethodProcessor.this.myProject);
                        }
                        return false;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedClass", "com/intellij/refactoring/extractMethod/ExtractMethodProcessor$7", "execute"));
                }
            };
            classes2.put(this.myTargetClass, null);
            PsiElement target = this.myTargetClass.getParent();
            PsiClass targetMember = this.myTargetClass;
            while (!(target instanceof PsiFile)) {
                if (target instanceof PsiClass) {
                    boolean success = true;
                    ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
                    for (PsiElement el : this.myElements) {
                        if (ControlFlowUtil.collectOuterLocals(array, el, this.myCodeFragmentMember, (PsiElement)targetMember)) continue;
                        success = false;
                        break;
                    }
                    if (success) {
                        classes2.put((PsiClass)target, array);
                        if (ExtractMethodProcessor.shouldAcceptCurrentTarget(extractPass, target)) {
                            return processor.execute((PsiElement)((PsiClass)target));
                        }
                    }
                }
                targetMember = target;
                target = target.getParent();
            }
            if (classes2.size() > 1) {
                PsiClass[] psiClasses = classes2.keySet().toArray(new PsiClass[classes2.size()]);
                PsiClass preselection = AnonymousTargetClassPreselectionUtil.getPreselection(classes2.keySet(), psiClasses[0]);
                NavigationUtil.getPsiElementPopup((PsiElement[])psiClasses, (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)"Choose Destination Class", (PsiElementProcessor)processor, (PsiElement)preselection).showInBestPositionFor(this.myEditor);
                return true;
            }
        }
        return this.applyChosenClassAndExtract(inputVariables, extractPass);
    }

    @NotNull
    protected Set<PsiVariable> getEffectivelyLocalVariables() {
        LinkedHashSet<PsiVariable> effectivelyLocal = new LinkedHashSet<PsiVariable>();
        List<PsiVariable> usedVariables = this.myControlFlowWrapper.getUsedVariablesInBody(ControlFlowUtil.findCodeFragment(this.myElements[0]), this.myOutputVariables);
        for (PsiVariable variable : usedVariables) {
            boolean toDeclare = !this.isDeclaredInside(variable) && this.myInputVariables.toDeclareInsideBody(variable);
            if (!toDeclare) continue;
            effectivelyLocal.add(variable);
        }
        if (this.myArtificialOutputVariable instanceof PsiField && !this.myIsChainedConstructor) {
            effectivelyLocal.add(this.myArtificialOutputVariable);
        }
        LinkedHashSet<PsiVariable> linkedHashSet = effectivelyLocal;
        if (linkedHashSet == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    private void declareNecessaryVariablesInsideBody(PsiCodeBlock body2) throws IncorrectOperationException {
        Set<PsiVariable> effectivelyLocal = this.getEffectivelyLocalVariables();
        for (PsiVariable variable : effectivelyLocal) {
            String name = variable.getName();
            LOG.assertTrue(name != null, (Object)"variable name is null");
            PsiDeclarationStatement statement = this.myElementFactory.createVariableDeclarationStatement(name, variable.getType(), null);
            body2.add((PsiElement)statement);
        }
    }

    protected void declareNecessaryVariablesAfterCall(PsiVariable outputVariable) throws IncorrectOperationException {
        if (this.myHasExpressionOutput) {
            return;
        }
        List<PsiVariable> usedVariables = this.myControlFlowWrapper.getUsedVariables();
        Collection<ControlFlowUtil.VariableInfo> reassigned = this.myControlFlowWrapper.getInitializedTwice();
        for (PsiVariable variable : usedVariables) {
            boolean toDeclare = this.isDeclaredInside(variable) && !variable.equals(outputVariable);
            if (!toDeclare) continue;
            String name = variable.getName();
            PsiDeclarationStatement statement = this.myElementFactory.createVariableDeclarationStatement(name, variable.getType(), null);
            if (reassigned.contains(new ControlFlowUtil.VariableInfo(variable, null))) {
                PsiElement[] psiElements = statement.getDeclaredElements();
                assert (psiElements.length > 0);
                PsiVariable var = (PsiVariable)psiElements[0];
                PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)false);
            }
            this.addToMethodCallLocation((PsiStatement)statement);
        }
    }

    public PsiMethodCallExpression getMethodCall() {
        return this.myMethodCall;
    }

    public void setMethodCall(PsiMethodCallExpression methodCall) {
        this.myMethodCall = methodCall;
    }

    public boolean isDeclaredInside(PsiVariable variable) {
        int endOffset;
        int startOffset;
        if (variable instanceof ImplicitVariable) {
            return false;
        }
        if (this.myExpression != null) {
            TextRange range = this.myExpression.getTextRange();
            startOffset = range.getStartOffset();
            endOffset = range.getEndOffset();
        } else {
            startOffset = this.myElements[0].getTextRange().getStartOffset();
            endOffset = this.myElements[this.myElements.length - 1].getTextRange().getEndOffset();
        }
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        if (nameIdentifier == null) {
            return false;
        }
        TextRange range = nameIdentifier.getTextRange();
        if (range == null) {
            return false;
        }
        int offset = range.getStartOffset();
        return startOffset <= offset && offset <= endOffset;
    }

    private String getNewVariableName(PsiVariable variable) {
        for (VariableData data : this.myVariableDatum) {
            if (!data.variable.equals(variable)) continue;
            return data.name;
        }
        return variable.getName();
    }

    private static boolean shouldAcceptCurrentTarget(Pass<ExtractMethodProcessor> extractPass, PsiElement target) {
        return extractPass == null && !(target instanceof PsiAnonymousClass);
    }

    private boolean applyChosenClassAndExtract(List<PsiVariable> inputVariables, @Nullable Pass<ExtractMethodProcessor> extractPass) throws PrepareFailedException {
        this.myStatic = this.shouldBeStatic();
        LinkedHashSet<PsiField> fields = new LinkedHashSet<PsiField>();
        this.myCanBeStatic = ExtractMethodProcessor.canBeStatic(this.myTargetClass, this.myCodeFragmentMember, this.myElements, fields);
        this.myInputVariables = new InputVariables(inputVariables, this.myProject, new LocalSearchScope(this.myElements), this.isFoldingApplicable());
        this.myInputVariables.setUsedInstanceFields(fields);
        if (!this.checkExitPoints()) {
            return false;
        }
        this.checkCanBeChainedConstructor();
        if (extractPass != null) {
            extractPass.pass((Object)this);
        }
        return true;
    }

    public static boolean canBeStatic(PsiClass targetClass, PsiElement place, PsiElement[] elements, final Set<PsiField> usedFields) {
        if (!PsiUtil.isLocalOrAnonymousClass((PsiClass)targetClass) && (targetClass.getContainingClass() == null || targetClass.hasModifierProperty("static"))) {
            boolean canBeStatic = true;
            if (targetClass.isInterface()) {
                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)place, PsiMethod.class, (boolean)false);
                boolean bl = canBeStatic = containingMethod == null || containingMethod.hasModifierProperty("static");
            }
            if (canBeStatic) {
                ElementNeedsThis needsThis = new ElementNeedsThis(targetClass){

                    @Override
                    protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
                        PsiExpression expression2;
                        if (!(!(classMember instanceof PsiField) || classMember.hasModifierProperty("static") || (expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)classMemberReference, PsiExpression.class, (boolean)false)) != null && PsiUtil.isAccessedForWriting((PsiExpression)expression2))) {
                            usedFields.add((PsiField)classMember);
                            return;
                        }
                        super.visitClassMemberReferenceElement(classMember, classMemberReference);
                    }
                };
                for (int i = 0; i < elements.length && !needsThis.usesMembers(); ++i) {
                    PsiElement element = elements[i];
                    element.accept((PsiElementVisitor)needsThis);
                }
                return !needsThis.usesMembers();
            }
        }
        return false;
    }

    protected boolean isFoldingApplicable() {
        return true;
    }

    protected void chooseAnchor() {
        this.myAnchor = this.myCodeFragmentMember;
        while (!this.myAnchor.getParent().equals(this.myTargetClass)) {
            this.myAnchor = this.myAnchor.getParent();
        }
    }

    private void declareVariableReusedAfterCall(PsiVariable variable) {
        if (variable != null && variable.getName() != null && this.isDeclaredInside(variable) && this.myControlFlowWrapper.getUsedVariables().contains(variable) && !this.myControlFlowWrapper.needVariableValueAfterEnd(variable)) {
            PsiDeclarationStatement declaration2 = this.myElementFactory.createVariableDeclarationStatement(variable.getName(), variable.getType(), null);
            this.addToMethodCallLocation((PsiStatement)declaration2);
        }
    }

    private void showMultipleExitPointsMessage() {
        if (this.myShowErrorDialogs) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            PsiStatement[] exitStatementsArray = this.myExitStatements.toArray(PsiStatement.EMPTY_ARRAY);
            EditorColorsManager manager = EditorColorsManager.getInstance();
            TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            highlightManager.addOccurrenceHighlights(this.myEditor, (PsiElement[])exitStatementsArray, attributes, true, null);
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"there.are.multiple.exit.points.in.the.selected.code.fragment"));
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.myEditor, (String)message2, (String)this.myRefactoringName, (String)this.myHelpId);
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
        }
    }

    protected void showMultipleOutputMessage(PsiType expressionType) throws PrepareFailedException {
        if (this.myShowErrorDialogs) {
            String message2 = this.buildMultipleOutputMessageError(expressionType) + "\nWould you like to Extract Method Object?";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(message2);
            }
            RefactoringMessageDialog dialog = new RefactoringMessageDialog(this.myRefactoringName, message2, this.myHelpId, "OptionPane.errorIcon", true, this.myProject);
            if (dialog.showAndGet()) {
                new ExtractMethodObjectHandler().invoke(this.myProject, this.myEditor, this.myTargetClass.getContainingFile(), DataManager.getInstance().getDataContext());
            }
        }
    }

    protected String buildMultipleOutputMessageError(PsiType expressionType) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"there.are.multiple.output.values.for.the.selected.code.fragment")));
        buffer.append("\n");
        if (this.myHasExpressionOutput) {
            buffer.append("    ").append(RefactoringBundle.message((String)"expression.result")).append(": ");
            buffer.append(PsiFormatUtil.formatType((PsiType)expressionType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            buffer.append(",\n");
        }
        if (this.myGenerateConditionalExit) {
            buffer.append("    ").append(RefactoringBundle.message((String)"boolean.method.result"));
            buffer.append(",\n");
        }
        for (int i = 0; i < this.myOutputVariables.length; ++i) {
            PsiVariable var = this.myOutputVariables[i];
            buffer.append("    ");
            buffer.append(var.getName());
            buffer.append(" : ");
            buffer.append(PsiFormatUtil.formatType((PsiType)var.getType(), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            if (i < this.myOutputVariables.length - 1) {
                buffer.append(",\n");
                continue;
            }
            buffer.append(".");
        }
        return buffer.toString();
    }

    public PsiMethod getExtractedMethod() {
        return this.myExtractedMethod;
    }

    public void setMethodName(String methodName) {
        this.myMethodName = methodName;
    }

    @Override
    public Boolean hasDuplicates() {
        List<Match> duplicates = this.getDuplicates();
        if (duplicates != null && !duplicates.isEmpty()) {
            return true;
        }
        if (this.initParametrizedDuplicates(true)) {
            return null;
        }
        return false;
    }

    boolean initParametrizedDuplicates(boolean showDialog) {
        if (this.myExtractedMethod != null && this.myParametrizedDuplicates != null && (!showDialog || ApplicationManager.getApplication().isUnitTestMode() || new SignatureSuggesterPreviewDialog(this.myExtractedMethod, this.myParametrizedDuplicates.getParametrizedMethod(), this.myMethodCall, this.myParametrizedDuplicates.getParametrizedCall(), this.myParametrizedDuplicates.getSize()).showAndGet())) {
            this.myDuplicates = this.myParametrizedDuplicates.getDuplicates();
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
                this.myExtractedMethod = this.myParametrizedDuplicates.replaceMethod(this.myExtractedMethod);
                this.myMethodCall = this.myParametrizedDuplicates.replaceCall(this.myMethodCall);
            });
            this.myVariableDatum = this.myParametrizedDuplicates.getVariableDatum();
            return true;
        }
        return false;
    }

    public boolean hasDuplicates(Set<VirtualFile> files) {
        DuplicatesFinder finder = this.initDuplicates();
        Boolean hasDuplicates = this.hasDuplicates();
        if (hasDuplicates == null || hasDuplicates.booleanValue()) {
            return true;
        }
        if (finder != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            for (VirtualFile file : files) {
                if (finder.findDuplicates((PsiElement)psiManager.findFile(file)).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public String getConfirmDuplicatePrompt(Match match) {
        boolean needToBeStatic = RefactoringUtil.isInStaticContext(match.getMatchStart(), this.myExtractedMethod.getContainingClass());
        String changedSignature = MatchUtil.getChangedSignature(match, this.myExtractedMethod, needToBeStatic, VisibilityUtil.getVisibilityStringToDisplay((PsiMember)this.myExtractedMethod));
        if (changedSignature != null) {
            return RefactoringBundle.message((String)"replace.this.code.fragment.and.change.signature", (Object[])new Object[]{changedSignature});
        }
        if (needToBeStatic && !this.myExtractedMethod.hasModifierProperty("static")) {
            return RefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.static");
        }
        return null;
    }

    @NotNull
    public UniqueNameGenerator getParameterNameGenerator(PsiElement scopeElement) {
        UniqueNameGenerator uniqueNameGenerator = new UniqueNameGenerator();
        for (VariableData data : this.myInputVariables.getInputVariables()) {
            String name;
            if (data.variable == null || (name = data.variable.getName()) == null) continue;
            uniqueNameGenerator.addExistingName(name);
        }
        for (PsiVariable variable : this.myOutputVariables) {
            String name = variable.getName();
            if (name == null) continue;
            uniqueNameGenerator.addExistingName(name);
        }
        PsiElement superParent = PsiTreeUtil.getParentOfType((PsiElement)scopeElement, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
        if (superParent != null) {
            ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)superParent)).filter(element -> element instanceof PsiVariable)).forEach(element -> {
                String name = ((PsiVariable)element).getName();
                if (name != null) {
                    uniqueNameGenerator.addExistingName(name);
                }
            });
        }
        UniqueNameGenerator uniqueNameGenerator2 = uniqueNameGenerator;
        if (uniqueNameGenerator2 == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(13);
        }
        return uniqueNameGenerator2;
    }

    @Override
    public String getReplaceDuplicatesTitle(int idx, int size) {
        return RefactoringBundle.message((String)"process.duplicates.title", (Object[])new Object[]{idx, size});
    }

    public InputVariables getInputVariables() {
        return this.myInputVariables;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.myTypeParameterList;
    }

    public PsiClassType[] getThrownExceptions() {
        return this.myThrownExceptions;
    }

    public boolean isStatic() {
        return this.myStatic;
    }

    public boolean isCanBeStatic() {
        return this.myCanBeStatic;
    }

    public PsiElement[] getElements() {
        return this.myElements;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(14);
        }
        return project;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public PsiVariable[] getOutputVariables() {
        return this.myOutputVariables;
    }

    public void setMethodVisibility(String methodVisibility) {
        this.myMethodVisibility = methodVisibility;
    }

    private /* synthetic */ void lambda$doRefactoring$5(SearchScope processConflictsScope, Map overloadsResolveMap) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Map<PsiMethodCallExpression, PsiMethod> overloads = ExtractMethodUtil.encodeOverloadTargets(this.myTargetClass, processConflictsScope, this.myMethodName, this.myCodeFragmentMember);
            overloadsResolveMap.putAll(overloads);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ExtractMethodProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parm";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConditionalExitStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNotNullConditionalStatement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodCall";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectivelyLocalVariables";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNameGenerator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateNullabilityAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullAt";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCopy";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithBlockStatementIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

