/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.javadoc;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.util.IncorrectOperationException;

public class MethodJavaDocHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.javadoc.MethodJavaDocHelper");
    private final PsiMethod myMethod;
    private final boolean myDoCorrectJavaDoc;
    private final PsiDocComment myDocComment;

    public MethodJavaDocHelper(PsiMethod method) {
        PsiDocTag[] paramTags;
        this.myMethod = method;
        this.myDocComment = this.myMethod.getDocComment();
        if (this.myDocComment == null) {
            this.myDoCorrectJavaDoc = false;
            return;
        }
        PsiParameter[] parameters2 = this.myMethod.getParameterList().getParameters();
        this.myDoCorrectJavaDoc = parameters2.length != 0 ? (paramTags = this.myDocComment.findTagsByName("param")).length > 0 : true;
    }

    public PsiDocTag getTagForParameter(PsiParameter parameter2) {
        PsiDocTag[] paramTags;
        if (!this.myDoCorrectJavaDoc) {
            return null;
        }
        if (parameter2 == null) {
            return null;
        }
        String name = parameter2.getName();
        for (PsiDocTag paramTag : paramTags = this.myDocComment.findTagsByName("param")) {
            PsiElement[] dataElements = paramTag.getDataElements();
            if (dataElements.length <= 0 || !dataElements[0].getText().equals(name)) continue;
            return paramTag;
        }
        return null;
    }

    public PsiDocTag addParameterAfter(String name, PsiDocTag anchor) throws IncorrectOperationException {
        if (!this.myDoCorrectJavaDoc) {
            return null;
        }
        if (anchor == null) {
            return this.prependParameter(name);
        }
        LOG.assertTrue(anchor.getParent() == this.myDocComment);
        PsiDocTag paramTag = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory().createParamTag(name, "");
        return (PsiDocTag)this.myDocComment.addAfter((PsiElement)paramTag, (PsiElement)anchor);
    }

    public PsiDocTag prependParameter(String name) throws IncorrectOperationException {
        if (!this.myDoCorrectJavaDoc) {
            return null;
        }
        PsiDocTag[] paramTags = this.myDocComment.findTagsByName("param");
        PsiDocTag newTag = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory().createParamTag(name, "");
        if (paramTags.length > 0) {
            return (PsiDocTag)this.myDocComment.addBefore((PsiElement)newTag, (PsiElement)paramTags[0]);
        }
        return (PsiDocTag)this.myDocComment.add((PsiElement)newTag);
    }

    public PsiDocTag appendParameter(String name) throws IncorrectOperationException {
        if (!this.myDoCorrectJavaDoc) {
            return null;
        }
        PsiDocTag[] paramTags = this.myDocComment.findTagsByName("param");
        PsiDocTag newTag = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory().createParamTag(name, "");
        if (paramTags.length > 0) {
            return (PsiDocTag)this.myDocComment.addAfter((PsiElement)newTag, (PsiElement)paramTags[paramTags.length - 1]);
        }
        return (PsiDocTag)this.myDocComment.add((PsiElement)newTag);
    }
}

