/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.AbstractTableCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class PsiClassTableCellEditor
extends AbstractTableCellEditor {
    private final Project myProject;
    private final GlobalSearchScope mySearchScope;
    private EditorTextField myEditor;

    public PsiClassTableCellEditor(Project project, GlobalSearchScope searchScope) {
        this.myProject = project;
        this.mySearchScope = searchScope;
    }

    public final Object getCellEditorValue() {
        return this.myEditor.getText();
    }

    public final boolean stopCellEditing() {
        boolean b = super.stopCellEditing();
        this.myEditor = null;
        return b;
    }

    public boolean isCellEditable(EventObject e) {
        return !(e instanceof MouseEvent) || ((MouseEvent)e).getClickCount() >= 2;
    }

    public final Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        Document document = JavaReferenceEditorUtil.createDocument(value2 == null ? "" : (String)value2, this.myProject, true);
        this.myEditor = new EditorTextField(document, this.myProject, (FileType)StdFileTypes.JAVA){

            protected boolean shouldHaveBorder() {
                return false;
            }

            public void addNotify() {
                super.addNotify();
                JComponent editorComponent = this.getEditor().getContentComponent();
                editorComponent.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ENTER");
                editorComponent.getActionMap().put("ENTER", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PsiClassTableCellEditor.this.stopCellEditing();
                    }
                });
            }
        };
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.myEditor);
        FixedSizeButton button = new FixedSizeButton((JComponent)this.myEditor);
        panel.add((Component)button, "East");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)PsiClassTableCellEditor.this.myProject).createInheritanceClassChooser(UIBundle.message((String)"choose.class", (Object[])new Object[0]), PsiClassTableCellEditor.this.mySearchScope, null, true, true, Conditions.alwaysTrue());
                chooser.showDialog();
                PsiClass psiClass = chooser.getSelected();
                if (psiClass != null) {
                    PsiClassTableCellEditor.this.myEditor.setText(psiClass.getQualifiedName());
                }
            }
        });
        panel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary() && PsiClassTableCellEditor.this.myEditor != null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)PsiClassTableCellEditor.this.myEditor, true));
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.myEditor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    PsiClassTableCellEditor.this.stopCellEditing();
                }
            }
        });
        return panel;
    }
}

