/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.dataflow.ScopeUtils;
import com.siyeh.ig.dataflow.TooBroadScopeInspectionBase;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooBroadScopeInspection
extends TooBroadScopeInspectionBase {
    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiVariable variable = (PsiVariable)infos[0];
        return new TooBroadScopeInspectionFix(variable.getName());
    }

    private class TooBroadScopeInspectionFix
    extends InspectionGadgetsFix {
        private final String variableName;

        TooBroadScopeInspectionFix(String variableName) {
            this.variableName = variableName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("too.broad.scope.narrow.quickfix", this.variableName);
            if (string == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Narrow scope" == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(1);
            }
            return "Narrow scope";
        }

        @Override
        protected void doFix(@NotNull Project project, ProblemDescriptor descriptor) {
            PsiDeclarationStatement newDeclaration;
            PsiElement referenceElement;
            PsiElement firstReferenceScope;
            PsiElement variableIdentifier;
            if (project == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(2);
            }
            if (!((variableIdentifier = descriptor.getPsiElement()) instanceof PsiIdentifier)) {
                return;
            }
            PsiVariable variable = (PsiVariable)variableIdentifier.getParent();
            assert (variable != null);
            PsiElement variableScope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class, PsiTryStatement.class});
            List<PsiReferenceExpression> references = VariableAccessUtils.findReferences(variable, variableScope);
            PsiElement commonParent = ScopeUtils.getCommonParent(references);
            assert (commonParent != null);
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                assert (variableScope != null);
                if ((commonParent = ScopeUtils.moveOutOfLoopsAndClasses(commonParent, variableScope)) == null) {
                    return;
                }
            }
            if ((firstReferenceScope = PsiTreeUtil.getParentOfType((PsiElement)(referenceElement = (PsiElement)references.get(0)), (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class, PsiTryStatement.class})) == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            if (commonParent instanceof PsiTryStatement) {
                PsiElement resourceReference = referenceElement.getParent();
                PsiResourceVariable resourceVariable = this.createResourceVariable(project, (PsiLocalVariable)variable, initializer != null ? tracker.markUnchanged(initializer) : null);
                newDeclaration = resourceReference.getParent().addBefore((PsiElement)resourceVariable, resourceReference);
                resourceReference.delete();
            } else if (commonParent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)commonParent;
                PsiStatement initialization = forStatement.getInitialization();
                if (initialization == null) {
                    return;
                }
                if (initialization instanceof PsiExpressionStatement) {
                    PsiExpressionStatement expressionStatement = (PsiExpressionStatement)initialization;
                    PsiExpression expression2 = expressionStatement.getExpression();
                    if (!(expression2 instanceof PsiAssignmentExpression)) {
                        return;
                    }
                    PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                    PsiExpression rhs = assignmentExpression.getRExpression();
                    newDeclaration = this.createNewDeclaration(variable, rhs, tracker);
                } else {
                    newDeclaration = this.createNewDeclaration(variable, initializer, tracker);
                }
                newDeclaration = initialization.replace((PsiElement)newDeclaration);
            } else if (firstReferenceScope.equals(commonParent)) {
                newDeclaration = this.moveDeclarationToLocation(variable, referenceElement, tracker);
            } else {
                PsiElement commonParentChild = ScopeUtils.getChildWhichContainsElement(commonParent, referenceElement);
                if (commonParentChild == null) {
                    return;
                }
                PsiElement location = commonParentChild.getPrevSibling();
                newDeclaration = this.createNewDeclaration(variable, initializer, tracker);
                newDeclaration = commonParent.addAfter((PsiElement)newDeclaration, location);
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            newDeclaration = codeStyleManager.reformat((PsiElement)newDeclaration);
            this.removeOldVariable(variable, tracker);
            tracker.insertCommentsBefore((PsiElement)newDeclaration);
            if (this.isOnTheFly()) {
                HighlightUtils.highlightElement((PsiElement)newDeclaration);
            }
        }

        private PsiResourceVariable createResourceVariable(@NotNull Project project, PsiLocalVariable variable, PsiExpression initializer) {
            if (project == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(3);
            }
            PsiTryStatement tryStatement = (PsiTryStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("try (X x = null){}", (PsiElement)variable);
            PsiResourceList resourceList = tryStatement.getResourceList();
            assert (resourceList != null);
            PsiResourceVariable resourceVariable = (PsiResourceVariable)resourceList.iterator().next();
            resourceVariable.getTypeElement().replace((PsiElement)variable.getTypeElement());
            PsiIdentifier nameIdentifier = resourceVariable.getNameIdentifier();
            assert (nameIdentifier != null);
            PsiIdentifier oldIdentifier = variable.getNameIdentifier();
            assert (oldIdentifier != null);
            nameIdentifier.replace((PsiElement)oldIdentifier);
            if (initializer != null) {
                resourceVariable.setInitializer(initializer);
            }
            return resourceVariable;
        }

        private void removeOldVariable(@NotNull PsiVariable variable, CommentTracker tracker) {
            PsiDeclarationStatement declaration2;
            if (variable == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(4);
            }
            if ((declaration2 = (PsiDeclarationStatement)variable.getParent()) == null) {
                return;
            }
            PsiElement[] declaredElements = declaration2.getDeclaredElements();
            if (declaredElements.length == 1) {
                tracker.delete((PsiElement)declaration2);
            } else {
                tracker.delete((PsiElement)variable);
            }
        }

        private PsiDeclarationStatement createNewDeclaration(@NotNull PsiVariable variable, @Nullable PsiExpression initializer, CommentTracker tracker) {
            if (variable == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(5);
            }
            Project project = variable.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            String name = variable.getName();
            if (name == null) {
                name = "";
            }
            PsiType type2 = variable.getType();
            PsiDeclarationStatement newDeclaration = factory.createVariableDeclarationStatement(name, type2, initializer != null ? tracker.markUnchanged(initializer) : null, (PsiElement)variable);
            PsiLocalVariable newVariable = (PsiLocalVariable)newDeclaration.getDeclaredElements()[0];
            PsiModifierList newModifierList = newVariable.getModifierList();
            PsiModifierList modifierList = variable.getModifierList();
            if (newModifierList != null && modifierList != null) {
                newModifierList.setModifierProperty("final", variable.hasModifierProperty("final"));
                GenerateMembersUtil.copyAnnotations(modifierList, newModifierList, new String[0]);
            }
            return newDeclaration;
        }

        private PsiDeclarationStatement moveDeclarationToLocation(@NotNull PsiVariable variable, @NotNull PsiElement location, CommentTracker tracker) {
            PsiExpressionStatement expressionStatement;
            PsiExpression expression2;
            if (variable == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(6);
            }
            if (location == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(7);
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)location, PsiStatement.class, (boolean)false);
            assert (statement != null);
            PsiElement statementParent = statement.getParent();
            while (statementParent instanceof PsiStatement && !(statementParent instanceof PsiForStatement)) {
                statement = (PsiStatement)statementParent;
                statementParent = statement.getParent();
            }
            assert (statementParent != null);
            PsiExpression initializer = variable.getInitializer();
            if (TooBroadScopeInspection.this.isMoveable(initializer) && statement instanceof PsiExpressionStatement && (expression2 = (expressionStatement = (PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                PsiExpression rhs = assignmentExpression.getRExpression();
                PsiExpression lhs = assignmentExpression.getLExpression();
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (location.equals(lhs) && JavaTokenType.EQ == tokenType && !VariableAccessUtils.variableIsUsed(variable, (PsiElement)rhs)) {
                    PsiDeclarationStatement newDeclaration = this.createNewDeclaration(variable, rhs, tracker);
                    newDeclaration = (PsiDeclarationStatement)statementParent.addBefore((PsiElement)newDeclaration, (PsiElement)statement);
                    PsiElement parent = assignmentExpression.getParent();
                    assert (parent != null);
                    tracker.delete(parent);
                    return newDeclaration;
                }
            }
            PsiDeclarationStatement newDeclaration = this.createNewDeclaration(variable, initializer, tracker);
            if (statement instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)statement;
                PsiStatement initialization = forStatement.getInitialization();
                newDeclaration = (PsiDeclarationStatement)forStatement.addBefore((PsiElement)newDeclaration, (PsiElement)initialization);
                if (initialization != null) {
                    tracker.delete((PsiElement)initialization);
                }
                return newDeclaration;
            }
            return (PsiDeclarationStatement)statementParent.addBefore((PsiElement)newDeclaration, (PsiElement)statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createResourceVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeOldVariable";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewDeclaration";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "moveDeclarationToLocation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

