/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeClassFinalFix;
import com.siyeh.ig.initialization.OverridableMethodCallDuringObjectConstructionInspectionBase;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class OverridableMethodCallDuringObjectConstructionInspection
extends OverridableMethodCallDuringObjectConstructionInspectionBase {
    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        PsiClass callClass = ClassUtils.getContainingClass((PsiElement)methodCallExpression);
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null || callClass == null || MethodUtils.isOverriddenInHierarchy(method, callClass)) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                OverridableMethodCallDuringObjectConstructionInspection.$$$reportNull$$$0(0);
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        SmartList fixes = new SmartList();
        fixes.add(new MakeClassFinalFix(callClass));
        if (!(method instanceof PsiCompiledElement)) {
            fixes.add(new MakeMethodFinalFix(method.getName()));
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            OverridableMethodCallDuringObjectConstructionInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection", "buildFixes"));
    }

    private static class MakeMethodFinalFix
    extends InspectionGadgetsFix {
        private final String methodName;

        MakeMethodFinalFix(String methodName) {
            this.methodName = methodName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("make.method.final.fix.name", this.methodName);
            if (string == null) {
                MakeMethodFinalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Make method 'final'" == null) {
                MakeMethodFinalFix.$$$reportNull$$$0(1);
            }
            return "Make method 'final'";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodName = descriptor.getPsiElement();
            PsiElement methodExpression = methodName.getParent();
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)methodExpression.getParent();
            PsiMethod method = methodCall.resolveMethod();
            if (method == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{method})) {
                return;
            }
            WriteAction.run(() -> method.getModifierList().setModifierProperty("final", true));
            if (method.getContainingFile() != methodExpression.getContainingFile()) {
                method.navigate(true);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection$MakeMethodFinalFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

