/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ForeachStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("extended.for.statement.display.name", new Object[0]);
        if (string == null) {
            ForeachStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("extended.for.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            ForeachStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ForEachFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForeachStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/jdk/ForeachStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ForeachStatementVisitor
    extends BaseInspectionVisitor {
        private ForeachStatementVisitor() {
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                ForeachStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitForeachStatement(statement);
            PsiExpression iteratedValue2 = statement.getIteratedValue();
            if (iteratedValue2 == null || !InheritanceUtil.isInheritor((PsiType)iteratedValue2.getType(), (String)"java.lang.Iterable")) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/jdk/ForeachStatementInspection$ForeachStatementVisitor", "visitForeachStatement"));
        }
    }

    private static class ForEachFix
    extends InspectionGadgetsFix {
        private ForEachFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("extended.for.statement.replace.quickfix", new Object[0]);
            if (string == null) {
                ForEachFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiForeachStatement statement = (PsiForeachStatement)element.getParent();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            assert (statement != null);
            PsiExpression iteratedValue2 = statement.getIteratedValue();
            if (iteratedValue2 == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            StringBuilder newStatement = new StringBuilder();
            PsiParameter iterationParameter = statement.getIterationParameter();
            boolean generateFinalLocals = JavaCodeStyleSettingsFacade.getInstance((Project)project).isGenerateFinalLocals();
            tracker.markUnchanged(iteratedValue2);
            if (iteratedValue2.getType() instanceof PsiArrayType) {
                PsiType type2 = iterationParameter.getType();
                String index = codeStyleManager.suggestUniqueVariableName("i", (PsiElement)statement, true);
                newStatement.append("for(int ").append(index).append(" = 0;");
                newStatement.append(index).append('<').append(iteratedValue2.getText()).append(".length;");
                newStatement.append(index).append("++)").append("{ ");
                if (generateFinalLocals) {
                    newStatement.append("final ");
                }
                newStatement.append(type2.getCanonicalText()).append(' ').append(iterationParameter.getName());
                newStatement.append(" = ").append(iteratedValue2.getText()).append('[').append(index).append("];");
            } else {
                StringBuilder methodCall = new StringBuilder();
                if (ParenthesesUtils.getPrecedence(iteratedValue2) > 1) {
                    methodCall.append('(').append(iteratedValue2.getText()).append(')');
                } else {
                    methodCall.append(iteratedValue2.getText());
                }
                methodCall.append(".iterator()");
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                PsiExpression iteratorCall = factory.createExpressionFromText(methodCall.toString(), (PsiElement)iteratedValue2);
                PsiType variableType = GenericsUtil.getVariableTypeByExpressionType((PsiType)iteratorCall.getType());
                if (variableType == null) {
                    return;
                }
                PsiType parameterType = iterationParameter.getType();
                String typeText = parameterType.getCanonicalText();
                newStatement.append("for(").append(variableType.getCanonicalText()).append(' ');
                String iterator = codeStyleManager.suggestUniqueVariableName("iterator", (PsiElement)statement, true);
                newStatement.append(iterator).append("=").append(iteratorCall.getText()).append(';');
                newStatement.append(iterator).append(".hasNext();){");
                if (generateFinalLocals) {
                    newStatement.append("final ");
                }
                newStatement.append(typeText).append(' ').append(iterationParameter.getName()).append(" = ").append(iterator).append(".next();");
            }
            PsiStatement body2 = statement.getBody();
            if (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                PsiElement[] children = block.getChildren();
                for (int i = 1; i < children.length - 1; ++i) {
                    newStatement.append(tracker.text(children[i]));
                }
            } else {
                String bodyText = body2 == null ? "" : tracker.text((PsiElement)body2);
                newStatement.append(bodyText);
            }
            newStatement.append('}');
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newStatement.toString(), tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/ForeachStatementInspection$ForEachFix", "getFamilyName"));
        }
    }
}

