/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.view;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedItemsListEditor;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.Cloner;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import gnu.trove.Equality;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.TemplatesManager;
import org.jetbrains.java.generate.template.toString.ToStringTemplatesManager;
import org.jetbrains.java.generate.view.GenerateTemplateConfigurable;

public class TemplatesPanel
extends NamedItemsListEditor<TemplateResource> {
    private static final Namer<TemplateResource> NAMER = new Namer<TemplateResource>(){

        public String getName(TemplateResource templateResource) {
            return templateResource.getFileName();
        }

        public boolean canRename(TemplateResource item) {
            return !item.isDefault();
        }

        public void setName(TemplateResource templateResource, String name) {
            templateResource.setFileName(name);
        }
    };
    private static final Factory<TemplateResource> FACTORY = () -> new TemplateResource();
    private static final Cloner<TemplateResource> CLONER = new Cloner<TemplateResource>(){

        public TemplateResource cloneOf(TemplateResource templateResource) {
            if (templateResource.isDefault()) {
                return templateResource;
            }
            return this.copyOf(templateResource);
        }

        public TemplateResource copyOf(TemplateResource templateResource) {
            TemplateResource result = new TemplateResource();
            result.setFileName(templateResource.getFileName());
            result.setTemplate(templateResource.getTemplate());
            return result;
        }
    };
    private static final Equality<TemplateResource> COMPARER = (o1, o2) -> Comparing.equal((String)o1.getTemplate(), (String)o2.getTemplate()) && Comparing.equal((String)o1.getFileName(), (String)o2.getFileName());
    private final Project myProject;
    private final TemplatesManager myTemplatesManager;
    private String myHint;

    public TemplatesPanel(Project project) {
        this(project, ToStringTemplatesManager.getInstance());
    }

    public TemplatesPanel(Project project, TemplatesManager templatesManager) {
        super(NAMER, FACTORY, CLONER, COMPARER, new ArrayList<TemplateResource>(templatesManager.getAllTemplates()));
        this.myProject = project;
        this.myTemplatesManager = templatesManager;
    }

    public void setHint(String hint) {
        this.myHint = hint;
    }

    @Nls
    public String getDisplayName() {
        return "Templates";
    }

    protected String subjDisplayName() {
        return "template";
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "Templates Dialog";
    }

    public boolean isModified() {
        return super.isModified() || !Comparing.equal((Object)this.myTemplatesManager.getDefaultTemplate(), (Object)this.getSelectedItem());
    }

    protected boolean canDelete(TemplateResource item) {
        return !item.isDefault();
    }

    protected UnnamedConfigurable createConfigurable(TemplateResource item) {
        GenerateTemplateConfigurable configurable = new GenerateTemplateConfigurable(item, Collections.emptyMap(), this.myProject, this.onMultipleFields());
        configurable.setHint(this.myHint);
        return configurable;
    }

    protected boolean onMultipleFields() {
        return true;
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.myTemplatesManager.setTemplates(this.getItems());
        TemplateResource selection = (TemplateResource)this.getSelectedItem();
        if (selection != null) {
            this.myTemplatesManager.setDefaultTemplate(selection);
        }
    }
}

