/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;
import org.jetbrains.idea.devkit.inspections.MoveRegistrationQuickFix;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a \u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\u0016H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u0018"}, d2={"checkProperModule", "", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "checkProperXmlFileForClass", "", "element", "Lcom/intellij/util/xml/DomElement;", "psiClass", "Lcom/intellij/psi/PsiClass;", "checkProperXmlFileForDefinition", "definingModule", "Lcom/intellij/openapi/module/Module;", "checkProperXmlFileForExtension", "Lorg/jetbrains/idea/devkit/dom/Extension;", "findMatchingImplModule", "module", "findModulePluginXmlFile", "Lcom/intellij/psi/xml/XmlFile;", "getRegisteringModule", "Lcom/intellij/psi/PsiElement;", "isIdeaPlatformModule", "intellij.devkit"})
@JvmName(name="ComponentModuleRegistrationChecker")
public final class ComponentModuleRegistrationChecker {
    /*
     * WARNING - void declaration
     */
    public static final void checkProperModule(@NotNull ExtensionPoint extensionPoint, @NotNull DomElementAnnotationHolder holder) {
        block5: {
            void epRegistration;
            GlobalSearchScope scope;
            Project project;
            PsiSearchHelper psiSearchHelper;
            Module module;
            Intrinsics.checkParameterIsNotNull((Object)extensionPoint, (String)"extensionPoint");
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            if (ComponentModuleRegistrationChecker.checkProperXmlFileForClass(extensionPoint, holder, (PsiClass)extensionPoint.getInterface().getValue())) {
                return;
            }
            if (ComponentModuleRegistrationChecker.checkProperXmlFileForClass(extensionPoint, holder, (PsiClass)extensionPoint.getBeanClass().getValue())) {
                return;
            }
            for (With withElement : extensionPoint.getWithElements()) {
                if (!ComponentModuleRegistrationChecker.checkProperXmlFileForClass(extensionPoint, holder, (PsiClass)withElement.getImplements().getValue())) continue;
                return;
            }
            String shortName = StringsKt.substringAfterLast$default((String)extensionPoint.getEffectiveQualifiedName(), (char)'.', null, (int)2, null);
            Module module2 = module = extensionPoint.getModule();
            if (module2 == null) {
                Intrinsics.throwNpe();
            }
            if (!Intrinsics.areEqual((Object)(psiSearchHelper = PsiSearchHelper.SERVICE.getInstance((Project)(project = module2.getProject()))).isCheapEnoughToSearch(shortName, scope = GlobalSearchScope.projectScope((Project)project), null, null), (Object)PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES)) break block5;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            psiSearchHelper.processElementsWithWord(new TextOccurenceProcessor((Ref.ObjectRef)epRegistration){
                final /* synthetic */ Ref.ObjectRef $epRegistration;

                public final boolean execute(@NotNull PsiElement element, int $noName_1) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    this.$epRegistration.element = ComponentModuleRegistrationChecker.access$getRegisteringModule(element);
                    return (Module)this.$epRegistration.element == null;
                }
                {
                    this.$epRegistration = objectRef;
                }
            }, (SearchScope)scope, shortName, (short)4, true, false);
            Module module3 = (Module)epRegistration.element;
            if (module3 != null) {
                Module module4;
                Module it = module4 = module3;
                ComponentModuleRegistrationChecker.checkProperXmlFileForDefinition(extensionPoint, holder, it);
            }
        }
    }

    private static final Module getRegisteringModule(PsiElement element) {
        PsiClassType psiClassType;
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (psiField == null) {
            return null;
        }
        PsiField epName = psiField;
        PsiType psiType = epName.getType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        if ((psiClassType = (PsiClassType)psiType) == null || (psiClassType = psiClassType.resolve()) == null) {
            return null;
        }
        PsiClassType psiClass = psiClassType;
        if (Intrinsics.areEqual((Object)psiClass.getQualifiedName(), (Object)"com.intellij.openapi.extensions.ExtensionPointName")) {
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)epName));
        }
        return null;
    }

    public static final void checkProperXmlFileForExtension(@NotNull Extension element, @NotNull DomElementAnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        for (DomAttributeChildDescription attributeDescription : element.getGenericInfo().getAttributeChildrenDescriptions()) {
            PsiClass psiClass;
            GenericAttributeValue attributeValue;
            String attributeName = attributeDescription.getName();
            if (Intrinsics.areEqual((Object)attributeName, (Object)"interfaceClass") || Intrinsics.areEqual((Object)attributeName, (Object)"serviceInterface") || Intrinsics.areEqual((Object)attributeName, (Object)"forClass") || (attributeValue = attributeDescription.getDomAttributeValue((DomElement)element)) == null || !DomUtil.hasXml((DomElement)((DomElement)attributeValue)) || !(attributeValue.getConverter() instanceof PluginPsiClassConverter)) continue;
            if ((PsiClass)attributeValue.getValue() == null) {
                continue;
            }
            if (!ComponentModuleRegistrationChecker.checkProperXmlFileForClass(element, holder, psiClass)) continue;
            return;
        }
        for (DomFixedChildDescription childDescription : element.getGenericInfo().getFixedChildrenDescriptions()) {
            DomElement domElement;
            if ((DomElement)CollectionsKt.firstOrNull((List)childDescription.getValues((DomElement)element)) == null) {
                continue;
            }
            Object object = domElement.getXmlTag();
            if (object == null || (object = object.getValue()) == null || (object = object.getText()) == null) {
                continue;
            }
            Object text = object;
            Project project = domElement.getXmlTag().getProject();
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass((String)text, GlobalSearchScope.projectScope((Project)project));
            if (psiClass == null || !ComponentModuleRegistrationChecker.checkProperXmlFileForClass(element, holder, psiClass)) continue;
            return;
        }
    }

    public static final boolean checkProperXmlFileForClass(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @Nullable PsiClass psiClass) {
        PsiClass definingModule;
        PsiClass psiClass2;
        PsiClass it;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiClass psiClass3 = psiClass;
        if (psiClass3 == null || (psiClass3 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)(it = (psiClass2 = psiClass3))))) == null) {
            return false;
        }
        PsiClass psiClass4 = definingModule = psiClass3;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass4, (String)"definingModule");
        return ComponentModuleRegistrationChecker.checkProperXmlFileForDefinition(element, holder, (Module)psiClass4);
    }

    private static final boolean checkProperXmlFileForDefinition(DomElement element, DomElementAnnotationHolder holder, Module definingModule) {
        Module implModule;
        Module definingModule2 = definingModule;
        XmlFile modulePluginXmlFile = ComponentModuleRegistrationChecker.findModulePluginXmlFile(definingModule2);
        if (modulePluginXmlFile == null && (implModule = ComponentModuleRegistrationChecker.findMatchingImplModule(definingModule2)) != null) {
            definingModule2 = implModule;
            modulePluginXmlFile = ComponentModuleRegistrationChecker.findModulePluginXmlFile(implModule);
        }
        if (modulePluginXmlFile != null && element.getModule() != definingModule2) {
            String string = "Element should be registered in " + modulePluginXmlFile.getName();
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
            String string2 = modulePluginXmlFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"modulePluginXmlFile.name");
            localQuickFixArray[0] = new MoveRegistrationQuickFix(definingModule2, string2);
            holder.createProblem(element, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, string, null, localQuickFixArray);
            return true;
        }
        return false;
    }

    public static final boolean isIdeaPlatformModule(@Nullable Module module) {
        if (module == null || !PsiUtil.isIdeaProject(module.getProject())) {
            return false;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        Object[] objectArray = contentRoots;
        if (objectArray.length == 0) {
            return false;
        }
        for (VirtualFile parent = contentRoots[0].getParent(); parent != null; parent = parent.getParent()) {
            if (Intrinsics.areEqual((Object)parent.getName(), (Object)"plugins")) {
                return false;
            }
            if (parent.findChild(".idea") == null) continue;
            return true;
        }
        return true;
    }

    private static final Module findMatchingImplModule(Module module) {
        return ModuleManager.getInstance((Project)module.getProject()).findModuleByName(module.getName() + ".impl");
    }

    private static final XmlFile findModulePluginXmlFile(Module module) {
        for (VirtualFile sourceRoot : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            VirtualFile metaInf = sourceRoot.findChild("META-INF");
            if (metaInf == null || !metaInf.isDirectory()) continue;
            for (VirtualFile file : metaInf.getChildren()) {
                PsiFile psiFile;
                if (!StringsKt.endsWith$default((String)file.getName(), (String)"Plugin.xml", (boolean)false, (int)2, null) || !((psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file)) instanceof XmlFile)) continue;
                return (XmlFile)psiFile;
            }
        }
        return null;
    }

    @Nullable
    public static final /* synthetic */ XmlFile access$findModulePluginXmlFile(@NotNull Module module) {
        return ComponentModuleRegistrationChecker.findModulePluginXmlFile(module);
    }

    @Nullable
    public static final /* synthetic */ Module access$getRegisteringModule(@NotNull PsiElement element) {
        return ComponentModuleRegistrationChecker.getRegisteringModule(element);
    }
}

