/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.ComponentModuleRegistrationChecker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0017J\b\u0010\u000e\u001a\u00020\u0005H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/MoveRegistrationQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myTargetModule", "Lcom/intellij/openapi/module/Module;", "myTargetFileName", "", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "intellij.devkit"})
public final class MoveRegistrationQuickFix
implements LocalQuickFix {
    private final Module myTargetModule;
    private final String myTargetFileName;

    @Nls
    @NotNull
    public String getName() {
        return "Move registration to " + this.myTargetFileName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Move registration to correct module";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        block8: {
            XmlTag[] subTags;
            XmlTag xmlTag;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            XmlTag xmlTag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class, (boolean)false);
            if (xmlTag2 == null) {
                return;
            }
            XmlTag tag = xmlTag2;
            XmlTag xmlTag3 = tag.getParentTag();
            if (xmlTag3 == null) {
                return;
            }
            XmlTag parentTag = xmlTag3;
            XmlFile xmlFile = ComponentModuleRegistrationChecker.access$findModulePluginXmlFile(this.myTargetModule);
            if (xmlFile == null) {
                return;
            }
            XmlFile targetFile = xmlFile;
            XmlTag xmlTag4 = targetFile.getRootTag();
            if (xmlTag4 == null) {
                return;
            }
            XmlTag rootTag = xmlTag4;
            XmlTag xmlTag5 = tag.getParentTag();
            if (xmlTag5 == null) {
                Intrinsics.throwNpe();
            }
            if ((xmlTag = (XmlTag)ArraysKt.firstOrNull((Object[])(subTags = rootTag.findSubTags(xmlTag5.getName())))) == null) {
                XmlTag xmlTag6;
                XmlTag $receiver = xmlTag6 = rootTag.addSubTag(rootTag.createChildTag(parentTag.getLocalName(), "", null, false), false);
                for (XmlAttribute attribute : parentTag.getAttributes()) {
                    $receiver.setAttribute(attribute.getName(), attribute.getValue());
                }
                xmlTag = xmlTag6;
            }
            XmlTag newParentTag = xmlTag;
            XmlTag newTag = newParentTag.addSubTag(tag, false);
            tag.delete();
            XmlTag xmlTag7 = newTag;
            if (!(xmlTag7 instanceof Navigatable)) {
                xmlTag7 = null;
            }
            Navigatable navigatable = (Navigatable)xmlTag7;
            if (navigatable == null) break block8;
            navigatable.navigate(true);
        }
    }

    public MoveRegistrationQuickFix(@NotNull Module myTargetModule, @NotNull String myTargetFileName) {
        Intrinsics.checkParameterIsNotNull((Object)myTargetModule, (String)"myTargetModule");
        Intrinsics.checkParameterIsNotNull((Object)myTargetFileName, (String)"myTargetFileName");
        this.myTargetModule = myTargetModule;
        this.myTargetFileName = myTargetFileName;
    }
}

