/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.util.ArrayUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u001a.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003\u001a\f\u0010\u0017\u001a\u00020\u000f*\u0004\u0018\u00010\u0014\u001a\f\u0010\u0018\u001a\u00020\u000f*\u0004\u0018\u00010\u0014\u001a\f\u0010\u0019\u001a\u00020\u000f*\u0004\u0018\u00010\u0014\u001a\n\u0010\u001a\u001a\u00020\u0003*\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"SERVICE_NAME_PREFIX", "", "CredentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "requestor", "Ljava/lang/Class;", "userName", "OneTimeString", "Lcom/intellij/credentialStore/OneTimeString;", "value", "", "offset", "", "length", "clearable", "", "generateServiceName", "subsystem", "key", "getAndMigrateCredentials", "Lcom/intellij/credentialStore/Credentials;", "oldAttributes", "newAttributes", "hasOnlyUserName", "isEmpty", "isFulfilled", "toPasswordStoreable", "intellij.platform.ide"})
public final class CredentialAttributesKt {
    @NotNull
    public static final String SERVICE_NAME_PREFIX = "IntelliJ Platform";

    @NotNull
    public static final String generateServiceName(@NotNull String subsystem, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)subsystem, (String)"subsystem");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return "IntelliJ Platform " + subsystem + " \u2014 " + key;
    }

    @NotNull
    public static final CredentialAttributes toPasswordStoreable(@NotNull CredentialAttributes $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.isPasswordMemoryOnly() ? new CredentialAttributes($receiver.getServiceName(), $receiver.getUserName(), $receiver.getRequestor(), false, 8, null) : $receiver;
    }

    @NotNull
    public static final CredentialAttributes CredentialAttributes(@NotNull Class<?> requestor, @Nullable String userName) {
        Intrinsics.checkParameterIsNotNull(requestor, (String)"requestor");
        String string = requestor.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"requestor.name");
        return new CredentialAttributes(string, userName, requestor, false, 8, null);
    }

    public static final boolean isFulfilled(@Nullable Credentials $receiver) {
        CharSequence charSequence;
        return $receiver != null && $receiver.getUserName() != null && !((charSequence = (CharSequence)((Object)$receiver.getPassword())) == null || charSequence.length() == 0);
    }

    public static final boolean hasOnlyUserName(@Nullable Credentials $receiver) {
        CharSequence charSequence;
        return $receiver != null && $receiver.getUserName() != null && ((charSequence = (CharSequence)((Object)$receiver.getPassword())) == null || charSequence.length() == 0);
    }

    public static final boolean isEmpty(@Nullable Credentials $receiver) {
        CharSequence charSequence;
        return $receiver == null || $receiver.getUserName() == null && ((charSequence = (CharSequence)((Object)$receiver.getPassword())) == null || charSequence.length() == 0);
    }

    @Nullable
    public static final Credentials getAndMigrateCredentials(@NotNull CredentialAttributes oldAttributes, @NotNull CredentialAttributes newAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)oldAttributes, (String)"oldAttributes");
        Intrinsics.checkParameterIsNotNull((Object)newAttributes, (String)"newAttributes");
        PasswordSafe safe = PasswordSafe.getInstance();
        Credentials credentials = safe.get(newAttributes);
        if (credentials == null && (credentials = safe.get(oldAttributes)) != null) {
            safe.set(oldAttributes, null);
            safe.set(newAttributes, credentials);
        }
        return credentials;
    }

    @JvmOverloads
    @NotNull
    public static final OneTimeString OneTimeString(@NotNull byte[] value, int offset, int length, boolean clearable) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (length == 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)ArrayUtil.EMPTY_CHAR_ARRAY, (String)"ArrayUtil.EMPTY_CHAR_ARRAY");
            return new OneTimeString(ArrayUtil.EMPTY_CHAR_ARRAY, 0, 0, false, 14, null);
        }
        CharsetDecoder charsetDecoder = Charsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        char[] charArray = new char[(int)((double)value.length * (double)charsetDecoder.maxCharsPerByte())];
        charsetDecoder.reset();
        CharBuffer charBuffer = CharBuffer.wrap(charArray);
        CoderResult cr = charsetDecoder.decode(ByteBuffer.wrap(value, offset, length), charBuffer, true);
        if (!cr.isUnderflow()) {
            cr.throwException();
        }
        if (!(cr = charsetDecoder.flush(charBuffer)).isUnderflow()) {
            cr.throwException();
        }
        ArraysKt.fill((byte[])value, (byte)0, (int)offset, (int)(offset + length));
        return new OneTimeString(charArray, 0, charBuffer.position(), clearable);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ OneTimeString OneTimeString$default(byte[] byArray, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return CredentialAttributesKt.OneTimeString(byArray, n, n2, bl);
    }

    @JvmOverloads
    @NotNull
    public static final OneTimeString OneTimeString(@NotNull byte[] value, int offset, int length) {
        return CredentialAttributesKt.OneTimeString$default(value, offset, length, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public static final OneTimeString OneTimeString(@NotNull byte[] value, int offset) {
        return CredentialAttributesKt.OneTimeString$default(value, offset, 0, false, 12, null);
    }

    @JvmOverloads
    @NotNull
    public static final OneTimeString OneTimeString(@NotNull byte[] value) {
        return CredentialAttributesKt.OneTimeString$default(value, 0, 0, false, 14, null);
    }
}

