/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.RunManagerKt;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH&J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH&J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H&J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H&J\u0016\u0010$\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!J\u0014\u0010%\u001a\u0004\u0018\u00010\t2\b\u0010\"\u001a\u0004\u0018\u00010#H&J\u0018\u0010&\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020#2\u0006\u0010\"\u001a\u00020#J\u0013\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0007\u00a2\u0006\u0002\u0010)J\u001b\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010+\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010+\u001a\u00020\rH&J\u0010\u0010.\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H&J\u0012\u0010/\u001a\u0004\u0018\u00010\r2\u0006\u00100\u001a\u00020#H&J\u001b\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010+\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u00102J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010+\u001a\u00020\rH&J\u0010\u00104\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\tH&J\u0010\u00105\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH&J\u0010\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u000208H&J\u0012\u00109\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\tH&J\u0012\u0010:\u001a\u00020\u001a2\b\u0010;\u001a\u0004\u0018\u00010\tH&J\u000e\u0010<\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020\u0005J\u001a\u0010>\u001a\u00020#2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010+\u001a\u0004\u0018\u00010\rR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u001a\u0010\u0012\u001a\u0004\u0018\u00010\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007\u00a8\u0006@"}, d2={"Lcom/intellij/execution/RunManager;", "", "()V", "allConfigurationsList", "", "Lcom/intellij/execution/configurations/RunConfiguration;", "getAllConfigurationsList", "()Ljava/util/List;", "allSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getAllSettings", "configurationFactories", "", "Lcom/intellij/execution/configurations/ConfigurationType;", "getConfigurationFactories", "()[Lcom/intellij/execution/configurations/ConfigurationType;", "configurationFactoriesWithoutUnknown", "getConfigurationFactoriesWithoutUnknown", "selectedConfiguration", "getSelectedConfiguration", "()Lcom/intellij/execution/RunnerAndConfigurationSettings;", "setSelectedConfiguration", "(Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "tempConfigurationsList", "getTempConfigurationsList", "addConfiguration", "", "settings", "isShared", "", "createConfiguration", "runConfiguration", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "createRunConfiguration", "findConfigurationByName", "findConfigurationByTypeAndName", "typeId", "getAllConfigurations", "()[Lcom/intellij/execution/configurations/RunConfiguration;", "getConfigurationSettings", "type", "(Lcom/intellij/execution/configurations/ConfigurationType;)[Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getConfigurationSettingsList", "getConfigurationTemplate", "getConfigurationType", "typeName", "getConfigurations", "(Lcom/intellij/execution/configurations/ConfigurationType;)[Lcom/intellij/execution/configurations/RunConfiguration;", "getConfigurationsList", "hasSettings", "makeStable", "refreshUsagesList", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "removeConfiguration", "setTemporaryConfiguration", "tempConfiguration", "setUniqueNameIfNeed", "configuration", "suggestUniqueName", "Companion", "intellij.platform.lang"})
public abstract class RunManager {
    private static final Pattern UNIQUE_NAME_PATTERN;
    public static final Companion Companion;

    @NotNull
    public abstract ConfigurationType[] getConfigurationFactories();

    @NotNull
    public abstract List<ConfigurationType> getConfigurationFactoriesWithoutUnknown();

    @Deprecated(message="", replaceWith=@ReplaceWith(imports={}, expression="getConfigurationsList(type)"))
    @NotNull
    public final RunConfiguration[] getConfigurations(@NotNull ConfigurationType type) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Collection collection = $receiver$iv = (Collection)this.getConfigurationsList(type);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        RunConfiguration[] runConfigurationArray = thisCollection$iv.toArray(new RunConfiguration[0]);
        if (runConfigurationArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return runConfigurationArray;
    }

    @NotNull
    public abstract List<RunConfiguration> getConfigurationsList(@NotNull ConfigurationType var1);

    @Deprecated(message="", replaceWith=@ReplaceWith(imports={}, expression="getConfigurationSettingsList(type)"))
    @NotNull
    public final RunnerAndConfigurationSettings[] getConfigurationSettings(@NotNull ConfigurationType type) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Collection collection = $receiver$iv = (Collection)this.getConfigurationSettingsList(type);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        RunnerAndConfigurationSettings[] runnerAndConfigurationSettingsArray = thisCollection$iv.toArray(new RunnerAndConfigurationSettings[0]);
        if (runnerAndConfigurationSettingsArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return runnerAndConfigurationSettingsArray;
    }

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull ConfigurationType var1);

    @Deprecated(message="", replaceWith=@ReplaceWith(imports={}, expression="allConfigurationsList"))
    @NotNull
    public final RunConfiguration[] getAllConfigurations() {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)this.getAllConfigurationsList();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        RunConfiguration[] runConfigurationArray = thisCollection$iv.toArray(new RunConfiguration[0]);
        if (runConfigurationArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return runConfigurationArray;
    }

    @NotNull
    public abstract List<RunConfiguration> getAllConfigurationsList();

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getAllSettings();

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getTempConfigurationsList();

    public abstract void makeStable(@NotNull RunnerAndConfigurationSettings var1);

    @Nullable
    public abstract RunnerAndConfigurationSettings getSelectedConfiguration();

    public abstract void setSelectedConfiguration(@Nullable RunnerAndConfigurationSettings var1);

    @NotNull
    public abstract RunnerAndConfigurationSettings createConfiguration(@NotNull String var1, @NotNull ConfigurationFactory var2);

    @NotNull
    public final RunnerAndConfigurationSettings createRunConfiguration(@NotNull String name, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        return this.createConfiguration(name, factory);
    }

    @NotNull
    public abstract RunnerAndConfigurationSettings createConfiguration(@NotNull RunConfiguration var1, @NotNull ConfigurationFactory var2);

    @NotNull
    public abstract RunnerAndConfigurationSettings getConfigurationTemplate(@NotNull ConfigurationFactory var1);

    public abstract void addConfiguration(@NotNull RunnerAndConfigurationSettings var1);

    public abstract void addConfiguration(@NotNull RunnerAndConfigurationSettings var1, boolean var2);

    public abstract void refreshUsagesList(@NotNull RunProfile var1);

    public abstract boolean hasSettings(@NotNull RunnerAndConfigurationSettings var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String suggestUniqueName(@Nullable String name, @Nullable ConfigurationType type) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        List<RunnerAndConfigurationSettings> settingsList = type == null ? this.getAllSettings() : this.getConfigurationSettingsList(type);
        String string = StringKt.nullize$default(name, false, 1, null);
        if (string == null) {
            string = RunManagerKt.access$getUNNAMED$p();
        }
        Iterable iterable = settingsList;
        String string2 = string;
        Companion companion = Companion;
        void var5_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)item$iv$iv;
            collection = destination$iv$iv;
            String string3 = it.getName();
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        return companion.suggestUniqueName(string2, collection);
    }

    public final boolean setUniqueNameIfNeed(@NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        String oldName = settings.getName();
        settings.setName(this.suggestUniqueName(StringUtil.notNullize((String)oldName, (String)RunManagerKt.access$getUNNAMED$p()), settings.getType()));
        return Intrinsics.areEqual((Object)oldName, (Object)settings.getName()) ^ true;
    }

    public final boolean setUniqueNameIfNeed(@NotNull RunConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        String oldName = configuration.getName();
        configuration.setName(this.suggestUniqueName(StringUtil.notNullize((String)oldName, (String)RunManagerKt.access$getUNNAMED$p()), configuration.getType()));
        return Intrinsics.areEqual((Object)oldName, (Object)configuration.getName()) ^ true;
    }

    @Nullable
    public abstract ConfigurationType getConfigurationType(@NotNull String var1);

    @Nullable
    public abstract RunnerAndConfigurationSettings findConfigurationByName(@Nullable String var1);

    @Nullable
    public final RunnerAndConfigurationSettings findConfigurationByTypeAndName(@NotNull String typeId, @NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)typeId, (String)"typeId");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Iterable $receiver$iv = this.getAllSettings();
            for (Object element$iv : $receiver$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                if (!(Intrinsics.areEqual((Object)typeId, (Object)it.getType().getId()) && Intrinsics.areEqual((Object)name, (Object)it.getName()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public abstract void removeConfiguration(@Nullable RunnerAndConfigurationSettings var1);

    public abstract void setTemporaryConfiguration(@Nullable RunnerAndConfigurationSettings var1);

    static {
        Companion = new Companion(null);
        UNIQUE_NAME_PATTERN = Pattern.compile("(.*?)\\s*\\(\\d+\\)");
    }

    @JvmStatic
    @NotNull
    public static final RunManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final String suggestUniqueName(@NotNull String str, @NotNull Collection<String> currentNames) {
        return Companion.suggestUniqueName(str, currentNames);
    }

    @JvmStatic
    @NotNull
    public static final String extractBaseName(@NotNull String uniqueName) {
        return Companion.extractBaseName(uniqueName);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0007R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/RunManager$Companion;", "", "()V", "UNIQUE_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getUNIQUE_NAME_PATTERN", "()Ljava/util/regex/Pattern;", "extractBaseName", "", "uniqueName", "getInstance", "Lcom/intellij/execution/RunManager;", "project", "Lcom/intellij/openapi/project/Project;", "suggestUniqueName", "str", "currentNames", "", "intellij.platform.lang"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final RunManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (Intrinsics.areEqual((Object)((Boolean)RunManagerKt.getIS_RUN_MANAGER_INITIALIZED().get((UserDataHolder)project)), (Object)true) ^ true) {
                RunManagerKt.access$getLOG$p().debug("Must be not called before project components initialized");
            }
            RunManager runManager = ServiceManager.getService(project, RunManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)runManager, (String)"ServiceManager.getServic\u2026, RunManager::class.java)");
            return runManager;
        }

        @JvmStatic
        @NotNull
        public final String suggestUniqueName(@NotNull String str, @NotNull Collection<String> currentNames) {
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            Intrinsics.checkParameterIsNotNull(currentNames, (String)"currentNames");
            if (!currentNames.contains(str)) {
                return str;
            }
            String originalName = this.extractBaseName(str);
            int i = 1;
            while (true) {
                String newName;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%s (%d)";
                Object[] objectArray = new Object[]{originalName, i};
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                if (!currentNames.contains(newName)) {
                    return newName;
                }
                ++i;
            }
        }

        private final Pattern getUNIQUE_NAME_PATTERN() {
            return UNIQUE_NAME_PATTERN;
        }

        @JvmStatic
        @NotNull
        public final String extractBaseName(@NotNull String uniqueName) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)uniqueName, (String)"uniqueName");
            Matcher matcher = this.getUNIQUE_NAME_PATTERN().matcher(uniqueName);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"matcher.group(1)");
            } else {
                string = uniqueName;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

