/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpacingBuilder {
    private static Logger LOG = Logger.getInstance(SpacingBuilder.class);
    private final CommonCodeStyleSettings myCodeStyleSettings;
    private final List<SpacingRule> myRules;

    @Deprecated
    public SpacingBuilder(CodeStyleSettings codeStyleSettings) {
        this.myRules = new ArrayList<SpacingRule>();
        this.myCodeStyleSettings = new CommonCodeStyleSettings(Language.ANY);
        LOG.error("The plugin calling this method uses deprecated API and must be updated.");
    }

    public SpacingBuilder(@NotNull CodeStyleSettings codeStyleSettings, @NotNull Language language) {
        if (codeStyleSettings == null) {
            SpacingBuilder.$$$reportNull$$$0(0);
        }
        if (language == null) {
            SpacingBuilder.$$$reportNull$$$0(1);
        }
        this.myRules = new ArrayList<SpacingRule>();
        this.myCodeStyleSettings = codeStyleSettings.getCommonSettings(language);
    }

    public SpacingBuilder(@NotNull CommonCodeStyleSettings languageCodeStyleSettings) {
        if (languageCodeStyleSettings == null) {
            SpacingBuilder.$$$reportNull$$$0(2);
        }
        this.myRules = new ArrayList<SpacingRule>();
        assert (languageCodeStyleSettings.getLanguage() != null) : "Only language code style settings are accepted (getLanguage() != null)";
        this.myCodeStyleSettings = languageCodeStyleSettings;
    }

    public RuleBuilder after(IElementType elementType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, TokenSet.create(elementType), null)});
    }

    public RuleBuilder after(TokenSet tokenSet) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, tokenSet, null)});
    }

    public RuleBuilder afterInside(IElementType elementType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), TokenSet.create(elementType), null)});
    }

    public RuleBuilder afterInside(IElementType elementType, TokenSet parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(parentType, TokenSet.create(elementType), null)});
    }

    public RuleBuilder afterInside(TokenSet tokenSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), tokenSet, null)});
    }

    public RuleBuilder before(IElementType elementType) {
        return this.before(TokenSet.create(elementType));
    }

    public RuleBuilder before(TokenSet tokenSet) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, null, tokenSet)});
    }

    public RuleBuilder beforeInside(TokenSet tokenSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), null, tokenSet)});
    }

    public RuleBuilder beforeInside(IElementType elementType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), null, TokenSet.create(elementType))});
    }

    public RuleBuilder beforeInside(IElementType elementType, TokenSet parentTypes) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(parentTypes, null, TokenSet.create(elementType))});
    }

    public RuleBuilder between(IElementType left, IElementType right) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, TokenSet.create(left), TokenSet.create(right))});
    }

    public RuleBuilder between(IElementType left, TokenSet rightSet) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, TokenSet.create(left), rightSet)});
    }

    public RuleBuilder between(TokenSet leftSet, IElementType right) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, leftSet, TokenSet.create(right))});
    }

    public RuleBuilder between(TokenSet leftType, TokenSet rightType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, leftType, rightType)});
    }

    public RuleBuilder betweenInside(IElementType leftType, IElementType rightType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), TokenSet.create(leftType), TokenSet.create(rightType))});
    }

    public RuleBuilder betweenInside(TokenSet leftSet, TokenSet rightSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), leftSet, rightSet)});
    }

    public RuleBuilder withinPair(IElementType pairFirst, IElementType pairSecond) {
        RuleCondition before = new RuleCondition(null, TokenSet.create(pairFirst), null);
        RuleCondition after = new RuleCondition(null, null, TokenSet.create(pairSecond));
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder withinPairInside(IElementType pairFirst, IElementType pairSecond, IElementType parent) {
        TokenSet parentSet = TokenSet.create(parent);
        RuleCondition before = new RuleCondition(parentSet, TokenSet.create(pairFirst), null);
        RuleCondition after = new RuleCondition(parentSet, null, TokenSet.create(pairSecond));
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder around(IElementType elementType) {
        return this.around(TokenSet.create(elementType));
    }

    public RuleBuilder around(TokenSet tokenSet) {
        RuleCondition before = new RuleCondition(null, null, tokenSet);
        RuleCondition after = new RuleCondition(null, tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder aroundInside(TokenSet tokenSet, TokenSet parent) {
        RuleCondition before = new RuleCondition(parent, null, tokenSet);
        RuleCondition after = new RuleCondition(parent, tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder aroundInside(TokenSet tokenSet, IElementType parent) {
        RuleCondition before = new RuleCondition(TokenSet.create(parent), null, tokenSet);
        RuleCondition after = new RuleCondition(TokenSet.create(parent), tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder aroundInside(IElementType token, IElementType parent) {
        TokenSet tokenSet = TokenSet.create(token);
        RuleCondition before = new RuleCondition(TokenSet.create(parent), null, tokenSet);
        RuleCondition after = new RuleCondition(TokenSet.create(parent), tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder aroundInside(IElementType token, TokenSet parent) {
        TokenSet tokenSet = TokenSet.create(token);
        RuleCondition before = new RuleCondition(parent, null, tokenSet);
        RuleCondition after = new RuleCondition(parent, tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public SpacingBuilder append(SpacingBuilder builder) {
        this.myRules.addAll(builder.myRules);
        return this;
    }

    @Nullable
    public Spacing getSpacing(Block parent, Block child1, Block child2) {
        if (!(parent instanceof ASTBlock && child1 instanceof ASTBlock && child2 instanceof ASTBlock)) {
            return null;
        }
        for (SpacingRule rule : this.myRules) {
            if (!rule.matches((ASTBlock)parent, (ASTBlock)child1, (ASTBlock)child2)) continue;
            return rule.createSpacing((ASTBlock)parent, (ASTBlock)child1, (ASTBlock)child2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "codeStyleSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "language";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "languageCodeStyleSettings";
                break;
            }
        }
        objectArray[1] = "com/intellij/formatting/SpacingBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class RuleBuilder {
        RuleCondition[] myConditions;

        private RuleBuilder(RuleCondition ... conditions) {
            this.myConditions = conditions;
        }

        public SpacingBuilder none() {
            return this.spaces(0);
        }

        public SpacingBuilder spaceIf(boolean option) {
            return this.spaceIf(option, false);
        }

        public SpacingBuilder spaceIf(boolean option, boolean useParentDependentLFSpacing) {
            return this.spaces(option ? 1 : 0, useParentDependentLFSpacing);
        }

        public SpacingBuilder spaces(int count) {
            return this.spaces(count, false);
        }

        public SpacingBuilder spaces(int count, boolean useParentDependentLFSpacing) {
            if (useParentDependentLFSpacing) {
                return this.parentDependentLFSpacing(count, count, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE);
            }
            return this.spacing(count, count, 0, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE);
        }

        public SpacingBuilder blankLines(int count) {
            int blankLines = count + 1;
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition, 0, 0, blankLines, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_DECLARATIONS));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakInCodeIf(boolean option) {
            return option ? this.lineBreakInCode() : SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakInCode() {
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition, 1, 0, 1, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakOrForceSpace(boolean lbOption, boolean spaceOption) {
            if (lbOption) {
                return this.lineBreakInCode();
            }
            int count = spaceOption ? 1 : 0;
            return this.spacing(count, count, 0, false, 0);
        }

        public SpacingBuilder spacing(int minSpaces, int maxSpaces, int minLF, boolean keepLineBreaks, int keepBlankLines) {
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition, minSpaces, maxSpaces, minLF, keepLineBreaks, keepBlankLines));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder parentDependentLFSpacing(int minSpaces, int maxSpaces, boolean keepLineBreaks, int keepBlankLines) {
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new DependentLFSpacingRule(condition, minSpaces, maxSpaces, keepLineBreaks, keepBlankLines));
            }
            return SpacingBuilder.this;
        }
    }

    private static class RuleCondition {
        private final TokenSet myParentType;
        private final TokenSet myChild1Type;
        private final TokenSet myChild2Type;

        private RuleCondition(TokenSet parentType, TokenSet child1Type, TokenSet child2Type) {
            this.myParentType = parentType;
            this.myChild1Type = child1Type;
            this.myChild2Type = child2Type;
        }

        private boolean matches(@NotNull IElementType parentType, @NotNull IElementType firstChildType, @NotNull IElementType secondChildType) {
            if (parentType == null) {
                RuleCondition.$$$reportNull$$$0(0);
            }
            if (firstChildType == null) {
                RuleCondition.$$$reportNull$$$0(1);
            }
            if (secondChildType == null) {
                RuleCondition.$$$reportNull$$$0(2);
            }
            return !(this.myParentType != null && !this.myParentType.contains(parentType) || this.myChild1Type != null && !this.myChild1Type.contains(firstChildType) || this.myChild2Type != null && !this.myChild2Type.contains(secondChildType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstChildType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "secondChildType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/formatting/SpacingBuilder$RuleCondition";
            objectArray[2] = "matches";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DependentLFSpacingRule
    extends SpacingRule {
        public DependentLFSpacingRule(@NotNull RuleCondition condition, int minSpaces, int maxSpaces, boolean keepLineBreaks, int keepBlankLines) {
            if (condition == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(0);
            }
            super(condition, minSpaces, maxSpaces, 1, keepLineBreaks, keepBlankLines);
        }

        @Override
        public Spacing createSpacing(@NotNull ASTBlock parentBlock, @NotNull ASTBlock childBlock1, @NotNull ASTBlock childBlock2) {
            if (parentBlock == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(1);
            }
            if (childBlock1 == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(2);
            }
            if (childBlock2 == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(3);
            }
            TextRange range = parentBlock.getNode().getTextRange();
            return Spacing.createDependentLFSpacing(this.myMinSpaces, this.myMaxSpaces, range, this.myKeepLineBreaks, this.myKeepBlankLines);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentBlock";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childBlock1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childBlock2";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/formatting/SpacingBuilder$DependentLFSpacingRule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSpacing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SpacingRule {
        protected final RuleCondition myRuleCondition;
        protected final int myMinSpaces;
        protected final int myMaxSpaces;
        protected final int myMinLF;
        protected final boolean myKeepLineBreaks;
        protected final int myKeepBlankLines;

        private SpacingRule(@NotNull RuleCondition condition, int minSpaces, int maxSpaces, int minLF, boolean keepLineBreaks, int keepBlankLines) {
            if (condition == null) {
                SpacingRule.$$$reportNull$$$0(0);
            }
            this.myRuleCondition = condition;
            this.myMinSpaces = minSpaces;
            this.myMaxSpaces = maxSpaces;
            this.myMinLF = minLF;
            this.myKeepLineBreaks = keepLineBreaks;
            this.myKeepBlankLines = keepBlankLines;
        }

        public boolean matches(@NotNull ASTBlock parentBlock, @NotNull ASTBlock childBlock1, @NotNull ASTBlock childBlock2) {
            if (parentBlock == null) {
                SpacingRule.$$$reportNull$$$0(1);
            }
            if (childBlock1 == null) {
                SpacingRule.$$$reportNull$$$0(2);
            }
            if (childBlock2 == null) {
                SpacingRule.$$$reportNull$$$0(3);
            }
            return this.myRuleCondition.matches(parentBlock.getNode().getElementType(), childBlock1.getNode().getElementType(), childBlock2.getNode().getElementType());
        }

        public Spacing createSpacing(@NotNull ASTBlock parentBlock, @NotNull ASTBlock childBlock1, @NotNull ASTBlock childBlock2) {
            if (parentBlock == null) {
                SpacingRule.$$$reportNull$$$0(4);
            }
            if (childBlock1 == null) {
                SpacingRule.$$$reportNull$$$0(5);
            }
            if (childBlock2 == null) {
                SpacingRule.$$$reportNull$$$0(6);
            }
            return Spacing.createSpacing(this.myMinSpaces, this.myMaxSpaces, this.myMinLF, this.myKeepLineBreaks, this.myKeepBlankLines);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentBlock";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childBlock1";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childBlock2";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/formatting/SpacingBuilder$SpacingRule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSpacing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

