/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Debugger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Alarm
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.Alarm");
    private volatile boolean myDisposed;
    private final List<Request> myRequests;
    private final List<Request> myPendingRequests;
    private final ScheduledExecutorService myExecutorService;
    private final Object LOCK;
    final ThreadToUse myThreadToUse;
    private JComponent myActivationComponent;

    public void dispose() {
        if (!this.myDisposed) {
            this.myDisposed = true;
            this.cancelAllRequests();
            if (this.myExecutorService != EdtExecutorService.getScheduledExecutorInstance()) {
                this.myExecutorService.shutdownNow();
            }
        }
    }

    private void checkDisposed() {
        LOG.assertTrue(!this.myDisposed, (Object)"Already disposed");
    }

    public Alarm() {
        this(ThreadToUse.SWING_THREAD);
    }

    public Alarm(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            Alarm.$$$reportNull$$$0(0);
        }
        this(ThreadToUse.SWING_THREAD, parentDisposable);
    }

    public Alarm(@NotNull ThreadToUse threadToUse) {
        if (threadToUse == null) {
            Alarm.$$$reportNull$$$0(1);
        }
        this(threadToUse, null);
    }

    public Alarm(@NotNull ThreadToUse threadToUse, @Nullable Disposable parentDisposable) {
        if (threadToUse == null) {
            Alarm.$$$reportNull$$$0(2);
        }
        this.myRequests = new SmartList();
        this.myPendingRequests = new SmartList();
        this.LOCK = new Object();
        this.myThreadToUse = threadToUse;
        ScheduledExecutorService scheduledExecutorService = this.myExecutorService = threadToUse == ThreadToUse.SWING_THREAD ? EdtExecutorService.getScheduledExecutorInstance() : AppExecutorUtil.createBoundedScheduledExecutorService((String)"Alarm pool", (int)1);
        if (parentDisposable == null) {
            if (threadToUse == ThreadToUse.POOLED_THREAD || threadToUse != ThreadToUse.SWING_THREAD) {
                boolean crash = threadToUse == ThreadToUse.POOLED_THREAD || ApplicationManager.getApplication().isUnitTestMode();
                IllegalArgumentException t = new IllegalArgumentException("You must provide parent Disposable for non-swing thread Alarm");
                if (crash) {
                    throw t;
                }
                LOG.warn((Throwable)t);
            }
        } else {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    public void addRequest(final @NotNull Runnable request, final int delay, boolean runWithActiveFrameOnly) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(3);
        }
        if (runWithActiveFrameOnly && !ApplicationManager.getApplication().isActive()) {
            MessageBus bus = ApplicationManager.getApplication().getMessageBus();
            final MessageBusConnection connection = bus.connect((Disposable)this);
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                @Override
                public void applicationActivated(IdeFrame ideFrame) {
                    connection.disconnect();
                    Alarm.this.addRequest(request, delay);
                }
            });
        } else {
            this.addRequest(request, delay);
        }
    }

    private ModalityState getModalityState() {
        if (this.myThreadToUse != ThreadToUse.SWING_THREAD) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return null;
        }
        return application.getDefaultModalityState();
    }

    public void addRequest(@NotNull Runnable request, long delayMillis) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(4);
        }
        this._addRequest(request, delayMillis, this.getModalityState());
    }

    public void addRequest(@NotNull Runnable request, int delayMillis) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(5);
        }
        this._addRequest(request, delayMillis, this.getModalityState());
    }

    public void addComponentRequest(@NotNull Runnable request, int delay) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(6);
        }
        assert (this.myActivationComponent != null);
        this._addRequest(request, delay, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addComponentRequest(@NotNull Runnable request, long delayMillis) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(7);
        }
        assert (this.myActivationComponent != null);
        this._addRequest(request, delayMillis, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addRequest(@NotNull Runnable request, int delayMillis, @Nullable ModalityState modalityState) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, modalityState);
    }

    /*
     * WARNING - void declaration
     */
    public void addRequest(@NotNull Runnable request, long delayMillis, @Nullable ModalityState modalityState) {
        void modalityState2;
        if (request == null) {
            Alarm.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, (ModalityState)modalityState2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void _addRequest(@NotNull Runnable request, long delayMillis, @Nullable ModalityState modalityState) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(10);
        }
        Object object = this.LOCK;
        synchronized (object) {
            void modalityState2;
            this.checkDisposed();
            Request requestToSchedule = new Request(request, (ModalityState)modalityState2, delayMillis);
            if (this.myActivationComponent == null || this.myActivationComponent.isShowing()) {
                this._add(requestToSchedule);
            } else if (!this.myPendingRequests.contains(requestToSchedule)) {
                this.myPendingRequests.add(requestToSchedule);
            }
        }
    }

    private void _add(@NotNull Request requestToSchedule) {
        if (requestToSchedule == null) {
            Alarm.$$$reportNull$$$0(11);
        }
        requestToSchedule.schedule();
        this.myRequests.add(requestToSchedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPending() {
        Object object = this.LOCK;
        synchronized (object) {
            for (Request each : this.myPendingRequests) {
                this._add(each);
            }
            this.myPendingRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequest(@NotNull Runnable request) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(12);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.cancelRequest(request, this.myRequests);
            this.cancelRequest(request, this.myPendingRequests);
            return true;
        }
    }

    private void cancelRequest(@NotNull Runnable request, @NotNull List<Request> list) {
        if (request == null) {
            Alarm.$$$reportNull$$$0(13);
        }
        if (list == null) {
            Alarm.$$$reportNull$$$0(14);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Request r = list.get(i);
            if (r.myTask != request) continue;
            r.cancel();
            list.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelAllRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.cancelAllRequests(this.myRequests) + this.cancelAllRequests(this.myPendingRequests);
        }
    }

    private int cancelAllRequests(@NotNull List<Request> list) {
        if (list == null) {
            Alarm.$$$reportNull$$$0(15);
        }
        int count = list.size();
        for (Request request : list) {
            request.cancel();
        }
        list.clear();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        SmartList requests;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            if (this.myRequests.isEmpty()) {
                return;
            }
            requests = new SmartList();
            for (Request request : this.myRequests) {
                Runnable existingTask = request.cancel();
                if (existingTask == null) continue;
                requests.add(Pair.create((Object)request, (Object)existingTask));
            }
            this.myRequests.clear();
        }
        for (Pair request : requests) {
            Object object = this.LOCK;
            synchronized (object) {
                ((Request)request.first).myTask = (Runnable)request.second;
            }
            ((Request)request.first).run();
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void waitForAllExecuted(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Request> requests;
        if (timeUnit == null) {
            Alarm.$$$reportNull$$$0(16);
        }
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            requests = new ArrayList<Request>(this.myRequests);
        }
        for (Request request : requests) {
            void unit;
            Future future;
            Object object = this.LOCK;
            synchronized (object) {
                future = request.myFuture;
            }
            if (future == null) continue;
            future.get(timeout, (TimeUnit)unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveRequestCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.isEmpty();
        }
    }

    protected boolean isEdt() {
        return Alarm.isEventDispatchThread();
    }

    public static boolean isEventDispatchThread() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isDispatchThread() || EventQueue.isDispatchThread();
    }

    @NotNull
    public Alarm setActivationComponent(@NotNull JComponent component) {
        if (component == null) {
            Alarm.$$$reportNull$$$0(17);
        }
        this.myActivationComponent = component;
        new UiNotifyConnector(component, new Activatable(){

            @Override
            public void showNotify() {
                Alarm.this.flushPending();
            }

            @Override
            public void hideNotify() {
            }
        });
        Alarm alarm = this;
        if (alarm == null) {
            Alarm.$$$reportNull$$$0(18);
        }
        return alarm;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadToUse";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestToSchedule";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/Alarm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/Alarm";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setActivationComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRequest";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addComponentRequest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "_addRequest";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "_add";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cancelRequest";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cancelAllRequests";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "waitForAllExecuted";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setActivationComponent";
                break;
            }
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Request
    implements Runnable {
        private Runnable myTask;
        private final ModalityState myModalityState;
        private Future<?> myFuture;
        private final long myDelay;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Debugger.Capture
        private Request(@Nullable Runnable task, ModalityState modalityState, long delayMillis) {
            if (task == null) {
                Request.$$$reportNull$$$0(0);
            }
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                this.myTask = task;
                this.myModalityState = modalityState;
                this.myDelay = delayMillis;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (Alarm.this.myDisposed) {
                    return;
                }
                Object object = Alarm.this.LOCK;
                synchronized (object) {
                    if (this.myTask == null) {
                        return;
                    }
                }
                Runnable scheduledTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Runnable task;
                        Object object = Alarm.this.LOCK;
                        synchronized (object) {
                            task = Request.this.myTask;
                            Request.this.myTask = null;
                        }
                        if (Alarm.this.myThreadToUse == ThreadToUse.SWING_THREAD && !Alarm.this.isEdt()) {
                            EdtInvocationManager.getInstance().invokeLater(() -> Request.this.runSafely(task));
                        } else {
                            Request.this.runSafely(task);
                        }
                    }

                    public String toString() {
                        return "ScheduledTask " + Request.this;
                    }
                };
                if (this.myModalityState == null) {
                    scheduledTask.run();
                } else {
                    Application app = ApplicationManager.getApplication();
                    if (app == null) {
                        SwingUtilities.invokeLater(scheduledTask);
                    } else {
                        app.invokeLater(scheduledTask, this.myModalityState);
                    }
                }
            }
            catch (ProcessCanceledException scheduledTask) {
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Debugger.Insert
        private void runSafely(@Nullable Runnable task) {
            try {
                if (!Alarm.this.myDisposed && task != null) {
                    QueueProcessor.runSafely(task);
                }
            }
            finally {
                Object object = Alarm.this.LOCK;
                synchronized (object) {
                    Alarm.this.myRequests.remove(this);
                    this.myFuture = null;
                }
            }
        }

        private void schedule() {
            this.myFuture = Alarm.this.myExecutorService.schedule(this, this.myDelay, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Runnable cancel() {
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                Future<?> future = this.myFuture;
                if (future != null) {
                    future.cancel(false);
                    this.myFuture = null;
                }
                Runnable task = this.myTask;
                this.myTask = null;
                return task;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Runnable task;
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                task = this.myTask;
            }
            return super.toString() + (task != null ? ": " + task : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/Alarm$Request", "<init>"));
        }
    }

    public static enum ThreadToUse {
        SWING_THREAD,
        SHARED_THREAD,
        POOLED_THREAD,
        OWN_THREAD;

    }
}

