/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.CommonBundle;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcherImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenPomPathModuleService;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenDefaultModelsProvider;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenModelsProvider;
import org.jetbrains.idea.maven.project.MavenModificationTracker;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManagerState;
import org.jetbrains.idea.maven.project.MavenProjectsManagerWatcher;
import org.jetbrains.idea.maven.project.MavenProjectsProcessor;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorArtifactsDownloadingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorEmptyTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorFoldersResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorPluginsResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenResourceCompilerConfigurationGenerator;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;

@State(name="MavenProjectsManager")
public class MavenProjectsManager
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenProjectsManagerState>,
SettingsSavingComponent,
Disposable,
ProjectComponent {
    private static final int IMPORT_DELAY = 1000;
    private static final String NON_MANAGED_POM_NOTIFICATION_GROUP_ID = "Maven: non-managed pom.xml";
    private static final NotificationGroup NON_MANAGED_POM_NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Maven: non-managed pom.xml");
    private final ReentrantLock initLock = new ReentrantLock();
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private MavenProjectsManagerState myState = new MavenProjectsManagerState();
    private final Alarm myInitializationAlarm;
    private final MavenEmbeddersManager myEmbeddersManager;
    private MavenProjectsTree myProjectsTree;
    private MavenProjectsManagerWatcher myWatcher;
    private MavenProjectsProcessor myReadingProcessor;
    private MavenProjectsProcessor myResolvingProcessor;
    private MavenProjectsProcessor myPluginsResolvingProcessor;
    private MavenProjectsProcessor myFoldersResolvingProcessor;
    private MavenProjectsProcessor myArtifactsDownloadingProcessor;
    private MavenProjectsProcessor myPostProcessor;
    private MavenMergingUpdateQueue myImportingQueue;
    private final Object myImportingDataLock = new Object();
    private final Map<MavenProject, MavenProjectChanges> myProjectsToImport = new LinkedHashMap<MavenProject, MavenProjectChanges>();
    private final Set<MavenProject> myProjectsToResolve = new LinkedHashSet<MavenProject>();
    private boolean myImportModuleGroupsRequired = false;
    private final EventDispatcher<MavenProjectsTree.Listener> myProjectsTreeDispatcher = EventDispatcher.create(MavenProjectsTree.Listener.class);
    private final List<Listener> myManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private ModificationTracker myModificationTracker;
    private MavenWorkspaceSettings myWorkspaceSettings;
    private MavenMergingUpdateQueue mySaveQueue;
    private static final int SAVE_DELAY = 1000;

    public static MavenProjectsManager getInstance(Project p) {
        return (MavenProjectsManager)p.getComponent(MavenProjectsManager.class);
    }

    public MavenProjectsManager(Project project) {
        super(project);
        this.myEmbeddersManager = new MavenEmbeddersManager(project);
        this.myModificationTracker = new MavenModificationTracker(this);
        this.myInitializationAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        this.mySaveQueue = new MavenMergingUpdateQueue("Maven save queue", 1000, !this.isUnitTestMode(), this);
    }

    public MavenProjectsManagerState getState() {
        if (this.isInitialized()) {
            this.applyTreeToState();
        }
        return this.myState;
    }

    public void loadState(@NotNull MavenProjectsManagerState state) {
        if (state == null) {
            MavenProjectsManager.$$$reportNull$$$0(0);
        }
        this.myState = state;
        if (this.isInitialized()) {
            this.applyStateToTree();
            this.scheduleUpdateAllProjects(false);
        }
    }

    public void dispose() {
    }

    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public MavenGeneralSettings getGeneralSettings() {
        return this.getWorkspaceSettings().generalSettings;
    }

    public MavenImportingSettings getImportingSettings() {
        return this.getWorkspaceSettings().importingSettings;
    }

    private MavenWorkspaceSettings getWorkspaceSettings() {
        if (this.myWorkspaceSettings == null) {
            this.myWorkspaceSettings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        }
        return this.myWorkspaceSettings;
    }

    public File getLocalRepository() {
        return this.getGeneralSettings().getEffectiveLocalRepository();
    }

    public void initComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        StartupManagerEx startupManager = StartupManagerEx.getInstanceEx((Project)this.myProject);
        startupManager.registerStartupActivity(() -> {
            boolean wasMavenized;
            boolean bl = wasMavenized = !this.myState.originalFiles.isEmpty();
            if (!wasMavenized) {
                return;
            }
            this.initMavenized();
        });
        startupManager.registerPostStartupActivity(() -> {
            if (!this.isMavenizedProject()) {
                this.showNotificationOrphanMavenProject(this.myProject);
            }
            CompilerManager.getInstance((Project)this.myProject).addBeforeTask(new CompileTask(){

                public boolean execute(CompileContext context) {
                    ApplicationManager.getApplication().runReadAction(() -> new MavenResourceCompilerConfigurationGenerator(MavenProjectsManager.this.myProject, MavenProjectsManager.this.myProjectsTree).generateBuildConfiguration(context.isRebuild()));
                    return true;
                }
            });
        });
    }

    private void showNotificationOrphanMavenProject(Project project) {
        NotificationSettings notificationSettings = NotificationsConfigurationImpl.getSettings((String)NON_MANAGED_POM_NOTIFICATION_GROUP_ID);
        if (!notificationSettings.isShouldLog() && notificationSettings.getDisplayType().equals((Object)NotificationDisplayType.NONE)) {
            return;
        }
        List pomFiles = MavenUtil.streamPomFiles(project, project.getBaseDir()).collect(Collectors.toList());
        for (final VirtualFile file : pomFiles) {
            this.showBalloon(ProjectBundle.message("maven.orphan.notification.title", new Object[0]), ProjectBundle.message("maven.orphan.notification.msg", file.getPresentableUrl()), NON_MANAGED_POM_NOTIFICATION_GROUP, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ("#add".equals(e.getDescription())) {
                        MavenProjectsManager.this.addManagedFilesOrUnignore(Collections.singletonList(file));
                        notification.expire();
                    } else if ("#disable".equals(e.getDescription())) {
                        int result = Messages.showYesNoDialog((Project)MavenProjectsManager.this.myProject, (String)"Notification will be disabled for all projects.\n\nSettings | Appearance & Behavior | Notifications | Maven: non-managed pom.xml\ncan be used to configure the notification.", (String)"Non-Managed Maven Project Detection", (String)"Disable Notification", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
                        if (result == 0) {
                            NotificationsConfigurationImpl.getInstanceImpl().changeSettings(MavenProjectsManager.NON_MANAGED_POM_NOTIFICATION_GROUP_ID, NotificationDisplayType.NONE, false, false);
                            notification.expire();
                        } else {
                            notification.hideBalloon();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager$2";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public void showBalloon(@NotNull String title, @NotNull String message, @NotNull NotificationGroup group, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (title == null) {
            MavenProjectsManager.$$$reportNull$$$0(1);
        }
        if (message == null) {
            MavenProjectsManager.$$$reportNull$$$0(2);
        }
        if (group == null) {
            MavenProjectsManager.$$$reportNull$$$0(3);
        }
        if (type == null) {
            MavenProjectsManager.$$$reportNull$$$0(4);
        }
        group.createNotification(title, message, type, listener).notify(this.myProject);
    }

    private void initMavenized() {
        this.doInit(false);
    }

    private void initNew(List<VirtualFile> files, MavenExplicitProfiles explicitProfiles) {
        this.myState.originalFiles = MavenUtil.collectPaths(files);
        this.getWorkspaceSettings().setEnabledProfiles(explicitProfiles.getEnabledProfiles());
        this.getWorkspaceSettings().setDisabledProfiles(explicitProfiles.getDisabledProfiles());
        this.doInit(true);
    }

    public void initForTests() {
        this.doInit(false);
    }

    private void doInit(boolean isNew) {
        this.initLock.lock();
        try {
            if (this.isInitialized.getAndSet(true)) {
                return;
            }
            this.initProjectsTree(!isNew);
            this.initWorkers();
            this.listenForSettingsChanges();
            this.listenForProjectsTreeChanges();
            MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> {
                if (!this.isUnitTestMode()) {
                    this.fireActivated();
                    this.listenForExternalChanges();
                }
                this.scheduleUpdateAllProjects(isNew);
            }));
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void initProjectsTree(boolean tryToLoadExisting) {
        if (tryToLoadExisting) {
            Path file = this.getProjectsTreeFile();
            try {
                if (PathKt.exists((Path)file)) {
                    this.myProjectsTree = MavenProjectsTree.read(this.myProject, file);
                }
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        if (this.myProjectsTree == null) {
            this.myProjectsTree = new MavenProjectsTree(this.myProject);
        }
        this.applyStateToTree();
        this.myProjectsTree.addListener((MavenProjectsTree.Listener)this.myProjectsTreeDispatcher.getMulticaster());
    }

    private void applyTreeToState() {
        this.myState.originalFiles = this.myProjectsTree.getManagedFilesPaths();
        this.myState.ignoredFiles = new THashSet(this.myProjectsTree.getIgnoredFilesPaths());
        this.myState.ignoredPathMasks = this.myProjectsTree.getIgnoredFilesPatterns();
    }

    private void applyStateToTree() {
        MavenWorkspaceSettings settings = this.getWorkspaceSettings();
        MavenExplicitProfiles explicitProfiles = new MavenExplicitProfiles(settings.enabledProfiles, settings.disabledProfiles);
        this.myProjectsTree.resetManagedFilesPathsAndProfiles(this.myState.originalFiles, explicitProfiles);
        this.myProjectsTree.setIgnoredFilesPaths(new ArrayList<String>(this.myState.ignoredFiles));
        this.myProjectsTree.setIgnoredFilesPatterns(this.myState.ignoredPathMasks);
    }

    public void save() {
        if (this.myProjectsTree != null) {
            this.mySaveQueue.queue(new Update(this){

                public void run() {
                    try {
                        MavenProjectsManager.this.myProjectsTree.save(MavenProjectsManager.this.getProjectsTreeFile());
                    }
                    catch (IOException e) {
                        MavenLog.LOG.info((Throwable)e);
                    }
                }
            });
        }
    }

    private Path getProjectsTreeFile() {
        return MavenProjectsManager.getProjectsTreesDir().resolve(this.myProject.getLocationHash()).resolve("tree.dat");
    }

    @NotNull
    private static Path getProjectsTreesDir() {
        Path path = MavenUtil.getPluginSystemDir("Projects");
        if (path == null) {
            MavenProjectsManager.$$$reportNull$$$0(5);
        }
        return path;
    }

    private void initWorkers() {
        this.myReadingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.reading", new Object[0]), false, this.myEmbeddersManager);
        this.myResolvingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.resolving", new Object[0]), true, this.myEmbeddersManager);
        this.myPluginsResolvingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.downloading.plugins", new Object[0]), true, this.myEmbeddersManager);
        this.myFoldersResolvingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.updating.folders", new Object[0]), true, this.myEmbeddersManager);
        this.myArtifactsDownloadingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.downloading", new Object[0]), true, this.myEmbeddersManager);
        this.myPostProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.post.processing", new Object[0]), true, this.myEmbeddersManager);
        this.myWatcher = new MavenProjectsManagerWatcher(this.myProject, this, this.myProjectsTree, this.getGeneralSettings(), this.myReadingProcessor, this.myEmbeddersManager);
        this.myImportingQueue = new MavenMergingUpdateQueue(this.getComponentName() + ": Importing queue", 1000, !this.isUnitTestMode(), (Disposable)this.myProject);
        this.myImportingQueue.setPassThrough(false);
        this.myImportingQueue.makeUserAware(this.myProject);
        this.myImportingQueue.makeDumbAware(this.myProject);
        this.myImportingQueue.makeModalAware(this.myProject);
    }

    private void listenForSettingsChanges() {
        this.getImportingSettings().addListener(new MavenImportingSettings.Listener(){

            @Override
            public void autoImportChanged() {
                if (MavenProjectsManager.this.myProject.isDisposed()) {
                    return;
                }
                if (MavenProjectsManager.this.getImportingSettings().isImportAutomatically()) {
                    MavenProjectsManager.this.scheduleImportAndResolve();
                }
            }

            @Override
            public void createModuleGroupsChanged() {
                MavenProjectsManager.this.scheduleImportSettings(true);
            }

            @Override
            public void createModuleForAggregatorsChanged() {
                MavenProjectsManager.this.scheduleImportSettings();
            }
        });
    }

    private void listenForProjectsTreeChanges() {
        this.myProjectsTree.addListener(new MavenProjectsTree.Listener(){

            @Override
            public void projectsIgnoredStateChanged(List<MavenProject> ignored, List<MavenProject> unignored, boolean fromImport) {
                if (!fromImport) {
                    MavenProjectsManager.this.scheduleImport();
                }
            }

            @Override
            public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
                MavenProject project;
                MavenProjectsManager.this.myEmbeddersManager.clearCaches();
                MavenProjectsManager.this.unscheduleAllTasks(deleted);
                List<MavenProject> updatedProjects = MavenUtil.collectFirsts(updated);
                ArrayList<Pair<MavenProject, MavenProjectChanges>> toImport = new ArrayList<Pair<MavenProject, MavenProjectChanges>>(updated);
                for (MavenProject eachDependent : MavenProjectsManager.this.myProjectsTree.getDependentProjects(updatedProjects)) {
                    toImport.add(Pair.create((Object)eachDependent, (Object)MavenProjectChanges.DEPENDENCIES));
                }
                THashSet toResolve = new THashSet(updatedProjects);
                toResolve.addAll(MavenProjectsManager.this.myProjectsTree.getDependentProjects(ContainerUtil.concat(updatedProjects, deleted)));
                Iterator it = toResolve.iterator();
                while (it.hasNext()) {
                    MavenProject each = (MavenProject)it.next();
                    if (!each.hasReadingProblems()) continue;
                    it.remove();
                }
                if (this.haveChanges(toImport) || !deleted.isEmpty()) {
                    MavenProjectsManager.this.scheduleForNextImport(toImport);
                }
                if (!deleted.isEmpty() && !MavenProjectsManager.this.hasScheduledProjects() && (project = (MavenProject)ObjectUtils.chooseNotNull((Object)ContainerUtil.getFirstItem((Collection)toResolve), (Object)ContainerUtil.getFirstItem(MavenProjectsManager.this.getNonIgnoredProjects()))) != null) {
                    MavenProjectsManager.this.scheduleForNextImport((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)project, (Object)MavenProjectChanges.ALL));
                    MavenProjectsManager.this.scheduleForNextResolve(ContainerUtil.list((Object[])new MavenProject[]{project}));
                }
                MavenProjectsManager.this.scheduleForNextResolve((Collection)toResolve);
                MavenProjectsManager.this.fireProjectScheduled();
            }

            private boolean haveChanges(List<Pair<MavenProject, MavenProjectChanges>> projectsWithChanges) {
                for (MavenProjectChanges each : MavenUtil.collectSeconds(projectsWithChanges)) {
                    if (!each.hasChanges()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
                if (nativeMavenProject != null) {
                    if (this.shouldScheduleProject(projectWithChanges)) {
                        MavenProjectsManager.this.scheduleForNextImport((Pair<MavenProject, MavenProjectChanges>)projectWithChanges);
                        MavenImportingSettings importingSettings = (MavenImportingSettings)ReadAction.compute(() -> MavenProjectsManager.this.myProject.isDisposed() ? null : MavenProjectsManager.this.getImportingSettings());
                        if (importingSettings == null) {
                            return;
                        }
                        MavenProjectsManager.this.scheduleArtifactsDownloading(Collections.singleton(projectWithChanges.first), null, importingSettings.isDownloadSourcesAutomatically(), importingSettings.isDownloadDocsAutomatically(), null);
                    }
                    if (!((MavenProject)projectWithChanges.first).hasReadingProblems() && ((MavenProject)projectWithChanges.first).hasUnresolvedPlugins()) {
                        MavenProjectsManager.this.schedulePluginsResolve((MavenProject)projectWithChanges.first, nativeMavenProject);
                    }
                }
            }

            @Override
            public void foldersResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                if (this.shouldScheduleProject(projectWithChanges)) {
                    MavenProjectsManager.this.scheduleForNextImport((Pair<MavenProject, MavenProjectChanges>)projectWithChanges);
                }
            }

            private boolean shouldScheduleProject(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                return !((MavenProject)projectWithChanges.first).hasReadingProblems() && ((MavenProjectChanges)projectWithChanges.second).hasChanges();
            }
        });
    }

    public void listenForExternalChanges() {
        this.myWatcher.start();
    }

    public void projectClosed() {
        this.initLock.lock();
        try {
            if (!this.isInitialized.getAndSet(false)) {
                return;
            }
            Disposer.dispose((Disposable)this.myImportingQueue);
            this.myWatcher.stop();
            this.myReadingProcessor.stop();
            this.myResolvingProcessor.stop();
            this.myPluginsResolvingProcessor.stop();
            this.myFoldersResolvingProcessor.stop();
            this.myArtifactsDownloadingProcessor.stop();
            this.myPostProcessor.stop();
            this.mySaveQueue.flush();
            if (this.isUnitTestMode()) {
                PathKt.delete((Path)MavenProjectsManager.getProjectsTreesDir());
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    public MavenEmbeddersManager getEmbeddersManager() {
        return this.myEmbeddersManager;
    }

    private boolean isInitialized() {
        return !this.initLock.isLocked() && this.isInitialized.get();
    }

    public boolean isMavenizedProject() {
        return this.isInitialized();
    }

    public boolean isMavenizedModule(@NotNull Module m) {
        if (m == null) {
            MavenProjectsManager.$$$reportNull$$$0(6);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (m == null) {
                MavenProjectsManager.$$$reportNull$$$0(55);
            }
            return !m.isDisposed() && ExternalSystemModulePropertyManager.getInstance((Module)m).isMavenized();
        });
    }

    public void setMavenizedModules(Collection<Module> modules, boolean mavenized) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (Module m : modules) {
            if (m.isDisposed()) continue;
            ExternalSystemModulePropertyManager.getInstance((Module)m).setMavenized(mavenized);
            ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)m)).stateChanged();
        }
    }

    public void resetManagedFilesAndProfilesInTests(List<VirtualFile> files, MavenExplicitProfiles profiles) {
        this.myWatcher.resetManagedFilesAndProfilesInTests(files, profiles);
    }

    public void addManagedFilesWithProfiles(List<VirtualFile> files, MavenExplicitProfiles profiles) {
        if (!this.isInitialized()) {
            this.initNew(files, profiles);
        } else {
            this.myWatcher.addManagedFilesWithProfiles(files, profiles);
        }
        MavenUtil.invokeLater(this.myProject, () -> {
            if (this.myProject == null || !this.myProject.isDefault() && !this.myProject.isDisposed()) {
                for (Notification notification : EventLog.getLogModel((Project)this.myProject).getNotifications()) {
                    if (!NON_MANAGED_POM_NOTIFICATION_GROUP_ID.equals(notification.getGroupId())) continue;
                    for (VirtualFile file : files) {
                        if (!StringUtil.startsWith((CharSequence)notification.getContent(), (CharSequence)file.getPresentableUrl())) continue;
                        notification.expire();
                    }
                }
            }
        });
    }

    public void addManagedFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            MavenProjectsManager.$$$reportNull$$$0(7);
        }
        this.addManagedFilesWithProfiles(files, MavenExplicitProfiles.NONE);
    }

    public void addManagedFilesOrUnignore(@NotNull List<VirtualFile> files) {
        if (files == null) {
            MavenProjectsManager.$$$reportNull$$$0(8);
        }
        this.removeIgnoredFilesPaths(MavenUtil.collectPaths(files));
        this.addManagedFiles(files);
    }

    public void removeManagedFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            MavenProjectsManager.$$$reportNull$$$0(9);
        }
        this.myWatcher.removeManagedFiles(files);
    }

    public boolean isManagedFile(@NotNull VirtualFile f) {
        if (f == null) {
            MavenProjectsManager.$$$reportNull$$$0(10);
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.isManagedFile(f);
    }

    @NotNull
    public MavenExplicitProfiles getExplicitProfiles() {
        if (!this.isInitialized()) {
            MavenExplicitProfiles mavenExplicitProfiles = MavenExplicitProfiles.NONE;
            if (mavenExplicitProfiles == null) {
                MavenProjectsManager.$$$reportNull$$$0(11);
            }
            return mavenExplicitProfiles;
        }
        MavenExplicitProfiles mavenExplicitProfiles = this.myProjectsTree.getExplicitProfiles();
        if (mavenExplicitProfiles == null) {
            MavenProjectsManager.$$$reportNull$$$0(12);
        }
        return mavenExplicitProfiles;
    }

    public void setExplicitProfiles(@NotNull MavenExplicitProfiles profiles) {
        if (profiles == null) {
            MavenProjectsManager.$$$reportNull$$$0(13);
        }
        this.myWatcher.setExplicitProfiles(profiles);
    }

    @NotNull
    public Collection<String> getAvailableProfiles() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(14);
            }
            return list;
        }
        Collection<String> collection = this.myProjectsTree.getAvailableProfiles();
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    public Collection<Pair<String, MavenProfileKind>> getProfilesWithStates() {
        if (!this.isInitialized()) {
            List<Pair<String, MavenProfileKind>> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(16);
            }
            return list;
        }
        Collection<Pair<String, MavenProfileKind>> collection = this.myProjectsTree.getProfilesWithStates();
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(17);
        }
        return collection;
    }

    public boolean hasProjects() {
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.hasProjects();
    }

    @NotNull
    public List<MavenProject> getProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public List<MavenProject> getRootProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(20);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getRootProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public List<MavenProject> getNonIgnoredProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getNonIgnoredProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getProjectsFiles() {
        if (!this.isInitialized()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(24);
            }
            return list;
        }
        List<VirtualFile> list = this.myProjectsTree.getProjectsFiles();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Nullable
    public MavenProject findProject(@NotNull VirtualFile f) {
        if (f == null) {
            MavenProjectsManager.$$$reportNull$$$0(26);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(f);
    }

    @Nullable
    public MavenProject findProject(@NotNull MavenId id) {
        if (id == null) {
            MavenProjectsManager.$$$reportNull$$$0(27);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(id);
    }

    @Nullable
    public MavenProject findProject(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenProjectsManager.$$$reportNull$$$0(28);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(artifact);
    }

    @Nullable
    public MavenProject findProject(@NotNull Module module) {
        VirtualFile f;
        if (module == null) {
            MavenProjectsManager.$$$reportNull$$$0(29);
        }
        return (f = this.findPomFile(module, new MavenModelsProvider(){

            @Override
            public Module[] getModules() {
                throw new UnsupportedOperationException();
            }

            @Override
            public VirtualFile[] getContentRoots(Module module) {
                return ModuleRootManager.getInstance((Module)module).getContentRoots();
            }
        })) == null ? null : this.findProject(f);
    }

    @Nullable
    public Module findModule(@NotNull MavenProject project) {
        if (project == null) {
            MavenProjectsManager.$$$reportNull$$$0(30);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(project.getFile());
    }

    @NotNull
    public Collection<MavenProject> findInheritors(@Nullable MavenProject parent) {
        if (parent == null || !this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(31);
            }
            return list;
        }
        Collection<MavenProject> collection = this.myProjectsTree.findInheritors(parent);
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @Nullable
    public MavenProject findContainingProject(@NotNull VirtualFile file) {
        if (file == null) {
            MavenProjectsManager.$$$reportNull$$$0(33);
        }
        if (!this.isInitialized()) {
            return null;
        }
        Module module = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file);
        return module == null ? null : this.findProject(module);
    }

    @Nullable
    private VirtualFile findPomFile(@NotNull Module module, @NotNull MavenModelsProvider modelsProvider) {
        String pomFileUrl;
        if (module == null) {
            MavenProjectsManager.$$$reportNull$$$0(34);
        }
        if (modelsProvider == null) {
            MavenProjectsManager.$$$reportNull$$$0(35);
        }
        if ((pomFileUrl = MavenPomPathModuleService.getInstance(module).getPomFileUrl()) != null) {
            return VirtualFileManager.getInstance().findFileByUrl(pomFileUrl);
        }
        for (VirtualFile root : modelsProvider.getContentRoots(module)) {
            List pomFiles = MavenUtil.streamPomFiles(module.getProject(), root).collect(Collectors.toList());
            if (pomFiles.isEmpty()) continue;
            if (pomFiles.size() == 1) {
                return (VirtualFile)pomFiles.get(0);
            }
            for (VirtualFile file : pomFiles) {
                if (module.getName().equals(file.getNameWithoutExtension())) {
                    return file;
                }
                MavenProject mavenProject = this.findProject(file);
                if (mavenProject == null || !module.getName().equals(mavenProject.getMavenId().getArtifactId())) continue;
                return file;
            }
        }
        return null;
    }

    @Nullable
    public MavenProject findAggregator(@NotNull MavenProject mavenProject) {
        if (mavenProject == null) {
            MavenProjectsManager.$$$reportNull$$$0(36);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findAggregator(mavenProject);
    }

    @Nullable
    public MavenProject findRootProject(@NotNull MavenProject mavenProject) {
        if (mavenProject == null) {
            MavenProjectsManager.$$$reportNull$$$0(37);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findRootProject(mavenProject);
    }

    @NotNull
    public List<MavenProject> getModules(@NotNull MavenProject aggregator) {
        if (aggregator == null) {
            MavenProjectsManager.$$$reportNull$$$0(38);
        }
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(39);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getModules(aggregator);
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    public List<String> getIgnoredFilesPaths() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(41);
            }
            return list;
        }
        List<String> list = this.myProjectsTree.getIgnoredFilesPaths();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(42);
        }
        return list;
    }

    public void setIgnoredFilesPaths(@NotNull List<String> paths) {
        if (paths == null) {
            MavenProjectsManager.$$$reportNull$$$0(43);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredFilesPaths(paths);
    }

    public void removeIgnoredFilesPaths(Collection<String> paths) {
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.removeIgnoredFilesPaths(paths);
    }

    public boolean getIgnoredState(@NotNull MavenProject project) {
        if (project == null) {
            MavenProjectsManager.$$$reportNull$$$0(44);
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.getIgnoredState(project);
    }

    public void setIgnoredState(@NotNull List<MavenProject> projects, boolean ignored) {
        if (projects == null) {
            MavenProjectsManager.$$$reportNull$$$0(45);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredState(projects, ignored);
    }

    @NotNull
    public List<String> getIgnoredFilesPatterns() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(46);
            }
            return list;
        }
        List<String> list = this.myProjectsTree.getIgnoredFilesPatterns();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(47);
        }
        return list;
    }

    public void setIgnoredFilesPatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            MavenProjectsManager.$$$reportNull$$$0(48);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredFilesPatterns(patterns);
    }

    public boolean isIgnored(@NotNull MavenProject project) {
        if (project == null) {
            MavenProjectsManager.$$$reportNull$$$0(49);
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.isIgnored(project);
    }

    public Set<MavenRemoteRepository> getRemoteRepositories() {
        THashSet result = new THashSet();
        for (MavenProject each : this.getProjects()) {
            result.addAll(each.getRemoteRepositories());
        }
        return result;
    }

    public MavenProjectsTree getProjectsTreeForTests() {
        return this.myProjectsTree;
    }

    private void scheduleUpdateAllProjects(boolean forceImportAndResolve) {
        this.doScheduleUpdateProjects(null, false, forceImportAndResolve);
    }

    public AsyncPromise<Void> forceUpdateProjects(@NotNull Collection<MavenProject> projects) {
        if (projects == null) {
            MavenProjectsManager.$$$reportNull$$$0(50);
        }
        return this.doScheduleUpdateProjects(projects, true, true);
    }

    public void forceUpdateAllProjectsOrFindAllAvailablePomFiles() {
        if (!this.isMavenizedProject()) {
            this.addManagedFiles(this.collectAllAvailablePomFiles());
        }
        this.doScheduleUpdateProjects(null, true, true);
    }

    private AsyncPromise<Void> doScheduleUpdateProjects(Collection<MavenProject> projects, boolean forceUpdate, boolean forceImportAndResolve) {
        AsyncPromise promise = new AsyncPromise();
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> {
            if (projects == null) {
                this.myWatcher.scheduleUpdateAll(forceUpdate, forceImportAndResolve).processed(promise);
            } else {
                this.myWatcher.scheduleUpdate(MavenUtil.collectFiles(projects), Collections.emptyList(), forceUpdate, forceImportAndResolve).processed(promise);
            }
        }));
        return promise;
    }

    public Promise<List<Module>> scheduleImportAndResolve() {
        AsyncPromise<List<Module>> promise = this.scheduleResolve();
        this.fireImportAndResolveScheduled();
        return promise;
    }

    private AsyncPromise<List<Module>> scheduleResolve() {
        AsyncPromise result = new AsyncPromise();
        this.runWhenFullyOpen(() -> {
            LinkedHashSet<MavenProject> toResolve;
            Object object = this.myImportingDataLock;
            synchronized (object) {
                toResolve = new LinkedHashSet<MavenProject>(this.myProjectsToResolve);
                this.myProjectsToResolve.clear();
            }
            if (toResolve.isEmpty()) {
                result.setResult(Collections.emptyList());
                return;
            }
            ResolveContext context = new ResolveContext();
            Runnable onCompletion = () -> {
                if (this.hasScheduledProjects()) {
                    this.scheduleImport().processed(result);
                } else {
                    result.setResult(Collections.emptyList());
                }
            };
            boolean useSinglePomResolver = Boolean.getBoolean("idea.maven.use.single.pom.resolver");
            if (useSinglePomResolver) {
                Iterator it = toResolve.iterator();
                while (it.hasNext()) {
                    MavenProject each = (MavenProject)it.next();
                    this.myResolvingProcessor.scheduleTask(new MavenProjectsProcessorResolvingTask(Collections.singleton(each), this.myProjectsTree, this.getGeneralSettings(), it.hasNext() ? null : onCompletion, context));
                }
            } else {
                this.myResolvingProcessor.scheduleTask(new MavenProjectsProcessorResolvingTask(toResolve, this.myProjectsTree, this.getGeneralSettings(), onCompletion, context));
            }
        });
        return result;
    }

    public void evaluateEffectivePom(final @NotNull MavenProject mavenProject, final @NotNull NullableConsumer<String> consumer) {
        if (mavenProject == null) {
            MavenProjectsManager.$$$reportNull$$$0(51);
        }
        if (consumer == null) {
            MavenProjectsManager.$$$reportNull$$$0(52);
        }
        this.runWhenFullyOpen(() -> {
            if (mavenProject == null) {
                MavenProjectsManager.$$$reportNull$$$0(53);
            }
            if (consumer == null) {
                MavenProjectsManager.$$$reportNull$$$0(54);
            }
            this.myResolvingProcessor.scheduleTask(new MavenProjectsProcessorTask(){

                @Override
                public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    indicator.setText("Evaluating effective POM");
                    MavenProjectsManager.this.myProjectsTree.executeWithEmbedder(mavenProject, MavenProjectsManager.this.getEmbeddersManager(), MavenEmbeddersManager.FOR_DEPENDENCIES_RESOLVE, console, indicator, new MavenProjectsTree.EmbedderTask(){

                        @Override
                        public void run(MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
                            try {
                                MavenExplicitProfiles profiles = mavenProject.getActivatedProfilesIds();
                                String res = embedder.evaluateEffectivePom(mavenProject.getFile(), profiles.getEnabledProfiles(), profiles.getDisabledProfiles());
                                consumer.consume((Object)res);
                            }
                            catch (UnsupportedOperationException e) {
                                consumer.consume(null);
                            }
                        }
                    });
                }
            });
        });
    }

    public void scheduleResolveInTests(Collection<MavenProject> projects) {
        this.scheduleForNextResolve(projects);
        this.scheduleResolve();
    }

    public void scheduleResolveAllInTests() {
        this.scheduleResolveInTests(this.getProjects());
    }

    public void scheduleFoldersResolve(Collection<MavenProject> projects) {
        this.runWhenFullyOpen(() -> {
            Iterator it = projects.iterator();
            while (it.hasNext()) {
                MavenProject each = (MavenProject)it.next();
                Runnable onCompletion = it.hasNext() ? null : () -> {
                    if (this.hasScheduledProjects()) {
                        this.scheduleImport();
                    }
                };
                this.myFoldersResolvingProcessor.scheduleTask(new MavenProjectsProcessorFoldersResolvingTask(each, this.getImportingSettings(), this.myProjectsTree, onCompletion));
            }
        });
    }

    public void scheduleFoldersResolveForAllProjects() {
        this.scheduleFoldersResolve(this.getProjects());
    }

    private void schedulePluginsResolve(MavenProject project, NativeMavenProjectHolder nativeMavenProject) {
        this.runWhenFullyOpen(() -> this.myPluginsResolvingProcessor.scheduleTask(new MavenProjectsProcessorPluginsResolvingTask(project, nativeMavenProject, this.myProjectsTree)));
    }

    public void scheduleArtifactsDownloading(Collection<MavenProject> projects, @Nullable Collection<MavenArtifact> artifacts, boolean sources, boolean docs, @Nullable AsyncResult<MavenArtifactDownloader.DownloadResult> result) {
        if (!sources && !docs) {
            return;
        }
        this.runWhenFullyOpen(() -> this.myArtifactsDownloadingProcessor.scheduleTask(new MavenProjectsProcessorArtifactsDownloadingTask(projects, artifacts, this.myProjectsTree, sources, docs, result)));
    }

    private void scheduleImportSettings() {
        this.scheduleImportSettings(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleImportSettings(boolean importModuleGroupsRequired) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            this.myImportModuleGroupsRequired = importModuleGroupsRequired;
        }
        this.scheduleImport();
    }

    private Promise<List<Module>> scheduleImport() {
        final AsyncPromise result = new AsyncPromise();
        this.runWhenFullyOpen(() -> this.myImportingQueue.queue(new Update(this){

            public void run() {
                result.setResult(MavenProjectsManager.this.importProjects());
            }
        }));
        return result;
    }

    public void scheduleImportInTests(List<VirtualFile> projectFiles) {
        ArrayList<Pair<MavenProject, MavenProjectChanges>> toImport = new ArrayList<Pair<MavenProject, MavenProjectChanges>>();
        for (VirtualFile each : projectFiles) {
            MavenProject project = this.findProject(each);
            if (project == null) continue;
            toImport.add((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)project, (Object)MavenProjectChanges.ALL));
        }
        this.scheduleForNextImport(toImport);
        this.scheduleImport();
    }

    private void scheduleForNextImport(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        this.scheduleForNextImport(Collections.singletonList(projectWithChanges));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleForNextImport(Collection<Pair<MavenProject, MavenProjectChanges>> projectsWithChanges) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            for (Pair<MavenProject, MavenProjectChanges> each : projectsWithChanges) {
                MavenProjectChanges changes = ((MavenProjectChanges)each.second).mergedWith(this.myProjectsToImport.get(each.first));
                this.myProjectsToImport.put((MavenProject)each.first, changes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleForNextResolve(Collection<MavenProject> projects) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            this.myProjectsToResolve.addAll(projects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasScheduledProjects() {
        if (!this.isInitialized()) {
            return false;
        }
        Object object = this.myImportingDataLock;
        synchronized (object) {
            return !this.myProjectsToImport.isEmpty() || !this.myProjectsToResolve.isEmpty();
        }
    }

    public boolean hasScheduledImportsInTests() {
        if (!this.isInitialized()) {
            return false;
        }
        return !this.myImportingQueue.isEmpty();
    }

    public void performScheduledImportInTests() {
        if (!this.isInitialized()) {
            return;
        }
        this.runWhenFullyOpen(() -> this.myImportingQueue.flush());
    }

    private void runWhenFullyOpen(Runnable runnable) {
        if (!this.isInitialized()) {
            return;
        }
        if (this.isNoBackgroundMode()) {
            runnable.run();
            return;
        }
        Ref wrapper = new Ref();
        wrapper.set(() -> {
            if (!StartupManagerEx.getInstanceEx((Project)this.myProject).postStartupActivityPassed()) {
                this.myInitializationAlarm.addRequest((Runnable)wrapper.get(), 1000);
                return;
            }
            runnable.run();
        });
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)wrapper.get());
    }

    private void schedulePostImportTasks(List<MavenProjectsProcessorTask> postTasks) {
        for (MavenProjectsProcessorTask each : postTasks) {
            this.myPostProcessor.scheduleTask(each);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unscheduleAllTasks(List<MavenProject> projects) {
        for (MavenProject each : projects) {
            MavenProjectsProcessorEmptyTask dummyTask = new MavenProjectsProcessorEmptyTask(each);
            Object object = this.myImportingDataLock;
            synchronized (object) {
                this.myProjectsToImport.remove(each);
                this.myProjectsToResolve.remove(each);
            }
            this.myResolvingProcessor.removeTask(dummyTask);
            this.myPluginsResolvingProcessor.removeTask(dummyTask);
            this.myFoldersResolvingProcessor.removeTask(dummyTask);
            this.myPostProcessor.removeTask(dummyTask);
        }
    }

    public void unscheduleAllTasksInTests() {
        this.unscheduleAllTasks(this.getProjects());
    }

    public void waitForReadingCompletion() {
        this.waitForTasksCompletion(null);
    }

    public void waitForResolvingCompletion() {
        this.waitForTasksCompletion(this.myResolvingProcessor);
    }

    public void waitForFoldersResolvingCompletion() {
        this.waitForTasksCompletion(this.myFoldersResolvingProcessor);
    }

    public void waitForPluginsResolvingCompletion() {
        this.waitForTasksCompletion(this.myPluginsResolvingProcessor);
    }

    public void waitForArtifactsDownloadingCompletion() {
        this.waitForTasksCompletion(this.myArtifactsDownloadingProcessor);
    }

    public void waitForPostImportTasksCompletion() {
        this.myPostProcessor.waitForCompletion();
    }

    private void waitForTasksCompletion(MavenProjectsProcessor processor) {
        FileDocumentManager.getInstance().saveAllDocuments();
        this.myReadingProcessor.waitForCompletion();
        if (processor != null) {
            processor.waitForCompletion();
        }
    }

    public void updateProjectTargetFolders() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            MavenFoldersImporter.updateProjectFolders(this.myProject, true);
            VirtualFileManager.getInstance().asyncRefresh(null);
        });
    }

    public List<Module> importProjects() {
        return this.importProjects((IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(this.myProject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Module> importProjects(final IdeModifiableModelsProvider modelsProvider) {
        List<Module> createdModules;
        boolean importModuleGroupsRequired;
        Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges;
        Object object = this.myImportingDataLock;
        synchronized (object) {
            projectsToImportWithChanges = Collections.unmodifiableMap(new LinkedHashMap<MavenProject, MavenProjectChanges>(this.myProjectsToImport));
            this.myProjectsToImport.clear();
            importModuleGroupsRequired = this.myImportModuleGroupsRequired;
            this.myImportModuleGroupsRequired = false;
        }
        Ref importer = new Ref();
        Ref postTasks = new Ref();
        final Runnable r = () -> {
            MavenProjectImporter projectImporter = new MavenProjectImporter(this.myProject, this.myProjectsTree, this.getFileToModuleMapping(new MavenModelsProvider(){

                @Override
                public Module[] getModules() {
                    return modelsProvider.getModules();
                }

                @Override
                public VirtualFile[] getContentRoots(Module module) {
                    return modelsProvider.getContentRoots(module);
                }
            }), projectsToImportWithChanges, importModuleGroupsRequired, modelsProvider, this.getImportingSettings());
            importer.set((Object)projectImporter);
            postTasks.set(projectImporter.importProject());
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            r.run();
        } else {
            MavenUtil.runInBackground(this.myProject, ProjectBundle.message("maven.project.importing", new Object[0]), false, new MavenTask(){

                @Override
                public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    r.run();
                }
            }).waitFor();
        }
        VirtualFileManager fm = VirtualFileManager.getInstance();
        if (this.isNormalProject()) {
            fm.asyncRefresh(null);
        } else {
            fm.syncRefresh();
        }
        if (postTasks.get() != null) {
            this.schedulePostImportTasks((List)postTasks.get());
        }
        this.myImportingQueue.restartTimer();
        MavenProjectImporter projectImporter = (MavenProjectImporter)importer.get();
        List<Object> list = createdModules = projectImporter == null ? Collections.emptyList() : projectImporter.getCreatedModules();
        if (!projectsToImportWithChanges.isEmpty()) {
            ((MavenImportListener)this.myProject.getMessageBus().syncPublisher(MavenImportListener.TOPIC)).importFinished(projectsToImportWithChanges.keySet(), createdModules);
        }
        return createdModules;
    }

    private Map<VirtualFile, Module> getFileToModuleMapping(MavenModelsProvider modelsProvider) {
        THashMap result = new THashMap();
        for (Module each : modelsProvider.getModules()) {
            VirtualFile f = this.findPomFile(each, modelsProvider);
            if (f == null) continue;
            result.put(f, each);
        }
        return result;
    }

    private List<VirtualFile> collectAllAvailablePomFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.getFileToModuleMapping(new MavenDefaultModelsProvider(this.myProject)).keySet());
        MavenUtil.streamPomFiles(this.myProject, this.myProject.getBaseDir()).forEach(result::add);
        return result;
    }

    public void addManagerListener(Listener listener) {
        this.myManagerListeners.add(listener);
    }

    public void addProjectsTreeListener(MavenProjectsTree.Listener listener) {
        this.myProjectsTreeDispatcher.addListener((EventListener)listener);
    }

    public void fireActivatedInTests() {
        this.fireActivated();
    }

    private void fireActivated() {
        for (Listener each : this.myManagerListeners) {
            each.activated();
        }
    }

    private void fireProjectScheduled() {
        for (Listener each : this.myManagerListeners) {
            each.projectsScheduled();
        }
    }

    private void fireImportAndResolveScheduled() {
        for (Listener each : this.myManagerListeners) {
            each.importAndResolveScheduled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectsManager";
                break;
            }
            case 6: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 30: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 36: 
            case 37: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aggregator";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsTreesDir";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitProfiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableProfiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilesWithStates";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjects";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProjects";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonIgnoredProjects";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsFiles";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findInheritors";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesPaths";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showBalloon";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMavenizedModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addManagedFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addManagedFilesOrUnignore";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeManagedFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isManagedFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setExplicitProfiles";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findContainingProject";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findPomFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findAggregator";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findRootProject";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesPaths";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredState";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredState";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesPatterns";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "forceUpdateProjects";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateEffectivePom$8";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isMavenizedModule$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExternalWatcherContributor
    implements ExternalSystemProjectsWatcherImpl.Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project project) {
            if (project == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(0);
            }
            ExternalWatcherContributor.runWhenFullyOpen(project, manager -> ((MavenProjectsManager)manager).doScheduleUpdateProjects(null, true, false));
        }

        public void markDirty(@NotNull Module module) {
            if (module == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(1);
            }
            ExternalWatcherContributor.runWhenFullyOpen(module.getProject(), manager -> {
                MavenProject mavenProject;
                if (module == null) {
                    ExternalWatcherContributor.$$$reportNull$$$0(5);
                }
                if ((mavenProject = manager.findProject(module)) != null) {
                    ((MavenProjectsManager)manager).doScheduleUpdateProjects(ContainerUtil.list((Object[])new MavenProject[]{mavenProject}), true, false);
                }
            });
        }

        private static void runWhenFullyOpen(@NotNull Project project, @NotNull Consumer<MavenProjectsManager> consumer) {
            if (project == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(3);
            }
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
            manager.runWhenFullyOpen(() -> {
                if (consumer == null) {
                    ExternalWatcherContributor.$$$reportNull$$$0(4);
                }
                consumer.accept(manager);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager$ExternalWatcherContributor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markDirtyAllExternalProjects";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markDirty";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runWhenFullyOpen";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$runWhenFullyOpen$2";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$markDirty$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener {
        default public void activated() {
        }

        default public void projectsScheduled() {
        }

        default public void importAndResolveScheduled() {
        }
    }
}

