/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiType;
import com.intellij.ui.UIBundle;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.binding.BoundIconRenderer;
import com.intellij.uiDesigner.binding.ChangeBoundFieldTypeFix;
import com.intellij.uiDesigner.binding.ChangeFormComponentTypeFix;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.binding.FormReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FormClassAnnotator
implements Annotator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.binding.FormClassAnnotator");

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        PsiClass aClass;
        List<PsiFile> formsBoundToClass;
        if (psiElement == null) {
            FormClassAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            FormClassAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof PsiField) {
            PsiField field = (PsiField)psiElement;
            PsiFile boundForm = FormReferenceProvider.getFormFile(field);
            if (boundForm != null) {
                FormClassAnnotator.annotateFormField(field, boundForm, holder);
            }
        } else if (psiElement instanceof PsiClass && (formsBoundToClass = FormClassIndex.findFormsBoundToClass((aClass = (PsiClass)psiElement).getProject(), aClass)).size() > 0) {
            Annotation boundClassAnnotation = holder.createInfoAnnotation((PsiElement)aClass.getNameIdentifier(), null);
            boundClassAnnotation.setGutterIconRenderer((GutterIconRenderer)new BoundIconRenderer((PsiElement)aClass));
        }
    }

    private static void annotateFormField(final PsiField field, PsiFile boundForm, AnnotationHolder holder) {
        PsiType fieldType;
        Annotation boundFieldAnnotation = holder.createInfoAnnotation((PsiElement)field, null);
        boundFieldAnnotation.setGutterIconRenderer((GutterIconRenderer)new BoundIconRenderer((PsiElement)field));
        LOG.assertTrue(boundForm instanceof PsiPlainTextFile);
        PsiType guiComponentType = FormReferenceProvider.getGUIComponentType((PsiPlainTextFile)boundForm, field.getName());
        if (guiComponentType != null && !(fieldType = field.getType()).isAssignableFrom(guiComponentType)) {
            String message = UIDesignerBundle.message("bound.field.type.mismatch", guiComponentType.getCanonicalText(), fieldType.getCanonicalText());
            Annotation annotation = holder.createErrorAnnotation((PsiElement)field.getTypeElement(), message);
            annotation.registerFix((IntentionAction)new ChangeFormComponentTypeFix((PsiPlainTextFile)boundForm, field.getName(), field.getType()), null, null);
            annotation.registerFix((IntentionAction)new ChangeBoundFieldTypeFix(field, guiComponentType), null, null);
        }
        if (field.hasInitializer()) {
            final String message = UIDesignerBundle.message("field.is.overwritten.by.generated.code", field.getName());
            Annotation annotation = holder.createWarningAnnotation((PsiElement)field.getInitializer(), message);
            annotation.registerFix(new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = message;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = UIBundle.message((String)"remove.field.initializer.quick.fix", (Object[])new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return field.getInitializer() != null;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    PsiExpression initializer = field.getInitializer();
                    LOG.assertTrue(initializer != null);
                    initializer.delete();
                }

                public boolean startInWriteAction() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 2: 
                        case 3: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/uiDesigner/binding/FormClassAnnotator$1";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/uiDesigner/binding/FormClassAnnotator$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isAvailable";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "invoke";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/uiDesigner/binding/FormClassAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

