/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.impl.YAMLArrayImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;
import org.jetbrains.yaml.psi.impl.YAMLHashImpl;

public class YAMLFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    private static final int PLACEHOLDER_LEN = 20;

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(1);
        }
        LinkedList<FoldingDescriptor> descriptors = new LinkedList<FoldingDescriptor>();
        YAMLFoldingBuilder.collectDescriptors(root, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    private static void collectDescriptors(@NotNull PsiElement element, @NotNull List<FoldingDescriptor> descriptors) {
        TextRange nodeTextRange;
        if (element == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(4);
        }
        if ((nodeTextRange = element.getTextRange()).getLength() < 2) {
            return;
        }
        if (element instanceof YAMLDocument) {
            if (PsiTreeUtil.findChildrenOfAnyType((PsiElement)element.getParent(), (Class[])new Class[]{YAMLDocument.class}).size() > 1) {
                descriptors.add(new FoldingDescriptor(element, nodeTextRange));
            }
        } else if (element instanceof YAMLScalar || element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getValue() instanceof YAMLCompoundValue) {
            descriptors.add(new FoldingDescriptor(element, nodeTextRange));
        }
        for (PsiElement child : element.getChildren()) {
            YAMLFoldingBuilder.collectDescriptors(child, descriptors);
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(5);
        }
        return YAMLFoldingBuilder.getPlaceholderText(SourceTreeToPsiMap.treeElementToPsi((ASTNode)node));
    }

    @NotNull
    private static String getPlaceholderText(@Nullable PsiElement psiElement) {
        if (psiElement instanceof YAMLDocument) {
            if ("---" == null) {
                YAMLFoldingBuilder.$$$reportNull$$$0(6);
            }
            return "---";
        }
        if (psiElement instanceof YAMLScalar) {
            String string = YAMLFoldingBuilder.normalizePlaceHolderText(((YAMLScalar)psiElement).getTextValue());
            if (string == null) {
                YAMLFoldingBuilder.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (psiElement instanceof YAMLSequence) {
            int size = ((YAMLSequence)psiElement).getItems().size();
            String placeholder = size + " " + StringUtil.pluralize((String)"item", (int)size);
            if (psiElement instanceof YAMLArrayImpl) {
                String string = "[" + placeholder + "]";
                if (string == null) {
                    YAMLFoldingBuilder.$$$reportNull$$$0(8);
                }
                return string;
            }
            if (psiElement instanceof YAMLBlockSequenceImpl) {
                String string = "<" + placeholder + ">";
                if (string == null) {
                    YAMLFoldingBuilder.$$$reportNull$$$0(9);
                }
                return string;
            }
        } else if (psiElement instanceof YAMLMapping) {
            int size = ((YAMLMapping)psiElement).getKeyValues().size();
            String placeholder = size + " " + StringUtil.pluralize((String)"key", (int)size);
            if (psiElement instanceof YAMLHashImpl) {
                String string = "{" + placeholder + "}";
                if (string == null) {
                    YAMLFoldingBuilder.$$$reportNull$$$0(10);
                }
                return string;
            }
            if (psiElement instanceof YAMLBlockMappingImpl) {
                String string = "<" + placeholder + ">";
                if (string == null) {
                    YAMLFoldingBuilder.$$$reportNull$$$0(11);
                }
                return string;
            }
        } else if (psiElement instanceof YAMLKeyValue) {
            String string = YAMLFoldingBuilder.normalizePlaceHolderText(((YAMLKeyValue)psiElement).getKeyText()) + ": " + YAMLFoldingBuilder.getPlaceholderText((PsiElement)((YAMLKeyValue)psiElement).getValue());
            if (string == null) {
                YAMLFoldingBuilder.$$$reportNull$$$0(12);
            }
            return string;
        }
        if ("..." == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(13);
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(14);
        }
        return false;
    }

    private static String normalizePlaceHolderText(@Nullable String text) {
        if (text == null) {
            return null;
        }
        if (text.length() <= 20) {
            return text;
        }
        return StringUtil.trimMiddle((String)text, (int)20);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/folding/YAMLFoldingBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/folding/YAMLFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

