/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.meta.impl.YamlDebugUtil;
import org.jetbrains.yaml.meta.impl.YamlKeyInsertHandlerImpl;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaClass;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Experimental
public abstract class YamlMetaTypeCompletionProviderBase
extends CompletionProvider<CompletionParameters> {
    protected static final Logger LOG = Logger.getInstance(YamlMetaTypeCompletionProviderBase.class);

    @Nullable
    protected abstract YamlMetaTypeProvider getMetaTypeProvider(@NotNull CompletionParameters var1);

    protected void addCompletions(@NotNull CompletionParameters params, ProcessingContext context, @NotNull CompletionResultSet result) {
        YamlMetaTypeProvider metaTypeProvider;
        if (params == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(0);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(1);
        }
        if ((metaTypeProvider = this.getMetaTypeProvider(params)) == null) {
            return;
        }
        PsiElement position = params.getPosition();
        if (!YamlMetaTypeCompletionProviderBase.isOfType(position.getParent(), YAMLElementTypes.SCALAR_PLAIN_VALUE)) {
            return;
        }
        YAMLScalar insertedScalar = (YAMLScalar)position.getParent();
        if (insertedScalar.getTextRange().getStartOffset() < params.getOffset()) {
            int positionOffset = params.getOffset() - insertedScalar.getTextRange().getStartOffset();
            assert (positionOffset > 0);
            String combinedText = insertedScalar.getText();
            if (positionOffset >= combinedText.length()) {
                return;
            }
            if (combinedText.charAt(positionOffset - 1) == ':') {
                YamlMetaTypeCompletionProviderBase.trace("Completion rejected: misplaced just after key position : " + YamlDebugUtil.getDebugInfo(position));
                return;
            }
        }
        YamlMetaTypeProvider.MetaTypeProxy meta = metaTypeProvider.getMetaTypeProxy((PsiElement)insertedScalar);
        YamlMetaTypeCompletionProviderBase.trace("meta: " + meta);
        if (meta == null) {
            return;
        }
        YamlMetaType metaType = meta.getMetaType();
        if (params.getCompletionType().equals((Object)CompletionType.BASIC) && metaType instanceof YamlScalarType) {
            PsiElement prevSibling;
            YamlScalarType scalarType = (YamlScalarType)metaType;
            if (insertedScalar.getParent() instanceof YAMLKeyValue && YamlMetaTypeCompletionProviderBase.isOfType(prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)insertedScalar), YAMLTokenTypes.SCALAR_KEY)) {
                YamlMetaTypeCompletionProviderBase.addValueCompletions(insertedScalar, scalarType, result, Collections.emptyMap());
                return;
            }
            if (insertedScalar.getParent() instanceof YAMLSequenceItem) {
                YAMLSequenceItem currentItem = (YAMLSequenceItem)insertedScalar.getParent();
                List siblingItems = Optional.ofNullable(currentItem.getParent()).filter(YAMLSequence.class::isInstance).map(YAMLSequence.class::cast).map(YAMLSequence::getItems).orElse(Collections.emptyList());
                Map<String, YAMLScalar> siblingValues = siblingItems.stream().filter(i -> i.getKeysValues().isEmpty()).filter(i -> !currentItem.equals(i)).map(YAMLSequenceItem::getValue).filter(Objects::nonNull).filter(YAMLScalar.class::isInstance).map(YAMLScalar.class::cast).collect(Collectors.toMap(scalar -> scalar.getText().trim(), scalar -> scalar));
                YamlMetaTypeCompletionProviderBase.addValueCompletions(insertedScalar, scalarType, result, siblingValues);
                return;
            }
        }
        if (metaType instanceof YamlMetaClass) {
            YamlMetaTypeCompletionProviderBase.addKeyCompletions(params, metaTypeProvider, meta, result, (PsiElement)insertedScalar);
        }
    }

    private static void addKeyCompletions(@NotNull CompletionParameters params, @NotNull YamlMetaTypeProvider metaTypeProvider, @NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull CompletionResultSet result, @NotNull PsiElement insertedScalar) {
        boolean needsSequenceItemMark;
        if (params == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(2);
        }
        if (metaTypeProvider == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(3);
        }
        if (meta == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(4);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(5);
        }
        if (insertedScalar == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(6);
        }
        if (!(meta.getMetaType() instanceof YamlMetaClass)) {
            return;
        }
        YamlMetaClass metaClass = (YamlMetaClass)meta.getMetaType();
        YAMLValue metaOwner = metaTypeProvider.getMetaOwner(insertedScalar);
        if (metaOwner instanceof YAMLScalar && metaOwner.getParent() instanceof YAMLMapping) {
            metaOwner = (YAMLValue)metaOwner.getParent();
        }
        Collection existingPairs = Optional.ofNullable(metaOwner).filter(YAMLMapping.class::isInstance).map(YAMLMapping.class::cast).map(YAMLMapping::getKeyValues).orElse(Collections.emptyList());
        Map<String, YAMLKeyValue> existingByKey = existingPairs.stream().collect(Collectors.toMap(kv -> kv.getKeyText().trim(), kv -> kv, (oldValue, newValue) -> oldValue));
        List<Field> fieldList = metaClass.getFeatures().stream().filter(childField -> !existingByKey.containsKey(childField.getName()) && childField.isEditable()).collect(Collectors.toList());
        boolean bl = needsSequenceItemMark = existingPairs.isEmpty() && YamlMetaTypeCompletionProviderBase.needsSequenceItem(meta.getField());
        if (params.getCompletionType() == CompletionType.SMART) {
            String text = insertedScalar.getText();
            int caretPos = text.indexOf(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
            String pattern = (caretPos >= 0 ? text.substring(0, caretPos) : text).toLowerCase();
            Collection<List<Field>> paths = YamlMetaTypeCompletionProviderBase.collectPaths(fieldList, pattern.length() > 0 ? 10 : 1);
            for (List<Field> pathToInsert : paths) {
                Field lastField = pathToInsert.get(pathToInsert.size() - 1);
                if (!lastField.getName().toLowerCase().startsWith(pattern)) continue;
                YamlMetaType.ForcedCompletionPath completionPath = YamlMetaType.ForcedCompletionPath.forDeepCompletion(pathToInsert);
                LookupElementBuilder l = LookupElementBuilder.create((Object)completionPath, (String)completionPath.getName()).withIcon(lastField.getLookupIcon()).withInsertHandler((InsertHandler)new YamlKeyInsertHandlerImpl(needsSequenceItemMark, pathToInsert.get(0))).withTypeText(lastField.getDefaultType().getDisplayName(), true).withStrikeoutness(lastField.isDeprecated());
                result.addElement((LookupElement)l);
            }
        } else {
            fieldList.stream().filter(childField -> !existingByKey.containsKey(childField.getName())).forEach(childField -> {
                if (result == null) {
                    YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(24);
                }
                if (insertedScalar == null) {
                    YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(25);
                }
                YamlMetaTypeCompletionProviderBase.registerBasicKeyCompletion(childField, result, insertedScalar, needsSequenceItemMark);
            });
        }
    }

    private static boolean needsSequenceItem(@NotNull Field parentField) {
        if (parentField == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(7);
        }
        return parentField.isMany() && !parentField.hasRelationSpecificType(Field.Relation.OBJECT_CONTENTS);
    }

    private static void registerBasicKeyCompletion(@NotNull Field toBeInserted, @NotNull CompletionResultSet result, @NotNull PsiElement insertedScalar, boolean needsSequenceItemMark) {
        List<LookupElementBuilder> lookups;
        if (toBeInserted == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(8);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(9);
        }
        if (insertedScalar == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(10);
        }
        if (!(lookups = toBeInserted.getKeyLookups(insertedScalar)).isEmpty()) {
            YamlKeyInsertHandlerImpl keyInsertHandler = new YamlKeyInsertHandlerImpl(needsSequenceItemMark, toBeInserted);
            lookups.stream().map(l -> l.withInsertHandler(keyInsertHandler)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }
    }

    @NotNull
    private static Collection<List<Field>> collectPaths(@NotNull Collection<Field> fields, int deepness) {
        if (fields == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(11);
        }
        ArrayList<List<Field>> result = new ArrayList<List<Field>>();
        YamlMetaTypeCompletionProviderBase.doCollectPathsRec(fields, Collections.emptyList(), result, deepness);
        ArrayList<List<Field>> arrayList = result;
        if (arrayList == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static void doCollectPathsRec(@NotNull Collection<Field> fields, @NotNull List<Field> currentPath, @NotNull Collection<List<Field>> result, int deepness) {
        if (fields == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(13);
        }
        if (currentPath == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(14);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(15);
        }
        if (currentPath.size() >= deepness) {
            return;
        }
        fields.forEach(field -> {
            if (currentPath == null) {
                YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(22);
            }
            if (result == null) {
                YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(23);
            }
            List<Field> fieldPath = Stream.concat(currentPath.stream(), Stream.of(field)).collect(Collectors.toList());
            result.add(fieldPath);
            YamlMetaType metaType = field.getType(field.getDefaultRelation());
            if (metaType instanceof YamlMetaClass && !field.isAnyNameAllowed()) {
                YamlMetaTypeCompletionProviderBase.doCollectPathsRec(((YamlMetaClass)metaType).getFeatures().stream().filter(Field::isEditable).collect(Collectors.toList()), fieldPath, result, deepness);
            }
        });
    }

    private static void addValueCompletions(@NotNull YAMLScalar insertedScalar, @NotNull YamlScalarType meta, @NotNull CompletionResultSet result, @NotNull Map<String, YAMLScalar> siblings) {
        if (insertedScalar == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(16);
        }
        if (meta == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(17);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(18);
        }
        if (siblings == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(19);
        }
        meta.getValueLookups(insertedScalar).stream().filter(lookup -> {
            if (siblings == null) {
                YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(21);
            }
            return !siblings.containsKey(lookup.getLookupString());
        }).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
    }

    private static void trace(String text) {
        LOG.trace(text);
    }

    private static boolean isOfType(@Nullable PsiElement psi, @NotNull IElementType type) {
        if (type == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(20);
        }
        return psi != null && psi.getNode().getElementType() == type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 15: 
            case 18: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaTypeProvider";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 6: 
            case 10: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedScalar";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentField";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toBeInserted";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlMetaTypeCompletionProviderBase";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPath";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblings";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlMetaTypeCompletionProviderBase";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addKeyCompletions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "needsSequenceItem";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerBasicKeyCompletion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectPaths";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doCollectPathsRec";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addValueCompletions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isOfType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addValueCompletions$12";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCollectPathsRec$11";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addKeyCompletions$9";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

