/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.bundled;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import groovy.lang.GroovyObject;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\b\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0005\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"bundledGroovyFile", "Ljava/io/File;", "getBundledGroovyFile", "()Ljava/io/File;", "bundledGroovyFile$delegate", "Lkotlin/Lazy;", "bundledGroovyJarRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBundledGroovyJarRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "bundledGroovyJarRoot$delegate", "createBundledGroovyScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "doGetBundledGroovyFile", "doGetBundledGroovyRoot", "intellij.groovy"})
@JvmName(name="BundledGroovy")
public final class BundledGroovy {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private static final Lazy bundledGroovyFile$delegate;
    @Nullable
    private static final Lazy bundledGroovyJarRoot$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(BundledGroovy.class, (String)"intellij.groovy"), "bundledGroovyFile", "getBundledGroovyFile()Ljava/io/File;")), (KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(BundledGroovy.class, (String)"intellij.groovy"), "bundledGroovyJarRoot", "getBundledGroovyJarRoot()Lcom/intellij/openapi/vfs/VirtualFile;"))};
        bundledGroovyFile$delegate = LazyKt.lazy((Function0)bundledGroovyFile.2.INSTANCE);
        bundledGroovyJarRoot$delegate = LazyKt.lazy((Function0)bundledGroovyJarRoot.2.INSTANCE);
    }

    @NotNull
    public static final File getBundledGroovyFile() {
        Lazy lazy = bundledGroovyFile$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        return (File)lazy.getValue();
    }

    private static final File doGetBundledGroovyFile() {
        String string = PathManager.getJarPathForClass(GroovyObject.class);
        if (string == null) {
            String string2 = "Cannot find JAR containing groovy classes";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String jarPath = string;
        File jar = new File(jarPath);
        boolean bl = GroovyConfigUtils.GROOVY_ALL_JAR_PATTERN.matcher(jar.getName()).matches();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Incorrect path to groovy JAR: " + jarPath;
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        return jar;
    }

    @Nullable
    public static final VirtualFile getBundledGroovyJarRoot() {
        Lazy lazy = bundledGroovyJarRoot$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[1];
        return (VirtualFile)lazy.getValue();
    }

    private static final VirtualFile doGetBundledGroovyRoot() {
        File jar = BundledGroovy.getBundledGroovyFile();
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)jar, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile jarFile = virtualFile;
        return JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
    }

    @Nullable
    public static final GlobalSearchScope createBundledGroovyScope(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile = BundledGroovy.getBundledGroovyJarRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        return GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)root, (boolean)true);
    }

    @NotNull
    public static final /* synthetic */ File access$doGetBundledGroovyFile() {
        return BundledGroovy.doGetBundledGroovyFile();
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$doGetBundledGroovyRoot() {
        return BundledGroovy.doGetBundledGroovyRoot();
    }
}

