/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.cs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.cs.GrReplaceMultiAssignmentFixKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0017J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/cs/GrReplaceMultiAssignmentFix;", "Lorg/jetbrains/plugins/groovy/codeInspection/GroovyFix;", "size", "", "(I)V", "getSize", "()I", "doFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generateListLiteral", "", "varName", "generateVariableName", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "getFamilyName", "getName", "intellij.groovy"})
public final class GrReplaceMultiAssignmentFix
extends GroovyFix {
    private final int size;

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        if (!(psiElement instanceof GrExpression)) {
            psiElement = null;
        }
        GrExpression grExpression = (GrExpression)psiElement;
        if (grExpression == null) {
            return;
        }
        GrExpression element = grExpression;
        PsiElement psiElement2 = element.getParent();
        if (!(psiElement2 instanceof GrStatement)) {
            psiElement2 = null;
        }
        GrStatement grStatement = (GrStatement)psiElement2;
        if (grStatement == null) {
            return;
        }
        GrStatement grStatement2 = grStatement;
        PsiElement psiElement3 = grStatement2.getParent();
        if (!(psiElement3 instanceof GrStatementOwner)) {
            psiElement3 = null;
        }
        GrStatementOwner grStatementOwner = (GrStatementOwner)psiElement3;
        if (grStatementOwner == null) {
            return;
        }
        GrStatementOwner grStatementOwner2 = grStatementOwner;
        String initializer = element.getText();
        if (!(element instanceof GrReferenceExpression) || !(((GrReferenceExpression)element).resolve() instanceof GrVariable)) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
            String fixVariableName = this.generateVariableName(element);
            GrStatement varDefinition = factory.createStatementFromText("def " + fixVariableName + " = " + initializer);
            grStatementOwner2.addStatementBefore(varDefinition, grStatement2);
            initializer = fixVariableName;
        }
        String string = initializer;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"initializer");
        GrInspectionUtil.replaceExpression(element, this.generateListLiteral(string));
    }

    private final String generateVariableName(GrExpression expression) {
        String string;
        DefaultGroovyVariableNameValidator validator = new DefaultGroovyVariableNameValidator(expression);
        String[] suggestedNames = GroovyNameSuggestionUtil.suggestVariableNameByType(expression.getType(), validator);
        Object[] objectArray = suggestedNames;
        Object[] objectArray2 = objectArray;
        if (!(objectArray2.length == 0)) {
            String string2 = suggestedNames[0];
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"suggestedNames[0]");
        } else {
            string = GrReplaceMultiAssignmentFixKt.getDefaultFixVariableName();
        }
        return string;
    }

    private final String generateListLiteral(String varName) {
        int n = 0;
        return CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(n, this.size - 1)), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)((Function1)new Function1<Integer, String>(varName){
            final /* synthetic */ String $varName;

            @NotNull
            public final String invoke(int it) {
                return "" + this.$varName + '[' + it + ']';
            }
            {
                this.$varName = string;
                super(1);
            }
        }), (int)24, null);
    }

    @NotNull
    public String getName() {
        String string = GroovyBundle.message("replace.with.list.literal", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyBundle.message(\"replace.with.list.literal\")");
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("replace.with.list.literal", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyBundle.message(\"replace.with.list.literal\")");
        return string;
    }

    public final int getSize() {
        return this.size;
    }

    public GrReplaceMultiAssignmentFix(int size) {
        this.size = size;
    }
}

