/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyLibraryProperties;

public abstract class GroovyLibraryPresentationProviderBase
extends LibraryPresentationProvider<GroovyLibraryProperties> {
    public GroovyLibraryPresentationProviderBase(LibraryKind kind) {
        super(kind);
    }

    public String getDescription(@NotNull GroovyLibraryProperties properties) {
        if (properties == null) {
            GroovyLibraryPresentationProviderBase.$$$reportNull$$$0(0);
        }
        String version = properties.getVersion();
        return this.getLibraryCategoryName() + " library" + (version != null ? " of version " + version : ":");
    }

    public GroovyLibraryProperties detect(@NotNull List<VirtualFile> classesRoots) {
        VirtualFile[] libraryFiles;
        if (classesRoots == null) {
            GroovyLibraryPresentationProviderBase.$$$reportNull$$$0(1);
        }
        if (this.managesLibrary(libraryFiles = VfsUtilCore.toVirtualFileArray(classesRoots))) {
            String version = this.getLibraryVersion(libraryFiles);
            return new GroovyLibraryProperties(version);
        }
        return null;
    }

    protected abstract void fillLibrary(String var1, LibraryEditor var2);

    public abstract boolean managesLibrary(VirtualFile[] var1);

    @Nullable
    @Nls
    public abstract String getLibraryVersion(VirtualFile[] var1);

    @NotNull
    public abstract Icon getIcon();

    public abstract boolean isSDKHome(@NotNull VirtualFile var1);

    @NotNull
    public abstract String getSDKVersion(String var1);

    @NotNull
    @Nls
    public abstract String getLibraryCategoryName();

    @NotNull
    @Nls
    public String getLibraryPrefix() {
        String string = StringUtil.toLowerCase((String)this.getLibraryCategoryName());
        if (string == null) {
            GroovyLibraryPresentationProviderBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean managesName(@NotNull String name) {
        if (name == null) {
            GroovyLibraryPresentationProviderBase.$$$reportNull$$$0(3);
        }
        return StringUtil.startsWithIgnoreCase((String)name, (String)this.getLibraryPrefix());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/config/GroovyLibraryPresentationProviderBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/config/GroovyLibraryPresentationProviderBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "managesName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

