/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyLiteralSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            GroovyLiteralSelectioner.$$$reportNull$$$0(0);
        }
        PsiElement parent = e.getParent();
        return GroovyLiteralSelectioner.isLiteral(e) || GroovyLiteralSelectioner.isLiteral(parent);
    }

    private static boolean isLiteral(PsiElement element) {
        return element instanceof GrListOrMap || element instanceof GrArgumentLabel || element instanceof GrLiteralImpl && ((GrLiteralImpl)element).isStringLiteral();
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            GroovyLiteralSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            GroovyLiteralSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GroovyLiteralSelectioner.$$$reportNull$$$0(3);
        }
        List result = super.select(e, editorText, cursorOffset, editor);
        if (e instanceof GrListOrMap) {
            return result;
        }
        int startOffset = -1;
        int endOffset = -1;
        String text = e.getText();
        int stringOffset = e.getTextOffset();
        IElementType elementType = e.getNode().getElementType();
        if (elementType == GroovyTokenTypes.mGSTRING_CONTENT || elementType == GroovyTokenTypes.mREGEX_CONTENT || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT) {
            int cur;
            int index = -1;
            while ((cur = text.indexOf(10, index + 1)) >= 0 && cur + stringOffset <= cursorOffset) {
                index = cur;
            }
            if (index >= 0) {
                startOffset = stringOffset + index + 1;
            }
            if ((index = text.indexOf(10, cursorOffset - stringOffset)) >= 0) {
                endOffset = stringOffset + index + 1;
            }
        }
        if (startOffset >= 0 && endOffset >= 0) {
            result.add(new TextRange(startOffset, endOffset));
        }
        String content = GrStringUtil.removeQuotes(text);
        int offset = stringOffset + text.indexOf(content);
        result.add(new TextRange(offset, offset + content.length()));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/editor/selection/GroovyLiteralSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

