/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParserDefinition;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;

public class GrFileStub
extends PsiFileStubImpl<GroovyFile> {
    @NotNull
    private final String[] myAnnotations;
    private final StringRef myName;
    private final boolean isScript;

    public GrFileStub(GroovyFile file) {
        super((PsiFile)file);
        this.myName = StringRef.fromString((String)file.getViewProvider().getVirtualFile().getNameWithoutExtension());
        this.isScript = file.isScript();
        GrPackageDefinition definition = file.getPackageDefinition();
        this.myAnnotations = definition != null ? GrStubUtils.getAnnotationNames(definition) : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public GrFileStub(StringRef name, boolean isScript, @NotNull String[] annotations2) {
        if (annotations2 == null) {
            GrFileStub.$$$reportNull$$$0(0);
        }
        super(null);
        this.myName = name;
        this.isScript = isScript;
        this.myAnnotations = annotations2;
    }

    @NotNull
    public IStubFileElementType getType() {
        IStubFileElementType iStubFileElementType = GroovyParserDefinition.GROOVY_FILE;
        if (iStubFileElementType == null) {
            GrFileStub.$$$reportNull$$$0(1);
        }
        return iStubFileElementType;
    }

    public StringRef getName() {
        return this.myName;
    }

    public boolean isScript() {
        return this.isScript;
    }

    @NotNull
    public String[] getAnnotations() {
        if (this.myAnnotations == null) {
            GrFileStub.$$$reportNull$$$0(2);
        }
        return this.myAnnotations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFileStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFileStub";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

